

# [doc = "Power control"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pwr (pub * mut u8) ; unsafe impl Send for Pwr { } unsafe impl Sync for Pwr { } impl Pwr { # [doc = "Power control register 1"]
pub fn cr1 (self) -> crate :: common :: Reg < regs :: Cr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Power control register 2"]
pub fn cr2 (self) -> crate :: common :: Reg < regs :: Cr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Power control register 3"]
pub fn cr3 (self) -> crate :: common :: Reg < regs :: Cr3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Power control register 4"]
pub fn cr4 (self) -> crate :: common :: Reg < regs :: Cr4 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Power status register 1"]
pub fn sr1 (self) -> crate :: common :: Reg < regs :: Sr1 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Power status register 2"]
pub fn sr2 (self) -> crate :: common :: Reg < regs :: Sr2 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "Power status clear register"]
pub fn scr (self) -> crate :: common :: Reg < regs :: Scr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "Power Port pull-up control register"]
pub fn pucr (self , n : usize) -> crate :: common :: Reg < regs :: Pcr , crate :: common :: RW > { assert ! (n < 6usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize + n * 8usize)) } } # [doc = "Power Port pull-down control register"]
pub fn pdcr (self , n : usize) -> crate :: common :: Reg < regs :: Pcr , crate :: common :: RW > { assert ! (n < 6usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize + n * 8usize)) } } } pub mod regs { # [doc = "Power Port pull control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pcr (pub u32) ; impl Pcr { # [doc = "Port pull bit y (y=0..15)"]
pub fn p (& self , n : usize) -> bool { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Port pull bit y (y=0..15)"]
pub fn set_p (& mut self , n : usize , val : bool) { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Pcr { fn default () -> Pcr { Pcr (0) } } # [doc = "Power control register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr1 (pub u32) ; impl Cr1 { # [doc = "Low-power mode selection"]
pub const fn lpms (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x07 ; val as u8 } # [doc = "Low-power mode selection"]
pub fn set_lpms (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val as u32) & 0x07) << 0usize) ; } # [doc = "Flash memory powered down during Stop mode"]
pub const fn fpd_stop (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Flash memory powered down during Stop mode"]
pub fn set_fpd_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Flash memory powered down during Low-power run mode"]
pub const fn fpd_lprun (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Flash memory powered down during Low-power run mode"]
pub fn set_fpd_lprun (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Flash memory powered down during Low-power sleep mode"]
pub const fn fpd_lpslp (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Flash memory powered down during Low-power sleep mode"]
pub fn set_fpd_lpslp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Disable backup domain write protection"]
pub const fn dbp (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Disable backup domain write protection"]
pub fn set_dbp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Voltage scaling range selection"]
pub const fn vos (& self) -> u8 { let val = (self . 0 >> 9usize) & 0x03 ; val as u8 } # [doc = "Voltage scaling range selection"]
pub fn set_vos (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 9usize)) | (((val as u32) & 0x03) << 9usize) ; } # [doc = "Low-power run"]
pub const fn lpr (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Low-power run"]
pub fn set_lpr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } } impl Default for Cr1 { fn default () -> Cr1 { Cr1 (0) } } # [doc = "Power control register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr2 (pub u32) ; impl Cr2 { # [doc = "Power voltage detector enable"]
pub const fn pvde (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Power voltage detector enable"]
pub fn set_pvde (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Power voltage detector falling threshold selection"]
pub const fn pvdft (& self) -> u8 { let val = (self . 0 >> 1usize) & 0x07 ; val as u8 } # [doc = "Power voltage detector falling threshold selection"]
pub fn set_pvdft (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 1usize)) | (((val as u32) & 0x07) << 1usize) ; } # [doc = "Power voltage detector rising threshold selection"]
pub const fn pvdrt (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x07 ; val as u8 } # [doc = "Power voltage detector rising threshold selection"]
pub fn set_pvdrt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val as u32) & 0x07) << 4usize) ; } } impl Default for Cr2 { fn default () -> Cr2 { Cr2 (0) } } # [doc = "Power status clear register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Scr (pub u32) ; impl Scr { # [doc = "Clear wakeup flag 1"]
pub const fn cwuf1 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Clear wakeup flag 1"]
pub fn set_cwuf1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Clear wakeup flag 2"]
pub const fn cwuf2 (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Clear wakeup flag 2"]
pub fn set_cwuf2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Clear wakeup flag 4"]
pub const fn cwuf4 (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Clear wakeup flag 4"]
pub fn set_cwuf4 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Clear wakeup flag 5"]
pub const fn cwuf5 (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Clear wakeup flag 5"]
pub fn set_cwuf5 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Clear wakeup flag 6"]
pub const fn cwuf6 (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Clear wakeup flag 6"]
pub fn set_cwuf6 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Clear standby flag"]
pub const fn csbf (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Clear standby flag"]
pub fn set_csbf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } } impl Default for Scr { fn default () -> Scr { Scr (0) } } # [doc = "Power control register 4"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr4 (pub u32) ; impl Cr4 { # [doc = "Wakeup pin WKUP1 polarity"]
pub const fn wp1 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Wakeup pin WKUP1 polarity"]
pub fn set_wp1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Wakeup pin WKUP2 polarity"]
pub const fn wp2 (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Wakeup pin WKUP2 polarity"]
pub fn set_wp2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Wakeup pin WKUP4 polarity"]
pub const fn wp4 (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Wakeup pin WKUP4 polarity"]
pub fn set_wp4 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Wakeup pin WKUP5 polarity"]
pub const fn wp5 (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Wakeup pin WKUP5 polarity"]
pub fn set_wp5 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "WKUP6 wakeup pin polarity"]
pub const fn wp6 (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "WKUP6 wakeup pin polarity"]
pub fn set_wp6 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "VBAT battery charging enable"]
pub const fn vbe (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "VBAT battery charging enable"]
pub fn set_vbe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "VBAT battery charging resistor selection"]
pub const fn vbrs (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "VBAT battery charging resistor selection"]
pub fn set_vbrs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } } impl Default for Cr4 { fn default () -> Cr4 { Cr4 (0) } } # [doc = "Power control register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr3 (pub u32) ; impl Cr3 { # [doc = "Enable Wakeup pin WKUP1"]
pub const fn ewup1 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Enable Wakeup pin WKUP1"]
pub fn set_ewup1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Enable Wakeup pin WKUP2"]
pub const fn ewup2 (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Enable Wakeup pin WKUP2"]
pub fn set_ewup2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Enable Wakeup pin WKUP4"]
pub const fn ewup4 (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Enable Wakeup pin WKUP4"]
pub fn set_ewup4 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Enable WKUP5 wakeup pin"]
pub const fn ewup5 (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Enable WKUP5 wakeup pin"]
pub fn set_ewup5 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Enable WKUP6 wakeup pin"]
pub const fn ewup6 (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Enable WKUP6 wakeup pin"]
pub fn set_ewup6 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "SRAM retention in Standby mode"]
pub const fn rrs (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "SRAM retention in Standby mode"]
pub fn set_rrs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Enable the periodical sampling mode for PDR detection"]
pub const fn ulpen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Enable the periodical sampling mode for PDR detection"]
pub fn set_ulpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Apply pull-up and pull-down configuration"]
pub const fn apc (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Apply pull-up and pull-down configuration"]
pub fn set_apc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Enable internal wakeup line"]
pub const fn eiwul (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Enable internal wakeup line"]
pub fn set_eiwul (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } } impl Default for Cr3 { fn default () -> Cr3 { Cr3 (0) } } # [doc = "Power status register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr1 (pub u32) ; impl Sr1 { # [doc = "Wakeup flag 1"]
pub const fn wuf1 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag 1"]
pub fn set_wuf1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Wakeup flag 2"]
pub const fn wuf2 (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag 2"]
pub fn set_wuf2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Wakeup flag 4"]
pub const fn wuf4 (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag 4"]
pub fn set_wuf4 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Wakeup flag 5"]
pub const fn wuf5 (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag 5"]
pub fn set_wuf5 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Wakeup flag 6"]
pub const fn wuf6 (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag 6"]
pub fn set_wuf6 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Standby flag"]
pub const fn sbf (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Standby flag"]
pub fn set_sbf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Wakeup flag internal"]
pub const fn wufi (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag internal"]
pub fn set_wufi (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } } impl Default for Sr1 { fn default () -> Sr1 { Sr1 (0) } } # [doc = "Power status register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr2 (pub u32) ; impl Sr2 { # [doc = "Flash ready flag"]
pub const fn flash_rdy (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Flash ready flag"]
pub fn set_flash_rdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Low-power regulator started"]
pub const fn reglps (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Low-power regulator started"]
pub fn set_reglps (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Low-power regulator flag"]
pub const fn reglpf (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Low-power regulator flag"]
pub fn set_reglpf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Voltage scaling flag"]
pub const fn vosf (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Voltage scaling flag"]
pub fn set_vosf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Power voltage detector output"]
pub const fn pvdo (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Power voltage detector output"]
pub fn set_pvdo (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } } impl Default for Sr2 { fn default () -> Sr2 { Sr2 (0) } } }