

# [doc = "Power control"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pwr (pub * mut u8) ; unsafe impl Send for Pwr { } unsafe impl Sync for Pwr { } impl Pwr { # [doc = "power control register"]
pub fn cr1 (self) -> crate :: common :: Reg < regs :: Cr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "power control/status register"]
pub fn csr1 (self) -> crate :: common :: Reg < regs :: Csr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pdds (pub u8) ; impl Pdds { # [doc = "Enter Stop mode when the CPU enters deepsleep"]
pub const STOP_MODE : Self = Self (0) ; # [doc = "Enter Standby mode when the CPU enters deepsleep"]
pub const STANDBY_MODE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Vos (pub u8) ; impl Vos { # [doc = "Scale 3 mode (STM32F4[23]
ONLY)"]
pub const SCALE3 : Self = Self (0x01) ; # [doc = "Scale 2 mode"]
pub const SCALE2 : Self = Self (0x02) ; # [doc = "Scale 1 mode (reset value)"]
pub const SCALE1 : Self = Self (0x03) ; } } pub mod regs { # [doc = "power control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr1 (pub u32) ; impl Cr1 { # [doc = "Low-power deep sleep"]
pub const fn lpds (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Low-power deep sleep"]
pub fn set_lpds (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Power down deepsleep"]
pub const fn pdds (& self) -> super :: vals :: Pdds { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Pdds (val as u8) } # [doc = "Power down deepsleep"]
pub fn set_pdds (& mut self , val : super :: vals :: Pdds) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Clear wakeup flag"]
pub const fn cwuf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Clear wakeup flag"]
pub fn set_cwuf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Clear standby flag"]
pub const fn csbf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Clear standby flag"]
pub fn set_csbf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Power voltage detector enable"]
pub const fn pvde (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Power voltage detector enable"]
pub fn set_pvde (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "PVD level selection"]
pub const fn pls (& self) -> u8 { let val = (self . 0 >> 5usize) & 0x07 ; val as u8 } # [doc = "PVD level selection"]
pub fn set_pls (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 5usize)) | (((val as u32) & 0x07) << 5usize) ; } # [doc = "Disable backup domain write protection"]
pub const fn dbp (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Disable backup domain write protection"]
pub fn set_dbp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Flash power down in Stop mode"]
pub const fn fpds (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Flash power down in Stop mode"]
pub fn set_fpds (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Low-Power Regulator Low Voltage in deepsleep"]
pub const fn lplvds (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Low-Power Regulator Low Voltage in deepsleep"]
pub fn set_lplvds (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Main regulator low voltage in deepsleep mode"]
pub const fn mrlvds (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Main regulator low voltage in deepsleep mode"]
pub fn set_mrlvds (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "ADCDC1"]
pub const fn adcdc1 (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "ADCDC1"]
pub fn set_adcdc1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Regulator voltage scaling output selection"]
pub const fn vos (& self) -> super :: vals :: Vos { let val = (self . 0 >> 14usize) & 0x03 ; super :: vals :: Vos (val as u8) } # [doc = "Regulator voltage scaling output selection"]
pub fn set_vos (& mut self , val : super :: vals :: Vos) { self . 0 = (self . 0 & ! (0x03 << 14usize)) | (((val . 0 as u32) & 0x03) << 14usize) ; } # [doc = "Over-drive enable (STM32F4[23]
ONLY)"]
pub const fn oden (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Over-drive enable (STM32F4[23]
ONLY)"]
pub fn set_oden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Over-drive switching enabled (STM32F4[23]
ONLY)"]
pub const fn odswen (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Over-drive switching enabled (STM32F4[23]
ONLY)"]
pub fn set_odswen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Under-drive enable in stop mode (STM32F4[23]
ONLY)"]
pub const fn uden (& self) -> u8 { let val = (self . 0 >> 18usize) & 0x03 ; val as u8 } # [doc = "Under-drive enable in stop mode (STM32F4[23]
ONLY)"]
pub fn set_uden (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 18usize)) | (((val as u32) & 0x03) << 18usize) ; } # [doc = "Flash Memory Stop while System Run"]
pub const fn fmssr (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Flash Memory Stop while System Run"]
pub fn set_fmssr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Flash Interface Stop while System Run"]
pub const fn fissr (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Flash Interface Stop while System Run"]
pub fn set_fissr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } } impl Default for Cr1 { fn default () -> Cr1 { Cr1 (0) } } # [doc = "power control/status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Csr1 (pub u32) ; impl Csr1 { # [doc = "Wakeup flag"]
pub const fn wuf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag"]
pub fn set_wuf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Standby flag"]
pub const fn sbf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Standby flag"]
pub fn set_sbf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "PVD output"]
pub const fn pvdo (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "PVD output"]
pub fn set_pvdo (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Backup regulator ready"]
pub const fn brr (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Backup regulator ready"]
pub fn set_brr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Enable WKUP2 pin"]
pub const fn ewup2 (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Enable WKUP2 pin"]
pub fn set_ewup2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Enable WKUP pin"]
pub const fn ewup (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Enable WKUP pin"]
pub fn set_ewup (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Backup regulator enable"]
pub const fn bre (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Backup regulator enable"]
pub fn set_bre (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Regulator voltage scaling output selection ready bit (STM32F4[23]
ONLY)"]
pub const fn vosrdy (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Regulator voltage scaling output selection ready bit (STM32F4[23]
ONLY)"]
pub fn set_vosrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Over-drive mode ready (STM32F4[23]
ONLY)"]
pub const fn odrdy (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Over-drive mode ready (STM32F4[23]
ONLY)"]
pub fn set_odrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Over-drive mode switching ready (STM32F4[23]
ONLY)"]
pub const fn odswrdy (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Over-drive mode switching ready (STM32F4[23]
ONLY)"]
pub fn set_odswrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Under-drive ready flag"]
pub const fn udrdy (& self) -> u8 { let val = (self . 0 >> 18usize) & 0x03 ; val as u8 } # [doc = "Under-drive ready flag"]
pub fn set_udrdy (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 18usize)) | (((val as u32) & 0x03) << 18usize) ; } } impl Default for Csr1 { fn default () -> Csr1 { Csr1 (0) } } }