

# [doc = "Power control"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pwr (pub * mut u8) ; unsafe impl Send for Pwr { } unsafe impl Sync for Pwr { } impl Pwr { # [doc = "power control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "power control/status register"]
pub fn csr (self) -> crate :: common :: Reg < regs :: Csr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pdds (pub u8) ; impl Pdds { # [doc = "Enter Stop mode when the CPU enters deepsleep"]
pub const STOP_MODE : Self = Self (0) ; # [doc = "Enter Standby mode when the CPU enters deepsleep"]
pub const STANDBY_MODE : Self = Self (0x01) ; } } pub mod regs { # [doc = "power control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Low-power deep sleep"]
pub const fn lpds (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Low-power deep sleep"]
pub fn set_lpds (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Power down deepsleep"]
pub const fn pdds (& self) -> super :: vals :: Pdds { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Pdds (val as u8) } # [doc = "Power down deepsleep"]
pub fn set_pdds (& mut self , val : super :: vals :: Pdds) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Clear wakeup flag"]
pub const fn cwuf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Clear wakeup flag"]
pub fn set_cwuf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Clear standby flag"]
pub const fn csbf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Clear standby flag"]
pub fn set_csbf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Power voltage detector enable"]
pub const fn pvde (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Power voltage detector enable"]
pub fn set_pvde (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "PVD level selection"]
pub const fn pls (& self) -> u8 { let val = (self . 0 >> 5usize) & 0x07 ; val as u8 } # [doc = "PVD level selection"]
pub fn set_pls (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 5usize)) | (((val as u32) & 0x07) << 5usize) ; } # [doc = "Disable backup domain write protection"]
pub const fn dbp (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Disable backup domain write protection"]
pub fn set_dbp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "ENable SD1 ADC"]
pub fn ensd (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 9usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "ENable SD1 ADC"]
pub fn set_ensd (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 9usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "power control/status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Csr (pub u32) ; impl Csr { # [doc = "Wakeup flag"]
pub const fn wuf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Wakeup flag"]
pub fn set_wuf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Standby flag"]
pub const fn sbf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Standby flag"]
pub fn set_sbf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "PVD output"]
pub const fn pvdo (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "PVD output"]
pub fn set_pvdo (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Internal voltage reference ready flag"]
pub const fn vrefintrdyf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Internal voltage reference ready flag"]
pub fn set_vrefintrdyf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Enable WKUP1 pin"]
pub fn ewup (& self , n : usize) -> bool { assert ! (n < 2usize) ; let offs = 8usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Enable WKUP1 pin"]
pub fn set_ewup (& mut self , n : usize , val : bool) { assert ! (n < 2usize) ; let offs = 8usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Csr { fn default () -> Csr { Csr (0) } } }