

# [doc = "USB on the go high speed"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHs (pub * mut u8) ; unsafe impl Send for OtgHs { } unsafe impl Sync for OtgHs { } impl OtgHs { # [doc = "OTG_HS control and status register"]
pub fn otg_hs_gotgctl (self) -> crate :: common :: Reg < regs :: OtgHsGotgctl , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "OTG_HS interrupt register"]
pub fn otg_hs_gotgint (self) -> crate :: common :: Reg < regs :: OtgHsGotgint , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "OTG_HS AHB configuration register"]
pub fn otg_hs_gahbcfg (self) -> crate :: common :: Reg < regs :: OtgHsGahbcfg , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "OTG_HS USB configuration register"]
pub fn otg_hs_gusbcfg (self) -> crate :: common :: Reg < regs :: OtgHsGusbcfg , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "OTG_HS reset register"]
pub fn otg_hs_grstctl (self) -> crate :: common :: Reg < regs :: OtgHsGrstctl , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "OTG_HS core interrupt register"]
pub fn otg_hs_gintsts (self) -> crate :: common :: Reg < regs :: OtgHsGintsts , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "OTG_HS interrupt mask register"]
pub fn otg_hs_gintmsk (self) -> crate :: common :: Reg < regs :: OtgHsGintmsk , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "OTG_HS Receive status debug read register (peripheral mode mode)"]
pub fn otg_hs_grxstsr_device (self) -> crate :: common :: Reg < regs :: OtgHsGrxstsrDevice , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "OTG_HS Receive status debug read register (host mode)"]
pub fn otg_hs_grxstsr_host (self) -> crate :: common :: Reg < regs :: OtgHsGrxstsrHost , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "OTG_HS status read and pop register (peripheral mode)"]
pub fn otg_hs_grxstsp_device (self) -> crate :: common :: Reg < regs :: OtgHsGrxstspDevice , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "OTG_HS status read and pop register (host mode)"]
pub fn otg_hs_grxstsp_host (self) -> crate :: common :: Reg < regs :: OtgHsGrxstspHost , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "OTG_HS Receive FIFO size register"]
pub fn otg_hs_grxfsiz (self) -> crate :: common :: Reg < regs :: OtgHsGrxfsiz , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "Endpoint 0 transmit FIFO size (peripheral mode)"]
pub fn otg_hs_dieptxf0_device (self) -> crate :: common :: Reg < regs :: OtgHsDieptxf0Device , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "OTG_HS nonperiodic transmit FIFO size register (host mode)"]
pub fn otg_hs_hnptxfsiz_host (self) -> crate :: common :: Reg < regs :: OtgHsHnptxfsizHost , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "OTG_HS nonperiodic transmit FIFO/queue status register"]
pub fn otg_hs_gnptxsts (self) -> crate :: common :: Reg < regs :: OtgHsGnptxsts , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "OTG_HS nonperiodic transmit FIFO/queue status register"]
pub fn otg_hs_hnptxsts (self) -> crate :: common :: Reg < regs :: OtgHsHnptxsts , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "OTG I2C access register"]
pub fn otg_hs_gi2cctl (self) -> crate :: common :: Reg < regs :: OtgHsGi2cctl , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "OTG_HS general core configuration register"]
pub fn otg_hs_gccfg (self) -> crate :: common :: Reg < regs :: OtgHsGccfg , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } # [doc = "OTG_HS core ID register"]
pub fn otg_hs_cid (self) -> crate :: common :: Reg < regs :: OtgHsCid , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (60usize)) } } # [doc = "OTG core LPM configuration register"]
pub fn otg_hs_glpmcfg (self) -> crate :: common :: Reg < regs :: OtgHsGlpmcfg , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (84usize)) } } # [doc = "OTG_HS Host periodic transmit FIFO size register"]
pub fn otg_hs_hptxfsiz (self) -> crate :: common :: Reg < regs :: OtgHsHptxfsiz , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (256usize)) } } # [doc = "OTG_HS device IN endpoint transmit FIFO size register"]
pub fn otg_hs_dieptxf1 (self) -> crate :: common :: Reg < regs :: OtgHsDieptxf1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (260usize)) } } # [doc = "OTG_HS device IN endpoint transmit FIFO size register"]
pub fn otg_hs_dieptxf2 (self) -> crate :: common :: Reg < regs :: OtgHsDieptxf2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (264usize)) } } # [doc = "OTG_HS device IN endpoint transmit FIFO size register"]
pub fn otg_hs_dieptxf3 (self) -> crate :: common :: Reg < regs :: OtgHsDieptxf3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (268usize)) } } # [doc = "OTG_HS device IN endpoint transmit FIFO size register"]
pub fn otg_hs_dieptxf4 (self) -> crate :: common :: Reg < regs :: OtgHsDieptxf4 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (272usize)) } } # [doc = "OTG_HS device IN endpoint transmit FIFO size register"]
pub fn otg_hs_dieptxf5 (self) -> crate :: common :: Reg < regs :: OtgHsDieptxf5 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (276usize)) } } # [doc = "OTG_HS device IN endpoint transmit FIFO size register"]
pub fn otg_hs_dieptxf6 (self) -> crate :: common :: Reg < regs :: OtgHsDieptxf6 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (280usize)) } } # [doc = "OTG_HS device IN endpoint transmit FIFO size register"]
pub fn otg_hs_dieptxf7 (self) -> crate :: common :: Reg < regs :: OtgHsDieptxf7 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (284usize)) } } } pub mod regs { # [doc = "OTG I2C access register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsGi2cctl (pub u32) ; impl OtgHsGi2cctl { # [doc = "I2C Read/Write Data"]
pub const fn rwdata (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "I2C Read/Write Data"]
pub fn set_rwdata (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "I2C Register Address"]
pub const fn regaddr (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "I2C Register Address"]
pub fn set_regaddr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "I2C Address"]
pub const fn addr (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x7f ; val as u8 } # [doc = "I2C Address"]
pub fn set_addr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 16usize)) | (((val as u32) & 0x7f) << 16usize) ; } # [doc = "I2C Enable"]
pub const fn i2cen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "I2C Enable"]
pub fn set_i2cen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "I2C ACK"]
pub const fn ack (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "I2C ACK"]
pub fn set_ack (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "I2C Device Address"]
pub const fn i2cdevadr (& self) -> u8 { let val = (self . 0 >> 26usize) & 0x03 ; val as u8 } # [doc = "I2C Device Address"]
pub fn set_i2cdevadr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 26usize)) | (((val as u32) & 0x03) << 26usize) ; } # [doc = "I2C DatSe0 USB mode"]
pub const fn i2cdatse0 (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "I2C DatSe0 USB mode"]
pub fn set_i2cdatse0 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "Read/Write Indicator"]
pub const fn rw (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Read/Write Indicator"]
pub fn set_rw (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "I2C Busy/Done"]
pub const fn bsydne (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "I2C Busy/Done"]
pub fn set_bsydne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for OtgHsGi2cctl { fn default () -> OtgHsGi2cctl { OtgHsGi2cctl (0) } } # [doc = "OTG_HS Host periodic transmit FIFO size register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsHptxfsiz (pub u32) ; impl OtgHsHptxfsiz { # [doc = "Host periodic TxFIFO start address"]
pub const fn ptxsa (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Host periodic TxFIFO start address"]
pub fn set_ptxsa (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "Host periodic TxFIFO depth"]
pub const fn ptxfd (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Host periodic TxFIFO depth"]
pub fn set_ptxfd (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for OtgHsHptxfsiz { fn default () -> OtgHsHptxfsiz { OtgHsHptxfsiz (0) } } # [doc = "OTG_HS Receive status debug read register (peripheral mode mode)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsGrxstsrDevice (pub u32) ; impl OtgHsGrxstsrDevice { # [doc = "Endpoint number"]
pub const fn epnum (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Endpoint number"]
pub fn set_epnum (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Byte count"]
pub const fn bcnt (& self) -> u16 { let val = (self . 0 >> 4usize) & 0x07ff ; val as u16 } # [doc = "Byte count"]
pub fn set_bcnt (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x07ff << 4usize)) | (((val as u32) & 0x07ff) << 4usize) ; } # [doc = "Data PID"]
pub const fn dpid (& self) -> u8 { let val = (self . 0 >> 15usize) & 0x03 ; val as u8 } # [doc = "Data PID"]
pub fn set_dpid (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 15usize)) | (((val as u32) & 0x03) << 15usize) ; } # [doc = "Packet status"]
pub const fn pktsts (& self) -> u8 { let val = (self . 0 >> 17usize) & 0x0f ; val as u8 } # [doc = "Packet status"]
pub fn set_pktsts (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 17usize)) | (((val as u32) & 0x0f) << 17usize) ; } # [doc = "Frame number"]
pub const fn frmnum (& self) -> u8 { let val = (self . 0 >> 21usize) & 0x0f ; val as u8 } # [doc = "Frame number"]
pub fn set_frmnum (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 21usize)) | (((val as u32) & 0x0f) << 21usize) ; } } impl Default for OtgHsGrxstsrDevice { fn default () -> OtgHsGrxstsrDevice { OtgHsGrxstsrDevice (0) } } # [doc = "OTG_HS control and status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsGotgctl (pub u32) ; impl OtgHsGotgctl { # [doc = "Session request success"]
pub const fn srqscs (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Session request success"]
pub fn set_srqscs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Session request"]
pub const fn srq (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Session request"]
pub fn set_srq (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Host negotiation success"]
pub const fn hngscs (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Host negotiation success"]
pub fn set_hngscs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "HNP request"]
pub const fn hnprq (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "HNP request"]
pub fn set_hnprq (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Host set HNP enable"]
pub const fn hshnpen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Host set HNP enable"]
pub fn set_hshnpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Device HNP enabled"]
pub const fn dhnpen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Device HNP enabled"]
pub fn set_dhnpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "Embedded host enable"]
pub const fn ehen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Embedded host enable"]
pub fn set_ehen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Connector ID status"]
pub const fn cidsts (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Connector ID status"]
pub fn set_cidsts (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Long/short debounce time"]
pub const fn dbct (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Long/short debounce time"]
pub fn set_dbct (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "A-session valid"]
pub const fn asvld (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "A-session valid"]
pub fn set_asvld (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "B-session valid"]
pub const fn bsvld (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "B-session valid"]
pub fn set_bsvld (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } } impl Default for OtgHsGotgctl { fn default () -> OtgHsGotgctl { OtgHsGotgctl (0) } } # [doc = "OTG_HS device IN endpoint transmit FIFO size register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsDieptxf7 (pub u32) ; impl OtgHsDieptxf7 { # [doc = "IN endpoint FIFOx transmit RAM start address"]
pub const fn ineptxsa (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "IN endpoint FIFOx transmit RAM start address"]
pub fn set_ineptxsa (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "IN endpoint TxFIFO depth"]
pub const fn ineptxfd (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "IN endpoint TxFIFO depth"]
pub fn set_ineptxfd (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for OtgHsDieptxf7 { fn default () -> OtgHsDieptxf7 { OtgHsDieptxf7 (0) } } # [doc = "OTG_HS general core configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsGccfg (pub u32) ; impl OtgHsGccfg { # [doc = "Data contact detection (DCD) status"]
pub const fn dcdet (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Data contact detection (DCD) status"]
pub fn set_dcdet (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Primary detection (PD) status"]
pub const fn pdet (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Primary detection (PD) status"]
pub fn set_pdet (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Secondary detection (SD) status"]
pub const fn sdet (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Secondary detection (SD) status"]
pub fn set_sdet (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "DM pull-up detection status"]
pub const fn ps2det (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "DM pull-up detection status"]
pub fn set_ps2det (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Power down"]
pub const fn pwrdwn (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Power down"]
pub fn set_pwrdwn (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Battery charging detector (BCD) enable"]
pub const fn bcden (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Battery charging detector (BCD) enable"]
pub fn set_bcden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Data contact detection (DCD) mode enable"]
pub const fn dcden (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Data contact detection (DCD) mode enable"]
pub fn set_dcden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Primary detection (PD) mode enable"]
pub const fn pden (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Primary detection (PD) mode enable"]
pub fn set_pden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Secondary detection (SD) mode enable"]
pub const fn sden (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Secondary detection (SD) mode enable"]
pub fn set_sden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "USB VBUS detection enable"]
pub const fn vbden (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "USB VBUS detection enable"]
pub fn set_vbden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } } impl Default for OtgHsGccfg { fn default () -> OtgHsGccfg { OtgHsGccfg (0) } } # [doc = "OTG_HS Receive status debug read register (host mode)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsGrxstsrHost (pub u32) ; impl OtgHsGrxstsrHost { # [doc = "Channel number"]
pub const fn chnum (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Channel number"]
pub fn set_chnum (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Byte count"]
pub const fn bcnt (& self) -> u16 { let val = (self . 0 >> 4usize) & 0x07ff ; val as u16 } # [doc = "Byte count"]
pub fn set_bcnt (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x07ff << 4usize)) | (((val as u32) & 0x07ff) << 4usize) ; } # [doc = "Data PID"]
pub const fn dpid (& self) -> u8 { let val = (self . 0 >> 15usize) & 0x03 ; val as u8 } # [doc = "Data PID"]
pub fn set_dpid (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 15usize)) | (((val as u32) & 0x03) << 15usize) ; } # [doc = "Packet status"]
pub const fn pktsts (& self) -> u8 { let val = (self . 0 >> 17usize) & 0x0f ; val as u8 } # [doc = "Packet status"]
pub fn set_pktsts (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 17usize)) | (((val as u32) & 0x0f) << 17usize) ; } } impl Default for OtgHsGrxstsrHost { fn default () -> OtgHsGrxstsrHost { OtgHsGrxstsrHost (0) } } # [doc = "OTG_HS device IN endpoint transmit FIFO size register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsDieptxf2 (pub u32) ; impl OtgHsDieptxf2 { # [doc = "IN endpoint FIFOx transmit RAM start address"]
pub const fn ineptxsa (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "IN endpoint FIFOx transmit RAM start address"]
pub fn set_ineptxsa (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "IN endpoint TxFIFO depth"]
pub const fn ineptxfd (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "IN endpoint TxFIFO depth"]
pub fn set_ineptxfd (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for OtgHsDieptxf2 { fn default () -> OtgHsDieptxf2 { OtgHsDieptxf2 (0) } } # [doc = "OTG_HS status read and pop register (peripheral mode)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsGrxstspDevice (pub u32) ; impl OtgHsGrxstspDevice { # [doc = "Endpoint number"]
pub const fn epnum (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Endpoint number"]
pub fn set_epnum (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Byte count"]
pub const fn bcnt (& self) -> u16 { let val = (self . 0 >> 4usize) & 0x07ff ; val as u16 } # [doc = "Byte count"]
pub fn set_bcnt (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x07ff << 4usize)) | (((val as u32) & 0x07ff) << 4usize) ; } # [doc = "Data PID"]
pub const fn dpid (& self) -> u8 { let val = (self . 0 >> 15usize) & 0x03 ; val as u8 } # [doc = "Data PID"]
pub fn set_dpid (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 15usize)) | (((val as u32) & 0x03) << 15usize) ; } # [doc = "Packet status"]
pub const fn pktsts (& self) -> u8 { let val = (self . 0 >> 17usize) & 0x0f ; val as u8 } # [doc = "Packet status"]
pub fn set_pktsts (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 17usize)) | (((val as u32) & 0x0f) << 17usize) ; } # [doc = "Frame number"]
pub const fn frmnum (& self) -> u8 { let val = (self . 0 >> 21usize) & 0x0f ; val as u8 } # [doc = "Frame number"]
pub fn set_frmnum (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 21usize)) | (((val as u32) & 0x0f) << 21usize) ; } } impl Default for OtgHsGrxstspDevice { fn default () -> OtgHsGrxstspDevice { OtgHsGrxstspDevice (0) } } # [doc = "OTG_HS nonperiodic transmit FIFO/queue status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsHnptxsts (pub u32) ; impl OtgHsHnptxsts { # [doc = "Nonperiodic TxFIFO space available"]
pub const fn nptxfsav (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Nonperiodic TxFIFO space available"]
pub fn set_nptxfsav (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "Nonperiodic transmit request queue space available"]
pub const fn nptqxsav (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Nonperiodic transmit request queue space available"]
pub fn set_nptqxsav (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } # [doc = "Top of the nonperiodic transmit request queue"]
pub const fn nptxqtop (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x7f ; val as u8 } # [doc = "Top of the nonperiodic transmit request queue"]
pub fn set_nptxqtop (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 24usize)) | (((val as u32) & 0x7f) << 24usize) ; } } impl Default for OtgHsHnptxsts { fn default () -> OtgHsHnptxsts { OtgHsHnptxsts (0) } } # [doc = "OTG_HS USB configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsGusbcfg (pub u32) ; impl OtgHsGusbcfg { # [doc = "FS timeout calibration"]
pub const fn tocal (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x07 ; val as u8 } # [doc = "FS timeout calibration"]
pub fn set_tocal (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val as u32) & 0x07) << 0usize) ; } # [doc = "USB 2.0 high-speed ULPI PHY or USB 1.1 full-speed serial transceiver select"]
pub const fn physel (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "USB 2.0 high-speed ULPI PHY or USB 1.1 full-speed serial transceiver select"]
pub fn set_physel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "SRP-capable"]
pub const fn srpcap (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "SRP-capable"]
pub fn set_srpcap (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "HNP-capable"]
pub const fn hnpcap (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "HNP-capable"]
pub fn set_hnpcap (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "USB turnaround time"]
pub const fn trdt (& self) -> u8 { let val = (self . 0 >> 10usize) & 0x0f ; val as u8 } # [doc = "USB turnaround time"]
pub fn set_trdt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 10usize)) | (((val as u32) & 0x0f) << 10usize) ; } # [doc = "PHY Low-power clock select"]
pub const fn phylpcs (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "PHY Low-power clock select"]
pub fn set_phylpcs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "ULPI FS/LS select"]
pub const fn ulpifsls (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "ULPI FS/LS select"]
pub fn set_ulpifsls (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "ULPI Auto-resume"]
pub const fn ulpiar (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "ULPI Auto-resume"]
pub fn set_ulpiar (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "ULPI Clock SuspendM"]
pub const fn ulpicsm (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "ULPI Clock SuspendM"]
pub fn set_ulpicsm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "ULPI External VBUS Drive"]
pub const fn ulpievbusd (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "ULPI External VBUS Drive"]
pub fn set_ulpievbusd (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "ULPI external VBUS indicator"]
pub const fn ulpievbusi (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "ULPI external VBUS indicator"]
pub fn set_ulpievbusi (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "TermSel DLine pulsing selection"]
pub const fn tsdps (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "TermSel DLine pulsing selection"]
pub fn set_tsdps (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Indicator complement"]
pub const fn pcci (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Indicator complement"]
pub fn set_pcci (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Indicator pass through"]
pub const fn ptci (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Indicator pass through"]
pub fn set_ptci (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "ULPI interface protect disable"]
pub const fn ulpiipd (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "ULPI interface protect disable"]
pub fn set_ulpiipd (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Forced host mode"]
pub const fn fhmod (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "Forced host mode"]
pub fn set_fhmod (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "Forced peripheral mode"]
pub const fn fdmod (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Forced peripheral mode"]
pub fn set_fdmod (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } } impl Default for OtgHsGusbcfg { fn default () -> OtgHsGusbcfg { OtgHsGusbcfg (0) } } # [doc = "OTG_HS nonperiodic transmit FIFO size register (host mode)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsHnptxfsizHost (pub u32) ; impl OtgHsHnptxfsizHost { # [doc = "Nonperiodic transmit RAM start address"]
pub const fn nptxfsa (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Nonperiodic transmit RAM start address"]
pub fn set_nptxfsa (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "Nonperiodic TxFIFO depth"]
pub const fn nptxfd (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Nonperiodic TxFIFO depth"]
pub fn set_nptxfd (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for OtgHsHnptxfsizHost { fn default () -> OtgHsHnptxfsizHost { OtgHsHnptxfsizHost (0) } } # [doc = "OTG_HS reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsGrstctl (pub u32) ; impl OtgHsGrstctl { # [doc = "Core soft reset"]
pub const fn csrst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Core soft reset"]
pub fn set_csrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "HCLK soft reset"]
pub const fn hsrst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "HCLK soft reset"]
pub fn set_hsrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Host frame counter reset"]
pub const fn fcrst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Host frame counter reset"]
pub fn set_fcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "RxFIFO flush"]
pub const fn rxfflsh (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "RxFIFO flush"]
pub fn set_rxfflsh (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TxFIFO flush"]
pub const fn txfflsh (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TxFIFO flush"]
pub fn set_txfflsh (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "TxFIFO number"]
pub const fn txfnum (& self) -> u8 { let val = (self . 0 >> 6usize) & 0x1f ; val as u8 } # [doc = "TxFIFO number"]
pub fn set_txfnum (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 6usize)) | (((val as u32) & 0x1f) << 6usize) ; } # [doc = "DMA request signal enabled for USB OTG HS"]
pub const fn dmareq (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "DMA request signal enabled for USB OTG HS"]
pub fn set_dmareq (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "AHB master idle"]
pub const fn ahbidl (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "AHB master idle"]
pub fn set_ahbidl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for OtgHsGrstctl { fn default () -> OtgHsGrstctl { OtgHsGrstctl (0) } } # [doc = "OTG_HS device IN endpoint transmit FIFO size register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsDieptxf1 (pub u32) ; impl OtgHsDieptxf1 { # [doc = "IN endpoint FIFOx transmit RAM start address"]
pub const fn ineptxsa (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "IN endpoint FIFOx transmit RAM start address"]
pub fn set_ineptxsa (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "IN endpoint TxFIFO depth"]
pub const fn ineptxfd (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "IN endpoint TxFIFO depth"]
pub fn set_ineptxfd (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for OtgHsDieptxf1 { fn default () -> OtgHsDieptxf1 { OtgHsDieptxf1 (0) } } # [doc = "OTG core LPM configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsGlpmcfg (pub u32) ; impl OtgHsGlpmcfg { # [doc = "LPM support enable"]
pub const fn lpmen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LPM support enable"]
pub fn set_lpmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LPM token acknowledge enable"]
pub const fn lpmack (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LPM token acknowledge enable"]
pub fn set_lpmack (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Best effort service latency"]
pub const fn besl (& self) -> u8 { let val = (self . 0 >> 2usize) & 0x0f ; val as u8 } # [doc = "Best effort service latency"]
pub fn set_besl (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 2usize)) | (((val as u32) & 0x0f) << 2usize) ; } # [doc = "bRemoteWake value"]
pub const fn remwake (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "bRemoteWake value"]
pub fn set_remwake (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "L1 Shallow Sleep enable"]
pub const fn l1ssen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "L1 Shallow Sleep enable"]
pub fn set_l1ssen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "BESL threshold"]
pub const fn beslthrs (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "BESL threshold"]
pub fn set_beslthrs (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "L1 deep sleep enable"]
pub const fn l1dsen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "L1 deep sleep enable"]
pub fn set_l1dsen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "LPM response"]
pub const fn lpmrst (& self) -> u8 { let val = (self . 0 >> 13usize) & 0x03 ; val as u8 } # [doc = "LPM response"]
pub fn set_lpmrst (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 13usize)) | (((val as u32) & 0x03) << 13usize) ; } # [doc = "Port sleep status"]
pub const fn slpsts (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Port sleep status"]
pub fn set_slpsts (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Sleep State Resume OK"]
pub const fn l1rsmok (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Sleep State Resume OK"]
pub fn set_l1rsmok (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "LPM Channel Index"]
pub const fn lpmchidx (& self) -> u8 { let val = (self . 0 >> 17usize) & 0x0f ; val as u8 } # [doc = "LPM Channel Index"]
pub fn set_lpmchidx (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 17usize)) | (((val as u32) & 0x0f) << 17usize) ; } # [doc = "LPM retry count"]
pub const fn lpmrcnt (& self) -> u8 { let val = (self . 0 >> 21usize) & 0x07 ; val as u8 } # [doc = "LPM retry count"]
pub fn set_lpmrcnt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 21usize)) | (((val as u32) & 0x07) << 21usize) ; } # [doc = "Send LPM transaction"]
pub const fn sndlpm (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Send LPM transaction"]
pub fn set_sndlpm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "LPM retry count status"]
pub const fn lpmrcntsts (& self) -> u8 { let val = (self . 0 >> 25usize) & 0x07 ; val as u8 } # [doc = "LPM retry count status"]
pub fn set_lpmrcntsts (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 25usize)) | (((val as u32) & 0x07) << 25usize) ; } # [doc = "Enable best effort service latency"]
pub const fn enbesl (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Enable best effort service latency"]
pub fn set_enbesl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } } impl Default for OtgHsGlpmcfg { fn default () -> OtgHsGlpmcfg { OtgHsGlpmcfg (0) } } # [doc = "OTG_HS device IN endpoint transmit FIFO size register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsDieptxf3 (pub u32) ; impl OtgHsDieptxf3 { # [doc = "IN endpoint FIFOx transmit RAM start address"]
pub const fn ineptxsa (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "IN endpoint FIFOx transmit RAM start address"]
pub fn set_ineptxsa (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "IN endpoint TxFIFO depth"]
pub const fn ineptxfd (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "IN endpoint TxFIFO depth"]
pub fn set_ineptxfd (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for OtgHsDieptxf3 { fn default () -> OtgHsDieptxf3 { OtgHsDieptxf3 (0) } } # [doc = "OTG_HS interrupt register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsGotgint (pub u32) ; impl OtgHsGotgint { # [doc = "Session end detected"]
pub const fn sedet (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Session end detected"]
pub fn set_sedet (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Session request success status change"]
pub const fn srsschg (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Session request success status change"]
pub fn set_srsschg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Host negotiation success status change"]
pub const fn hnsschg (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Host negotiation success status change"]
pub fn set_hnsschg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Host negotiation detected"]
pub const fn hngdet (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Host negotiation detected"]
pub fn set_hngdet (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "A-device timeout change"]
pub const fn adtochg (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "A-device timeout change"]
pub fn set_adtochg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Debounce done"]
pub const fn dbcdne (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Debounce done"]
pub fn set_dbcdne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "ID input pin changed"]
pub const fn idchng (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "ID input pin changed"]
pub fn set_idchng (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } } impl Default for OtgHsGotgint { fn default () -> OtgHsGotgint { OtgHsGotgint (0) } } # [doc = "OTG_HS nonperiodic transmit FIFO/queue status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsGnptxsts (pub u32) ; impl OtgHsGnptxsts { # [doc = "Nonperiodic TxFIFO space available"]
pub const fn nptxfsav (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Nonperiodic TxFIFO space available"]
pub fn set_nptxfsav (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "Nonperiodic transmit request queue space available"]
pub const fn nptqxsav (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Nonperiodic transmit request queue space available"]
pub fn set_nptqxsav (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } # [doc = "Top of the nonperiodic transmit request queue"]
pub const fn nptxqtop (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x7f ; val as u8 } # [doc = "Top of the nonperiodic transmit request queue"]
pub fn set_nptxqtop (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 24usize)) | (((val as u32) & 0x7f) << 24usize) ; } } impl Default for OtgHsGnptxsts { fn default () -> OtgHsGnptxsts { OtgHsGnptxsts (0) } } # [doc = "Endpoint 0 transmit FIFO size (peripheral mode)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsDieptxf0Device (pub u32) ; impl OtgHsDieptxf0Device { # [doc = "Endpoint 0 transmit RAM start address"]
pub const fn tx0fsa (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Endpoint 0 transmit RAM start address"]
pub fn set_tx0fsa (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "Endpoint 0 TxFIFO depth"]
pub const fn tx0fd (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Endpoint 0 TxFIFO depth"]
pub fn set_tx0fd (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for OtgHsDieptxf0Device { fn default () -> OtgHsDieptxf0Device { OtgHsDieptxf0Device (0) } } # [doc = "OTG_HS core ID register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsCid (pub u32) ; impl OtgHsCid { # [doc = "Product ID field"]
pub const fn product_id (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Product ID field"]
pub fn set_product_id (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for OtgHsCid { fn default () -> OtgHsCid { OtgHsCid (0) } } # [doc = "OTG_HS AHB configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsGahbcfg (pub u32) ; impl OtgHsGahbcfg { # [doc = "Global interrupt mask"]
pub const fn gint (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Global interrupt mask"]
pub fn set_gint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Burst length/type"]
pub const fn hbstlen (& self) -> u8 { let val = (self . 0 >> 1usize) & 0x0f ; val as u8 } # [doc = "Burst length/type"]
pub fn set_hbstlen (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 1usize)) | (((val as u32) & 0x0f) << 1usize) ; } # [doc = "DMA enable"]
pub const fn dmaen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "DMA enable"]
pub fn set_dmaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "TxFIFO empty level"]
pub const fn txfelvl (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "TxFIFO empty level"]
pub fn set_txfelvl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Periodic TxFIFO empty level"]
pub const fn ptxfelvl (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Periodic TxFIFO empty level"]
pub fn set_ptxfelvl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } } impl Default for OtgHsGahbcfg { fn default () -> OtgHsGahbcfg { OtgHsGahbcfg (0) } } # [doc = "OTG_HS status read and pop register (host mode)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsGrxstspHost (pub u32) ; impl OtgHsGrxstspHost { # [doc = "Channel number"]
pub const fn chnum (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Channel number"]
pub fn set_chnum (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Byte count"]
pub const fn bcnt (& self) -> u16 { let val = (self . 0 >> 4usize) & 0x07ff ; val as u16 } # [doc = "Byte count"]
pub fn set_bcnt (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x07ff << 4usize)) | (((val as u32) & 0x07ff) << 4usize) ; } # [doc = "Data PID"]
pub const fn dpid (& self) -> u8 { let val = (self . 0 >> 15usize) & 0x03 ; val as u8 } # [doc = "Data PID"]
pub fn set_dpid (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 15usize)) | (((val as u32) & 0x03) << 15usize) ; } # [doc = "Packet status"]
pub const fn pktsts (& self) -> u8 { let val = (self . 0 >> 17usize) & 0x0f ; val as u8 } # [doc = "Packet status"]
pub fn set_pktsts (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 17usize)) | (((val as u32) & 0x0f) << 17usize) ; } } impl Default for OtgHsGrxstspHost { fn default () -> OtgHsGrxstspHost { OtgHsGrxstspHost (0) } } # [doc = "OTG_HS device IN endpoint transmit FIFO size register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsDieptxf6 (pub u32) ; impl OtgHsDieptxf6 { # [doc = "IN endpoint FIFOx transmit RAM start address"]
pub const fn ineptxsa (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "IN endpoint FIFOx transmit RAM start address"]
pub fn set_ineptxsa (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "IN endpoint TxFIFO depth"]
pub const fn ineptxfd (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "IN endpoint TxFIFO depth"]
pub fn set_ineptxfd (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for OtgHsDieptxf6 { fn default () -> OtgHsDieptxf6 { OtgHsDieptxf6 (0) } } # [doc = "OTG_HS core interrupt register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsGintsts (pub u32) ; impl OtgHsGintsts { # [doc = "Current mode of operation"]
pub const fn cmod (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Current mode of operation"]
pub fn set_cmod (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Mode mismatch interrupt"]
pub const fn mmis (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Mode mismatch interrupt"]
pub fn set_mmis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "OTG interrupt"]
pub const fn otgint (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "OTG interrupt"]
pub fn set_otgint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Start of frame"]
pub const fn sof (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Start of frame"]
pub fn set_sof (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "RxFIFO nonempty"]
pub const fn rxflvl (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "RxFIFO nonempty"]
pub fn set_rxflvl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Nonperiodic TxFIFO empty"]
pub const fn nptxfe (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Nonperiodic TxFIFO empty"]
pub fn set_nptxfe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Global IN nonperiodic NAK effective"]
pub const fn ginakeff (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Global IN nonperiodic NAK effective"]
pub fn set_ginakeff (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Global OUT NAK effective"]
pub const fn boutnakeff (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Global OUT NAK effective"]
pub fn set_boutnakeff (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Early suspend"]
pub const fn esusp (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Early suspend"]
pub fn set_esusp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "USB suspend"]
pub const fn usbsusp (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "USB suspend"]
pub fn set_usbsusp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "USB reset"]
pub const fn usbrst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "USB reset"]
pub fn set_usbrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Enumeration done"]
pub const fn enumdne (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "Enumeration done"]
pub fn set_enumdne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Isochronous OUT packet dropped interrupt"]
pub const fn isoodrp (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Isochronous OUT packet dropped interrupt"]
pub fn set_isoodrp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "End of periodic frame interrupt"]
pub const fn eopf (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "End of periodic frame interrupt"]
pub fn set_eopf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "IN endpoint interrupt"]
pub const fn iepint (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "IN endpoint interrupt"]
pub fn set_iepint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "OUT endpoint interrupt"]
pub const fn oepint (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "OUT endpoint interrupt"]
pub fn set_oepint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Incomplete isochronous IN transfer"]
pub const fn iisoixfr (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Incomplete isochronous IN transfer"]
pub fn set_iisoixfr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Incomplete periodic transfer"]
pub const fn pxfr_incompisoout (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Incomplete periodic transfer"]
pub fn set_pxfr_incompisoout (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Data fetch suspended"]
pub const fn datafsusp (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "Data fetch suspended"]
pub fn set_datafsusp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Host port interrupt"]
pub const fn hprtint (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Host port interrupt"]
pub fn set_hprtint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Host channels interrupt"]
pub const fn hcint (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Host channels interrupt"]
pub fn set_hcint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Periodic TxFIFO empty"]
pub const fn ptxfe (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Periodic TxFIFO empty"]
pub fn set_ptxfe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Connector ID status change"]
pub const fn cidschg (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Connector ID status change"]
pub fn set_cidschg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "Disconnect detected interrupt"]
pub const fn discint (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "Disconnect detected interrupt"]
pub fn set_discint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "Session request/new session detected interrupt"]
pub const fn srqint (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Session request/new session detected interrupt"]
pub fn set_srqint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Resume/remote wakeup detected interrupt"]
pub const fn wkuint (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Resume/remote wakeup detected interrupt"]
pub fn set_wkuint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for OtgHsGintsts { fn default () -> OtgHsGintsts { OtgHsGintsts (0) } } # [doc = "OTG_HS device IN endpoint transmit FIFO size register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsDieptxf4 (pub u32) ; impl OtgHsDieptxf4 { # [doc = "IN endpoint FIFOx transmit RAM start address"]
pub const fn ineptxsa (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "IN endpoint FIFOx transmit RAM start address"]
pub fn set_ineptxsa (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "IN endpoint TxFIFO depth"]
pub const fn ineptxfd (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "IN endpoint TxFIFO depth"]
pub fn set_ineptxfd (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for OtgHsDieptxf4 { fn default () -> OtgHsDieptxf4 { OtgHsDieptxf4 (0) } } # [doc = "OTG_HS Receive FIFO size register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsGrxfsiz (pub u32) ; impl OtgHsGrxfsiz { # [doc = "RxFIFO depth"]
pub const fn rxfd (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "RxFIFO depth"]
pub fn set_rxfd (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for OtgHsGrxfsiz { fn default () -> OtgHsGrxfsiz { OtgHsGrxfsiz (0) } } # [doc = "OTG_HS interrupt mask register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsGintmsk (pub u32) ; impl OtgHsGintmsk { # [doc = "Mode mismatch interrupt mask"]
pub const fn mmism (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Mode mismatch interrupt mask"]
pub fn set_mmism (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "OTG interrupt mask"]
pub const fn otgint (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "OTG interrupt mask"]
pub fn set_otgint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Start of frame mask"]
pub const fn sofm (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Start of frame mask"]
pub fn set_sofm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Receive FIFO nonempty mask"]
pub const fn rxflvlm (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Receive FIFO nonempty mask"]
pub fn set_rxflvlm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Nonperiodic TxFIFO empty mask"]
pub const fn nptxfem (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Nonperiodic TxFIFO empty mask"]
pub fn set_nptxfem (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Global nonperiodic IN NAK effective mask"]
pub const fn ginakeffm (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Global nonperiodic IN NAK effective mask"]
pub fn set_ginakeffm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Global OUT NAK effective mask"]
pub const fn gonakeffm (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Global OUT NAK effective mask"]
pub fn set_gonakeffm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Early suspend mask"]
pub const fn esuspm (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Early suspend mask"]
pub fn set_esuspm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "USB suspend mask"]
pub const fn usbsuspm (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "USB suspend mask"]
pub fn set_usbsuspm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "USB reset mask"]
pub const fn usbrst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "USB reset mask"]
pub fn set_usbrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Enumeration done mask"]
pub const fn enumdnem (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "Enumeration done mask"]
pub fn set_enumdnem (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Isochronous OUT packet dropped interrupt mask"]
pub const fn isoodrpm (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Isochronous OUT packet dropped interrupt mask"]
pub fn set_isoodrpm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "End of periodic frame interrupt mask"]
pub const fn eopfm (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "End of periodic frame interrupt mask"]
pub fn set_eopfm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "IN endpoints interrupt mask"]
pub const fn iepint (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "IN endpoints interrupt mask"]
pub fn set_iepint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "OUT endpoints interrupt mask"]
pub const fn oepint (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "OUT endpoints interrupt mask"]
pub fn set_oepint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Incomplete isochronous IN transfer mask"]
pub const fn iisoixfrm (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Incomplete isochronous IN transfer mask"]
pub fn set_iisoixfrm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Incomplete periodic transfer mask"]
pub const fn pxfrm_iisooxfrm (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Incomplete periodic transfer mask"]
pub fn set_pxfrm_iisooxfrm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Data fetch suspended mask"]
pub const fn fsuspm (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "Data fetch suspended mask"]
pub fn set_fsuspm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Reset detected interrupt mask"]
pub const fn rstde (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Reset detected interrupt mask"]
pub fn set_rstde (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Host port interrupt mask"]
pub const fn prtim (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Host port interrupt mask"]
pub fn set_prtim (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Host channels interrupt mask"]
pub const fn hcim (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Host channels interrupt mask"]
pub fn set_hcim (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Periodic TxFIFO empty mask"]
pub const fn ptxfem (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Periodic TxFIFO empty mask"]
pub fn set_ptxfem (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "LPM interrupt mask"]
pub const fn lpmintm (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "LPM interrupt mask"]
pub fn set_lpmintm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Connector ID status change mask"]
pub const fn cidschgm (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Connector ID status change mask"]
pub fn set_cidschgm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "Disconnect detected interrupt mask"]
pub const fn discint (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "Disconnect detected interrupt mask"]
pub fn set_discint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "Session request/new session detected interrupt mask"]
pub const fn srqim (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Session request/new session detected interrupt mask"]
pub fn set_srqim (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Resume/remote wakeup detected interrupt mask"]
pub const fn wuim (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Resume/remote wakeup detected interrupt mask"]
pub fn set_wuim (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for OtgHsGintmsk { fn default () -> OtgHsGintmsk { OtgHsGintmsk (0) } } # [doc = "OTG_HS device IN endpoint transmit FIFO size register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgHsDieptxf5 (pub u32) ; impl OtgHsDieptxf5 { # [doc = "IN endpoint FIFOx transmit RAM start address"]
pub const fn ineptxsa (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "IN endpoint FIFOx transmit RAM start address"]
pub fn set_ineptxsa (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "IN endpoint TxFIFO depth"]
pub const fn ineptxfd (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "IN endpoint TxFIFO depth"]
pub fn set_ineptxfd (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for OtgHsDieptxf5 { fn default () -> OtgHsDieptxf5 { OtgHsDieptxf5 (0) } } }