

# [doc = "USB on the go full speed"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFs (pub * mut u8) ; unsafe impl Send for OtgFs { } unsafe impl Sync for OtgFs { } impl OtgFs { # [doc = "OTG_FS control and status register (OTG_FS_GOTGCTL)"]
pub fn otg_fs_gotgctl (self) -> crate :: common :: Reg < regs :: OtgFsGotgctl , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "OTG_FS interrupt register (OTG_FS_GOTGINT)"]
pub fn otg_fs_gotgint (self) -> crate :: common :: Reg < regs :: OtgFsGotgint , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "OTG_FS AHB configuration register (OTG_FS_GAHBCFG)"]
pub fn otg_fs_gahbcfg (self) -> crate :: common :: Reg < regs :: OtgFsGahbcfg , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "OTG_FS USB configuration register (OTG_FS_GUSBCFG)"]
pub fn otg_fs_gusbcfg (self) -> crate :: common :: Reg < regs :: OtgFsGusbcfg , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "OTG_FS reset register (OTG_FS_GRSTCTL)"]
pub fn otg_fs_grstctl (self) -> crate :: common :: Reg < regs :: OtgFsGrstctl , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "OTG_FS core interrupt register (OTG_FS_GINTSTS)"]
pub fn otg_fs_gintsts (self) -> crate :: common :: Reg < regs :: OtgFsGintsts , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "OTG_FS interrupt mask register (OTG_FS_GINTMSK)"]
pub fn otg_fs_gintmsk (self) -> crate :: common :: Reg < regs :: OtgFsGintmsk , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "OTG_FS Receive status debug read(Device mode)"]
pub fn otg_fs_grxstsr_device (self) -> crate :: common :: Reg < regs :: OtgFsGrxstsrDevice , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "OTG_FS Receive status debug read(Host mode)"]
pub fn otg_fs_grxstsr_host (self) -> crate :: common :: Reg < regs :: OtgFsGrxstsrHost , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "OTG status read and pop register (Device mode)"]
pub fn otg_fs_grxstsp_device (self) -> crate :: common :: Reg < regs :: OtgFsGrxstspDevice , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "OTG status read and pop register (Host mode)"]
pub fn otg_fs_grxstsp_host (self) -> crate :: common :: Reg < regs :: OtgFsGrxstspHost , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "OTG_FS Receive FIFO size register (OTG_FS_GRXFSIZ)"]
pub fn otg_fs_grxfsiz (self) -> crate :: common :: Reg < regs :: OtgFsGrxfsiz , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "OTG_FS Endpoint 0 Transmit FIFO size"]
pub fn otg_fs_dieptxf0_device (self) -> crate :: common :: Reg < regs :: OtgFsDieptxf0Device , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "OTG_FS Host non-periodic transmit FIFO size register"]
pub fn otg_fs_hnptxfsiz_host (self) -> crate :: common :: Reg < regs :: OtgFsHnptxfsizHost , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "OTG_FS non-periodic transmit FIFO/queue status register (OTG_FS_GNPTXSTS)"]
pub fn otg_fs_hnptxsts (self) -> crate :: common :: Reg < regs :: OtgFsHnptxsts , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "OTG I2C access register"]
pub fn otg_fs_gi2cctl (self) -> crate :: common :: Reg < regs :: OtgFsGi2cctl , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "OTG_FS general core configuration register (OTG_FS_GCCFG)"]
pub fn otg_fs_gccfg (self) -> crate :: common :: Reg < regs :: OtgFsGccfg , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } # [doc = "core ID register"]
pub fn otg_fs_cid (self) -> crate :: common :: Reg < regs :: OtgFsCid , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (60usize)) } } # [doc = "OTG core LPM configuration register"]
pub fn otg_fs_glpmcfg (self) -> crate :: common :: Reg < regs :: OtgFsGlpmcfg , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (84usize)) } } # [doc = "OTG power down register"]
pub fn otg_fs_gpwrdn (self) -> crate :: common :: Reg < regs :: OtgFsGpwrdn , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (88usize)) } } # [doc = "OTG ADP timer, control and status register"]
pub fn otg_fs_gadpctl (self) -> crate :: common :: Reg < regs :: OtgFsGadpctl , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (96usize)) } } # [doc = "OTG_FS Host periodic transmit FIFO size register (OTG_FS_HPTXFSIZ)"]
pub fn otg_fs_hptxfsiz (self) -> crate :: common :: Reg < regs :: OtgFsHptxfsiz , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (256usize)) } } # [doc = "OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF1)"]
pub fn otg_fs_dieptxf1 (self) -> crate :: common :: Reg < regs :: OtgFsDieptxf1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (260usize)) } } # [doc = "OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF2)"]
pub fn otg_fs_dieptxf2 (self) -> crate :: common :: Reg < regs :: OtgFsDieptxf2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (264usize)) } } # [doc = "OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF3)"]
pub fn otg_fs_dieptxf3 (self) -> crate :: common :: Reg < regs :: OtgFsDieptxf3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (268usize)) } } # [doc = "OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF4)"]
pub fn otg_fs_dieptxf4 (self) -> crate :: common :: Reg < regs :: OtgFsDieptxf4 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (272usize)) } } # [doc = "OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF5)"]
pub fn otg_fs_dieptxf5 (self) -> crate :: common :: Reg < regs :: OtgFsDieptxf5 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (276usize)) } } } pub mod regs { # [doc = "OTG core LPM configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsGlpmcfg (pub u32) ; impl OtgFsGlpmcfg { # [doc = "LPM support enable"]
pub const fn lpmen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LPM support enable"]
pub fn set_lpmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LPM token acknowledge enable"]
pub const fn lpmack (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LPM token acknowledge enable"]
pub fn set_lpmack (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Best effort service latency"]
pub const fn besl (& self) -> u8 { let val = (self . 0 >> 2usize) & 0x0f ; val as u8 } # [doc = "Best effort service latency"]
pub fn set_besl (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 2usize)) | (((val as u32) & 0x0f) << 2usize) ; } # [doc = "bRemoteWake value"]
pub const fn remwake (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "bRemoteWake value"]
pub fn set_remwake (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "L1 Shallow Sleep enable"]
pub const fn l1ssen (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "L1 Shallow Sleep enable"]
pub fn set_l1ssen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "BESL threshold"]
pub const fn beslthrs (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "BESL threshold"]
pub fn set_beslthrs (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "L1 deep sleep enable"]
pub const fn l1dsen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "L1 deep sleep enable"]
pub fn set_l1dsen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "LPM response"]
pub const fn lpmrst (& self) -> u8 { let val = (self . 0 >> 13usize) & 0x03 ; val as u8 } # [doc = "LPM response"]
pub fn set_lpmrst (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 13usize)) | (((val as u32) & 0x03) << 13usize) ; } # [doc = "Port sleep status"]
pub const fn slpsts (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Port sleep status"]
pub fn set_slpsts (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Sleep State Resume OK"]
pub const fn l1rsmok (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Sleep State Resume OK"]
pub fn set_l1rsmok (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "LPM Channel Index"]
pub const fn lpmchidx (& self) -> u8 { let val = (self . 0 >> 17usize) & 0x0f ; val as u8 } # [doc = "LPM Channel Index"]
pub fn set_lpmchidx (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 17usize)) | (((val as u32) & 0x0f) << 17usize) ; } # [doc = "LPM retry count"]
pub const fn lpmrcnt (& self) -> u8 { let val = (self . 0 >> 21usize) & 0x07 ; val as u8 } # [doc = "LPM retry count"]
pub fn set_lpmrcnt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 21usize)) | (((val as u32) & 0x07) << 21usize) ; } # [doc = "Send LPM transaction"]
pub const fn sndlpm (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Send LPM transaction"]
pub fn set_sndlpm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "LPM retry count status"]
pub const fn lpmrcntsts (& self) -> u8 { let val = (self . 0 >> 25usize) & 0x07 ; val as u8 } # [doc = "LPM retry count status"]
pub fn set_lpmrcntsts (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 25usize)) | (((val as u32) & 0x07) << 25usize) ; } # [doc = "Enable best effort service latency"]
pub const fn enbesl (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Enable best effort service latency"]
pub fn set_enbesl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } } impl Default for OtgFsGlpmcfg { fn default () -> OtgFsGlpmcfg { OtgFsGlpmcfg (0) } } # [doc = "OTG_FS non-periodic transmit FIFO/queue status register (OTG_FS_GNPTXSTS)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsHnptxsts (pub u32) ; impl OtgFsHnptxsts { # [doc = "Non-periodic TxFIFO space available"]
pub const fn nptxfsav (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Non-periodic TxFIFO space available"]
pub fn set_nptxfsav (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "Non-periodic transmit request queue space available"]
pub const fn nptqxsav (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Non-periodic transmit request queue space available"]
pub fn set_nptqxsav (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } # [doc = "Top of the non-periodic transmit request queue"]
pub const fn nptxqtop (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x7f ; val as u8 } # [doc = "Top of the non-periodic transmit request queue"]
pub fn set_nptxqtop (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 24usize)) | (((val as u32) & 0x7f) << 24usize) ; } } impl Default for OtgFsHnptxsts { fn default () -> OtgFsHnptxsts { OtgFsHnptxsts (0) } } # [doc = "OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF4)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsDieptxf4 (pub u32) ; impl OtgFsDieptxf4 { # [doc = "IN endpoint FIFOx transmit RAM start address"]
pub const fn ineptxsa (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "IN endpoint FIFOx transmit RAM start address"]
pub fn set_ineptxsa (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "IN endpoint Tx FIFO depth"]
pub const fn ineptxfd (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "IN endpoint Tx FIFO depth"]
pub fn set_ineptxfd (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for OtgFsDieptxf4 { fn default () -> OtgFsDieptxf4 { OtgFsDieptxf4 (0) } } # [doc = "OTG_FS AHB configuration register (OTG_FS_GAHBCFG)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsGahbcfg (pub u32) ; impl OtgFsGahbcfg { # [doc = "Global interrupt mask"]
pub const fn gint (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Global interrupt mask"]
pub fn set_gint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TxFIFO empty level"]
pub const fn txfelvl (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "TxFIFO empty level"]
pub fn set_txfelvl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Periodic TxFIFO empty level"]
pub const fn ptxfelvl (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Periodic TxFIFO empty level"]
pub fn set_ptxfelvl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } } impl Default for OtgFsGahbcfg { fn default () -> OtgFsGahbcfg { OtgFsGahbcfg (0) } } # [doc = "OTG_FS Receive status debug read(Device mode)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsGrxstsrDevice (pub u32) ; impl OtgFsGrxstsrDevice { # [doc = "Endpoint number"]
pub const fn epnum (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Endpoint number"]
pub fn set_epnum (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Byte count"]
pub const fn bcnt (& self) -> u16 { let val = (self . 0 >> 4usize) & 0x07ff ; val as u16 } # [doc = "Byte count"]
pub fn set_bcnt (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x07ff << 4usize)) | (((val as u32) & 0x07ff) << 4usize) ; } # [doc = "Data PID"]
pub const fn dpid (& self) -> u8 { let val = (self . 0 >> 15usize) & 0x03 ; val as u8 } # [doc = "Data PID"]
pub fn set_dpid (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 15usize)) | (((val as u32) & 0x03) << 15usize) ; } # [doc = "Packet status"]
pub const fn pktsts (& self) -> u8 { let val = (self . 0 >> 17usize) & 0x0f ; val as u8 } # [doc = "Packet status"]
pub fn set_pktsts (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 17usize)) | (((val as u32) & 0x0f) << 17usize) ; } # [doc = "Frame number"]
pub const fn frmnum (& self) -> u8 { let val = (self . 0 >> 21usize) & 0x0f ; val as u8 } # [doc = "Frame number"]
pub fn set_frmnum (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 21usize)) | (((val as u32) & 0x0f) << 21usize) ; } } impl Default for OtgFsGrxstsrDevice { fn default () -> OtgFsGrxstsrDevice { OtgFsGrxstsrDevice (0) } } # [doc = "core ID register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsCid (pub u32) ; impl OtgFsCid { # [doc = "Product ID field"]
pub const fn product_id (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Product ID field"]
pub fn set_product_id (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for OtgFsCid { fn default () -> OtgFsCid { OtgFsCid (0) } } # [doc = "OTG I2C access register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsGi2cctl (pub u32) ; impl OtgFsGi2cctl { # [doc = "I2C Read/Write Data"]
pub const fn rwdata (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "I2C Read/Write Data"]
pub fn set_rwdata (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "I2C Register Address"]
pub const fn regaddr (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "I2C Register Address"]
pub fn set_regaddr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "I2C Address"]
pub const fn addr (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x7f ; val as u8 } # [doc = "I2C Address"]
pub fn set_addr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 16usize)) | (((val as u32) & 0x7f) << 16usize) ; } # [doc = "I2C Enable"]
pub const fn i2cen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "I2C Enable"]
pub fn set_i2cen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "I2C ACK"]
pub const fn ack (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "I2C ACK"]
pub fn set_ack (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "I2C Device Address"]
pub const fn i2cdevadr (& self) -> u8 { let val = (self . 0 >> 26usize) & 0x03 ; val as u8 } # [doc = "I2C Device Address"]
pub fn set_i2cdevadr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 26usize)) | (((val as u32) & 0x03) << 26usize) ; } # [doc = "I2C DatSe0 USB mode"]
pub const fn i2cdatse0 (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "I2C DatSe0 USB mode"]
pub fn set_i2cdatse0 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "Read/Write Indicator"]
pub const fn rw (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Read/Write Indicator"]
pub fn set_rw (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "I2C Busy/Done"]
pub const fn bsydne (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "I2C Busy/Done"]
pub fn set_bsydne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for OtgFsGi2cctl { fn default () -> OtgFsGi2cctl { OtgFsGi2cctl (0) } } # [doc = "OTG_FS Endpoint 0 Transmit FIFO size"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsDieptxf0Device (pub u32) ; impl OtgFsDieptxf0Device { # [doc = "Endpoint 0 transmit RAM start address"]
pub const fn tx0fsa (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Endpoint 0 transmit RAM start address"]
pub fn set_tx0fsa (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "Endpoint 0 TxFIFO depth"]
pub const fn tx0fd (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Endpoint 0 TxFIFO depth"]
pub fn set_tx0fd (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for OtgFsDieptxf0Device { fn default () -> OtgFsDieptxf0Device { OtgFsDieptxf0Device (0) } } # [doc = "OTG_FS Host periodic transmit FIFO size register (OTG_FS_HPTXFSIZ)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsHptxfsiz (pub u32) ; impl OtgFsHptxfsiz { # [doc = "Host periodic TxFIFO start address"]
pub const fn ptxsa (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Host periodic TxFIFO start address"]
pub fn set_ptxsa (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "Host periodic TxFIFO depth"]
pub const fn ptxfsiz (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Host periodic TxFIFO depth"]
pub fn set_ptxfsiz (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for OtgFsHptxfsiz { fn default () -> OtgFsHptxfsiz { OtgFsHptxfsiz (0) } } # [doc = "OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF5)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsDieptxf5 (pub u32) ; impl OtgFsDieptxf5 { # [doc = "IN endpoint FIFOx transmit RAM start address"]
pub const fn ineptxsa (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "IN endpoint FIFOx transmit RAM start address"]
pub fn set_ineptxsa (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "IN endpoint Tx FIFO depth"]
pub const fn ineptxfd (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "IN endpoint Tx FIFO depth"]
pub fn set_ineptxfd (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for OtgFsDieptxf5 { fn default () -> OtgFsDieptxf5 { OtgFsDieptxf5 (0) } } # [doc = "OTG_FS Receive status debug read(Host mode)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsGrxstsrHost (pub u32) ; impl OtgFsGrxstsrHost { # [doc = "Endpoint number"]
pub const fn chnum (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Endpoint number"]
pub fn set_chnum (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Byte count"]
pub const fn bcnt (& self) -> u16 { let val = (self . 0 >> 4usize) & 0x07ff ; val as u16 } # [doc = "Byte count"]
pub fn set_bcnt (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x07ff << 4usize)) | (((val as u32) & 0x07ff) << 4usize) ; } # [doc = "Data PID"]
pub const fn dpid (& self) -> u8 { let val = (self . 0 >> 15usize) & 0x03 ; val as u8 } # [doc = "Data PID"]
pub fn set_dpid (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 15usize)) | (((val as u32) & 0x03) << 15usize) ; } # [doc = "Packet status"]
pub const fn pktsts (& self) -> u8 { let val = (self . 0 >> 17usize) & 0x0f ; val as u8 } # [doc = "Packet status"]
pub fn set_pktsts (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 17usize)) | (((val as u32) & 0x0f) << 17usize) ; } } impl Default for OtgFsGrxstsrHost { fn default () -> OtgFsGrxstsrHost { OtgFsGrxstsrHost (0) } } # [doc = "OTG_FS Host non-periodic transmit FIFO size register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsHnptxfsizHost (pub u32) ; impl OtgFsHnptxfsizHost { # [doc = "Non-periodic transmit RAM start address"]
pub const fn nptxfsa (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Non-periodic transmit RAM start address"]
pub fn set_nptxfsa (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "Non-periodic TxFIFO depth"]
pub const fn nptxfd (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Non-periodic TxFIFO depth"]
pub fn set_nptxfd (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for OtgFsHnptxfsizHost { fn default () -> OtgFsHnptxfsizHost { OtgFsHnptxfsizHost (0) } } # [doc = "OTG_FS reset register (OTG_FS_GRSTCTL)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsGrstctl (pub u32) ; impl OtgFsGrstctl { # [doc = "Core soft reset"]
pub const fn csrst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Core soft reset"]
pub fn set_csrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "HCLK soft reset"]
pub const fn hsrst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "HCLK soft reset"]
pub fn set_hsrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Host frame counter reset"]
pub const fn fcrst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Host frame counter reset"]
pub fn set_fcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "RxFIFO flush"]
pub const fn rxfflsh (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "RxFIFO flush"]
pub fn set_rxfflsh (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TxFIFO flush"]
pub const fn txfflsh (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TxFIFO flush"]
pub fn set_txfflsh (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "TxFIFO number"]
pub const fn txfnum (& self) -> u8 { let val = (self . 0 >> 6usize) & 0x1f ; val as u8 } # [doc = "TxFIFO number"]
pub fn set_txfnum (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 6usize)) | (((val as u32) & 0x1f) << 6usize) ; } # [doc = "AHB master idle"]
pub const fn ahbidl (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "AHB master idle"]
pub fn set_ahbidl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for OtgFsGrstctl { fn default () -> OtgFsGrstctl { OtgFsGrstctl (0) } } # [doc = "OTG_FS USB configuration register (OTG_FS_GUSBCFG)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsGusbcfg (pub u32) ; impl OtgFsGusbcfg { # [doc = "FS timeout calibration"]
pub const fn tocal (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x07 ; val as u8 } # [doc = "FS timeout calibration"]
pub fn set_tocal (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val as u32) & 0x07) << 0usize) ; } # [doc = "Full Speed serial transceiver select"]
pub const fn physel (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Full Speed serial transceiver select"]
pub fn set_physel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "SRP-capable"]
pub const fn srpcap (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "SRP-capable"]
pub fn set_srpcap (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "HNP-capable"]
pub const fn hnpcap (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "HNP-capable"]
pub fn set_hnpcap (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "USB turnaround time"]
pub const fn trdt (& self) -> u8 { let val = (self . 0 >> 10usize) & 0x0f ; val as u8 } # [doc = "USB turnaround time"]
pub fn set_trdt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 10usize)) | (((val as u32) & 0x0f) << 10usize) ; } # [doc = "Force host mode"]
pub const fn fhmod (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "Force host mode"]
pub fn set_fhmod (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "Force device mode"]
pub const fn fdmod (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Force device mode"]
pub fn set_fdmod (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } } impl Default for OtgFsGusbcfg { fn default () -> OtgFsGusbcfg { OtgFsGusbcfg (0) } } # [doc = "OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF1)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsDieptxf1 (pub u32) ; impl OtgFsDieptxf1 { # [doc = "IN endpoint FIFO2 transmit RAM start address"]
pub const fn ineptxsa (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "IN endpoint FIFO2 transmit RAM start address"]
pub fn set_ineptxsa (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "IN endpoint TxFIFO depth"]
pub const fn ineptxfd (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "IN endpoint TxFIFO depth"]
pub fn set_ineptxfd (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for OtgFsDieptxf1 { fn default () -> OtgFsDieptxf1 { OtgFsDieptxf1 (0) } } # [doc = "OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF3)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsDieptxf3 (pub u32) ; impl OtgFsDieptxf3 { # [doc = "IN endpoint FIFO4 transmit RAM start address"]
pub const fn ineptxsa (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "IN endpoint FIFO4 transmit RAM start address"]
pub fn set_ineptxsa (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "IN endpoint TxFIFO depth"]
pub const fn ineptxfd (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "IN endpoint TxFIFO depth"]
pub fn set_ineptxfd (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for OtgFsDieptxf3 { fn default () -> OtgFsDieptxf3 { OtgFsDieptxf3 (0) } } # [doc = "OTG_FS core interrupt register (OTG_FS_GINTSTS)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsGintsts (pub u32) ; impl OtgFsGintsts { # [doc = "Current mode of operation"]
pub const fn cmod (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Current mode of operation"]
pub fn set_cmod (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Mode mismatch interrupt"]
pub const fn mmis (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Mode mismatch interrupt"]
pub fn set_mmis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "OTG interrupt"]
pub const fn otgint (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "OTG interrupt"]
pub fn set_otgint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Start of frame"]
pub const fn sof (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Start of frame"]
pub fn set_sof (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "RxFIFO non-empty"]
pub const fn rxflvl (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "RxFIFO non-empty"]
pub fn set_rxflvl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Non-periodic TxFIFO empty"]
pub const fn nptxfe (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Non-periodic TxFIFO empty"]
pub fn set_nptxfe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Global IN non-periodic NAK effective"]
pub const fn ginakeff (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Global IN non-periodic NAK effective"]
pub fn set_ginakeff (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Global OUT NAK effective"]
pub const fn goutnakeff (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Global OUT NAK effective"]
pub fn set_goutnakeff (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Early suspend"]
pub const fn esusp (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Early suspend"]
pub fn set_esusp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "USB suspend"]
pub const fn usbsusp (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "USB suspend"]
pub fn set_usbsusp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "USB reset"]
pub const fn usbrst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "USB reset"]
pub fn set_usbrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Enumeration done"]
pub const fn enumdne (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "Enumeration done"]
pub fn set_enumdne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Isochronous OUT packet dropped interrupt"]
pub const fn isoodrp (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Isochronous OUT packet dropped interrupt"]
pub fn set_isoodrp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "End of periodic frame interrupt"]
pub const fn eopf (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "End of periodic frame interrupt"]
pub fn set_eopf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "IN endpoint interrupt"]
pub const fn iepint (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "IN endpoint interrupt"]
pub fn set_iepint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "OUT endpoint interrupt"]
pub const fn oepint (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "OUT endpoint interrupt"]
pub fn set_oepint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Incomplete isochronous IN transfer"]
pub const fn iisoixfr (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Incomplete isochronous IN transfer"]
pub fn set_iisoixfr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Incomplete periodic transfer(Host mode)/Incomplete isochronous OUT transfer(Device mode)"]
pub const fn ipxfr_incompisoout (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Incomplete periodic transfer(Host mode)/Incomplete isochronous OUT transfer(Device mode)"]
pub fn set_ipxfr_incompisoout (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Reset detected interrupt"]
pub const fn rstdet (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Reset detected interrupt"]
pub fn set_rstdet (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Host port interrupt"]
pub const fn hprtint (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Host port interrupt"]
pub fn set_hprtint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Host channels interrupt"]
pub const fn hcint (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Host channels interrupt"]
pub fn set_hcint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Periodic TxFIFO empty"]
pub const fn ptxfe (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Periodic TxFIFO empty"]
pub fn set_ptxfe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Connector ID status change"]
pub const fn cidschg (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Connector ID status change"]
pub fn set_cidschg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "Disconnect detected interrupt"]
pub const fn discint (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "Disconnect detected interrupt"]
pub fn set_discint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "Session request/new session detected interrupt"]
pub const fn srqint (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Session request/new session detected interrupt"]
pub fn set_srqint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Resume/remote wakeup detected interrupt"]
pub const fn wkupint (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Resume/remote wakeup detected interrupt"]
pub fn set_wkupint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for OtgFsGintsts { fn default () -> OtgFsGintsts { OtgFsGintsts (0) } } # [doc = "OTG_FS interrupt mask register (OTG_FS_GINTMSK)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsGintmsk (pub u32) ; impl OtgFsGintmsk { # [doc = "Mode mismatch interrupt mask"]
pub const fn mmism (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Mode mismatch interrupt mask"]
pub fn set_mmism (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "OTG interrupt mask"]
pub const fn otgint (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "OTG interrupt mask"]
pub fn set_otgint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Start of frame mask"]
pub const fn sofm (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Start of frame mask"]
pub fn set_sofm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Receive FIFO non-empty mask"]
pub const fn rxflvlm (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Receive FIFO non-empty mask"]
pub fn set_rxflvlm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Non-periodic TxFIFO empty mask"]
pub const fn nptxfem (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Non-periodic TxFIFO empty mask"]
pub fn set_nptxfem (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Global non-periodic IN NAK effective mask"]
pub const fn ginakeffm (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Global non-periodic IN NAK effective mask"]
pub fn set_ginakeffm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Global OUT NAK effective mask"]
pub const fn gonakeffm (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Global OUT NAK effective mask"]
pub fn set_gonakeffm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Early suspend mask"]
pub const fn esuspm (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Early suspend mask"]
pub fn set_esuspm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "USB suspend mask"]
pub const fn usbsuspm (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "USB suspend mask"]
pub fn set_usbsuspm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "USB reset mask"]
pub const fn usbrst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "USB reset mask"]
pub fn set_usbrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Enumeration done mask"]
pub const fn enumdnem (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "Enumeration done mask"]
pub fn set_enumdnem (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Isochronous OUT packet dropped interrupt mask"]
pub const fn isoodrpm (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Isochronous OUT packet dropped interrupt mask"]
pub fn set_isoodrpm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "End of periodic frame interrupt mask"]
pub const fn eopfm (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "End of periodic frame interrupt mask"]
pub fn set_eopfm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "IN endpoints interrupt mask"]
pub const fn iepint (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "IN endpoints interrupt mask"]
pub fn set_iepint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "OUT endpoints interrupt mask"]
pub const fn oepint (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "OUT endpoints interrupt mask"]
pub fn set_oepint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Incomplete isochronous IN transfer mask"]
pub const fn iisoixfrm (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Incomplete isochronous IN transfer mask"]
pub fn set_iisoixfrm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Incomplete periodic transfer mask(Host mode)/Incomplete isochronous OUT transfer mask(Device mode)"]
pub const fn ipxfrm_iisooxfrm (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Incomplete periodic transfer mask(Host mode)/Incomplete isochronous OUT transfer mask(Device mode)"]
pub fn set_ipxfrm_iisooxfrm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Reset detected interrupt mask"]
pub const fn rstdetm (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Reset detected interrupt mask"]
pub fn set_rstdetm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Host port interrupt mask"]
pub const fn prtim (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Host port interrupt mask"]
pub fn set_prtim (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Host channels interrupt mask"]
pub const fn hcim (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Host channels interrupt mask"]
pub fn set_hcim (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Periodic TxFIFO empty mask"]
pub const fn ptxfem (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Periodic TxFIFO empty mask"]
pub fn set_ptxfem (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "LPM interrupt mask"]
pub const fn lpmin (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "LPM interrupt mask"]
pub fn set_lpmin (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Connector ID status change mask"]
pub const fn cidschgm (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Connector ID status change mask"]
pub fn set_cidschgm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "Disconnect detected interrupt mask"]
pub const fn discint (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "Disconnect detected interrupt mask"]
pub fn set_discint (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "Session request/new session detected interrupt mask"]
pub const fn srqim (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Session request/new session detected interrupt mask"]
pub fn set_srqim (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Resume/remote wakeup detected interrupt mask"]
pub const fn wuim (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Resume/remote wakeup detected interrupt mask"]
pub fn set_wuim (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for OtgFsGintmsk { fn default () -> OtgFsGintmsk { OtgFsGintmsk (0) } } # [doc = "OTG_FS control and status register (OTG_FS_GOTGCTL)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsGotgctl (pub u32) ; impl OtgFsGotgctl { # [doc = "Session request success"]
pub const fn srqscs (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Session request success"]
pub fn set_srqscs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Session request"]
pub const fn srq (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Session request"]
pub fn set_srq (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "VBUS valid override enable"]
pub const fn vbvaloen (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "VBUS valid override enable"]
pub fn set_vbvaloen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "VBUS valid override value"]
pub const fn vbvaloval (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "VBUS valid override value"]
pub fn set_vbvaloval (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "A-peripheral session valid override enable"]
pub const fn avaloen (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "A-peripheral session valid override enable"]
pub fn set_avaloen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "A-peripheral session valid override value"]
pub const fn avaloval (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "A-peripheral session valid override value"]
pub fn set_avaloval (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "B-peripheral session valid override enable"]
pub const fn bvaloen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "B-peripheral session valid override enable"]
pub fn set_bvaloen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "B-peripheral session valid override value"]
pub const fn bvaloval (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "B-peripheral session valid override value"]
pub fn set_bvaloval (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Host negotiation success"]
pub const fn hngscs (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Host negotiation success"]
pub fn set_hngscs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "HNP request"]
pub const fn hnprq (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "HNP request"]
pub fn set_hnprq (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Host set HNP enable"]
pub const fn hshnpen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Host set HNP enable"]
pub fn set_hshnpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Device HNP enabled"]
pub const fn dhnpen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Device HNP enabled"]
pub fn set_dhnpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "Embedded host enable"]
pub const fn ehen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Embedded host enable"]
pub fn set_ehen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Connector ID status"]
pub const fn cidsts (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Connector ID status"]
pub fn set_cidsts (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Long/short debounce time"]
pub const fn dbct (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Long/short debounce time"]
pub fn set_dbct (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "A-session valid"]
pub const fn asvld (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "A-session valid"]
pub fn set_asvld (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "B-session valid"]
pub const fn bsvld (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "B-session valid"]
pub fn set_bsvld (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "OTG version"]
pub const fn otgver (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "OTG version"]
pub fn set_otgver (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } } impl Default for OtgFsGotgctl { fn default () -> OtgFsGotgctl { OtgFsGotgctl (0) } } # [doc = "OTG status read and pop register (Device mode)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsGrxstspDevice (pub u32) ; impl OtgFsGrxstspDevice { # [doc = "Endpoint number"]
pub const fn epnum (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Endpoint number"]
pub fn set_epnum (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Byte count"]
pub const fn bcnt (& self) -> u16 { let val = (self . 0 >> 4usize) & 0x07ff ; val as u16 } # [doc = "Byte count"]
pub fn set_bcnt (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x07ff << 4usize)) | (((val as u32) & 0x07ff) << 4usize) ; } # [doc = "Data PID"]
pub const fn dpid (& self) -> u8 { let val = (self . 0 >> 15usize) & 0x03 ; val as u8 } # [doc = "Data PID"]
pub fn set_dpid (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 15usize)) | (((val as u32) & 0x03) << 15usize) ; } # [doc = "Packet status"]
pub const fn pktsts (& self) -> u8 { let val = (self . 0 >> 17usize) & 0x0f ; val as u8 } # [doc = "Packet status"]
pub fn set_pktsts (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 17usize)) | (((val as u32) & 0x0f) << 17usize) ; } # [doc = "Frame number"]
pub const fn frmnum (& self) -> u8 { let val = (self . 0 >> 21usize) & 0x0f ; val as u8 } # [doc = "Frame number"]
pub fn set_frmnum (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 21usize)) | (((val as u32) & 0x0f) << 21usize) ; } } impl Default for OtgFsGrxstspDevice { fn default () -> OtgFsGrxstspDevice { OtgFsGrxstspDevice (0) } } # [doc = "OTG_FS Receive FIFO size register (OTG_FS_GRXFSIZ)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsGrxfsiz (pub u32) ; impl OtgFsGrxfsiz { # [doc = "RxFIFO depth"]
pub const fn rxfd (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "RxFIFO depth"]
pub fn set_rxfd (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for OtgFsGrxfsiz { fn default () -> OtgFsGrxfsiz { OtgFsGrxfsiz (0) } } # [doc = "OTG ADP timer, control and status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsGadpctl (pub u32) ; impl OtgFsGadpctl { # [doc = "Probe discharge"]
pub const fn prbdschg (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x03 ; val as u8 } # [doc = "Probe discharge"]
pub fn set_prbdschg (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val as u32) & 0x03) << 0usize) ; } # [doc = "Probe delta"]
pub const fn prbdelta (& self) -> u8 { let val = (self . 0 >> 2usize) & 0x03 ; val as u8 } # [doc = "Probe delta"]
pub fn set_prbdelta (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val as u32) & 0x03) << 2usize) ; } # [doc = "Probe period"]
pub const fn prbper (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x03 ; val as u8 } # [doc = "Probe period"]
pub fn set_prbper (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 4usize)) | (((val as u32) & 0x03) << 4usize) ; } # [doc = "Ramp time"]
pub const fn rtim (& self) -> u16 { let val = (self . 0 >> 6usize) & 0x07ff ; val as u16 } # [doc = "Ramp time"]
pub fn set_rtim (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x07ff << 6usize)) | (((val as u32) & 0x07ff) << 6usize) ; } # [doc = "Enable probe"]
pub const fn enaprb (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Enable probe"]
pub fn set_enaprb (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Enable sense"]
pub const fn enasns (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Enable sense"]
pub fn set_enasns (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "ADP reset"]
pub const fn adprst (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "ADP reset"]
pub fn set_adprst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "ADP enable"]
pub const fn adpen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "ADP enable"]
pub fn set_adpen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "ADP probe interrupt flag"]
pub const fn adpprbif (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "ADP probe interrupt flag"]
pub fn set_adpprbif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "ADP sense interrupt flag"]
pub const fn adpsnsif (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "ADP sense interrupt flag"]
pub fn set_adpsnsif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "ADP timeout interrupt flag"]
pub const fn adptoif (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "ADP timeout interrupt flag"]
pub fn set_adptoif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "ADP probe interrupt mask"]
pub const fn adpprbim (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "ADP probe interrupt mask"]
pub fn set_adpprbim (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "ADP sense interrupt mask"]
pub const fn adpsnsim (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "ADP sense interrupt mask"]
pub fn set_adpsnsim (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "ADP timeout interrupt mask"]
pub const fn adptoim (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "ADP timeout interrupt mask"]
pub fn set_adptoim (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Access request"]
pub const fn ar (& self) -> u8 { let val = (self . 0 >> 27usize) & 0x03 ; val as u8 } # [doc = "Access request"]
pub fn set_ar (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 27usize)) | (((val as u32) & 0x03) << 27usize) ; } } impl Default for OtgFsGadpctl { fn default () -> OtgFsGadpctl { OtgFsGadpctl (0) } } # [doc = "OTG status read and pop register (Host mode)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsGrxstspHost (pub u32) ; impl OtgFsGrxstspHost { # [doc = "Channel number"]
pub const fn chnum (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Channel number"]
pub fn set_chnum (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "Byte count"]
pub const fn bcnt (& self) -> u16 { let val = (self . 0 >> 4usize) & 0x07ff ; val as u16 } # [doc = "Byte count"]
pub fn set_bcnt (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x07ff << 4usize)) | (((val as u32) & 0x07ff) << 4usize) ; } # [doc = "Data PID"]
pub const fn dpid (& self) -> u8 { let val = (self . 0 >> 15usize) & 0x03 ; val as u8 } # [doc = "Data PID"]
pub fn set_dpid (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 15usize)) | (((val as u32) & 0x03) << 15usize) ; } # [doc = "Packet status"]
pub const fn pktsts (& self) -> u8 { let val = (self . 0 >> 17usize) & 0x0f ; val as u8 } # [doc = "Packet status"]
pub fn set_pktsts (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 17usize)) | (((val as u32) & 0x0f) << 17usize) ; } } impl Default for OtgFsGrxstspHost { fn default () -> OtgFsGrxstspHost { OtgFsGrxstspHost (0) } } # [doc = "OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF2)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsDieptxf2 (pub u32) ; impl OtgFsDieptxf2 { # [doc = "IN endpoint FIFO3 transmit RAM start address"]
pub const fn ineptxsa (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "IN endpoint FIFO3 transmit RAM start address"]
pub fn set_ineptxsa (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "IN endpoint TxFIFO depth"]
pub const fn ineptxfd (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "IN endpoint TxFIFO depth"]
pub fn set_ineptxfd (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for OtgFsDieptxf2 { fn default () -> OtgFsDieptxf2 { OtgFsDieptxf2 (0) } } # [doc = "OTG power down register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsGpwrdn (pub u32) ; impl OtgFsGpwrdn { # [doc = "ADP module enable"]
pub const fn adpmen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "ADP module enable"]
pub fn set_adpmen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "ADP interrupt flag"]
pub const fn adpif (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "ADP interrupt flag"]
pub fn set_adpif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } } impl Default for OtgFsGpwrdn { fn default () -> OtgFsGpwrdn { OtgFsGpwrdn (0) } } # [doc = "OTG_FS general core configuration register (OTG_FS_GCCFG)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsGccfg (pub u32) ; impl OtgFsGccfg { # [doc = "Data contact detection (DCD) status"]
pub const fn dcdet (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Data contact detection (DCD) status"]
pub fn set_dcdet (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Primary detection (PD) status"]
pub const fn pdet (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Primary detection (PD) status"]
pub fn set_pdet (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Secondary detection (SD) status"]
pub const fn sdet (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Secondary detection (SD) status"]
pub fn set_sdet (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "DM pull-up detection status"]
pub const fn ps2det (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "DM pull-up detection status"]
pub fn set_ps2det (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Power down"]
pub const fn pwrdwn (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Power down"]
pub fn set_pwrdwn (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Battery charging detector (BCD) enable"]
pub const fn bcden (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Battery charging detector (BCD) enable"]
pub fn set_bcden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Data contact detection (DCD) mode enable"]
pub const fn dcden (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Data contact detection (DCD) mode enable"]
pub fn set_dcden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Primary detection (PD) mode enable"]
pub const fn pden (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Primary detection (PD) mode enable"]
pub fn set_pden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Secondary detection (SD) mode enable"]
pub const fn sden (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Secondary detection (SD) mode enable"]
pub fn set_sden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "USB VBUS detection enable"]
pub const fn vbden (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "USB VBUS detection enable"]
pub fn set_vbden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } } impl Default for OtgFsGccfg { fn default () -> OtgFsGccfg { OtgFsGccfg (0) } } # [doc = "OTG_FS interrupt register (OTG_FS_GOTGINT)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OtgFsGotgint (pub u32) ; impl OtgFsGotgint { # [doc = "Session end detected"]
pub const fn sedet (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Session end detected"]
pub fn set_sedet (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Session request success status change"]
pub const fn srsschg (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Session request success status change"]
pub fn set_srsschg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Host negotiation success status change"]
pub const fn hnsschg (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Host negotiation success status change"]
pub fn set_hnsschg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Host negotiation detected"]
pub const fn hngdet (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Host negotiation detected"]
pub fn set_hngdet (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "A-device timeout change"]
pub const fn adtochg (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "A-device timeout change"]
pub fn set_adtochg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Debounce done"]
pub const fn dbcdne (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Debounce done"]
pub fn set_dbcdne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "ID input pin changed"]
pub const fn idchng (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "ID input pin changed"]
pub fn set_idchng (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } } impl Default for OtgFsGotgint { fn default () -> OtgFsGotgint { OtgFsGotgint (0) } } }