

# [doc = "Management data input/output slave"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Mdios (pub * mut u8) ; unsafe impl Send for Mdios { } unsafe impl Sync for Mdios { } impl Mdios { # [doc = "MDIOS configuration register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "MDIOS write flag register"]
pub fn wrfr (self) -> crate :: common :: Reg < regs :: Wrfr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "MDIOS clear write flag register"]
pub fn cwrfr (self) -> crate :: common :: Reg < regs :: Cwrfr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "MDIOS read flag register"]
pub fn rdfr (self) -> crate :: common :: Reg < regs :: Rdfr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "MDIOS clear read flag register"]
pub fn crdfr (self) -> crate :: common :: Reg < regs :: Crdfr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "MDIOS status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "MDIOS clear flag register"]
pub fn clrfr (self) -> crate :: common :: Reg < regs :: Clrfr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "MDIOS input data register %s"]
pub fn dinr (self , n : usize) -> crate :: common :: Reg < regs :: Dinr , crate :: common :: R > { assert ! (n < 32usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize + n * 4usize)) } } # [doc = "MDIOS output data register %s"]
pub fn doutr (self , n : usize) -> crate :: common :: Reg < regs :: Doutr , crate :: common :: RW > { assert ! (n < 32usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (156usize + n * 4usize)) } } } pub mod regs { # [doc = "MDIOS status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr (pub u32) ; impl Sr { # [doc = "Preamble error flag"]
pub const fn perf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Preamble error flag"]
pub fn set_perf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Start error flag"]
pub const fn serf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Start error flag"]
pub fn set_serf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Turnaround error flag"]
pub const fn terf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Turnaround error flag"]
pub fn set_terf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } } impl Default for Sr { fn default () -> Sr { Sr (0) } } # [doc = "MDIOS clear write flag register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cwrfr (pub u32) ; impl Cwrfr { # [doc = "Clear the write flag"]
pub const fn cwrf (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Clear the write flag"]
pub fn set_cwrf (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Cwrfr { fn default () -> Cwrfr { Cwrfr (0) } } # [doc = "MDIOS write flag register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Wrfr (pub u32) ; impl Wrfr { # [doc = "Write flags for MDIO registers 0 to 31"]
pub const fn wrf (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Write flags for MDIO registers 0 to 31"]
pub fn set_wrf (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Wrfr { fn default () -> Wrfr { Wrfr (0) } } # [doc = "MDIOS read flag register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rdfr (pub u32) ; impl Rdfr { # [doc = "Read flags for MDIO registers 0 to 31"]
pub const fn rdf (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Read flags for MDIO registers 0 to 31"]
pub fn set_rdf (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Rdfr { fn default () -> Rdfr { Rdfr (0) } } # [doc = "MDIOS configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Peripheral enable"]
pub const fn en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Peripheral enable"]
pub fn set_en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Register write interrupt enable"]
pub const fn wrie (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Register write interrupt enable"]
pub fn set_wrie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Register Read Interrupt Enable"]
pub const fn rdie (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Register Read Interrupt Enable"]
pub fn set_rdie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Error interrupt enable"]
pub const fn eie (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Error interrupt enable"]
pub fn set_eie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Disable Preamble Check"]
pub const fn dpc (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Disable Preamble Check"]
pub fn set_dpc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Slaves's address"]
pub const fn port_address (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x1f ; val as u8 } # [doc = "Slaves's address"]
pub fn set_port_address (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 8usize)) | (((val as u32) & 0x1f) << 8usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "MDIOS clear flag register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Clrfr (pub u32) ; impl Clrfr { # [doc = "Clear the preamble error flag"]
pub const fn cperf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Clear the preamble error flag"]
pub fn set_cperf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Clear the start error flag"]
pub const fn cserf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Clear the start error flag"]
pub fn set_cserf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Clear the turnaround error flag"]
pub const fn cterf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Clear the turnaround error flag"]
pub fn set_cterf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } } impl Default for Clrfr { fn default () -> Clrfr { Clrfr (0) } } # [doc = "MDIOS output data register %s"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Doutr (pub u32) ; impl Doutr { # [doc = "Output data sent to MDIO Master during read frames"]
pub const fn dout (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Output data sent to MDIO Master during read frames"]
pub fn set_dout (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Doutr { fn default () -> Doutr { Doutr (0) } } # [doc = "MDIOS input data register %s"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dinr (pub u32) ; impl Dinr { # [doc = "Input data received from MDIO Master during write frames"]
pub const fn din (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Input data received from MDIO Master during write frames"]
pub fn set_din (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Dinr { fn default () -> Dinr { Dinr (0) } } # [doc = "MDIOS clear read flag register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Crdfr (pub u32) ; impl Crdfr { # [doc = "Clear the read flag"]
pub const fn crdf (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Clear the read flag"]
pub fn set_crdf (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Crdfr { fn default () -> Crdfr { Crdfr (0) } } }