

# [doc = "LCD-TFT Controller"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ltdc (pub * mut u8) ; unsafe impl Send for Ltdc { } unsafe impl Sync for Ltdc { } impl Ltdc { # [doc = "Synchronization Size Configuration Register"]
pub fn sscr (self) -> crate :: common :: Reg < regs :: Sscr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Back Porch Configuration Register"]
pub fn bpcr (self) -> crate :: common :: Reg < regs :: Bpcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Active Width Configuration Register"]
pub fn awcr (self) -> crate :: common :: Reg < regs :: Awcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Total Width Configuration Register"]
pub fn twcr (self) -> crate :: common :: Reg < regs :: Twcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "Global Control Register"]
pub fn gcr (self) -> crate :: common :: Reg < regs :: Gcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "Shadow Reload Configuration Register"]
pub fn srcr (self) -> crate :: common :: Reg < regs :: Srcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "Background Color Configuration Register"]
pub fn bccr (self) -> crate :: common :: Reg < regs :: Bccr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "Interrupt Enable Register"]
pub fn ier (self) -> crate :: common :: Reg < regs :: Ier , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize)) } } # [doc = "Interrupt Status Register"]
pub fn isr (self) -> crate :: common :: Reg < regs :: Isr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } # [doc = "Interrupt Clear Register"]
pub fn icr (self) -> crate :: common :: Reg < regs :: Icr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (60usize)) } } # [doc = "Line Interrupt Position Configuration Register"]
pub fn lipcr (self) -> crate :: common :: Reg < regs :: Lipcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (64usize)) } } # [doc = "Current Position Status Register"]
pub fn cpsr (self) -> crate :: common :: Reg < regs :: Cpsr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (68usize)) } } # [doc = "Current Display Status Register"]
pub fn cdsr (self) -> crate :: common :: Reg < regs :: Cdsr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "Cluster LAYER%s, containing L?CR, L?WHPCR, L?WVPCR, L?CKCR, L?PFCR, L?CACR, L?DCCR, L?BFCR, L?CFBAR, L?CFBLR, L?CFBLNR, L?CLUTWR"]
pub fn layer (self , n : usize) -> Layer { assert ! (n < 2usize) ; unsafe { Layer (self . 0 . add (132usize + n * 128usize)) } } } # [doc = "Cluster LAYER%s, containing L?CR, L?WHPCR, L?WVPCR, L?CKCR, L?PFCR, L?CACR, L?DCCR, L?BFCR, L?CFBAR, L?CFBLR, L?CFBLNR, L?CLUTWR"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Layer (pub * mut u8) ; unsafe impl Send for Layer { } unsafe impl Sync for Layer { } impl Layer { # [doc = "Layerx Control Register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Layerx Window Horizontal Position Configuration Register"]
pub fn whpcr (self) -> crate :: common :: Reg < regs :: Whpcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Layerx Window Vertical Position Configuration Register"]
pub fn wvpcr (self) -> crate :: common :: Reg < regs :: Wvpcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Layerx Color Keying Configuration Register"]
pub fn ckcr (self) -> crate :: common :: Reg < regs :: Ckcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Layerx Pixel Format Configuration Register"]
pub fn pfcr (self) -> crate :: common :: Reg < regs :: Pfcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Layerx Constant Alpha Configuration Register"]
pub fn cacr (self) -> crate :: common :: Reg < regs :: Cacr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "Layerx Default Color Configuration Register"]
pub fn dccr (self) -> crate :: common :: Reg < regs :: Dccr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "Layerx Blending Factors Configuration Register"]
pub fn bfcr (self) -> crate :: common :: Reg < regs :: Bfcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "Layerx Color Frame Buffer Address Register"]
pub fn cfbar (self) -> crate :: common :: Reg < regs :: Cfbar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "Layerx Color Frame Buffer Length Register"]
pub fn cfblr (self) -> crate :: common :: Reg < regs :: Cfblr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "Layerx ColorFrame Buffer Line Number Register"]
pub fn cfblnr (self) -> crate :: common :: Reg < regs :: Cfblnr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "Layerx CLUT Write Register"]
pub fn clutwr (self) -> crate :: common :: Reg < regs :: Clutwr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (64usize)) } } } pub mod regs { # [doc = "Layerx Color Keying Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ckcr (pub u32) ; impl Ckcr { # [doc = "Color Key Blue value"]
pub const fn ckblue (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Color Key Blue value"]
pub fn set_ckblue (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Color Key Green value"]
pub const fn ckgreen (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Color Key Green value"]
pub fn set_ckgreen (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "Color Key Red value"]
pub const fn ckred (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Color Key Red value"]
pub fn set_ckred (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } } impl Default for Ckcr { fn default () -> Ckcr { Ckcr (0) } } # [doc = "Global Control Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Gcr (pub u32) ; impl Gcr { # [doc = "LCD-TFT controller enable bit"]
pub const fn ltdcen (& self) -> super :: vals :: Ltdcen { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Ltdcen (val as u8) } # [doc = "LCD-TFT controller enable bit"]
pub fn set_ltdcen (& mut self , val : super :: vals :: Ltdcen) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Dither Blue Width"]
pub const fn dbw (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x07 ; val as u8 } # [doc = "Dither Blue Width"]
pub fn set_dbw (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val as u32) & 0x07) << 4usize) ; } # [doc = "Dither Green Width"]
pub const fn dgw (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x07 ; val as u8 } # [doc = "Dither Green Width"]
pub fn set_dgw (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 8usize)) | (((val as u32) & 0x07) << 8usize) ; } # [doc = "Dither Red Width"]
pub const fn drw (& self) -> u8 { let val = (self . 0 >> 12usize) & 0x07 ; val as u8 } # [doc = "Dither Red Width"]
pub fn set_drw (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 12usize)) | (((val as u32) & 0x07) << 12usize) ; } # [doc = "Dither Enable"]
pub const fn den (& self) -> super :: vals :: Den { let val = (self . 0 >> 16usize) & 0x01 ; super :: vals :: Den (val as u8) } # [doc = "Dither Enable"]
pub fn set_den (& mut self , val : super :: vals :: Den) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val . 0 as u32) & 0x01) << 16usize) ; } # [doc = "Pixel Clock Polarity"]
pub const fn pcpol (& self) -> super :: vals :: Pcpol { let val = (self . 0 >> 28usize) & 0x01 ; super :: vals :: Pcpol (val as u8) } # [doc = "Pixel Clock Polarity"]
pub fn set_pcpol (& mut self , val : super :: vals :: Pcpol) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val . 0 as u32) & 0x01) << 28usize) ; } # [doc = "Data Enable Polarity"]
pub const fn depol (& self) -> super :: vals :: Depol { let val = (self . 0 >> 29usize) & 0x01 ; super :: vals :: Depol (val as u8) } # [doc = "Data Enable Polarity"]
pub fn set_depol (& mut self , val : super :: vals :: Depol) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val . 0 as u32) & 0x01) << 29usize) ; } # [doc = "Vertical Synchronization Polarity"]
pub const fn vspol (& self) -> super :: vals :: Vspol { let val = (self . 0 >> 30usize) & 0x01 ; super :: vals :: Vspol (val as u8) } # [doc = "Vertical Synchronization Polarity"]
pub fn set_vspol (& mut self , val : super :: vals :: Vspol) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val . 0 as u32) & 0x01) << 30usize) ; } # [doc = "Horizontal Synchronization Polarity"]
pub const fn hspol (& self) -> super :: vals :: Hspol { let val = (self . 0 >> 31usize) & 0x01 ; super :: vals :: Hspol (val as u8) } # [doc = "Horizontal Synchronization Polarity"]
pub fn set_hspol (& mut self , val : super :: vals :: Hspol) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val . 0 as u32) & 0x01) << 31usize) ; } } impl Default for Gcr { fn default () -> Gcr { Gcr (0) } } # [doc = "Background Color Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bccr (pub u32) ; impl Bccr { # [doc = "Background color blue value"]
pub const fn bcblue (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Background color blue value"]
pub fn set_bcblue (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Background color green value"]
pub const fn bcgreen (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Background color green value"]
pub fn set_bcgreen (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "Background color red value"]
pub const fn bcred (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Background color red value"]
pub fn set_bcred (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } } impl Default for Bccr { fn default () -> Bccr { Bccr (0) } } # [doc = "Layerx Window Vertical Position Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Wvpcr (pub u32) ; impl Wvpcr { # [doc = "Window Vertical Start Position"]
pub const fn wvstpos (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x07ff ; val as u16 } # [doc = "Window Vertical Start Position"]
pub fn set_wvstpos (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x07ff << 0usize)) | (((val as u32) & 0x07ff) << 0usize) ; } # [doc = "Window Vertical Stop Position"]
pub const fn wvsppos (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x07ff ; val as u16 } # [doc = "Window Vertical Stop Position"]
pub fn set_wvsppos (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x07ff << 16usize)) | (((val as u32) & 0x07ff) << 16usize) ; } } impl Default for Wvpcr { fn default () -> Wvpcr { Wvpcr (0) } } # [doc = "Layerx Blending Factors Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bfcr (pub u32) ; impl Bfcr { # [doc = "Blending Factor 2"]
pub fn bf (& self , n : usize) -> super :: vals :: Bf2 { assert ! (n < 2usize) ; let offs = 0usize + n * 8usize ; let val = (self . 0 >> offs) & 0x07 ; super :: vals :: Bf2 (val as u8) } # [doc = "Blending Factor 2"]
pub fn set_bf (& mut self , n : usize , val : super :: vals :: Bf2) { assert ! (n < 2usize) ; let offs = 0usize + n * 8usize ; self . 0 = (self . 0 & ! (0x07 << offs)) | (((val . 0 as u32) & 0x07) << offs) ; } } impl Default for Bfcr { fn default () -> Bfcr { Bfcr (0) } } # [doc = "Current Display Status Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cdsr (pub u32) ; impl Cdsr { # [doc = "Vertical Data Enable display Status"]
pub const fn vdes (& self) -> super :: vals :: Vdes { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Vdes (val as u8) } # [doc = "Vertical Data Enable display Status"]
pub fn set_vdes (& mut self , val : super :: vals :: Vdes) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Horizontal Data Enable display Status"]
pub const fn hdes (& self) -> super :: vals :: Hdes { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Hdes (val as u8) } # [doc = "Horizontal Data Enable display Status"]
pub fn set_hdes (& mut self , val : super :: vals :: Hdes) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Vertical Synchronization display Status"]
pub const fn vsyncs (& self) -> super :: vals :: Vsyncs { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Vsyncs (val as u8) } # [doc = "Vertical Synchronization display Status"]
pub fn set_vsyncs (& mut self , val : super :: vals :: Vsyncs) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Horizontal Synchronization display Status"]
pub const fn hsyncs (& self) -> super :: vals :: Hsyncs { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Hsyncs (val as u8) } # [doc = "Horizontal Synchronization display Status"]
pub fn set_hsyncs (& mut self , val : super :: vals :: Hsyncs) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } } impl Default for Cdsr { fn default () -> Cdsr { Cdsr (0) } } # [doc = "Current Position Status Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cpsr (pub u32) ; impl Cpsr { # [doc = "Current Y Position"]
pub const fn cypos (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Current Y Position"]
pub fn set_cypos (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "Current X Position"]
pub const fn cxpos (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Current X Position"]
pub fn set_cxpos (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for Cpsr { fn default () -> Cpsr { Cpsr (0) } } # [doc = "Interrupt Clear Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Icr (pub u32) ; impl Icr { # [doc = "Clears the Line Interrupt Flag"]
pub const fn clif (& self) -> super :: vals :: Clif { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Clif (val as u8) } # [doc = "Clears the Line Interrupt Flag"]
pub fn set_clif (& mut self , val : super :: vals :: Clif) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Clears the FIFO Underrun Interrupt flag"]
pub const fn cfuif (& self) -> super :: vals :: Cfuif { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Cfuif (val as u8) } # [doc = "Clears the FIFO Underrun Interrupt flag"]
pub fn set_cfuif (& mut self , val : super :: vals :: Cfuif) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Clears the Transfer Error Interrupt Flag"]
pub const fn cterrif (& self) -> super :: vals :: Cterrif { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Cterrif (val as u8) } # [doc = "Clears the Transfer Error Interrupt Flag"]
pub fn set_cterrif (& mut self , val : super :: vals :: Cterrif) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Clears Register Reload Interrupt Flag"]
pub const fn crrif (& self) -> super :: vals :: Crrif { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Crrif (val as u8) } # [doc = "Clears Register Reload Interrupt Flag"]
pub fn set_crrif (& mut self , val : super :: vals :: Crrif) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } } impl Default for Icr { fn default () -> Icr { Icr (0) } } # [doc = "Active Width Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Awcr (pub u32) ; impl Awcr { # [doc = "Accumulated Active Height (in units of horizontal scan line)"]
pub const fn aah (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x07ff ; val as u16 } # [doc = "Accumulated Active Height (in units of horizontal scan line)"]
pub fn set_aah (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x07ff << 0usize)) | (((val as u32) & 0x07ff) << 0usize) ; } # [doc = "Accumulated Active Width (in units of pixel clock period)"]
pub const fn aaw (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x0fff ; val as u16 } # [doc = "Accumulated Active Width (in units of pixel clock period)"]
pub fn set_aaw (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 16usize)) | (((val as u32) & 0x0fff) << 16usize) ; } } impl Default for Awcr { fn default () -> Awcr { Awcr (0) } } # [doc = "Interrupt Enable Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ier (pub u32) ; impl Ier { # [doc = "Line Interrupt Enable"]
pub const fn lie (& self) -> super :: vals :: Lie { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Lie (val as u8) } # [doc = "Line Interrupt Enable"]
pub fn set_lie (& mut self , val : super :: vals :: Lie) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "FIFO Underrun Interrupt Enable"]
pub const fn fuie (& self) -> super :: vals :: Fuie { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Fuie (val as u8) } # [doc = "FIFO Underrun Interrupt Enable"]
pub fn set_fuie (& mut self , val : super :: vals :: Fuie) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Transfer Error Interrupt Enable"]
pub const fn terrie (& self) -> super :: vals :: Terrie { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Terrie (val as u8) } # [doc = "Transfer Error Interrupt Enable"]
pub fn set_terrie (& mut self , val : super :: vals :: Terrie) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Register Reload interrupt enable"]
pub const fn rrie (& self) -> super :: vals :: Rrie { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Rrie (val as u8) } # [doc = "Register Reload interrupt enable"]
pub fn set_rrie (& mut self , val : super :: vals :: Rrie) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } } impl Default for Ier { fn default () -> Ier { Ier (0) } } # [doc = "Layerx Color Frame Buffer Length Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfblr (pub u32) ; impl Cfblr { # [doc = "Color Frame Buffer Line Length"]
pub const fn cfbll (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x1fff ; val as u16 } # [doc = "Color Frame Buffer Line Length"]
pub fn set_cfbll (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x1fff << 0usize)) | (((val as u32) & 0x1fff) << 0usize) ; } # [doc = "Color Frame Buffer Pitch in bytes"]
pub const fn cfbp (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x1fff ; val as u16 } # [doc = "Color Frame Buffer Pitch in bytes"]
pub fn set_cfbp (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x1fff << 16usize)) | (((val as u32) & 0x1fff) << 16usize) ; } } impl Default for Cfblr { fn default () -> Cfblr { Cfblr (0) } } # [doc = "Back Porch Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bpcr (pub u32) ; impl Bpcr { # [doc = "Accumulated Vertical back porch (in units of horizontal scan line)"]
pub const fn avbp (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x07ff ; val as u16 } # [doc = "Accumulated Vertical back porch (in units of horizontal scan line)"]
pub fn set_avbp (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x07ff << 0usize)) | (((val as u32) & 0x07ff) << 0usize) ; } # [doc = "Accumulated Horizontal back porch (in units of pixel clock period)"]
pub const fn ahbp (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x0fff ; val as u16 } # [doc = "Accumulated Horizontal back porch (in units of pixel clock period)"]
pub fn set_ahbp (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 16usize)) | (((val as u32) & 0x0fff) << 16usize) ; } } impl Default for Bpcr { fn default () -> Bpcr { Bpcr (0) } } # [doc = "Interrupt Status Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Isr (pub u32) ; impl Isr { # [doc = "Line Interrupt flag"]
pub const fn lif (& self) -> super :: vals :: Lif { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Lif (val as u8) } # [doc = "Line Interrupt flag"]
pub fn set_lif (& mut self , val : super :: vals :: Lif) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "FIFO Underrun Interrupt flag"]
pub const fn fuif (& self) -> super :: vals :: Fuif { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Fuif (val as u8) } # [doc = "FIFO Underrun Interrupt flag"]
pub fn set_fuif (& mut self , val : super :: vals :: Fuif) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Transfer Error interrupt flag"]
pub const fn terrif (& self) -> super :: vals :: Terrif { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Terrif (val as u8) } # [doc = "Transfer Error interrupt flag"]
pub fn set_terrif (& mut self , val : super :: vals :: Terrif) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Register Reload Interrupt Flag"]
pub const fn rrif (& self) -> super :: vals :: Rrif { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Rrif (val as u8) } # [doc = "Register Reload Interrupt Flag"]
pub fn set_rrif (& mut self , val : super :: vals :: Rrif) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } } impl Default for Isr { fn default () -> Isr { Isr (0) } } # [doc = "Line Interrupt Position Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Lipcr (pub u32) ; impl Lipcr { # [doc = "Line Interrupt Position"]
pub const fn lipos (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x07ff ; val as u16 } # [doc = "Line Interrupt Position"]
pub fn set_lipos (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x07ff << 0usize)) | (((val as u32) & 0x07ff) << 0usize) ; } } impl Default for Lipcr { fn default () -> Lipcr { Lipcr (0) } } # [doc = "Total Width Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Twcr (pub u32) ; impl Twcr { # [doc = "Total Height (in units of horizontal scan line)"]
pub const fn totalh (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x07ff ; val as u16 } # [doc = "Total Height (in units of horizontal scan line)"]
pub fn set_totalh (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x07ff << 0usize)) | (((val as u32) & 0x07ff) << 0usize) ; } # [doc = "Total Width (in units of pixel clock period)"]
pub const fn totalw (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x0fff ; val as u16 } # [doc = "Total Width (in units of pixel clock period)"]
pub fn set_totalw (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 16usize)) | (((val as u32) & 0x0fff) << 16usize) ; } } impl Default for Twcr { fn default () -> Twcr { Twcr (0) } } # [doc = "Layerx ColorFrame Buffer Line Number Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfblnr (pub u32) ; impl Cfblnr { # [doc = "Frame Buffer Line Number"]
pub const fn cfblnbr (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x07ff ; val as u16 } # [doc = "Frame Buffer Line Number"]
pub fn set_cfblnbr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x07ff << 0usize)) | (((val as u32) & 0x07ff) << 0usize) ; } } impl Default for Cfblnr { fn default () -> Cfblnr { Cfblnr (0) } } # [doc = "Layerx Pixel Format Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pfcr (pub u32) ; impl Pfcr { # [doc = "Pixel Format"]
pub const fn pf (& self) -> super :: vals :: Pf { let val = (self . 0 >> 0usize) & 0x07 ; super :: vals :: Pf (val as u8) } # [doc = "Pixel Format"]
pub fn set_pf (& mut self , val : super :: vals :: Pf) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val . 0 as u32) & 0x07) << 0usize) ; } } impl Default for Pfcr { fn default () -> Pfcr { Pfcr (0) } } # [doc = "Layerx CLUT Write Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Clutwr (pub u32) ; impl Clutwr { # [doc = "Blue value"]
pub const fn blue (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Blue value"]
pub fn set_blue (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Green value"]
pub const fn green (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Green value"]
pub fn set_green (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "Red value"]
pub const fn red (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Red value"]
pub fn set_red (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } # [doc = "CLUT Address"]
pub const fn clutadd (& self) -> u8 { let val = (self . 0 >> 24usize) & 0xff ; val as u8 } # [doc = "CLUT Address"]
pub fn set_clutadd (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 24usize)) | (((val as u32) & 0xff) << 24usize) ; } } impl Default for Clutwr { fn default () -> Clutwr { Clutwr (0) } } # [doc = "Layerx Default Color Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dccr (pub u32) ; impl Dccr { # [doc = "Default Color Blue"]
pub const fn dcblue (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Default Color Blue"]
pub fn set_dcblue (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Default Color Green"]
pub const fn dcgreen (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Default Color Green"]
pub fn set_dcgreen (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "Default Color Red"]
pub const fn dcred (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Default Color Red"]
pub fn set_dcred (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } # [doc = "Default Color Alpha"]
pub const fn dcalpha (& self) -> u8 { let val = (self . 0 >> 24usize) & 0xff ; val as u8 } # [doc = "Default Color Alpha"]
pub fn set_dcalpha (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 24usize)) | (((val as u32) & 0xff) << 24usize) ; } } impl Default for Dccr { fn default () -> Dccr { Dccr (0) } } # [doc = "Layerx Color Frame Buffer Address Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfbar (pub u32) ; impl Cfbar { # [doc = "Color Frame Buffer Start Address"]
pub const fn cfbadd (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Color Frame Buffer Start Address"]
pub fn set_cfbadd (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Cfbar { fn default () -> Cfbar { Cfbar (0) } } # [doc = "Shadow Reload Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Srcr (pub u32) ; impl Srcr { # [doc = "Immediate Reload"]
pub const fn imr (& self) -> super :: vals :: Imr { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Imr (val as u8) } # [doc = "Immediate Reload"]
pub fn set_imr (& mut self , val : super :: vals :: Imr) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Vertical Blanking Reload"]
pub const fn vbr (& self) -> super :: vals :: Vbr { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Vbr (val as u8) } # [doc = "Vertical Blanking Reload"]
pub fn set_vbr (& mut self , val : super :: vals :: Vbr) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } } impl Default for Srcr { fn default () -> Srcr { Srcr (0) } } # [doc = "Synchronization Size Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sscr (pub u32) ; impl Sscr { # [doc = "Vertical Synchronization Height (in units of horizontal scan line)"]
pub const fn vsh (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x07ff ; val as u16 } # [doc = "Vertical Synchronization Height (in units of horizontal scan line)"]
pub fn set_vsh (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x07ff << 0usize)) | (((val as u32) & 0x07ff) << 0usize) ; } # [doc = "Horizontal Synchronization Width (in units of pixel clock period)"]
pub const fn hsw (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x0fff ; val as u16 } # [doc = "Horizontal Synchronization Width (in units of pixel clock period)"]
pub fn set_hsw (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 16usize)) | (((val as u32) & 0x0fff) << 16usize) ; } } impl Default for Sscr { fn default () -> Sscr { Sscr (0) } } # [doc = "Layerx Constant Alpha Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cacr (pub u32) ; impl Cacr { # [doc = "Constant Alpha"]
pub const fn consta (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Constant Alpha"]
pub fn set_consta (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } } impl Default for Cacr { fn default () -> Cacr { Cacr (0) } } # [doc = "Layerx Control Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Layer Enable"]
pub const fn len (& self) -> super :: vals :: Len { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Len (val as u8) } # [doc = "Layer Enable"]
pub fn set_len (& mut self , val : super :: vals :: Len) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Color Keying Enable"]
pub const fn colken (& self) -> super :: vals :: Colken { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Colken (val as u8) } # [doc = "Color Keying Enable"]
pub fn set_colken (& mut self , val : super :: vals :: Colken) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Color Look-Up Table Enable"]
pub const fn cluten (& self) -> super :: vals :: Cluten { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Cluten (val as u8) } # [doc = "Color Look-Up Table Enable"]
pub fn set_cluten (& mut self , val : super :: vals :: Cluten) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "Layerx Window Horizontal Position Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Whpcr (pub u32) ; impl Whpcr { # [doc = "Window Horizontal Start Position"]
pub const fn whstpos (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Window Horizontal Start Position"]
pub fn set_whstpos (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "Window Horizontal Stop Position"]
pub const fn whsppos (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x0fff ; val as u16 } # [doc = "Window Horizontal Stop Position"]
pub fn set_whsppos (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 16usize)) | (((val as u32) & 0x0fff) << 16usize) ; } } impl Default for Whpcr { fn default () -> Whpcr { Whpcr (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rrie (pub u8) ; impl Rrie { # [doc = "Register reload interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Register reload interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Terrif (pub u8) ; impl Terrif { # [doc = "No transfer error"]
pub const NOERROR : Self = Self (0) ; # [doc = "Transfer error interrupt generated when a bus error occurs"]
pub const ERROR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Len (pub u8) ; impl Len { # [doc = "Layer disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Layer enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Colken (pub u8) ; impl Colken { # [doc = "Color keying disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Color keying enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Hsyncs (pub u8) ; impl Hsyncs { # [doc = "Currently not in HSYNC phase"]
pub const NOTACTIVE : Self = Self (0) ; # [doc = "Currently in HSYNC phase"]
pub const ACTIVE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Vspol (pub u8) ; impl Vspol { # [doc = "Vertical synchronization polarity is active low"]
pub const ACTIVELOW : Self = Self (0) ; # [doc = "Vertical synchronization polarity is active high"]
pub const ACTIVEHIGH : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Terrie (pub u8) ; impl Terrie { # [doc = "Transfer error interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Transfer error interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pf (pub u8) ; impl Pf { # [doc = "ARGB8888"]
pub const ARGB8888 : Self = Self (0) ; # [doc = "RGB888"]
pub const RGB888 : Self = Self (0x01) ; # [doc = "RGB565"]
pub const RGB565 : Self = Self (0x02) ; # [doc = "ARGB1555"]
pub const ARGB1555 : Self = Self (0x03) ; # [doc = "ARGB4444"]
pub const ARGB4444 : Self = Self (0x04) ; # [doc = "L8 (8-bit luminance)"]
pub const L8 : Self = Self (0x05) ; # [doc = "AL44 (4-bit alpha, 4-bit luminance)"]
pub const AL44 : Self = Self (0x06) ; # [doc = "AL88 (8-bit alpha, 8-bit luminance)"]
pub const AL88 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lie (pub u8) ; impl Lie { # [doc = "Line interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Line interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rrif (pub u8) ; impl Rrif { # [doc = "No register reload"]
pub const NORELOAD : Self = Self (0) ; # [doc = "Register reload interrupt generated when a vertical blanking reload occurs (and the first line after the active area is reached)"]
pub const RELOAD : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cluten (pub u8) ; impl Cluten { # [doc = "Color look-up table disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Color look-up table enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Bf1 (pub u8) ; impl Bf1 { # [doc = "BF1 = constant alpha"]
pub const CONSTANT : Self = Self (0x04) ; # [doc = "BF1 = pixel alpha * constant alpha"]
pub const PIXEL : Self = Self (0x06) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fuif (pub u8) ; impl Fuif { # [doc = "No FIFO underrun"]
pub const NOUNDERRUN : Self = Self (0) ; # [doc = "FIFO underrun interrupt generated, if one of the layer FIFOs is empty and pixel data is read from the FIFO"]
pub const UNDERRUN : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fuie (pub u8) ; impl Fuie { # [doc = "FIFO underrun interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "FIFO underrun interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Bf2 (pub u8) ; impl Bf2 { # [doc = "BF2 = 1 - constant alpha"]
pub const CONSTANT : Self = Self (0x05) ; # [doc = "BF2 = 1 - pixel alpha * constant alpha"]
pub const PIXEL : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Hspol (pub u8) ; impl Hspol { # [doc = "Horizontal synchronization polarity is active low"]
pub const ACTIVELOW : Self = Self (0) ; # [doc = "Horizontal synchronization polarity is active high"]
pub const ACTIVEHIGH : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Depol (pub u8) ; impl Depol { # [doc = "Data enable polarity is active low"]
pub const ACTIVELOW : Self = Self (0) ; # [doc = "Data enable polarity is active high"]
pub const ACTIVEHIGH : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cterrif (pub u8) ; impl Cterrif { # [doc = "Clears the TERRIF flag in the ISR register"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ltdcen (pub u8) ; impl Ltdcen { # [doc = "LCD-TFT controller disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "LCD-TFT controller enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Crrif (pub u8) ; impl Crrif { # [doc = "Clears the RRIF flag in the ISR register"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Den (pub u8) ; impl Den { # [doc = "Dither disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Dither enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pcpol (pub u8) ; impl Pcpol { # [doc = "Pixel clock on rising edge"]
pub const RISINGEDGE : Self = Self (0) ; # [doc = "Pixel clock on falling edge"]
pub const FALLINGEDGE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Vbr (pub u8) ; impl Vbr { # [doc = "This bit is set by software and cleared only by hardware after reload (it cannot be cleared through register write once it is set)"]
pub const NOEFFECT : Self = Self (0) ; # [doc = "The shadow registers are reloaded during the vertical blanking period (at the beginning of the first line after the active display area)."]
pub const RELOAD : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Vsyncs (pub u8) ; impl Vsyncs { # [doc = "Currently not in VSYNC phase"]
pub const NOTACTIVE : Self = Self (0) ; # [doc = "Currently in VSYNC phase"]
pub const ACTIVE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lif (pub u8) ; impl Lif { # [doc = "Programmed line not reached"]
pub const NOTREACHED : Self = Self (0) ; # [doc = "Line interrupt generated when a programmed line is reached"]
pub const REACHED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Vdes (pub u8) ; impl Vdes { # [doc = "Currently not in vertical Data Enable phase"]
pub const NOTACTIVE : Self = Self (0) ; # [doc = "Currently in vertical Data Enable phase"]
pub const ACTIVE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Clif (pub u8) ; impl Clif { # [doc = "Clears the LIF flag in the ISR register"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Hdes (pub u8) ; impl Hdes { # [doc = "Currently not in horizontal Data Enable phase"]
pub const NOTACTIVE : Self = Self (0) ; # [doc = "Currently in horizontal Data Enable phase"]
pub const ACTIVE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cfuif (pub u8) ; impl Cfuif { # [doc = "Clears the FUIF flag in the ISR register"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Imr (pub u8) ; impl Imr { # [doc = "This bit is set by software and cleared only by hardware after reload (it cannot be cleared through register write once it is set)"]
pub const NOEFFECT : Self = Self (0) ; # [doc = "The shadow registers are reloaded immediately. This bit is set by software and cleared only by hardware after reload"]
pub const RELOAD : Self = Self (0x01) ; } }