

# [doc = "Lower power Universal asynchronous receiver transmitter"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Lpuart (pub * mut u8) ; unsafe impl Send for Lpuart { } unsafe impl Sync for Lpuart { } impl Lpuart { # [doc = "Control register 1"]
pub fn cr1 (self) -> crate :: common :: Reg < regs :: Cr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Control register 2"]
pub fn cr2 (self) -> crate :: common :: Reg < regs :: Cr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Control register 3"]
pub fn cr3 (self) -> crate :: common :: Reg < regs :: Cr3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Baud rate register"]
pub fn brr (self) -> crate :: common :: Reg < regs :: Brr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Request register"]
pub fn rqr (self) -> crate :: common :: Reg < regs :: Rqr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "Interrupt & status register"]
pub fn isr (self) -> crate :: common :: Reg < regs :: Isr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "Interrupt flag clear register"]
pub fn icr (self) -> crate :: common :: Reg < regs :: Icr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "Receive data register"]
pub fn rdr (self) -> crate :: common :: Reg < regs :: Rdr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "Transmit data register"]
pub fn tdr (self) -> crate :: common :: Reg < regs :: Tdr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "Prescaler register"]
pub fn presc (self) -> crate :: common :: Reg < regs :: Presc , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } } pub mod regs { # [doc = "Baud rate register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Brr (pub u32) ; impl Brr { # [doc = "BRR"]
pub const fn brr (& self) -> u32 { let val = (self . 0 >> 0usize) & 0x000f_ffff ; val as u32 } # [doc = "BRR"]
pub fn set_brr (& mut self , val : u32) { self . 0 = (self . 0 & ! (0x000f_ffff << 0usize)) | (((val as u32) & 0x000f_ffff) << 0usize) ; } } impl Default for Brr { fn default () -> Brr { Brr (0) } } # [doc = "Receive data register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rdr (pub u32) ; impl Rdr { # [doc = "Receive data value"]
pub const fn rdr (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x01ff ; val as u16 } # [doc = "Receive data value"]
pub fn set_rdr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x01ff << 0usize)) | (((val as u32) & 0x01ff) << 0usize) ; } } impl Default for Rdr { fn default () -> Rdr { Rdr (0) } } # [doc = "Control register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr2 (pub u32) ; impl Cr2 { # [doc = "7-bit Address Detection/4-bit Address Detection"]
pub const fn addm7 (& self) -> super :: vals :: Addm7 { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Addm7 (val as u8) } # [doc = "7-bit Address Detection/4-bit Address Detection"]
pub fn set_addm7 (& mut self , val : super :: vals :: Addm7) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "STOP bits"]
pub const fn stop (& self) -> super :: vals :: Stop { let val = (self . 0 >> 12usize) & 0x03 ; super :: vals :: Stop (val as u8) } # [doc = "STOP bits"]
pub fn set_stop (& mut self , val : super :: vals :: Stop) { self . 0 = (self . 0 & ! (0x03 << 12usize)) | (((val . 0 as u32) & 0x03) << 12usize) ; } # [doc = "Swap TX/RX pins"]
pub const fn swap (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Swap TX/RX pins"]
pub fn set_swap (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "RX pin active level inversion"]
pub const fn rxinv (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "RX pin active level inversion"]
pub fn set_rxinv (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TX pin active level inversion"]
pub const fn txinv (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TX pin active level inversion"]
pub fn set_txinv (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Binary data inversion"]
pub const fn datainv (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Binary data inversion"]
pub fn set_datainv (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Most significant bit first"]
pub const fn msbfirst (& self) -> super :: vals :: Msbfirst { let val = (self . 0 >> 19usize) & 0x01 ; super :: vals :: Msbfirst (val as u8) } # [doc = "Most significant bit first"]
pub fn set_msbfirst (& mut self , val : super :: vals :: Msbfirst) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val . 0 as u32) & 0x01) << 19usize) ; } # [doc = "Address of the USART node"]
pub const fn add (& self) -> u8 { let val = (self . 0 >> 24usize) & 0xff ; val as u8 } # [doc = "Address of the USART node"]
pub fn set_add (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 24usize)) | (((val as u32) & 0xff) << 24usize) ; } } impl Default for Cr2 { fn default () -> Cr2 { Cr2 (0) } } # [doc = "Interrupt & status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Isr (pub u32) ; impl Isr { # [doc = "PE"]
pub const fn pe (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "PE"]
pub fn set_pe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "FE"]
pub const fn fe (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "FE"]
pub fn set_fe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "NE"]
pub const fn ne (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "NE"]
pub fn set_ne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "ORE"]
pub const fn ore (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "ORE"]
pub fn set_ore (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "IDLE"]
pub const fn idle (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IDLE"]
pub fn set_idle (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "RXNE"]
pub const fn rxne (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "RXNE"]
pub fn set_rxne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "TC"]
pub const fn tc (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "TC"]
pub fn set_tc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "TXE"]
pub const fn txe (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "TXE"]
pub fn set_txe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "CTSIF"]
pub const fn ctsif (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "CTSIF"]
pub fn set_ctsif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "CTS"]
pub const fn cts (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "CTS"]
pub fn set_cts (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "BUSY"]
pub const fn busy (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "BUSY"]
pub fn set_busy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "CMF"]
pub const fn cmf (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "CMF"]
pub fn set_cmf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "SBKF"]
pub const fn sbkf (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "SBKF"]
pub fn set_sbkf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "RWU"]
pub const fn rwu (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "RWU"]
pub fn set_rwu (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "WUF"]
pub const fn wuf (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "WUF"]
pub fn set_wuf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "TEACK"]
pub const fn teack (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "TEACK"]
pub fn set_teack (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "REACK"]
pub const fn reack (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "REACK"]
pub fn set_reack (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "TXFIFO Empty"]
pub const fn txfe (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "TXFIFO Empty"]
pub fn set_txfe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "RXFIFO Full"]
pub const fn rxff (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "RXFIFO Full"]
pub fn set_rxff (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "RXFIFO threshold flag"]
pub const fn rxft (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "RXFIFO threshold flag"]
pub fn set_rxft (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "TXFIFO threshold flag"]
pub const fn txft (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "TXFIFO threshold flag"]
pub fn set_txft (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } } impl Default for Isr { fn default () -> Isr { Isr (0) } } # [doc = "Control register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr1 (pub u32) ; impl Cr1 { # [doc = "USART enable"]
pub const fn ue (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "USART enable"]
pub fn set_ue (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "USART enable in Stop mode"]
pub const fn uesm (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "USART enable in Stop mode"]
pub fn set_uesm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Receiver enable"]
pub const fn re (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Receiver enable"]
pub fn set_re (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Transmitter enable"]
pub const fn te (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Transmitter enable"]
pub fn set_te (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "IDLE interrupt enable"]
pub const fn idleie (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IDLE interrupt enable"]
pub fn set_idleie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "RXNE interrupt enable"]
pub const fn rxneie (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "RXNE interrupt enable"]
pub fn set_rxneie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Transmission complete interrupt enable"]
pub const fn tcie (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Transmission complete interrupt enable"]
pub fn set_tcie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "interrupt enable"]
pub const fn txeie (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "interrupt enable"]
pub fn set_txeie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "PE interrupt enable"]
pub const fn peie (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "PE interrupt enable"]
pub fn set_peie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Parity selection"]
pub const fn ps (& self) -> super :: vals :: Ps { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Ps (val as u8) } # [doc = "Parity selection"]
pub fn set_ps (& mut self , val : super :: vals :: Ps) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "Parity control enable"]
pub const fn pce (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Parity control enable"]
pub fn set_pce (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Receiver wakeup method"]
pub const fn wake (& self) -> super :: vals :: Wake { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Wake (val as u8) } # [doc = "Receiver wakeup method"]
pub fn set_wake (& mut self , val : super :: vals :: Wake) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "Word length"]
pub const fn m0 (& self) -> super :: vals :: M0 { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: M0 (val as u8) } # [doc = "Word length"]
pub fn set_m0 (& mut self , val : super :: vals :: M0) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } # [doc = "Mute mode enable"]
pub const fn mme (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "Mute mode enable"]
pub fn set_mme (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Character match interrupt enable"]
pub const fn cmie (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Character match interrupt enable"]
pub fn set_cmie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Driver Enable de-assertion time"]
pub const fn dedt (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x1f ; val as u8 } # [doc = "Driver Enable de-assertion time"]
pub fn set_dedt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 16usize)) | (((val as u32) & 0x1f) << 16usize) ; } # [doc = "Driver Enable assertion time"]
pub const fn deat (& self) -> u8 { let val = (self . 0 >> 21usize) & 0x1f ; val as u8 } # [doc = "Driver Enable assertion time"]
pub fn set_deat (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 21usize)) | (((val as u32) & 0x1f) << 21usize) ; } # [doc = "Word length"]
pub const fn m1 (& self) -> super :: vals :: M1 { let val = (self . 0 >> 28usize) & 0x01 ; super :: vals :: M1 (val as u8) } # [doc = "Word length"]
pub fn set_m1 (& mut self , val : super :: vals :: M1) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val . 0 as u32) & 0x01) << 28usize) ; } # [doc = "FIFO mode enable"]
pub const fn fifoen (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "FIFO mode enable"]
pub fn set_fifoen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "TXFIFO empty interrupt enable"]
pub const fn txfeie (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "TXFIFO empty interrupt enable"]
pub fn set_txfeie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "RXFIFO Full interrupt enable"]
pub const fn rxffie (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "RXFIFO Full interrupt enable"]
pub fn set_rxffie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Cr1 { fn default () -> Cr1 { Cr1 (0) } } # [doc = "Prescaler register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Presc (pub u32) ; impl Presc { # [doc = "Clock prescaler"]
pub const fn prescaler (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Clock prescaler"]
pub fn set_prescaler (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } } impl Default for Presc { fn default () -> Presc { Presc (0) } } # [doc = "Interrupt flag clear register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Icr (pub u32) ; impl Icr { # [doc = "Parity error clear flag"]
pub const fn pecf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Parity error clear flag"]
pub fn set_pecf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Framing error clear flag"]
pub const fn fecf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Framing error clear flag"]
pub fn set_fecf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Noise detected clear flag"]
pub const fn ncf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Noise detected clear flag"]
pub fn set_ncf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Overrun error clear flag"]
pub const fn orecf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Overrun error clear flag"]
pub fn set_orecf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Idle line detected clear flag"]
pub const fn idlecf (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Idle line detected clear flag"]
pub fn set_idlecf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Transmission complete clear flag"]
pub const fn tccf (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Transmission complete clear flag"]
pub fn set_tccf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "CTS clear flag"]
pub const fn ctscf (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "CTS clear flag"]
pub fn set_ctscf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Character match clear flag"]
pub const fn cmcf (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Character match clear flag"]
pub fn set_cmcf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Wakeup from Stop mode clear flag"]
pub const fn wucf (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Wakeup from Stop mode clear flag"]
pub fn set_wucf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } } impl Default for Icr { fn default () -> Icr { Icr (0) } } # [doc = "Request register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rqr (pub u32) ; impl Rqr { # [doc = "Send break request"]
pub const fn sbkrq (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Send break request"]
pub fn set_sbkrq (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Mute mode request"]
pub const fn mmrq (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Mute mode request"]
pub fn set_mmrq (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Receive data flush request"]
pub const fn rxfrq (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Receive data flush request"]
pub fn set_rxfrq (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Transmit data flush request"]
pub const fn txfrq (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Transmit data flush request"]
pub fn set_txfrq (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } } impl Default for Rqr { fn default () -> Rqr { Rqr (0) } } # [doc = "Control register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr3 (pub u32) ; impl Cr3 { # [doc = "Error interrupt enable"]
pub const fn eie (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Error interrupt enable"]
pub fn set_eie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Half-duplex selection"]
pub const fn hdsel (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Half-duplex selection"]
pub fn set_hdsel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "DMA enable receiver"]
pub const fn dmar (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "DMA enable receiver"]
pub fn set_dmar (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "DMA enable transmitter"]
pub const fn dmat (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "DMA enable transmitter"]
pub fn set_dmat (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "RTS enable"]
pub const fn rtse (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "RTS enable"]
pub fn set_rtse (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "CTS enable"]
pub const fn ctse (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "CTS enable"]
pub fn set_ctse (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "CTS interrupt enable"]
pub const fn ctsie (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "CTS interrupt enable"]
pub fn set_ctsie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Overrun Disable"]
pub const fn ovrdis (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Overrun Disable"]
pub fn set_ovrdis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "DMA Disable on Reception Error"]
pub const fn ddre (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "DMA Disable on Reception Error"]
pub fn set_ddre (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Driver enable mode"]
pub const fn dem (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Driver enable mode"]
pub fn set_dem (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Driver enable polarity selection"]
pub const fn dep (& self) -> super :: vals :: Dep { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Dep (val as u8) } # [doc = "Driver enable polarity selection"]
pub fn set_dep (& mut self , val : super :: vals :: Dep) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } # [doc = "Wakeup from Stop mode interrupt flag selection"]
pub const fn wus (& self) -> super :: vals :: Wus { let val = (self . 0 >> 20usize) & 0x03 ; super :: vals :: Wus (val as u8) } # [doc = "Wakeup from Stop mode interrupt flag selection"]
pub fn set_wus (& mut self , val : super :: vals :: Wus) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val . 0 as u32) & 0x03) << 20usize) ; } # [doc = "Wakeup from Stop mode interrupt enable"]
pub const fn wufie (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "Wakeup from Stop mode interrupt enable"]
pub fn set_wufie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "TXFIFO threshold interrupt enable"]
pub const fn txftie (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "TXFIFO threshold interrupt enable"]
pub fn set_txftie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Receive FIFO threshold configuration"]
pub const fn rxftcfg (& self) -> u8 { let val = (self . 0 >> 25usize) & 0x07 ; val as u8 } # [doc = "Receive FIFO threshold configuration"]
pub fn set_rxftcfg (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 25usize)) | (((val as u32) & 0x07) << 25usize) ; } # [doc = "RXFIFO threshold interrupt enable"]
pub const fn rxftie (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "RXFIFO threshold interrupt enable"]
pub fn set_rxftie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "TXFIFO threshold configuration"]
pub const fn txftcfg (& self) -> u8 { let val = (self . 0 >> 29usize) & 0x07 ; val as u8 } # [doc = "TXFIFO threshold configuration"]
pub fn set_txftcfg (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 29usize)) | (((val as u32) & 0x07) << 29usize) ; } } impl Default for Cr3 { fn default () -> Cr3 { Cr3 (0) } } # [doc = "Transmit data register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Tdr (pub u32) ; impl Tdr { # [doc = "Transmit data value"]
pub const fn tdr (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x01ff ; val as u16 } # [doc = "Transmit data value"]
pub fn set_tdr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x01ff << 0usize)) | (((val as u32) & 0x01ff) << 0usize) ; } } impl Default for Tdr { fn default () -> Tdr { Tdr (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wake (pub u8) ; impl Wake { # [doc = "Idle line"]
pub const IDLE : Self = Self (0) ; # [doc = "Address mask"]
pub const ADDRESS : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ps (pub u8) ; impl Ps { # [doc = "Even parity"]
pub const EVEN : Self = Self (0) ; # [doc = "Odd parity"]
pub const ODD : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Addm7 (pub u8) ; impl Addm7 { # [doc = "4-bit address detection"]
pub const BIT4 : Self = Self (0) ; # [doc = "7-bit address detection"]
pub const BIT7 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dep (pub u8) ; impl Dep { # [doc = "DE signal is active high"]
pub const HIGH : Self = Self (0) ; # [doc = "DE signal is active low"]
pub const LOW : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Msbfirst (pub u8) ; impl Msbfirst { # [doc = "data is transmitted/received with data bit 0 first, following the start bit"]
pub const LSB : Self = Self (0) ; # [doc = "data is transmitted/received with MSB (bit 7/8/9) first, following the start bit"]
pub const MSB : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct M0 (pub u8) ; impl M0 { # [doc = "1 start bit, 8 data bits, n stop bits"]
pub const BIT8 : Self = Self (0) ; # [doc = "1 start bit, 9 data bits, n stop bits"]
pub const BIT9 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wus (pub u8) ; impl Wus { # [doc = "WUF active on address match"]
pub const ADDRESS : Self = Self (0) ; # [doc = "WuF active on Start bit detection"]
pub const START : Self = Self (0x02) ; # [doc = "WUF active on RXNE"]
pub const RXNE : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct M1 (pub u8) ; impl M1 { # [doc = "Use M0 to set the data bits"]
pub const M0 : Self = Self (0) ; # [doc = "1 start bit, 7 data bits, n stop bits"]
pub const BIT7 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Stop (pub u8) ; impl Stop { # [doc = "1 stop bit"]
pub const STOP1 : Self = Self (0) ; # [doc = "0.5 stop bit"]
pub const STOP0P5 : Self = Self (0x01) ; # [doc = "2 stop bit"]
pub const STOP2 : Self = Self (0x02) ; # [doc = "1.5 stop bit"]
pub const STOP1P5 : Self = Self (0x03) ; } }