

# [doc = "Low power timer"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Lptim (pub * mut u8) ; unsafe impl Send for Lptim { } unsafe impl Sync for Lptim { } impl Lptim { # [doc = "Interrupt and Status Register"]
pub fn isr (self) -> crate :: common :: Reg < regs :: Isr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Interrupt Clear Register"]
pub fn icr (self) -> crate :: common :: Reg < regs :: Icr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Interrupt Enable Register"]
pub fn ier (self) -> crate :: common :: Reg < regs :: Ier , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Configuration Register"]
pub fn cfgr (self) -> crate :: common :: Reg < regs :: Cfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Control Register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Compare Register"]
pub fn cmp (self) -> crate :: common :: Reg < regs :: Cmp , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "Autoreload Register"]
pub fn arr (self) -> crate :: common :: Reg < regs :: Arr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "Counter Register"]
pub fn cnt (self) -> crate :: common :: Reg < regs :: Cnt , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } } pub mod regs { # [doc = "Interrupt Clear Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Icr (pub u32) ; impl Icr { # [doc = "compare match Clear Flag"]
pub const fn cmpmcf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "compare match Clear Flag"]
pub fn set_cmpmcf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Autoreload match Clear Flag"]
pub const fn arrmcf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Autoreload match Clear Flag"]
pub fn set_arrmcf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "External trigger valid edge Clear Flag"]
pub const fn exttrigcf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "External trigger valid edge Clear Flag"]
pub fn set_exttrigcf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Compare register update OK Clear Flag"]
pub const fn cmpokcf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Compare register update OK Clear Flag"]
pub fn set_cmpokcf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Autoreload register update OK Clear Flag"]
pub const fn arrokcf (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Autoreload register update OK Clear Flag"]
pub fn set_arrokcf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Direction change to UP Clear Flag"]
pub const fn upcf (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Direction change to UP Clear Flag"]
pub fn set_upcf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Direction change to down Clear Flag"]
pub const fn downcf (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Direction change to down Clear Flag"]
pub fn set_downcf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } } impl Default for Icr { fn default () -> Icr { Icr (0) } } # [doc = "Interrupt Enable Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ier (pub u32) ; impl Ier { # [doc = "Compare match Interrupt Enable"]
pub const fn cmpmie (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Compare match Interrupt Enable"]
pub fn set_cmpmie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Autoreload match Interrupt Enable"]
pub const fn arrmie (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Autoreload match Interrupt Enable"]
pub fn set_arrmie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "External trigger valid edge Interrupt Enable"]
pub const fn exttrigie (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "External trigger valid edge Interrupt Enable"]
pub fn set_exttrigie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Compare register update OK Interrupt Enable"]
pub const fn cmpokie (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Compare register update OK Interrupt Enable"]
pub fn set_cmpokie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Autoreload register update OK Interrupt Enable"]
pub const fn arrokie (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Autoreload register update OK Interrupt Enable"]
pub fn set_arrokie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Direction change to UP Interrupt Enable"]
pub const fn upie (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Direction change to UP Interrupt Enable"]
pub fn set_upie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Direction change to down Interrupt Enable"]
pub const fn downie (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Direction change to down Interrupt Enable"]
pub fn set_downie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } } impl Default for Ier { fn default () -> Ier { Ier (0) } } # [doc = "Control Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "LPTIM Enable"]
pub const fn enable (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LPTIM Enable"]
pub fn set_enable (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "LPTIM start in single mode"]
pub const fn sngstrt (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "LPTIM start in single mode"]
pub fn set_sngstrt (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Timer start in continuous mode"]
pub const fn cntstrt (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Timer start in continuous mode"]
pub fn set_cntstrt (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "Interrupt and Status Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Isr (pub u32) ; impl Isr { # [doc = "Compare match"]
pub const fn cmpm (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Compare match"]
pub fn set_cmpm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Autoreload match"]
pub const fn arrm (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Autoreload match"]
pub fn set_arrm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "External trigger edge event"]
pub const fn exttrig (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "External trigger edge event"]
pub fn set_exttrig (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Compare register update OK"]
pub const fn cmpok (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Compare register update OK"]
pub fn set_cmpok (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Autoreload register update OK"]
pub const fn arrok (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Autoreload register update OK"]
pub fn set_arrok (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Counter direction change down to up"]
pub const fn up (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Counter direction change down to up"]
pub fn set_up (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Counter direction change up to down"]
pub const fn down (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Counter direction change up to down"]
pub fn set_down (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } } impl Default for Isr { fn default () -> Isr { Isr (0) } } # [doc = "Counter Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cnt (pub u32) ; impl Cnt { # [doc = "Counter value"]
pub const fn cnt (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Counter value"]
pub fn set_cnt (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Cnt { fn default () -> Cnt { Cnt (0) } } # [doc = "Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr (pub u32) ; impl Cfgr { # [doc = "Clock selector"]
pub const fn cksel (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Clock selector"]
pub fn set_cksel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Clock Polarity"]
pub const fn ckpol (& self) -> u8 { let val = (self . 0 >> 1usize) & 0x03 ; val as u8 } # [doc = "Clock Polarity"]
pub fn set_ckpol (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 1usize)) | (((val as u32) & 0x03) << 1usize) ; } # [doc = "Configurable digital filter for external clock"]
pub const fn ckflt (& self) -> u8 { let val = (self . 0 >> 3usize) & 0x03 ; val as u8 } # [doc = "Configurable digital filter for external clock"]
pub fn set_ckflt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 3usize)) | (((val as u32) & 0x03) << 3usize) ; } # [doc = "Configurable digital filter for trigger"]
pub const fn trgflt (& self) -> u8 { let val = (self . 0 >> 6usize) & 0x03 ; val as u8 } # [doc = "Configurable digital filter for trigger"]
pub fn set_trgflt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 6usize)) | (((val as u32) & 0x03) << 6usize) ; } # [doc = "Clock prescaler"]
pub const fn presc (& self) -> u8 { let val = (self . 0 >> 9usize) & 0x07 ; val as u8 } # [doc = "Clock prescaler"]
pub fn set_presc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 9usize)) | (((val as u32) & 0x07) << 9usize) ; } # [doc = "Trigger selector"]
pub const fn trigsel (& self) -> u8 { let val = (self . 0 >> 13usize) & 0x07 ; val as u8 } # [doc = "Trigger selector"]
pub fn set_trigsel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 13usize)) | (((val as u32) & 0x07) << 13usize) ; } # [doc = "Trigger enable and polarity"]
pub const fn trigen (& self) -> u8 { let val = (self . 0 >> 17usize) & 0x03 ; val as u8 } # [doc = "Trigger enable and polarity"]
pub fn set_trigen (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 17usize)) | (((val as u32) & 0x03) << 17usize) ; } # [doc = "Timeout enable"]
pub const fn timout (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Timeout enable"]
pub fn set_timout (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Waveform shape"]
pub const fn wave (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Waveform shape"]
pub fn set_wave (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Waveform shape polarity"]
pub const fn wavpol (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Waveform shape polarity"]
pub fn set_wavpol (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Registers update mode"]
pub const fn preload (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "Registers update mode"]
pub fn set_preload (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "counter mode enabled"]
pub const fn countmode (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "counter mode enabled"]
pub fn set_countmode (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Encoder mode enable"]
pub const fn enc (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Encoder mode enable"]
pub fn set_enc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } } impl Default for Cfgr { fn default () -> Cfgr { Cfgr (0) } } # [doc = "Autoreload Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Arr (pub u32) ; impl Arr { # [doc = "Auto reload value"]
pub const fn arr (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Auto reload value"]
pub fn set_arr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Arr { fn default () -> Arr { Arr (0) } } # [doc = "Compare Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cmp (pub u32) ; impl Cmp { # [doc = "Compare value"]
pub const fn cmp (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Compare value"]
pub fn set_cmp (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Cmp { fn default () -> Cmp { Cmp (0) } } }