

# [doc = "Independent watchdog"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Iwdg (pub * mut u8) ; unsafe impl Send for Iwdg { } unsafe impl Sync for Iwdg { } impl Iwdg { # [doc = "Key register"]
pub fn kr (self) -> crate :: common :: Reg < regs :: Kr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Prescaler register"]
pub fn pr (self) -> crate :: common :: Reg < regs :: Pr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Reload register"]
pub fn rlr (self) -> crate :: common :: Reg < regs :: Rlr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Window register"]
pub fn winr (self) -> crate :: common :: Reg < regs :: Winr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pr (pub u8) ; impl Pr { # [doc = "Divider /4"]
pub const DIVIDEBY4 : Self = Self (0) ; # [doc = "Divider /8"]
pub const DIVIDEBY8 : Self = Self (0x01) ; # [doc = "Divider /16"]
pub const DIVIDEBY16 : Self = Self (0x02) ; # [doc = "Divider /32"]
pub const DIVIDEBY32 : Self = Self (0x03) ; # [doc = "Divider /64"]
pub const DIVIDEBY64 : Self = Self (0x04) ; # [doc = "Divider /128"]
pub const DIVIDEBY128 : Self = Self (0x05) ; # [doc = "Divider /256"]
pub const DIVIDEBY256 : Self = Self (0x06) ; # [doc = "Divider /256"]
pub const DIVIDEBY256BIS : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Key (pub u16) ; impl Key { # [doc = "Enable access to PR, RLR and WINR registers (0x5555)"]
pub const ENABLE : Self = Self (0x5555) ; # [doc = "Reset the watchdog value (0xAAAA)"]
pub const RESET : Self = Self (0xaaaa) ; # [doc = "Start the watchdog (0xCCCC)"]
pub const START : Self = Self (0xcccc) ; } } pub mod regs { # [doc = "Key register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Kr (pub u32) ; impl Kr { # [doc = "Key value (write only, read 0000h)"]
pub const fn key (& self) -> super :: vals :: Key { let val = (self . 0 >> 0usize) & 0xffff ; super :: vals :: Key (val as u16) } # [doc = "Key value (write only, read 0000h)"]
pub fn set_key (& mut self , val : super :: vals :: Key) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val . 0 as u32) & 0xffff) << 0usize) ; } } impl Default for Kr { fn default () -> Kr { Kr (0) } } # [doc = "Prescaler register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pr (pub u32) ; impl Pr { # [doc = "Prescaler divider"]
pub const fn pr (& self) -> super :: vals :: Pr { let val = (self . 0 >> 0usize) & 0x07 ; super :: vals :: Pr (val as u8) } # [doc = "Prescaler divider"]
pub fn set_pr (& mut self , val : super :: vals :: Pr) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val . 0 as u32) & 0x07) << 0usize) ; } } impl Default for Pr { fn default () -> Pr { Pr (0) } } # [doc = "Window register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Winr (pub u32) ; impl Winr { # [doc = "Watchdog counter window value"]
pub const fn win (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Watchdog counter window value"]
pub fn set_win (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } } impl Default for Winr { fn default () -> Winr { Winr (0) } } # [doc = "Reload register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rlr (pub u32) ; impl Rlr { # [doc = "Watchdog counter reload value"]
pub const fn rl (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Watchdog counter reload value"]
pub fn set_rl (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } } impl Default for Rlr { fn default () -> Rlr { Rlr (0) } } # [doc = "Status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr (pub u32) ; impl Sr { # [doc = "Watchdog prescaler value update"]
pub const fn pvu (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Watchdog prescaler value update"]
pub fn set_pvu (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Watchdog counter reload value update"]
pub const fn rvu (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Watchdog counter reload value update"]
pub fn set_rvu (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Watchdog counter window value update"]
pub const fn wvu (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Watchdog counter window value update"]
pub fn set_wvu (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } } impl Default for Sr { fn default () -> Sr { Sr (0) } } }