

# [doc = "Inter-integrated circuit"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct I2c (pub * mut u8) ; unsafe impl Send for I2c { } unsafe impl Sync for I2c { } impl I2c { # [doc = "Control register 1"]
pub fn cr1 (self) -> crate :: common :: Reg < regs :: Cr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Control register 2"]
pub fn cr2 (self) -> crate :: common :: Reg < regs :: Cr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Own address register 1"]
pub fn oar1 (self) -> crate :: common :: Reg < regs :: Oar1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Own address register 2"]
pub fn oar2 (self) -> crate :: common :: Reg < regs :: Oar2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Timing register"]
pub fn timingr (self) -> crate :: common :: Reg < regs :: Timingr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Timeout register"]
pub fn timeoutr (self) -> crate :: common :: Reg < regs :: Timeoutr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "Interrupt and Status register"]
pub fn isr (self) -> crate :: common :: Reg < regs :: Isr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "Interrupt clear register"]
pub fn icr (self) -> crate :: common :: Reg < regs :: Icr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "PEC register"]
pub fn pecr (self) -> crate :: common :: Reg < regs :: Pecr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "Receive data register"]
pub fn rxdr (self) -> crate :: common :: Reg < regs :: Rxdr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "Transmit data register"]
pub fn txdr (self) -> crate :: common :: Reg < regs :: Txdr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Autoend (pub u8) ; impl Autoend { # [doc = "Software end mode: TC flag is set when NBYTES data are transferred, stretching SCL low"]
pub const SOFTWARE : Self = Self (0) ; # [doc = "Automatic end mode: a STOP condition is automatically sent when NBYTES data are transferred"]
pub const AUTOMATIC : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Headr (pub u8) ; impl Headr { # [doc = "The master sends the complete 10 bit slave address read sequence"]
pub const COMPLETE : Self = Self (0) ; # [doc = "The master only sends the 1st 7 bits of the 10 bit address, followed by Read direction"]
pub const PARTIAL : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Oamsk (pub u8) ; impl Oamsk { # [doc = "No mask"]
pub const NOMASK : Self = Self (0) ; # [doc = "OA2[1]
is masked and don’t care. Only OA2[7:2]
are compared"]
pub const MASK1 : Self = Self (0x01) ; # [doc = "OA2[2:1]
are masked and don’t care. Only OA2[7:3]
are compared"]
pub const MASK2 : Self = Self (0x02) ; # [doc = "OA2[3:1]
are masked and don’t care. Only OA2[7:4]
are compared"]
pub const MASK3 : Self = Self (0x03) ; # [doc = "OA2[4:1]
are masked and don’t care. Only OA2[7:5]
are compared"]
pub const MASK4 : Self = Self (0x04) ; # [doc = "OA2[5:1]
are masked and don’t care. Only OA2[7:6]
are compared"]
pub const MASK5 : Self = Self (0x05) ; # [doc = "OA2[6:1]
are masked and don’t care. Only OA2[7]
is compared."]
pub const MASK6 : Self = Self (0x06) ; # [doc = "OA2[7:1]
are masked and don’t care. No comparison is done, and all (except reserved) 7-bit received addresses are acknowledged"]
pub const MASK7 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dir (pub u8) ; impl Dir { # [doc = "Write transfer, slave enters receiver mode"]
pub const WRITE : Self = Self (0) ; # [doc = "Read transfer, slave enters transmitter mode"]
pub const READ : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Addmode (pub u8) ; impl Addmode { # [doc = "7-bit addressing mode"]
pub const BIT7 : Self = Self (0) ; # [doc = "10-bit addressing mode"]
pub const BIT10 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Reload (pub u8) ; impl Reload { # [doc = "The transfer is completed after the NBYTES data transfer (STOP or RESTART will follow)"]
pub const COMPLETED : Self = Self (0) ; # [doc = "The transfer is not completed after the NBYTES data transfer (NBYTES will be reloaded)"]
pub const NOTCOMPLETED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dnf (pub u8) ; impl Dnf { # [doc = "Digital filter disabled"]
pub const NOFILTER : Self = Self (0) ; # [doc = "Digital filter enabled and filtering capability up to 1 tI2CCLK"]
pub const FILTER1 : Self = Self (0x01) ; # [doc = "Digital filter enabled and filtering capability up to 2 tI2CCLK"]
pub const FILTER2 : Self = Self (0x02) ; # [doc = "Digital filter enabled and filtering capability up to 3 tI2CCLK"]
pub const FILTER3 : Self = Self (0x03) ; # [doc = "Digital filter enabled and filtering capability up to 4 tI2CCLK"]
pub const FILTER4 : Self = Self (0x04) ; # [doc = "Digital filter enabled and filtering capability up to 5 tI2CCLK"]
pub const FILTER5 : Self = Self (0x05) ; # [doc = "Digital filter enabled and filtering capability up to 6 tI2CCLK"]
pub const FILTER6 : Self = Self (0x06) ; # [doc = "Digital filter enabled and filtering capability up to 7 tI2CCLK"]
pub const FILTER7 : Self = Self (0x07) ; # [doc = "Digital filter enabled and filtering capability up to 8 tI2CCLK"]
pub const FILTER8 : Self = Self (0x08) ; # [doc = "Digital filter enabled and filtering capability up to 9 tI2CCLK"]
pub const FILTER9 : Self = Self (0x09) ; # [doc = "Digital filter enabled and filtering capability up to 10 tI2CCLK"]
pub const FILTER10 : Self = Self (0x0a) ; # [doc = "Digital filter enabled and filtering capability up to 11 tI2CCLK"]
pub const FILTER11 : Self = Self (0x0b) ; # [doc = "Digital filter enabled and filtering capability up to 12 tI2CCLK"]
pub const FILTER12 : Self = Self (0x0c) ; # [doc = "Digital filter enabled and filtering capability up to 13 tI2CCLK"]
pub const FILTER13 : Self = Self (0x0d) ; # [doc = "Digital filter enabled and filtering capability up to 14 tI2CCLK"]
pub const FILTER14 : Self = Self (0x0e) ; # [doc = "Digital filter enabled and filtering capability up to 15 tI2CCLK"]
pub const FILTER15 : Self = Self (0x0f) ; } } pub mod regs { # [doc = "Timeout register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Timeoutr (pub u32) ; impl Timeoutr { # [doc = "Bus timeout A"]
pub const fn timeouta (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Bus timeout A"]
pub fn set_timeouta (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "Idle clock timeout detection"]
pub const fn tidle (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Idle clock timeout detection"]
pub fn set_tidle (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Clock timeout enable"]
pub const fn timouten (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Clock timeout enable"]
pub fn set_timouten (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Bus timeout B"]
pub const fn timeoutb (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x0fff ; val as u16 } # [doc = "Bus timeout B"]
pub fn set_timeoutb (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 16usize)) | (((val as u32) & 0x0fff) << 16usize) ; } # [doc = "Extended clock timeout enable"]
pub const fn texten (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Extended clock timeout enable"]
pub fn set_texten (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Timeoutr { fn default () -> Timeoutr { Timeoutr (0) } } # [doc = "PEC register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pecr (pub u32) ; impl Pecr { # [doc = "Packet error checking register"]
pub const fn pec (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Packet error checking register"]
pub fn set_pec (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } } impl Default for Pecr { fn default () -> Pecr { Pecr (0) } } # [doc = "Receive data register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rxdr (pub u32) ; impl Rxdr { # [doc = "8-bit receive data"]
pub const fn rxdata (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "8-bit receive data"]
pub fn set_rxdata (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } } impl Default for Rxdr { fn default () -> Rxdr { Rxdr (0) } } # [doc = "Transmit data register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Txdr (pub u32) ; impl Txdr { # [doc = "8-bit transmit data"]
pub const fn txdata (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "8-bit transmit data"]
pub fn set_txdata (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } } impl Default for Txdr { fn default () -> Txdr { Txdr (0) } } # [doc = "Timing register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Timingr (pub u32) ; impl Timingr { # [doc = "SCL low period (master mode)"]
pub const fn scll (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "SCL low period (master mode)"]
pub fn set_scll (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "SCL high period (master mode)"]
pub const fn sclh (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "SCL high period (master mode)"]
pub fn set_sclh (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "Data hold time"]
pub const fn sdadel (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x0f ; val as u8 } # [doc = "Data hold time"]
pub fn set_sdadel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 16usize)) | (((val as u32) & 0x0f) << 16usize) ; } # [doc = "Data setup time"]
pub const fn scldel (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x0f ; val as u8 } # [doc = "Data setup time"]
pub fn set_scldel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 20usize)) | (((val as u32) & 0x0f) << 20usize) ; } # [doc = "Timing prescaler"]
pub const fn presc (& self) -> u8 { let val = (self . 0 >> 28usize) & 0x0f ; val as u8 } # [doc = "Timing prescaler"]
pub fn set_presc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 28usize)) | (((val as u32) & 0x0f) << 28usize) ; } } impl Default for Timingr { fn default () -> Timingr { Timingr (0) } } # [doc = "Control register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr1 (pub u32) ; impl Cr1 { # [doc = "Peripheral enable"]
pub const fn pe (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Peripheral enable"]
pub fn set_pe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TX Interrupt enable"]
pub const fn txie (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TX Interrupt enable"]
pub fn set_txie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "RX Interrupt enable"]
pub const fn rxie (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "RX Interrupt enable"]
pub fn set_rxie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Address match interrupt enable (slave only)"]
pub const fn addrie (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Address match interrupt enable (slave only)"]
pub fn set_addrie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Not acknowledge received interrupt enable"]
pub const fn nackie (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Not acknowledge received interrupt enable"]
pub fn set_nackie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "STOP detection Interrupt enable"]
pub const fn stopie (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "STOP detection Interrupt enable"]
pub fn set_stopie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Transfer Complete interrupt enable"]
pub const fn tcie (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Transfer Complete interrupt enable"]
pub fn set_tcie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Error interrupts enable"]
pub const fn errie (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Error interrupts enable"]
pub fn set_errie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Digital noise filter"]
pub const fn dnf (& self) -> super :: vals :: Dnf { let val = (self . 0 >> 8usize) & 0x0f ; super :: vals :: Dnf (val as u8) } # [doc = "Digital noise filter"]
pub fn set_dnf (& mut self , val : super :: vals :: Dnf) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val . 0 as u32) & 0x0f) << 8usize) ; } # [doc = "Analog noise filter OFF"]
pub const fn anfoff (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Analog noise filter OFF"]
pub fn set_anfoff (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "DMA transmission requests enable"]
pub const fn txdmaen (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "DMA transmission requests enable"]
pub fn set_txdmaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "DMA reception requests enable"]
pub const fn rxdmaen (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "DMA reception requests enable"]
pub fn set_rxdmaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Slave byte control"]
pub const fn sbc (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Slave byte control"]
pub fn set_sbc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Clock stretching disable"]
pub const fn nostretch (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Clock stretching disable"]
pub fn set_nostretch (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "General call enable"]
pub const fn gcen (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "General call enable"]
pub fn set_gcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "SMBus Host address enable"]
pub const fn smbhen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "SMBus Host address enable"]
pub fn set_smbhen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "SMBus Device Default address enable"]
pub const fn smbden (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "SMBus Device Default address enable"]
pub fn set_smbden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "SMBUS alert enable"]
pub const fn alerten (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "SMBUS alert enable"]
pub fn set_alerten (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "PEC enable"]
pub const fn pecen (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "PEC enable"]
pub fn set_pecen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } } impl Default for Cr1 { fn default () -> Cr1 { Cr1 (0) } } # [doc = "Own address register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Oar1 (pub u32) ; impl Oar1 { # [doc = "Interface address"]
pub const fn oa1 (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x03ff ; val as u16 } # [doc = "Interface address"]
pub fn set_oa1 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x03ff << 0usize)) | (((val as u32) & 0x03ff) << 0usize) ; } # [doc = "Own Address 1 10-bit mode"]
pub const fn oa1mode (& self) -> super :: vals :: Addmode { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Addmode (val as u8) } # [doc = "Own Address 1 10-bit mode"]
pub fn set_oa1mode (& mut self , val : super :: vals :: Addmode) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "Own Address 1 enable"]
pub const fn oa1en (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Own Address 1 enable"]
pub fn set_oa1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } } impl Default for Oar1 { fn default () -> Oar1 { Oar1 (0) } } # [doc = "Control register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr2 (pub u32) ; impl Cr2 { # [doc = "Slave address bit (master mode)"]
pub const fn sadd (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x03ff ; val as u16 } # [doc = "Slave address bit (master mode)"]
pub fn set_sadd (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x03ff << 0usize)) | (((val as u32) & 0x03ff) << 0usize) ; } # [doc = "Transfer direction (master mode)"]
pub const fn dir (& self) -> super :: vals :: Dir { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Dir (val as u8) } # [doc = "Transfer direction (master mode)"]
pub fn set_dir (& mut self , val : super :: vals :: Dir) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "10-bit addressing mode (master mode)"]
pub const fn add10 (& self) -> super :: vals :: Addmode { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Addmode (val as u8) } # [doc = "10-bit addressing mode (master mode)"]
pub fn set_add10 (& mut self , val : super :: vals :: Addmode) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "10-bit address header only read direction (master receiver mode)"]
pub const fn head10r (& self) -> super :: vals :: Headr { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: Headr (val as u8) } # [doc = "10-bit address header only read direction (master receiver mode)"]
pub fn set_head10r (& mut self , val : super :: vals :: Headr) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } # [doc = "Start generation"]
pub const fn start (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "Start generation"]
pub fn set_start (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Stop generation (master mode)"]
pub const fn stop (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Stop generation (master mode)"]
pub fn set_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "NACK generation (slave mode)"]
pub const fn nack (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "NACK generation (slave mode)"]
pub fn set_nack (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Number of bytes"]
pub const fn nbytes (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Number of bytes"]
pub fn set_nbytes (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } # [doc = "NBYTES reload mode"]
pub const fn reload (& self) -> super :: vals :: Reload { let val = (self . 0 >> 24usize) & 0x01 ; super :: vals :: Reload (val as u8) } # [doc = "NBYTES reload mode"]
pub fn set_reload (& mut self , val : super :: vals :: Reload) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val . 0 as u32) & 0x01) << 24usize) ; } # [doc = "Automatic end mode (master mode)"]
pub const fn autoend (& self) -> super :: vals :: Autoend { let val = (self . 0 >> 25usize) & 0x01 ; super :: vals :: Autoend (val as u8) } # [doc = "Automatic end mode (master mode)"]
pub fn set_autoend (& mut self , val : super :: vals :: Autoend) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val . 0 as u32) & 0x01) << 25usize) ; } # [doc = "Packet error checking byte"]
pub const fn pecbyte (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Packet error checking byte"]
pub fn set_pecbyte (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } } impl Default for Cr2 { fn default () -> Cr2 { Cr2 (0) } } # [doc = "Own address register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Oar2 (pub u32) ; impl Oar2 { # [doc = "Interface address"]
pub const fn oa2 (& self) -> u8 { let val = (self . 0 >> 1usize) & 0x7f ; val as u8 } # [doc = "Interface address"]
pub fn set_oa2 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 1usize)) | (((val as u32) & 0x7f) << 1usize) ; } # [doc = "Own Address 2 masks"]
pub const fn oa2msk (& self) -> super :: vals :: Oamsk { let val = (self . 0 >> 8usize) & 0x07 ; super :: vals :: Oamsk (val as u8) } # [doc = "Own Address 2 masks"]
pub fn set_oa2msk (& mut self , val : super :: vals :: Oamsk) { self . 0 = (self . 0 & ! (0x07 << 8usize)) | (((val . 0 as u32) & 0x07) << 8usize) ; } # [doc = "Own Address 2 enable"]
pub const fn oa2en (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Own Address 2 enable"]
pub fn set_oa2en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } } impl Default for Oar2 { fn default () -> Oar2 { Oar2 (0) } } # [doc = "Interrupt and Status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Isr (pub u32) ; impl Isr { # [doc = "Transmit data register empty (transmitters)"]
pub const fn txe (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Transmit data register empty (transmitters)"]
pub fn set_txe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Transmit interrupt status (transmitters)"]
pub const fn txis (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Transmit interrupt status (transmitters)"]
pub fn set_txis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Receive data register not empty (receivers)"]
pub const fn rxne (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Receive data register not empty (receivers)"]
pub fn set_rxne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Address matched (slave mode)"]
pub const fn addr (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Address matched (slave mode)"]
pub fn set_addr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Not acknowledge received flag"]
pub const fn nackf (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Not acknowledge received flag"]
pub fn set_nackf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Stop detection flag"]
pub const fn stopf (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Stop detection flag"]
pub fn set_stopf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Transfer Complete (master mode)"]
pub const fn tc (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Transfer Complete (master mode)"]
pub fn set_tc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Transfer Complete Reload"]
pub const fn tcr (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Transfer Complete Reload"]
pub fn set_tcr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Bus error"]
pub const fn berr (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Bus error"]
pub fn set_berr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Arbitration lost"]
pub const fn arlo (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Arbitration lost"]
pub fn set_arlo (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Overrun/Underrun (slave mode)"]
pub const fn ovr (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Overrun/Underrun (slave mode)"]
pub fn set_ovr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "PEC Error in reception"]
pub const fn pecerr (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "PEC Error in reception"]
pub fn set_pecerr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "Timeout or t_low detection flag"]
pub const fn timeout (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Timeout or t_low detection flag"]
pub fn set_timeout (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "SMBus alert"]
pub const fn alert (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "SMBus alert"]
pub fn set_alert (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Bus busy"]
pub const fn busy (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Bus busy"]
pub fn set_busy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Transfer direction (Slave mode)"]
pub const fn dir (& self) -> super :: vals :: Dir { let val = (self . 0 >> 16usize) & 0x01 ; super :: vals :: Dir (val as u8) } # [doc = "Transfer direction (Slave mode)"]
pub fn set_dir (& mut self , val : super :: vals :: Dir) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val . 0 as u32) & 0x01) << 16usize) ; } # [doc = "Address match code (Slave mode)"]
pub const fn addcode (& self) -> u8 { let val = (self . 0 >> 17usize) & 0x7f ; val as u8 } # [doc = "Address match code (Slave mode)"]
pub fn set_addcode (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 17usize)) | (((val as u32) & 0x7f) << 17usize) ; } } impl Default for Isr { fn default () -> Isr { Isr (0) } } # [doc = "Interrupt clear register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Icr (pub u32) ; impl Icr { # [doc = "Address Matched flag clear"]
pub const fn addrcf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Address Matched flag clear"]
pub fn set_addrcf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Not Acknowledge flag clear"]
pub const fn nackcf (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Not Acknowledge flag clear"]
pub fn set_nackcf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Stop detection flag clear"]
pub const fn stopcf (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Stop detection flag clear"]
pub fn set_stopcf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Bus error flag clear"]
pub const fn berrcf (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Bus error flag clear"]
pub fn set_berrcf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Arbitration lost flag clear"]
pub const fn arlocf (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Arbitration lost flag clear"]
pub fn set_arlocf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Overrun/Underrun flag clear"]
pub const fn ovrcf (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Overrun/Underrun flag clear"]
pub fn set_ovrcf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "PEC Error flag clear"]
pub const fn peccf (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "PEC Error flag clear"]
pub fn set_peccf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "Timeout detection flag clear"]
pub const fn timoutcf (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Timeout detection flag clear"]
pub fn set_timoutcf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Alert flag clear"]
pub const fn alertcf (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "Alert flag clear"]
pub fn set_alertcf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } } impl Default for Icr { fn default () -> Icr { Icr (0) } } }