

# [doc = "Inter-integrated circuit"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct I2c (pub * mut u8) ; unsafe impl Send for I2c { } unsafe impl Sync for I2c { } impl I2c { # [doc = "Control register 1"]
pub fn cr1 (self) -> crate :: common :: Reg < regs :: Cr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Control register 2"]
pub fn cr2 (self) -> crate :: common :: Reg < regs :: Cr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Own address register 1"]
pub fn oar1 (self) -> crate :: common :: Reg < regs :: Oar1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Own address register 2"]
pub fn oar2 (self) -> crate :: common :: Reg < regs :: Oar2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Data register"]
pub fn dr (self) -> crate :: common :: Reg < regs :: Dr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Status register 1"]
pub fn sr1 (self) -> crate :: common :: Reg < regs :: Sr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "Status register 2"]
pub fn sr2 (self) -> crate :: common :: Reg < regs :: Sr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "Clock control register"]
pub fn ccr (self) -> crate :: common :: Reg < regs :: Ccr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "TRISE register"]
pub fn trise (self) -> crate :: common :: Reg < regs :: Trise , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "FLTR register"]
pub fn fltr (self) -> crate :: common :: Reg < regs :: Fltr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dnf (pub u8) ; impl Dnf { # [doc = "Digital filter disabled"]
pub const NOFILTER : Self = Self (0) ; # [doc = "Digital filter enabled and filtering capability up to 1 tI2CCLK"]
pub const FILTER1 : Self = Self (0x01) ; # [doc = "Digital filter enabled and filtering capability up to 2 tI2CCLK"]
pub const FILTER2 : Self = Self (0x02) ; # [doc = "Digital filter enabled and filtering capability up to 3 tI2CCLK"]
pub const FILTER3 : Self = Self (0x03) ; # [doc = "Digital filter enabled and filtering capability up to 4 tI2CCLK"]
pub const FILTER4 : Self = Self (0x04) ; # [doc = "Digital filter enabled and filtering capability up to 5 tI2CCLK"]
pub const FILTER5 : Self = Self (0x05) ; # [doc = "Digital filter enabled and filtering capability up to 6 tI2CCLK"]
pub const FILTER6 : Self = Self (0x06) ; # [doc = "Digital filter enabled and filtering capability up to 7 tI2CCLK"]
pub const FILTER7 : Self = Self (0x07) ; # [doc = "Digital filter enabled and filtering capability up to 8 tI2CCLK"]
pub const FILTER8 : Self = Self (0x08) ; # [doc = "Digital filter enabled and filtering capability up to 9 tI2CCLK"]
pub const FILTER9 : Self = Self (0x09) ; # [doc = "Digital filter enabled and filtering capability up to 10 tI2CCLK"]
pub const FILTER10 : Self = Self (0x0a) ; # [doc = "Digital filter enabled and filtering capability up to 11 tI2CCLK"]
pub const FILTER11 : Self = Self (0x0b) ; # [doc = "Digital filter enabled and filtering capability up to 12 tI2CCLK"]
pub const FILTER12 : Self = Self (0x0c) ; # [doc = "Digital filter enabled and filtering capability up to 13 tI2CCLK"]
pub const FILTER13 : Self = Self (0x0d) ; # [doc = "Digital filter enabled and filtering capability up to 14 tI2CCLK"]
pub const FILTER14 : Self = Self (0x0e) ; # [doc = "Digital filter enabled and filtering capability up to 15 tI2CCLK"]
pub const FILTER15 : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Duty (pub u8) ; impl Duty { # [doc = "Duty cycle t_low/t_high = 2/1"]
pub const DUTY2_1 : Self = Self (0) ; # [doc = "Duty cycle t_low/t_high = 16/9"]
pub const DUTY16_9 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Smbus (pub u8) ; impl Smbus { # [doc = "I2C Mode"]
pub const I2C : Self = Self (0) ; # [doc = "SMBus"]
pub const SMBUS : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Addmode (pub u8) ; impl Addmode { # [doc = "7-bit addressing mode"]
pub const BIT7 : Self = Self (0) ; # [doc = "10-bit addressing mode"]
pub const BIT10 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pos (pub u8) ; impl Pos { # [doc = "ACK bit controls the (N)ACK of the current byte being received"]
pub const CURRENT : Self = Self (0) ; # [doc = "ACK bit controls the (N)ACK of the next byte to be received"]
pub const NEXT : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Smbtype (pub u8) ; impl Smbtype { # [doc = "SMBus Device"]
pub const DEVICE : Self = Self (0) ; # [doc = "SMBus Host"]
pub const HOST : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct FS (pub u8) ; impl FS { # [doc = "Standard mode I2C"]
pub const STANDARD : Self = Self (0) ; # [doc = "Fast mode I2C"]
pub const FAST : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Endual (pub u8) ; impl Endual { # [doc = "Single addressing mode"]
pub const SINGLE : Self = Self (0) ; # [doc = "Dual addressing mode"]
pub const DUAL : Self = Self (0x01) ; } } pub mod regs { # [doc = "Control register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr1 (pub u32) ; impl Cr1 { # [doc = "Peripheral enable"]
pub const fn pe (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Peripheral enable"]
pub fn set_pe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "SMBus mode"]
pub const fn smbus (& self) -> super :: vals :: Smbus { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Smbus (val as u8) } # [doc = "SMBus mode"]
pub fn set_smbus (& mut self , val : super :: vals :: Smbus) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "SMBus type"]
pub const fn smbtype (& self) -> super :: vals :: Smbtype { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Smbtype (val as u8) } # [doc = "SMBus type"]
pub fn set_smbtype (& mut self , val : super :: vals :: Smbtype) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "ARP enable"]
pub const fn enarp (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "ARP enable"]
pub fn set_enarp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "PEC enable"]
pub const fn enpec (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "PEC enable"]
pub fn set_enpec (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "General call enable"]
pub const fn engc (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "General call enable"]
pub fn set_engc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Clock stretching disable (Slave mode)"]
pub const fn nostretch (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Clock stretching disable (Slave mode)"]
pub fn set_nostretch (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Start generation"]
pub const fn start (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Start generation"]
pub fn set_start (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Stop generation"]
pub const fn stop (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Stop generation"]
pub fn set_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Acknowledge enable"]
pub const fn ack (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Acknowledge enable"]
pub fn set_ack (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Acknowledge/PEC Position (for data reception)"]
pub const fn pos (& self) -> super :: vals :: Pos { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Pos (val as u8) } # [doc = "Acknowledge/PEC Position (for data reception)"]
pub fn set_pos (& mut self , val : super :: vals :: Pos) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "Packet error checking"]
pub const fn pec (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Packet error checking"]
pub fn set_pec (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "SMBus alert"]
pub const fn alert (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "SMBus alert"]
pub fn set_alert (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Software reset"]
pub const fn swrst (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Software reset"]
pub fn set_swrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } } impl Default for Cr1 { fn default () -> Cr1 { Cr1 (0) } } # [doc = "TRISE register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Trise (pub u32) ; impl Trise { # [doc = "Maximum rise time in Fast/Standard mode (Master mode)"]
pub const fn trise (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x3f ; val as u8 } # [doc = "Maximum rise time in Fast/Standard mode (Master mode)"]
pub fn set_trise (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x3f << 0usize)) | (((val as u32) & 0x3f) << 0usize) ; } } impl Default for Trise { fn default () -> Trise { Trise (0) } } # [doc = "Clock control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ccr (pub u32) ; impl Ccr { # [doc = "Clock control register in Fast/Standard mode (Master mode)"]
pub const fn ccr (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Clock control register in Fast/Standard mode (Master mode)"]
pub fn set_ccr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "Fast mode duty cycle"]
pub const fn duty (& self) -> super :: vals :: Duty { let val = (self . 0 >> 14usize) & 0x01 ; super :: vals :: Duty (val as u8) } # [doc = "Fast mode duty cycle"]
pub fn set_duty (& mut self , val : super :: vals :: Duty) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val . 0 as u32) & 0x01) << 14usize) ; } # [doc = "I2C master mode selection"]
pub const fn f_s (& self) -> super :: vals :: FS { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: FS (val as u8) } # [doc = "I2C master mode selection"]
pub fn set_f_s (& mut self , val : super :: vals :: FS) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } } impl Default for Ccr { fn default () -> Ccr { Ccr (0) } } # [doc = "FLTR register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fltr (pub u32) ; impl Fltr { # [doc = "Digital noise filter"]
pub const fn dnf (& self) -> super :: vals :: Dnf { let val = (self . 0 >> 0usize) & 0x0f ; super :: vals :: Dnf (val as u8) } # [doc = "Digital noise filter"]
pub fn set_dnf (& mut self , val : super :: vals :: Dnf) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val . 0 as u32) & 0x0f) << 0usize) ; } # [doc = "Analog noise filter"]
pub const fn anoff (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Analog noise filter"]
pub fn set_anoff (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } } impl Default for Fltr { fn default () -> Fltr { Fltr (0) } } # [doc = "Control register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr2 (pub u32) ; impl Cr2 { # [doc = "Peripheral clock frequency"]
pub const fn freq (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x3f ; val as u8 } # [doc = "Peripheral clock frequency"]
pub fn set_freq (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x3f << 0usize)) | (((val as u32) & 0x3f) << 0usize) ; } # [doc = "Error interrupt enable"]
pub const fn iterren (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Error interrupt enable"]
pub fn set_iterren (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Event interrupt enable"]
pub const fn itevten (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Event interrupt enable"]
pub fn set_itevten (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Buffer interrupt enable"]
pub const fn itbufen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Buffer interrupt enable"]
pub fn set_itbufen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "DMA requests enable"]
pub const fn dmaen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "DMA requests enable"]
pub fn set_dmaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "DMA last transfer"]
pub const fn last (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "DMA last transfer"]
pub fn set_last (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } } impl Default for Cr2 { fn default () -> Cr2 { Cr2 (0) } } # [doc = "Data register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dr (pub u32) ; impl Dr { # [doc = "8-bit data register"]
pub const fn dr (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "8-bit data register"]
pub fn set_dr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } } impl Default for Dr { fn default () -> Dr { Dr (0) } } # [doc = "Status register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr1 (pub u32) ; impl Sr1 { # [doc = "Start bit (Master mode)"]
pub const fn start (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Start bit (Master mode)"]
pub fn set_start (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Address sent (master mode)/matched (slave mode)"]
pub const fn addr (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Address sent (master mode)/matched (slave mode)"]
pub fn set_addr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Byte transfer finished"]
pub const fn btf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Byte transfer finished"]
pub fn set_btf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "10-bit header sent (Master mode)"]
pub const fn add10 (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "10-bit header sent (Master mode)"]
pub fn set_add10 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Stop detection (slave mode)"]
pub const fn stopf (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Stop detection (slave mode)"]
pub fn set_stopf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Data register not empty (receivers)"]
pub const fn rxne (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Data register not empty (receivers)"]
pub fn set_rxne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Data register empty (transmitters)"]
pub const fn txe (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Data register empty (transmitters)"]
pub fn set_txe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Bus error"]
pub const fn berr (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Bus error"]
pub fn set_berr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Arbitration lost (master mode)"]
pub const fn arlo (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Arbitration lost (master mode)"]
pub fn set_arlo (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Acknowledge failure"]
pub const fn af (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Acknowledge failure"]
pub fn set_af (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Overrun/Underrun"]
pub const fn ovr (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Overrun/Underrun"]
pub fn set_ovr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "PEC Error in reception"]
pub const fn pecerr (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "PEC Error in reception"]
pub fn set_pecerr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Timeout or t_low detection flag"]
pub const fn timeout (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Timeout or t_low detection flag"]
pub fn set_timeout (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SMBus alert"]
pub const fn alert (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "SMBus alert"]
pub fn set_alert (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } } impl Default for Sr1 { fn default () -> Sr1 { Sr1 (0) } } # [doc = "Own address register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Oar2 (pub u32) ; impl Oar2 { # [doc = "Dual addressing mode enable"]
pub const fn endual (& self) -> super :: vals :: Endual { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Endual (val as u8) } # [doc = "Dual addressing mode enable"]
pub fn set_endual (& mut self , val : super :: vals :: Endual) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Interface address"]
pub const fn add2 (& self) -> u8 { let val = (self . 0 >> 1usize) & 0x7f ; val as u8 } # [doc = "Interface address"]
pub fn set_add2 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 1usize)) | (((val as u32) & 0x7f) << 1usize) ; } } impl Default for Oar2 { fn default () -> Oar2 { Oar2 (0) } } # [doc = "Status register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr2 (pub u32) ; impl Sr2 { # [doc = "Master/slave"]
pub const fn msl (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Master/slave"]
pub fn set_msl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Bus busy"]
pub const fn busy (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Bus busy"]
pub fn set_busy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Transmitter/receiver"]
pub const fn tra (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Transmitter/receiver"]
pub fn set_tra (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "General call address (Slave mode)"]
pub const fn gencall (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "General call address (Slave mode)"]
pub fn set_gencall (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "SMBus device default address (Slave mode)"]
pub const fn smbdefault (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "SMBus device default address (Slave mode)"]
pub fn set_smbdefault (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "SMBus host header (Slave mode)"]
pub const fn smbhost (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "SMBus host header (Slave mode)"]
pub fn set_smbhost (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Dual flag (Slave mode)"]
pub const fn dualf (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Dual flag (Slave mode)"]
pub fn set_dualf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Packet error checking register"]
pub const fn pec (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Packet error checking register"]
pub fn set_pec (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } } impl Default for Sr2 { fn default () -> Sr2 { Sr2 (0) } } # [doc = "Own address register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Oar1 (pub u32) ; impl Oar1 { # [doc = "Interface address"]
pub const fn add (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x03ff ; val as u16 } # [doc = "Interface address"]
pub fn set_add (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x03ff << 0usize)) | (((val as u32) & 0x03ff) << 0usize) ; } # [doc = "Addressing mode (slave mode)"]
pub const fn addmode (& self) -> super :: vals :: Addmode { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Addmode (val as u8) } # [doc = "Addressing mode (slave mode)"]
pub fn set_addmode (& mut self , val : super :: vals :: Addmode) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } } impl Default for Oar1 { fn default () -> Oar1 { Oar1 (0) } } }