

# [doc = "General-purpose I/Os"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Gpio (pub * mut u8) ; unsafe impl Send for Gpio { } unsafe impl Sync for Gpio { } impl Gpio { # [doc = "GPIO port mode register"]
pub fn moder (self) -> crate :: common :: Reg < regs :: Moder , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "GPIO port output type register"]
pub fn otyper (self) -> crate :: common :: Reg < regs :: Otyper , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "GPIO port output speed register"]
pub fn ospeedr (self) -> crate :: common :: Reg < regs :: Ospeedr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "GPIO port pull-up/pull-down register"]
pub fn pupdr (self) -> crate :: common :: Reg < regs :: Pupdr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "GPIO port input data register"]
pub fn idr (self) -> crate :: common :: Reg < regs :: Idr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "GPIO port output data register"]
pub fn odr (self) -> crate :: common :: Reg < regs :: Odr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "GPIO port bit set/reset register"]
pub fn bsrr (self) -> crate :: common :: Reg < regs :: Bsrr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "GPIO port configuration lock register"]
pub fn lckr (self) -> crate :: common :: Reg < regs :: Lckr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "GPIO alternate function register (low, high)"]
pub fn afr (self , n : usize) -> crate :: common :: Reg < regs :: Afr , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize + n * 4usize)) } } } pub mod regs { # [doc = "GPIO port output type register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Otyper (pub u32) ; impl Otyper { # [doc = "Port x configuration bits (y = 0..15)"]
pub fn ot (& self , n : usize) -> super :: vals :: Ot { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Ot (val as u8) } # [doc = "Port x configuration bits (y = 0..15)"]
pub fn set_ot (& mut self , n : usize , val : super :: vals :: Ot) { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } } impl Default for Otyper { fn default () -> Otyper { Otyper (0) } } # [doc = "GPIO port mode register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Moder (pub u32) ; impl Moder { # [doc = "Port x configuration bits (y = 0..15)"]
pub fn moder (& self , n : usize) -> super :: vals :: Moder { assert ! (n < 16usize) ; let offs = 0usize + n * 2usize ; let val = (self . 0 >> offs) & 0x03 ; super :: vals :: Moder (val as u8) } # [doc = "Port x configuration bits (y = 0..15)"]
pub fn set_moder (& mut self , n : usize , val : super :: vals :: Moder) { assert ! (n < 16usize) ; let offs = 0usize + n * 2usize ; self . 0 = (self . 0 & ! (0x03 << offs)) | (((val . 0 as u32) & 0x03) << offs) ; } } impl Default for Moder { fn default () -> Moder { Moder (0) } } # [doc = "GPIO port input data register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Idr (pub u32) ; impl Idr { # [doc = "Port input data (y = 0..15)"]
pub fn idr (& self , n : usize) -> super :: vals :: Idr { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Idr (val as u8) } # [doc = "Port input data (y = 0..15)"]
pub fn set_idr (& mut self , n : usize , val : super :: vals :: Idr) { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } } impl Default for Idr { fn default () -> Idr { Idr (0) } } # [doc = "GPIO port configuration lock register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Lckr (pub u32) ; impl Lckr { # [doc = "Port x lock bit y (y= 0..15)"]
pub fn lck (& self , n : usize) -> super :: vals :: Lck { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Lck (val as u8) } # [doc = "Port x lock bit y (y= 0..15)"]
pub fn set_lck (& mut self , n : usize , val : super :: vals :: Lck) { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "Port x lock bit y (y= 0..15)"]
pub const fn lckk (& self) -> super :: vals :: Lckk { let val = (self . 0 >> 16usize) & 0x01 ; super :: vals :: Lckk (val as u8) } # [doc = "Port x lock bit y (y= 0..15)"]
pub fn set_lckk (& mut self , val : super :: vals :: Lckk) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val . 0 as u32) & 0x01) << 16usize) ; } } impl Default for Lckr { fn default () -> Lckr { Lckr (0) } } # [doc = "GPIO alternate function register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Afr (pub u32) ; impl Afr { # [doc = "Alternate function selection for port x bit y (y = 0..15)"]
pub fn afr (& self , n : usize) -> u8 { assert ! (n < 8usize) ; let offs = 0usize + n * 4usize ; let val = (self . 0 >> offs) & 0x0f ; val as u8 } # [doc = "Alternate function selection for port x bit y (y = 0..15)"]
pub fn set_afr (& mut self , n : usize , val : u8) { assert ! (n < 8usize) ; let offs = 0usize + n * 4usize ; self . 0 = (self . 0 & ! (0x0f << offs)) | (((val as u32) & 0x0f) << offs) ; } } impl Default for Afr { fn default () -> Afr { Afr (0) } } # [doc = "GPIO port bit set/reset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bsrr (pub u32) ; impl Bsrr { # [doc = "Port x set bit y (y= 0..15)"]
pub fn bs (& self , n : usize) -> bool { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Port x set bit y (y= 0..15)"]
pub fn set_bs (& mut self , n : usize , val : bool) { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Port x set bit y (y= 0..15)"]
pub fn br (& self , n : usize) -> bool { assert ! (n < 16usize) ; let offs = 16usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Port x set bit y (y= 0..15)"]
pub fn set_br (& mut self , n : usize , val : bool) { assert ! (n < 16usize) ; let offs = 16usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Bsrr { fn default () -> Bsrr { Bsrr (0) } } # [doc = "GPIO port pull-up/pull-down register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pupdr (pub u32) ; impl Pupdr { # [doc = "Port x configuration bits (y = 0..15)"]
pub fn pupdr (& self , n : usize) -> super :: vals :: Pupdr { assert ! (n < 16usize) ; let offs = 0usize + n * 2usize ; let val = (self . 0 >> offs) & 0x03 ; super :: vals :: Pupdr (val as u8) } # [doc = "Port x configuration bits (y = 0..15)"]
pub fn set_pupdr (& mut self , n : usize , val : super :: vals :: Pupdr) { assert ! (n < 16usize) ; let offs = 0usize + n * 2usize ; self . 0 = (self . 0 & ! (0x03 << offs)) | (((val . 0 as u32) & 0x03) << offs) ; } } impl Default for Pupdr { fn default () -> Pupdr { Pupdr (0) } } # [doc = "GPIO port output speed register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ospeedr (pub u32) ; impl Ospeedr { # [doc = "Port x configuration bits (y = 0..15)"]
pub fn ospeedr (& self , n : usize) -> super :: vals :: Ospeedr { assert ! (n < 16usize) ; let offs = 0usize + n * 2usize ; let val = (self . 0 >> offs) & 0x03 ; super :: vals :: Ospeedr (val as u8) } # [doc = "Port x configuration bits (y = 0..15)"]
pub fn set_ospeedr (& mut self , n : usize , val : super :: vals :: Ospeedr) { assert ! (n < 16usize) ; let offs = 0usize + n * 2usize ; self . 0 = (self . 0 & ! (0x03 << offs)) | (((val . 0 as u32) & 0x03) << offs) ; } } impl Default for Ospeedr { fn default () -> Ospeedr { Ospeedr (0) } } # [doc = "GPIO port output data register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Odr (pub u32) ; impl Odr { # [doc = "Port output data (y = 0..15)"]
pub fn odr (& self , n : usize) -> super :: vals :: Odr { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Odr (val as u8) } # [doc = "Port output data (y = 0..15)"]
pub fn set_odr (& mut self , n : usize , val : super :: vals :: Odr) { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } } impl Default for Odr { fn default () -> Odr { Odr (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lck (pub u8) ; impl Lck { # [doc = "Port configuration not locked"]
pub const UNLOCKED : Self = Self (0) ; # [doc = "Port configuration locked"]
pub const LOCKED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Moder (pub u8) ; impl Moder { # [doc = "Input mode (reset state)"]
pub const INPUT : Self = Self (0) ; # [doc = "General purpose output mode"]
pub const OUTPUT : Self = Self (0x01) ; # [doc = "Alternate function mode"]
pub const ALTERNATE : Self = Self (0x02) ; # [doc = "Analog mode"]
pub const ANALOG : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Odr (pub u8) ; impl Odr { # [doc = "Set output to logic low"]
pub const LOW : Self = Self (0) ; # [doc = "Set output to logic high"]
pub const HIGH : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ospeedr (pub u8) ; impl Ospeedr { # [doc = "Low speed"]
pub const LOWSPEED : Self = Self (0) ; # [doc = "Medium speed"]
pub const MEDIUMSPEED : Self = Self (0x01) ; # [doc = "High speed"]
pub const HIGHSPEED : Self = Self (0x02) ; # [doc = "Very high speed"]
pub const VERYHIGHSPEED : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Idr (pub u8) ; impl Idr { # [doc = "Input is logic low"]
pub const LOW : Self = Self (0) ; # [doc = "Input is logic high"]
pub const HIGH : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lckk (pub u8) ; impl Lckk { # [doc = "Port configuration lock key not active"]
pub const NOTACTIVE : Self = Self (0) ; # [doc = "Port configuration lock key active"]
pub const ACTIVE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ot (pub u8) ; impl Ot { # [doc = "Output push-pull (reset state)"]
pub const PUSHPULL : Self = Self (0) ; # [doc = "Output open-drain"]
pub const OPENDRAIN : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pupdr (pub u8) ; impl Pupdr { # [doc = "No pull-up, pull-down"]
pub const FLOATING : Self = Self (0) ; # [doc = "Pull-up"]
pub const PULLUP : Self = Self (0x01) ; # [doc = "Pull-down"]
pub const PULLDOWN : Self = Self (0x02) ; } }