

# [doc = "General purpose I/O"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Gpio (pub * mut u8) ; unsafe impl Send for Gpio { } unsafe impl Sync for Gpio { } impl Gpio { # [doc = "Port configuration register low (GPIOn_CRL)"]
pub fn cr (self , n : usize) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize + n * 4usize)) } } # [doc = "Port input data register (GPIOn_IDR)"]
pub fn idr (self) -> crate :: common :: Reg < regs :: Idr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Port output data register (GPIOn_ODR)"]
pub fn odr (self) -> crate :: common :: Reg < regs :: Odr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Port bit set/reset register (GPIOn_BSRR)"]
pub fn bsrr (self) -> crate :: common :: Reg < regs :: Bsrr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Port bit reset register (GPIOn_BRR)"]
pub fn brr (self) -> crate :: common :: Reg < regs :: Brr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "Port configuration lock register"]
pub fn lckr (self) -> crate :: common :: Reg < regs :: Lckr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } } pub mod regs { # [doc = "Port configuration lock register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Lckr (pub u32) ; impl Lckr { # [doc = "Port A Lock bit"]
pub fn lck (& self , n : usize) -> super :: vals :: Lck { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Lck (val as u8) } # [doc = "Port A Lock bit"]
pub fn set_lck (& mut self , n : usize , val : super :: vals :: Lck) { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "Lock key"]
pub const fn lckk (& self) -> super :: vals :: Lckk { let val = (self . 0 >> 16usize) & 0x01 ; super :: vals :: Lckk (val as u8) } # [doc = "Lock key"]
pub fn set_lckk (& mut self , val : super :: vals :: Lckk) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val . 0 as u32) & 0x01) << 16usize) ; } } impl Default for Lckr { fn default () -> Lckr { Lckr (0) } } # [doc = "Port input data register (GPIOn_IDR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Idr (pub u32) ; impl Idr { # [doc = "Port input data"]
pub fn idr (& self , n : usize) -> super :: vals :: Idr { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Idr (val as u8) } # [doc = "Port input data"]
pub fn set_idr (& mut self , n : usize , val : super :: vals :: Idr) { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } } impl Default for Idr { fn default () -> Idr { Idr (0) } } # [doc = "Port bit reset register (GPIOn_BRR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Brr (pub u32) ; impl Brr { # [doc = "Reset bit"]
pub fn br (& self , n : usize) -> bool { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Reset bit"]
pub fn set_br (& mut self , n : usize , val : bool) { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Brr { fn default () -> Brr { Brr (0) } } # [doc = "Port output data register (GPIOn_ODR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Odr (pub u32) ; impl Odr { # [doc = "Port output data"]
pub fn odr (& self , n : usize) -> super :: vals :: Odr { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Odr (val as u8) } # [doc = "Port output data"]
pub fn set_odr (& mut self , n : usize , val : super :: vals :: Odr) { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } } impl Default for Odr { fn default () -> Odr { Odr (0) } } # [doc = "Port configuration register (GPIOn_CRx)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Port n mode bits"]
pub fn mode (& self , n : usize) -> super :: vals :: Mode { assert ! (n < 8usize) ; let offs = 0usize + n * 4usize ; let val = (self . 0 >> offs) & 0x03 ; super :: vals :: Mode (val as u8) } # [doc = "Port n mode bits"]
pub fn set_mode (& mut self , n : usize , val : super :: vals :: Mode) { assert ! (n < 8usize) ; let offs = 0usize + n * 4usize ; self . 0 = (self . 0 & ! (0x03 << offs)) | (((val . 0 as u32) & 0x03) << offs) ; } # [doc = "Port n configuration bits, for input mode"]
pub fn cnf_in (& self , n : usize) -> super :: vals :: CnfIn { assert ! (n < 8usize) ; let offs = 2usize + n * 4usize ; let val = (self . 0 >> offs) & 0x03 ; super :: vals :: CnfIn (val as u8) } # [doc = "Port n configuration bits, for input mode"]
pub fn set_cnf_in (& mut self , n : usize , val : super :: vals :: CnfIn) { assert ! (n < 8usize) ; let offs = 2usize + n * 4usize ; self . 0 = (self . 0 & ! (0x03 << offs)) | (((val . 0 as u32) & 0x03) << offs) ; } # [doc = "Port n configuration bits, for output mode"]
pub fn cnf_out (& self , n : usize) -> super :: vals :: CnfOut { assert ! (n < 8usize) ; let offs = 2usize + n * 4usize ; let val = (self . 0 >> offs) & 0x03 ; super :: vals :: CnfOut (val as u8) } # [doc = "Port n configuration bits, for output mode"]
pub fn set_cnf_out (& mut self , n : usize , val : super :: vals :: CnfOut) { assert ! (n < 8usize) ; let offs = 2usize + n * 4usize ; self . 0 = (self . 0 & ! (0x03 << offs)) | (((val . 0 as u32) & 0x03) << offs) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "Port bit set/reset register (GPIOn_BSRR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bsrr (pub u32) ; impl Bsrr { # [doc = "Set bit"]
pub fn bs (& self , n : usize) -> bool { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Set bit"]
pub fn set_bs (& mut self , n : usize , val : bool) { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Reset bit"]
pub fn br (& self , n : usize) -> bool { assert ! (n < 16usize) ; let offs = 16usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Reset bit"]
pub fn set_br (& mut self , n : usize , val : bool) { assert ! (n < 16usize) ; let offs = 16usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Bsrr { fn default () -> Bsrr { Bsrr (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct CnfIn (pub u8) ; impl CnfIn { # [doc = "Analog mode"]
pub const ANALOG : Self = Self (0) ; # [doc = "Floating input (reset state)"]
pub const FLOATING : Self = Self (0x01) ; # [doc = "Input with pull-up/pull-down"]
pub const PULL : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Idr (pub u8) ; impl Idr { # [doc = "Input is logic low"]
pub const LOW : Self = Self (0) ; # [doc = "Input is logic high"]
pub const HIGH : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct CnfOut (pub u8) ; impl CnfOut { # [doc = "Push-Pull mode"]
pub const PUSHPULL : Self = Self (0) ; # [doc = "Open Drain-Mode"]
pub const OPENDRAIN : Self = Self (0x01) ; # [doc = "Alternate Function Push-Pull Mode"]
pub const ALTPUSHPULL : Self = Self (0x02) ; # [doc = "Alternate Function Open-Drain Mode"]
pub const ALTOPENDRAIN : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lckk (pub u8) ; impl Lckk { # [doc = "Port configuration lock key not active"]
pub const NOTACTIVE : Self = Self (0) ; # [doc = "Port configuration lock key active"]
pub const ACTIVE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mode (pub u8) ; impl Mode { # [doc = "Input mode (reset state)"]
pub const INPUT : Self = Self (0) ; # [doc = "Output mode 10 MHz"]
pub const OUTPUT10MHZ : Self = Self (0x01) ; # [doc = "Output mode 2 MHz"]
pub const OUTPUT2MHZ : Self = Self (0x02) ; # [doc = "Output mode 50 MHz"]
pub const OUTPUT50MHZ : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lck (pub u8) ; impl Lck { # [doc = "Port configuration not locked"]
pub const UNLOCKED : Self = Self (0) ; # [doc = "Port configuration locked"]
pub const LOCKED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Odr (pub u8) ; impl Odr { # [doc = "Set output to logic low"]
pub const LOW : Self = Self (0) ; # [doc = "Set output to logic high"]
pub const HIGH : Self = Self (0x01) ; } }