

# [doc = "Flash"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Flash (pub * mut u8) ; unsafe impl Send for Flash { } unsafe impl Sync for Flash { } impl Flash { # [doc = "Access control register"]
pub fn acr (self) -> crate :: common :: Reg < regs :: Acr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Power down key register"]
pub fn pdkeyr (self) -> crate :: common :: Reg < regs :: Pdkeyr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Flash key register"]
pub fn keyr (self) -> crate :: common :: Reg < regs :: Keyr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Option byte key register"]
pub fn optkeyr (self) -> crate :: common :: Reg < regs :: Optkeyr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Flash control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "Flash ECC register"]
pub fn eccr (self) -> crate :: common :: Reg < regs :: Eccr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "Flash option register"]
pub fn optr (self) -> crate :: common :: Reg < regs :: Optr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "Flash Bank 1 PCROP Start address register"]
pub fn pcrop1sr (self) -> crate :: common :: Reg < regs :: Pcrop1sr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "Flash Bank 1 PCROP End address register"]
pub fn pcrop1er (self) -> crate :: common :: Reg < regs :: Pcrop1er , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "Flash Bank 1 WRP area A address register"]
pub fn wrp1ar (self) -> crate :: common :: Reg < regs :: Wrp1ar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "Flash Bank 1 WRP area B address register"]
pub fn wrp1br (self) -> crate :: common :: Reg < regs :: Wrp1br , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "Flash Bank 2 PCROP Start address register"]
pub fn pcrop2sr (self) -> crate :: common :: Reg < regs :: Pcrop2sr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (68usize)) } } # [doc = "Flash Bank 2 PCROP End address register"]
pub fn pcrop2er (self) -> crate :: common :: Reg < regs :: Pcrop2er , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "Flash Bank 2 WRP area A address register"]
pub fn wrp2ar (self) -> crate :: common :: Reg < regs :: Wrp2ar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } # [doc = "Flash Bank 2 WRP area B address register"]
pub fn wrp2br (self) -> crate :: common :: Reg < regs :: Wrp2br , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (80usize)) } } } pub mod regs { # [doc = "Access control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Acr (pub u32) ; impl Acr { # [doc = "Latency"]
pub const fn latency (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x07 ; val as u8 } # [doc = "Latency"]
pub fn set_latency (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val as u32) & 0x07) << 0usize) ; } # [doc = "Prefetch enable"]
pub const fn prften (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Prefetch enable"]
pub fn set_prften (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Instruction cache enable"]
pub const fn icen (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Instruction cache enable"]
pub fn set_icen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Data cache enable"]
pub const fn dcen (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Data cache enable"]
pub fn set_dcen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Instruction cache reset"]
pub const fn icrst (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Instruction cache reset"]
pub fn set_icrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "Data cache reset"]
pub const fn dcrst (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Data cache reset"]
pub fn set_dcrst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Flash Power-down mode during Low-power run mode"]
pub const fn run_pd (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "Flash Power-down mode during Low-power run mode"]
pub fn set_run_pd (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Flash Power-down mode during Low-power sleep mode"]
pub const fn sleep_pd (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Flash Power-down mode during Low-power sleep mode"]
pub fn set_sleep_pd (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } } impl Default for Acr { fn default () -> Acr { Acr (0) } } # [doc = "Flash option register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Optr (pub u32) ; impl Optr { # [doc = "Read protection level"]
pub const fn rdp (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Read protection level"]
pub fn set_rdp (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "BOR reset Level"]
pub const fn bor_lev (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x07 ; val as u8 } # [doc = "BOR reset Level"]
pub fn set_bor_lev (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 8usize)) | (((val as u32) & 0x07) << 8usize) ; } # [doc = "nRST_STOP"]
pub const fn n_rst_stop (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "nRST_STOP"]
pub fn set_n_rst_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "nRST_STDBY"]
pub const fn n_rst_stdby (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "nRST_STDBY"]
pub fn set_n_rst_stdby (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Independent watchdog selection"]
pub const fn idwg_sw (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Independent watchdog selection"]
pub fn set_idwg_sw (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Independent watchdog counter freeze in Stop mode"]
pub const fn iwdg_stop (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Independent watchdog counter freeze in Stop mode"]
pub fn set_iwdg_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Independent watchdog counter freeze in Standby mode"]
pub const fn iwdg_stdby (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Independent watchdog counter freeze in Standby mode"]
pub fn set_iwdg_stdby (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Window watchdog selection"]
pub const fn wwdg_sw (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Window watchdog selection"]
pub fn set_wwdg_sw (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Dual-bank boot"]
pub fn bfb (& self , n : usize) -> bool { assert ! (n < 1usize) ; let offs = 20usize + n * 0usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Dual-bank boot"]
pub fn set_bfb (& mut self , n : usize , val : bool) { assert ! (n < 1usize) ; let offs = 20usize + n * 0usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Dual-Bank on 512 KB or 256 KB Flash memory devices"]
pub const fn dualbank (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Dual-Bank on 512 KB or 256 KB Flash memory devices"]
pub fn set_dualbank (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Boot configuration"]
pub const fn n_boot1 (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Boot configuration"]
pub fn set_n_boot1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "SRAM2 parity check enable"]
pub const fn sram2_pe (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "SRAM2 parity check enable"]
pub fn set_sram2_pe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "SRAM2 Erase when system reset"]
pub const fn sram2_rst (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "SRAM2 Erase when system reset"]
pub fn set_sram2_rst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Software BOOT0"]
pub const fn n_swboot0 (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Software BOOT0"]
pub fn set_n_swboot0 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "nBOOT0 option bit"]
pub const fn n_boot0 (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "nBOOT0 option bit"]
pub fn set_n_boot0 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } } impl Default for Optr { fn default () -> Optr { Optr (0) } } # [doc = "Flash Bank 1 WRP area B address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Wrp1br (pub u32) ; impl Wrp1br { # [doc = "Bank 1 WRP second area B start offset"]
pub const fn wrp1b_strt (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Bank 1 WRP second area B start offset"]
pub fn set_wrp1b_strt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Bank 1 WRP second area B end offset"]
pub const fn wrp1b_end (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Bank 1 WRP second area B end offset"]
pub fn set_wrp1b_end (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } } impl Default for Wrp1br { fn default () -> Wrp1br { Wrp1br (0) } } # [doc = "Power down key register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pdkeyr (pub u32) ; impl Pdkeyr { # [doc = "RUN_PD in FLASH_ACR key"]
pub const fn pdkeyr (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "RUN_PD in FLASH_ACR key"]
pub fn set_pdkeyr (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Pdkeyr { fn default () -> Pdkeyr { Pdkeyr (0) } } # [doc = "Flash control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Programming"]
pub const fn pg (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Programming"]
pub fn set_pg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Page erase"]
pub const fn per (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Page erase"]
pub fn set_per (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Bank 1 Mass erase"]
pub fn mer (& self , n : usize) -> bool { assert ! (n < 2usize) ; let offs = 2usize + n * 13usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Bank 1 Mass erase"]
pub fn set_mer (& mut self , n : usize , val : bool) { assert ! (n < 2usize) ; let offs = 2usize + n * 13usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Page number"]
pub const fn pnb (& self) -> u8 { let val = (self . 0 >> 3usize) & 0xff ; val as u8 } # [doc = "Page number"]
pub fn set_pnb (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 3usize)) | (((val as u32) & 0xff) << 3usize) ; } # [doc = "Bank erase"]
pub const fn bker (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Bank erase"]
pub fn set_bker (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "Start"]
pub const fn start (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Start"]
pub fn set_start (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Options modification start"]
pub const fn optstrt (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Options modification start"]
pub fn set_optstrt (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Fast programming"]
pub const fn fstpg (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Fast programming"]
pub fn set_fstpg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "End of operation interrupt enable"]
pub const fn eopie (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "End of operation interrupt enable"]
pub fn set_eopie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Error interrupt enable"]
pub const fn errie (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Error interrupt enable"]
pub fn set_errie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "PCROP read error interrupt enable"]
pub const fn rderrie (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "PCROP read error interrupt enable"]
pub fn set_rderrie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Force the option byte loading"]
pub const fn obl_launch (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "Force the option byte loading"]
pub fn set_obl_launch (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "Options Lock"]
pub const fn optlock (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Options Lock"]
pub fn set_optlock (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "FLASH_CR Lock"]
pub const fn lock (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "FLASH_CR Lock"]
pub fn set_lock (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "Flash Bank 1 PCROP End address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pcrop1er (pub u32) ; impl Pcrop1er { # [doc = "Bank 1 PCROP area end offset"]
pub const fn pcrop1_end (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Bank 1 PCROP area end offset"]
pub fn set_pcrop1_end (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "PCROP area preserved when RDP level decreased"]
pub const fn pcrop_rdp (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "PCROP area preserved when RDP level decreased"]
pub fn set_pcrop_rdp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Pcrop1er { fn default () -> Pcrop1er { Pcrop1er (0) } } # [doc = "Flash key register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Keyr (pub u32) ; impl Keyr { # [doc = "KEYR"]
pub const fn keyr (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "KEYR"]
pub fn set_keyr (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Keyr { fn default () -> Keyr { Keyr (0) } } # [doc = "Flash Bank 2 WRP area B address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Wrp2br (pub u32) ; impl Wrp2br { # [doc = "Bank 2 WRP second area B start offset"]
pub const fn wrp2b_strt (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Bank 2 WRP second area B start offset"]
pub fn set_wrp2b_strt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Bank 2 WRP second area B end offset"]
pub const fn wrp2b_end (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Bank 2 WRP second area B end offset"]
pub fn set_wrp2b_end (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } } impl Default for Wrp2br { fn default () -> Wrp2br { Wrp2br (0) } } # [doc = "Flash Bank 1 PCROP Start address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pcrop1sr (pub u32) ; impl Pcrop1sr { # [doc = "Bank 1 PCROP area start offset"]
pub const fn pcrop1_strt (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Bank 1 PCROP area start offset"]
pub fn set_pcrop1_strt (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Pcrop1sr { fn default () -> Pcrop1sr { Pcrop1sr (0) } } # [doc = "Option byte key register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Optkeyr (pub u32) ; impl Optkeyr { # [doc = "Option byte key"]
pub const fn optkeyr (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Option byte key"]
pub fn set_optkeyr (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Optkeyr { fn default () -> Optkeyr { Optkeyr (0) } } # [doc = "Status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr (pub u32) ; impl Sr { # [doc = "End of operation"]
pub const fn eop (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "End of operation"]
pub fn set_eop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Operation error"]
pub const fn operr (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Operation error"]
pub fn set_operr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Programming error"]
pub const fn progerr (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Programming error"]
pub fn set_progerr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Write protected error"]
pub const fn wrperr (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Write protected error"]
pub fn set_wrperr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Programming alignment error"]
pub const fn pgaerr (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Programming alignment error"]
pub fn set_pgaerr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Size error"]
pub const fn sizerr (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Size error"]
pub fn set_sizerr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Programming sequence error"]
pub const fn pgserr (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Programming sequence error"]
pub fn set_pgserr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Fast programming data miss error"]
pub const fn miserr (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Fast programming data miss error"]
pub fn set_miserr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Fast programming error"]
pub const fn fasterr (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Fast programming error"]
pub fn set_fasterr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "PCROP read error"]
pub const fn rderr (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "PCROP read error"]
pub fn set_rderr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Option validity error"]
pub const fn optverr (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Option validity error"]
pub fn set_optverr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Busy"]
pub const fn bsy (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Busy"]
pub fn set_bsy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Sr { fn default () -> Sr { Sr (0) } } # [doc = "Flash Bank 2 WRP area A address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Wrp2ar (pub u32) ; impl Wrp2ar { # [doc = "Bank 2 WRP first area A start offset"]
pub const fn wrp2a_strt (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Bank 2 WRP first area A start offset"]
pub fn set_wrp2a_strt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Bank 2 WRP first area A end offset"]
pub const fn wrp2a_end (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Bank 2 WRP first area A end offset"]
pub fn set_wrp2a_end (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } } impl Default for Wrp2ar { fn default () -> Wrp2ar { Wrp2ar (0) } } # [doc = "Flash Bank 1 WRP area A address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Wrp1ar (pub u32) ; impl Wrp1ar { # [doc = "Bank 1 WRP first area tart offset"]
pub const fn wrp1a_strt (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Bank 1 WRP first area tart offset"]
pub fn set_wrp1a_strt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Bank 1 WRP first area A end offset"]
pub const fn wrp1a_end (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Bank 1 WRP first area A end offset"]
pub fn set_wrp1a_end (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } } impl Default for Wrp1ar { fn default () -> Wrp1ar { Wrp1ar (0) } } # [doc = "Flash Bank 2 PCROP End address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pcrop2er (pub u32) ; impl Pcrop2er { # [doc = "Bank 2 PCROP area end offset"]
pub const fn pcrop2_end (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Bank 2 PCROP area end offset"]
pub fn set_pcrop2_end (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Pcrop2er { fn default () -> Pcrop2er { Pcrop2er (0) } } # [doc = "Flash ECC register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Eccr (pub u32) ; impl Eccr { # [doc = "ECC fail address"]
pub const fn addr_ecc (& self) -> u32 { let val = (self . 0 >> 0usize) & 0x0007_ffff ; val as u32 } # [doc = "ECC fail address"]
pub fn set_addr_ecc (& mut self , val : u32) { self . 0 = (self . 0 & ! (0x0007_ffff << 0usize)) | (((val as u32) & 0x0007_ffff) << 0usize) ; } # [doc = "ECC fail bank"]
pub const fn bk_ecc (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "ECC fail bank"]
pub fn set_bk_ecc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "System Flash ECC fail"]
pub const fn sysf_ecc (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "System Flash ECC fail"]
pub fn set_sysf_ecc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "ECC correction interrupt enable"]
pub const fn eccie (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "ECC correction interrupt enable"]
pub fn set_eccie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "ECC correction"]
pub const fn eccc (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "ECC correction"]
pub fn set_eccc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "ECC detection"]
pub const fn eccd (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "ECC detection"]
pub fn set_eccd (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Eccr { fn default () -> Eccr { Eccr (0) } } # [doc = "Flash Bank 2 PCROP Start address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Pcrop2sr (pub u32) ; impl Pcrop2sr { # [doc = "Bank 2 PCROP area start offset"]
pub const fn pcrop2_strt (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Bank 2 PCROP area start offset"]
pub fn set_pcrop2_strt (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Pcrop2sr { fn default () -> Pcrop2sr { Pcrop2sr (0) } } }