

# [doc = "Flash"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Flash (pub * mut u8) ; unsafe impl Send for Flash { } unsafe impl Sync for Flash { } impl Flash { # [doc = "Access control register"]
pub fn acr (self) -> crate :: common :: Reg < regs :: Acr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Cluster BANK%s, containing KEYR?, CR?, SR?, CCR?, PRAR_CUR?, PRAR_PRG?, SCAR_CUR?, SCAR_PRG?, WPSN_CUR?R, WPSN_PRG?R, CRCCR?, CRCSADD?R, CRCEADD?R, ECC_FA?R"]
pub fn bank (self , n : usize) -> Bank { assert ! (n < 2usize) ; unsafe { Bank (self . 0 . add (4usize + n * 256usize)) } } # [doc = "FLASH option key register"]
pub fn optkeyr (self) -> crate :: common :: Reg < regs :: Optkeyr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "FLASH option control register"]
pub fn optcr (self) -> crate :: common :: Reg < regs :: Optcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "FLASH option status register"]
pub fn optsr_cur (self) -> crate :: common :: Reg < regs :: OptsrCur , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "FLASH option status register"]
pub fn optsr_prg (self) -> crate :: common :: Reg < regs :: OptsrPrg , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "FLASH option clear control register"]
pub fn optccr (self) -> crate :: common :: Reg < regs :: Optccr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "FLASH register with boot address"]
pub fn boot_curr (self) -> crate :: common :: Reg < regs :: BootCurr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (64usize)) } } # [doc = "FLASH register with boot address"]
pub fn boot_prgr (self) -> crate :: common :: Reg < regs :: BootPrgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (68usize)) } } # [doc = "FLASH CRC data register"]
pub fn crcdatar (self) -> crate :: common :: Reg < regs :: Crcdatar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (92usize)) } } } # [doc = "Cluster BANK%s, containing KEYR?, CR?, SR?, CCR?, PRAR_CUR?, PRAR_PRG?, SCAR_CUR?, SCAR_PRG?, WPSN_CUR?R, WPSN_PRG?R, CRCCR?, CRCSADD?R, CRCEADD?R, ECC_FA?R"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bank (pub * mut u8) ; unsafe impl Send for Bank { } unsafe impl Sync for Bank { } impl Bank { # [doc = "FLASH key register for bank 1"]
pub fn keyr (self) -> crate :: common :: Reg < regs :: Keyr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "FLASH control register for bank 1"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "FLASH status register for bank 1"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "FLASH clear control register for bank 1"]
pub fn ccr (self) -> crate :: common :: Reg < regs :: Ccr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "FLASH protection address for bank 1"]
pub fn prar_cur (self) -> crate :: common :: Reg < regs :: PrarCur , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "FLASH protection address for bank 1"]
pub fn prar_prg (self) -> crate :: common :: Reg < regs :: PrarPrg , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "FLASH secure address for bank 1"]
pub fn scar_cur (self) -> crate :: common :: Reg < regs :: ScarCur , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "FLASH secure address for bank 1"]
pub fn scar_prg (self) -> crate :: common :: Reg < regs :: ScarPrg , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "FLASH write sector protection for bank 1"]
pub fn wpsn_curr (self) -> crate :: common :: Reg < regs :: WpsnCurr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize)) } } # [doc = "FLASH write sector protection for bank 1"]
pub fn wpsn_prgr (self) -> crate :: common :: Reg < regs :: WpsnPrgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } # [doc = "FLASH CRC control register for bank 1"]
pub fn crccr (self) -> crate :: common :: Reg < regs :: Crccr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } # [doc = "FLASH CRC start address register for bank 1"]
pub fn crcsaddr (self) -> crate :: common :: Reg < regs :: Crcsaddr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (80usize)) } } # [doc = "FLASH CRC end address register for bank 1"]
pub fn crceaddr (self) -> crate :: common :: Reg < regs :: Crceaddr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (84usize)) } } # [doc = "FLASH ECC fail address for bank 1"]
pub fn far (self) -> crate :: common :: Reg < regs :: Far , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (92usize)) } } } pub mod regs { # [doc = "FLASH register with boot address"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct BootCurr (pub u32) ; impl BootCurr { # [doc = "Boot address 0"]
pub const fn boot_add0 (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Boot address 0"]
pub fn set_boot_add0 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "Boot address 1"]
pub const fn boot_add1 (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Boot address 1"]
pub fn set_boot_add1 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for BootCurr { fn default () -> BootCurr { BootCurr (0) } } # [doc = "FLASH register with boot address"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct BootPrgr (pub u32) ; impl BootPrgr { # [doc = "Boot address 0"]
pub const fn boot_add0 (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Boot address 0"]
pub fn set_boot_add0 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "Boot address 1"]
pub const fn boot_add1 (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Boot address 1"]
pub fn set_boot_add1 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for BootPrgr { fn default () -> BootPrgr { BootPrgr (0) } } # [doc = "FLASH secure address for bank 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct ScarCur (pub u32) ; impl ScarCur { # [doc = "Bank 1 lowest secure protected address"]
pub const fn sec_area_start (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Bank 1 lowest secure protected address"]
pub fn set_sec_area_start (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "Bank 1 highest secure protected address"]
pub const fn sec_area_end (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x0fff ; val as u16 } # [doc = "Bank 1 highest secure protected address"]
pub fn set_sec_area_end (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 16usize)) | (((val as u32) & 0x0fff) << 16usize) ; } # [doc = "Bank 1 secure protected erase enable option status bit"]
pub const fn dmes (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Bank 1 secure protected erase enable option status bit"]
pub fn set_dmes (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for ScarCur { fn default () -> ScarCur { ScarCur (0) } } # [doc = "FLASH option clear control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Optccr (pub u32) ; impl Optccr { # [doc = "OPTCHANGEERR reset bit"]
pub const fn clr_optchangeerr (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "OPTCHANGEERR reset bit"]
pub fn set_clr_optchangeerr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } } impl Default for Optccr { fn default () -> Optccr { Optccr (0) } } # [doc = "FLASH write sector protection for bank 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct WpsnPrgr (pub u32) ; impl WpsnPrgr { # [doc = "Bank 1 sector write protection configuration byte"]
pub const fn wrpsn (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Bank 1 sector write protection configuration byte"]
pub fn set_wrpsn (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } } impl Default for WpsnPrgr { fn default () -> WpsnPrgr { WpsnPrgr (0) } } # [doc = "FLASH protection address for bank 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct PrarCur (pub u32) ; impl PrarCur { # [doc = "Bank 1 lowest PCROP protected address"]
pub const fn prot_area_start (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Bank 1 lowest PCROP protected address"]
pub fn set_prot_area_start (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "Bank 1 highest PCROP protected address"]
pub const fn prot_area_end (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x0fff ; val as u16 } # [doc = "Bank 1 highest PCROP protected address"]
pub fn set_prot_area_end (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 16usize)) | (((val as u32) & 0x0fff) << 16usize) ; } # [doc = "Bank 1 PCROP protected erase enable option status bit"]
pub const fn dmep (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Bank 1 PCROP protected erase enable option status bit"]
pub fn set_dmep (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for PrarCur { fn default () -> PrarCur { PrarCur (0) } } # [doc = "FLASH protection address for bank 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct PrarPrg (pub u32) ; impl PrarPrg { # [doc = "Bank 1 lowest PCROP protected address configuration"]
pub const fn prot_area_start (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Bank 1 lowest PCROP protected address configuration"]
pub fn set_prot_area_start (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "Bank 1 highest PCROP protected address configuration"]
pub const fn prot_area_end (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x0fff ; val as u16 } # [doc = "Bank 1 highest PCROP protected address configuration"]
pub fn set_prot_area_end (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 16usize)) | (((val as u32) & 0x0fff) << 16usize) ; } # [doc = "Bank 1 PCROP protected erase enable option configuration bit"]
pub const fn dmep (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Bank 1 PCROP protected erase enable option configuration bit"]
pub fn set_dmep (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for PrarPrg { fn default () -> PrarPrg { PrarPrg (0) } } # [doc = "FLASH CRC start address register for bank 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Crcsaddr (pub u32) ; impl Crcsaddr { # [doc = "CRC start address on bank 1"]
pub const fn crc_start_addr (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "CRC start address on bank 1"]
pub fn set_crc_start_addr (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Crcsaddr { fn default () -> Crcsaddr { Crcsaddr (0) } } # [doc = "FLASH option key register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Optkeyr (pub u32) ; impl Optkeyr { # [doc = "Unlock key option bytes"]
pub const fn optkeyr (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Unlock key option bytes"]
pub fn set_optkeyr (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Optkeyr { fn default () -> Optkeyr { Optkeyr (0) } } # [doc = "FLASH write sector protection for bank 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct WpsnCurr (pub u32) ; impl WpsnCurr { # [doc = "Bank 1 sector write protection option status byte"]
pub const fn wrpsn (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Bank 1 sector write protection option status byte"]
pub fn set_wrpsn (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } } impl Default for WpsnCurr { fn default () -> WpsnCurr { WpsnCurr (0) } } # [doc = "FLASH CRC control register for bank 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Crccr (pub u32) ; impl Crccr { # [doc = "Bank 1 CRC sector number"]
pub const fn crc_sect (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x07 ; val as u8 } # [doc = "Bank 1 CRC sector number"]
pub fn set_crc_sect (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val as u32) & 0x07) << 0usize) ; } # [doc = "Bank 1 CRC select bit"]
pub const fn all_bank (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Bank 1 CRC select bit"]
pub fn set_all_bank (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Bank 1 CRC sector mode select bit"]
pub const fn crc_by_sect (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Bank 1 CRC sector mode select bit"]
pub fn set_crc_by_sect (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Bank 1 CRC sector select bit"]
pub const fn add_sect (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Bank 1 CRC sector select bit"]
pub fn set_add_sect (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Bank 1 CRC sector list clear bit"]
pub const fn clean_sect (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Bank 1 CRC sector list clear bit"]
pub fn set_clean_sect (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Bank 1 CRC start bit"]
pub const fn start_crc (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Bank 1 CRC start bit"]
pub fn set_start_crc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Bank 1 CRC clear bit"]
pub const fn clean_crc (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Bank 1 CRC clear bit"]
pub fn set_clean_crc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Bank 1 CRC burst size"]
pub const fn crc_burst (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x03 ; val as u8 } # [doc = "Bank 1 CRC burst size"]
pub fn set_crc_burst (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val as u32) & 0x03) << 20usize) ; } } impl Default for Crccr { fn default () -> Crccr { Crccr (0) } } # [doc = "FLASH CRC data register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Crcdatar (pub u32) ; impl Crcdatar { # [doc = "CRC result"]
pub const fn crc_data (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "CRC result"]
pub fn set_crc_data (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Crcdatar { fn default () -> Crcdatar { Crcdatar (0) } } # [doc = "FLASH ECC fail address for bank 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Far (pub u32) ; impl Far { # [doc = "Bank 1 ECC error address"]
pub const fn fail_ecc_addr (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x7fff ; val as u16 } # [doc = "Bank 1 ECC error address"]
pub fn set_fail_ecc_addr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x7fff << 0usize)) | (((val as u32) & 0x7fff) << 0usize) ; } } impl Default for Far { fn default () -> Far { Far (0) } } # [doc = "FLASH key register for bank 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Keyr (pub u32) ; impl Keyr { # [doc = "Bank 1 access configuration unlock key"]
pub const fn keyr (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Bank 1 access configuration unlock key"]
pub fn set_keyr (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Keyr { fn default () -> Keyr { Keyr (0) } } # [doc = "Access control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Acr (pub u32) ; impl Acr { # [doc = "Read latency"]
pub const fn latency (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x07 ; val as u8 } # [doc = "Read latency"]
pub fn set_latency (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val as u32) & 0x07) << 0usize) ; } # [doc = "Flash signal delay"]
pub const fn wrhighfreq (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x03 ; val as u8 } # [doc = "Flash signal delay"]
pub fn set_wrhighfreq (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 4usize)) | (((val as u32) & 0x03) << 4usize) ; } } impl Default for Acr { fn default () -> Acr { Acr (0) } } # [doc = "FLASH control register for bank 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Bank 1 configuration lock bit"]
pub const fn lock (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Bank 1 configuration lock bit"]
pub fn set_lock (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Bank 1 program enable bit"]
pub const fn pg (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Bank 1 program enable bit"]
pub fn set_pg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Bank 1 sector erase request"]
pub const fn ser (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Bank 1 sector erase request"]
pub fn set_ser (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Bank 1 erase request"]
pub const fn ber (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Bank 1 erase request"]
pub fn set_ber (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Bank 1 program size"]
pub const fn psize (& self) -> u8 { let val = (self . 0 >> 4usize) & 0x03 ; val as u8 } # [doc = "Bank 1 program size"]
pub fn set_psize (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 4usize)) | (((val as u32) & 0x03) << 4usize) ; } # [doc = "Bank 1 write forcing control bit"]
pub const fn fw (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Bank 1 write forcing control bit"]
pub fn set_fw (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Bank 1 bank or sector erase start control bit"]
pub const fn start (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Bank 1 bank or sector erase start control bit"]
pub fn set_start (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Bank 1 sector erase selection number"]
pub const fn snb (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x07 ; val as u8 } # [doc = "Bank 1 sector erase selection number"]
pub fn set_snb (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 8usize)) | (((val as u32) & 0x07) << 8usize) ; } # [doc = "Bank 1 CRC control bit"]
pub const fn crc_en (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Bank 1 CRC control bit"]
pub fn set_crc_en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Bank 1 end-of-program interrupt control bit"]
pub const fn eopie (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Bank 1 end-of-program interrupt control bit"]
pub fn set_eopie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Bank 1 write protection error interrupt enable bit"]
pub const fn wrperrie (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Bank 1 write protection error interrupt enable bit"]
pub fn set_wrperrie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Bank 1 programming sequence error interrupt enable bit"]
pub const fn pgserrie (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Bank 1 programming sequence error interrupt enable bit"]
pub fn set_pgserrie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Bank 1 strobe error interrupt enable bit"]
pub const fn strberrie (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Bank 1 strobe error interrupt enable bit"]
pub fn set_strberrie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Bank 1 inconsistency error interrupt enable bit"]
pub const fn incerrie (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Bank 1 inconsistency error interrupt enable bit"]
pub fn set_incerrie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Bank 1 write/erase error interrupt enable bit"]
pub const fn operrie (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "Bank 1 write/erase error interrupt enable bit"]
pub fn set_operrie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Bank 1 read protection error interrupt enable bit"]
pub const fn rdperrie (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Bank 1 read protection error interrupt enable bit"]
pub fn set_rdperrie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Bank 1 secure error interrupt enable bit"]
pub const fn rdserrie (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Bank 1 secure error interrupt enable bit"]
pub fn set_rdserrie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Bank 1 ECC single correction error interrupt enable bit"]
pub const fn sneccerrie (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Bank 1 ECC single correction error interrupt enable bit"]
pub fn set_sneccerrie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Bank 1 ECC double detection error interrupt enable bit"]
pub const fn dbeccerrie (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Bank 1 ECC double detection error interrupt enable bit"]
pub fn set_dbeccerrie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Bank 1 end of CRC calculation interrupt enable bit"]
pub const fn crcendie (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "Bank 1 end of CRC calculation interrupt enable bit"]
pub fn set_crcendie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "FLASH option status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OptsrPrg (pub u32) ; impl OptsrPrg { # [doc = "BOR reset level option configuration bits"]
pub const fn bor_lev (& self) -> u8 { let val = (self . 0 >> 2usize) & 0x03 ; val as u8 } # [doc = "BOR reset level option configuration bits"]
pub fn set_bor_lev (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val as u32) & 0x03) << 2usize) ; } # [doc = "IWDG1 option configuration bit"]
pub const fn iwdg1_hw (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IWDG1 option configuration bit"]
pub fn set_iwdg1_hw (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Option byte erase after D1 DStop option configuration bit"]
pub const fn n_rst_stop_d1 (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Option byte erase after D1 DStop option configuration bit"]
pub fn set_n_rst_stop_d1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Option byte erase after D1 DStandby option configuration bit"]
pub const fn n_rst_stby_d1 (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Option byte erase after D1 DStandby option configuration bit"]
pub fn set_n_rst_stby_d1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Readout protection level option configuration byte"]
pub const fn rdp (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Readout protection level option configuration byte"]
pub fn set_rdp (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "IWDG Stop mode freeze option configuration bit"]
pub const fn fz_iwdg_stop (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "IWDG Stop mode freeze option configuration bit"]
pub fn set_fz_iwdg_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "IWDG Standby mode freeze option configuration bit"]
pub const fn fz_iwdg_sdby (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "IWDG Standby mode freeze option configuration bit"]
pub fn set_fz_iwdg_sdby (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "DTCM size select option configuration bits"]
pub const fn st_ram_size (& self) -> u8 { let val = (self . 0 >> 19usize) & 0x03 ; val as u8 } # [doc = "DTCM size select option configuration bits"]
pub fn set_st_ram_size (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 19usize)) | (((val as u32) & 0x03) << 19usize) ; } # [doc = "Security option configuration bit"]
pub const fn security (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Security option configuration bit"]
pub fn set_security (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "User option configuration bit 1"]
pub const fn rss1 (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "User option configuration bit 1"]
pub fn set_rss1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "User option configuration bit 2"]
pub const fn rss2 (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "User option configuration bit 2"]
pub fn set_rss2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "I/O high-speed at low-voltage (PRODUCT_BELOW_25V)"]
pub const fn io_hslv (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "I/O high-speed at low-voltage (PRODUCT_BELOW_25V)"]
pub fn set_io_hslv (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "Bank swapping option configuration bit"]
pub const fn swap_bank_opt (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Bank swapping option configuration bit"]
pub fn set_swap_bank_opt (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for OptsrPrg { fn default () -> OptsrPrg { OptsrPrg (0) } } # [doc = "FLASH CRC end address register for bank 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Crceaddr (pub u32) ; impl Crceaddr { # [doc = "CRC end address on bank 1"]
pub const fn crc_end_addr (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "CRC end address on bank 1"]
pub fn set_crc_end_addr (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Crceaddr { fn default () -> Crceaddr { Crceaddr (0) } } # [doc = "FLASH status register for bank 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr (pub u32) ; impl Sr { # [doc = "Bank 1 ongoing program flag"]
pub const fn bsy (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Bank 1 ongoing program flag"]
pub fn set_bsy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Bank 1 write buffer not empty flag"]
pub const fn wbne (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Bank 1 write buffer not empty flag"]
pub fn set_wbne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Bank 1 wait queue flag"]
pub const fn qw (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Bank 1 wait queue flag"]
pub fn set_qw (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Bank 1 CRC busy flag"]
pub const fn crc_busy (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Bank 1 CRC busy flag"]
pub fn set_crc_busy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Bank 1 end-of-program flag"]
pub const fn eop (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Bank 1 end-of-program flag"]
pub fn set_eop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Bank 1 write protection error flag"]
pub const fn wrperr (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Bank 1 write protection error flag"]
pub fn set_wrperr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Bank 1 programming sequence error flag"]
pub const fn pgserr (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Bank 1 programming sequence error flag"]
pub fn set_pgserr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Bank 1 strobe error flag"]
pub const fn strberr (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Bank 1 strobe error flag"]
pub fn set_strberr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Bank 1 inconsistency error flag"]
pub const fn incerr (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Bank 1 inconsistency error flag"]
pub fn set_incerr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Bank 1 write/erase error flag"]
pub const fn operr (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "Bank 1 write/erase error flag"]
pub fn set_operr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Bank 1 read protection error flag"]
pub const fn rdperr (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Bank 1 read protection error flag"]
pub fn set_rdperr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Bank 1 secure error flag"]
pub const fn rdserr (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Bank 1 secure error flag"]
pub fn set_rdserr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Bank 1 single correction error flag"]
pub const fn sneccerr1 (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Bank 1 single correction error flag"]
pub fn set_sneccerr1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Bank 1 ECC double detection error flag"]
pub const fn dbeccerr (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Bank 1 ECC double detection error flag"]
pub fn set_dbeccerr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Bank 1 CRC-complete flag"]
pub const fn crcend (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "Bank 1 CRC-complete flag"]
pub fn set_crcend (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } } impl Default for Sr { fn default () -> Sr { Sr (0) } } # [doc = "FLASH option control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Optcr (pub u32) ; impl Optcr { # [doc = "FLASH_OPTCR lock option configuration bit"]
pub const fn optlock (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "FLASH_OPTCR lock option configuration bit"]
pub fn set_optlock (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Option byte start change option configuration bit"]
pub const fn optstart (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Option byte start change option configuration bit"]
pub fn set_optstart (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Flash mass erase enable bit"]
pub const fn mer (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Flash mass erase enable bit"]
pub fn set_mer (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Option byte change error interrupt enable bit"]
pub const fn optchangeerrie (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Option byte change error interrupt enable bit"]
pub fn set_optchangeerrie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Bank swapping configuration bit"]
pub const fn swap_bank (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Bank swapping configuration bit"]
pub fn set_swap_bank (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Optcr { fn default () -> Optcr { Optcr (0) } } # [doc = "FLASH option status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct OptsrCur (pub u32) ; impl OptsrCur { # [doc = "Option byte change ongoing flag"]
pub const fn opt_busy (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Option byte change ongoing flag"]
pub fn set_opt_busy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Brownout level option status bit"]
pub const fn bor_lev (& self) -> u8 { let val = (self . 0 >> 2usize) & 0x03 ; val as u8 } # [doc = "Brownout level option status bit"]
pub fn set_bor_lev (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val as u32) & 0x03) << 2usize) ; } # [doc = "IWDG1 control option status bit"]
pub const fn iwdg1_hw (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "IWDG1 control option status bit"]
pub fn set_iwdg1_hw (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "D1 DStop entry reset option status bit"]
pub const fn n_rst_stop_d1 (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "D1 DStop entry reset option status bit"]
pub fn set_n_rst_stop_d1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "D1 DStandby entry reset option status bit"]
pub const fn n_rst_stby_d1 (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "D1 DStandby entry reset option status bit"]
pub fn set_n_rst_stby_d1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Readout protection level option status byte"]
pub const fn rdp (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Readout protection level option status byte"]
pub fn set_rdp (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "IWDG Stop mode freeze option status bit"]
pub const fn fz_iwdg_stop (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "IWDG Stop mode freeze option status bit"]
pub fn set_fz_iwdg_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "IWDG Standby mode freeze option status bit"]
pub const fn fz_iwdg_sdby (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "IWDG Standby mode freeze option status bit"]
pub fn set_fz_iwdg_sdby (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "DTCM RAM size option status"]
pub const fn st_ram_size (& self) -> u8 { let val = (self . 0 >> 19usize) & 0x03 ; val as u8 } # [doc = "DTCM RAM size option status"]
pub fn set_st_ram_size (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 19usize)) | (((val as u32) & 0x03) << 19usize) ; } # [doc = "Security enable option status bit"]
pub const fn security (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Security enable option status bit"]
pub fn set_security (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "User option bit 1"]
pub const fn rss1 (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "User option bit 1"]
pub fn set_rss1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Device personalization status bit"]
pub const fn perso_ok (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Device personalization status bit"]
pub fn set_perso_ok (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "I/O high-speed at low-voltage status bit (PRODUCT_BELOW_25V)"]
pub const fn io_hslv (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "I/O high-speed at low-voltage status bit (PRODUCT_BELOW_25V)"]
pub fn set_io_hslv (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "Option byte change error flag"]
pub const fn optchangeerr (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Option byte change error flag"]
pub fn set_optchangeerr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "Bank swapping option status bit"]
pub const fn swap_bank_opt (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Bank swapping option status bit"]
pub fn set_swap_bank_opt (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for OptsrCur { fn default () -> OptsrCur { OptsrCur (0) } } # [doc = "FLASH secure address for bank 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct ScarPrg (pub u32) ; impl ScarPrg { # [doc = "Bank 1 lowest secure protected address configuration"]
pub const fn sec_area_start (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Bank 1 lowest secure protected address configuration"]
pub fn set_sec_area_start (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "Bank 1 highest secure protected address configuration"]
pub const fn sec_area_end (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x0fff ; val as u16 } # [doc = "Bank 1 highest secure protected address configuration"]
pub fn set_sec_area_end (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 16usize)) | (((val as u32) & 0x0fff) << 16usize) ; } # [doc = "Bank 1 secure protected erase enable option configuration bit"]
pub const fn dmes (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Bank 1 secure protected erase enable option configuration bit"]
pub fn set_dmes (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for ScarPrg { fn default () -> ScarPrg { ScarPrg (0) } } # [doc = "FLASH clear control register for bank 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ccr (pub u32) ; impl Ccr { # [doc = "Bank 1 EOP1 flag clear bit"]
pub const fn clr_eop (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Bank 1 EOP1 flag clear bit"]
pub fn set_clr_eop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Bank 1 WRPERR1 flag clear bit"]
pub const fn clr_wrperr (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Bank 1 WRPERR1 flag clear bit"]
pub fn set_clr_wrperr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "Bank 1 PGSERR1 flag clear bi"]
pub const fn clr_pgserr (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "Bank 1 PGSERR1 flag clear bi"]
pub fn set_clr_pgserr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "Bank 1 STRBERR1 flag clear bit"]
pub const fn clr_strberr (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "Bank 1 STRBERR1 flag clear bit"]
pub fn set_clr_strberr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Bank 1 INCERR1 flag clear bit"]
pub const fn clr_incerr (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Bank 1 INCERR1 flag clear bit"]
pub fn set_clr_incerr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Bank 1 OPERR1 flag clear bit"]
pub const fn clr_operr (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "Bank 1 OPERR1 flag clear bit"]
pub fn set_clr_operr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Bank 1 RDPERR1 flag clear bit"]
pub const fn clr_rdperr (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Bank 1 RDPERR1 flag clear bit"]
pub fn set_clr_rdperr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Bank 1 RDSERR1 flag clear bit"]
pub const fn clr_rdserr (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Bank 1 RDSERR1 flag clear bit"]
pub fn set_clr_rdserr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Bank 1 SNECCERR1 flag clear bit"]
pub const fn clr_sneccerr (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Bank 1 SNECCERR1 flag clear bit"]
pub fn set_clr_sneccerr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Bank 1 DBECCERR1 flag clear bit"]
pub const fn clr_dbeccerr (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Bank 1 DBECCERR1 flag clear bit"]
pub fn set_clr_dbeccerr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } # [doc = "Bank 1 CRCEND1 flag clear bit"]
pub const fn clr_crcend (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "Bank 1 CRCEND1 flag clear bit"]
pub fn set_clr_crcend (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } } impl Default for Ccr { fn default () -> Ccr { Ccr (0) } } }