

# [doc = "FLASH"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Flash (pub * mut u8) ; unsafe impl Send for Flash { } unsafe impl Sync for Flash { } impl Flash { # [doc = "Flash access control register"]
pub fn acr (self) -> crate :: common :: Reg < regs :: Acr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Flash key register"]
pub fn keyr (self) -> crate :: common :: Reg < regs :: Keyr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Flash option key register"]
pub fn optkeyr (self) -> crate :: common :: Reg < regs :: Optkeyr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Flash option control register"]
pub fn optcr (self) -> crate :: common :: Reg < regs :: Optcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Strt (pub u8) ; impl Strt { # [doc = "Trigger an erase operation"]
pub const START : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ser (pub u8) ; impl Ser { # [doc = "Erase activated for selected sector"]
pub const SECTORERASE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Icrst (pub u8) ; impl Icrst { # [doc = "Instruction cache is not reset"]
pub const NOTRESET : Self = Self (0) ; # [doc = "Instruction cache is reset"]
pub const RESET : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dcen (pub u8) ; impl Dcen { # [doc = "Data cache is disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Data cache is enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dcrst (pub u8) ; impl Dcrst { # [doc = "Data cache is not reset"]
pub const NOTRESET : Self = Self (0) ; # [doc = "Data cache is reset"]
pub const RESET : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Prften (pub u8) ; impl Prften { # [doc = "Prefetch is disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Prefetch is enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Eopie (pub u8) ; impl Eopie { # [doc = "End of operation interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "End of operation interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Errie (pub u8) ; impl Errie { # [doc = "Error interrupt generation disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Error interrupt generation enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Latency (pub u8) ; impl Latency { # [doc = "0 wait states"]
pub const WS0 : Self = Self (0) ; # [doc = "1 wait states"]
pub const WS1 : Self = Self (0x01) ; # [doc = "2 wait states"]
pub const WS2 : Self = Self (0x02) ; # [doc = "3 wait states"]
pub const WS3 : Self = Self (0x03) ; # [doc = "4 wait states"]
pub const WS4 : Self = Self (0x04) ; # [doc = "5 wait states"]
pub const WS5 : Self = Self (0x05) ; # [doc = "6 wait states"]
pub const WS6 : Self = Self (0x06) ; # [doc = "7 wait states"]
pub const WS7 : Self = Self (0x07) ; # [doc = "8 wait states"]
pub const WS8 : Self = Self (0x08) ; # [doc = "9 wait states"]
pub const WS9 : Self = Self (0x09) ; # [doc = "10 wait states"]
pub const WS10 : Self = Self (0x0a) ; # [doc = "11 wait states"]
pub const WS11 : Self = Self (0x0b) ; # [doc = "12 wait states"]
pub const WS12 : Self = Self (0x0c) ; # [doc = "13 wait states"]
pub const WS13 : Self = Self (0x0d) ; # [doc = "14 wait states"]
pub const WS14 : Self = Self (0x0e) ; # [doc = "15 wait states"]
pub const WS15 : Self = Self (0x0f) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lock (pub u8) ; impl Lock { # [doc = "FLASH_CR register is unlocked"]
pub const UNLOCKED : Self = Self (0) ; # [doc = "FLASH_CR register is locked"]
pub const LOCKED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mer (pub u8) ; impl Mer { # [doc = "Erase activated for all user sectors"]
pub const MASSERASE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Psize (pub u8) ; impl Psize { # [doc = "Program x8"]
pub const PSIZE8 : Self = Self (0) ; # [doc = "Program x16"]
pub const PSIZE16 : Self = Self (0x01) ; # [doc = "Program x32"]
pub const PSIZE32 : Self = Self (0x02) ; # [doc = "Program x64"]
pub const PSIZE64 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Icen (pub u8) ; impl Icen { # [doc = "Instruction cache is disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Instruction cache is enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pg (pub u8) ; impl Pg { # [doc = "Flash programming activated"]
pub const PROGRAM : Self = Self (0x01) ; } } pub mod regs { # [doc = "Flash key register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Keyr (pub u32) ; impl Keyr { # [doc = "FPEC key"]
pub const fn key (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "FPEC key"]
pub fn set_key (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Keyr { fn default () -> Keyr { Keyr (0) } } # [doc = "Control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Programming"]
pub const fn pg (& self) -> super :: vals :: Pg { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Pg (val as u8) } # [doc = "Programming"]
pub fn set_pg (& mut self , val : super :: vals :: Pg) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Sector Erase"]
pub const fn ser (& self) -> super :: vals :: Ser { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Ser (val as u8) } # [doc = "Sector Erase"]
pub fn set_ser (& mut self , val : super :: vals :: Ser) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Mass Erase"]
pub const fn mer (& self) -> super :: vals :: Mer { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Mer (val as u8) } # [doc = "Mass Erase"]
pub fn set_mer (& mut self , val : super :: vals :: Mer) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Sector number"]
pub const fn snb (& self) -> u8 { let val = (self . 0 >> 3usize) & 0x0f ; val as u8 } # [doc = "Sector number"]
pub fn set_snb (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 3usize)) | (((val as u32) & 0x0f) << 3usize) ; } # [doc = "Program size"]
pub const fn psize (& self) -> super :: vals :: Psize { let val = (self . 0 >> 8usize) & 0x03 ; super :: vals :: Psize (val as u8) } # [doc = "Program size"]
pub fn set_psize (& mut self , val : super :: vals :: Psize) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val . 0 as u32) & 0x03) << 8usize) ; } # [doc = "Start"]
pub const fn strt (& self) -> super :: vals :: Strt { let val = (self . 0 >> 16usize) & 0x01 ; super :: vals :: Strt (val as u8) } # [doc = "Start"]
pub fn set_strt (& mut self , val : super :: vals :: Strt) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val . 0 as u32) & 0x01) << 16usize) ; } # [doc = "End of operation interrupt enable"]
pub const fn eopie (& self) -> super :: vals :: Eopie { let val = (self . 0 >> 24usize) & 0x01 ; super :: vals :: Eopie (val as u8) } # [doc = "End of operation interrupt enable"]
pub fn set_eopie (& mut self , val : super :: vals :: Eopie) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val . 0 as u32) & 0x01) << 24usize) ; } # [doc = "Error interrupt enable"]
pub const fn errie (& self) -> super :: vals :: Errie { let val = (self . 0 >> 25usize) & 0x01 ; super :: vals :: Errie (val as u8) } # [doc = "Error interrupt enable"]
pub fn set_errie (& mut self , val : super :: vals :: Errie) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val . 0 as u32) & 0x01) << 25usize) ; } # [doc = "Lock"]
pub const fn lock (& self) -> super :: vals :: Lock { let val = (self . 0 >> 31usize) & 0x01 ; super :: vals :: Lock (val as u8) } # [doc = "Lock"]
pub fn set_lock (& mut self , val : super :: vals :: Lock) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val . 0 as u32) & 0x01) << 31usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "Flash option key register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Optkeyr (pub u32) ; impl Optkeyr { # [doc = "Option byte key"]
pub const fn optkey (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Option byte key"]
pub fn set_optkey (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Optkeyr { fn default () -> Optkeyr { Optkeyr (0) } } # [doc = "Flash access control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Acr (pub u32) ; impl Acr { # [doc = "Latency"]
pub const fn latency (& self) -> super :: vals :: Latency { let val = (self . 0 >> 0usize) & 0x07 ; super :: vals :: Latency (val as u8) } # [doc = "Latency"]
pub fn set_latency (& mut self , val : super :: vals :: Latency) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val . 0 as u32) & 0x07) << 0usize) ; } # [doc = "Prefetch enable"]
pub const fn prften (& self) -> super :: vals :: Prften { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Prften (val as u8) } # [doc = "Prefetch enable"]
pub fn set_prften (& mut self , val : super :: vals :: Prften) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "Instruction cache enable"]
pub const fn icen (& self) -> super :: vals :: Icen { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Icen (val as u8) } # [doc = "Instruction cache enable"]
pub fn set_icen (& mut self , val : super :: vals :: Icen) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "Data cache enable"]
pub const fn dcen (& self) -> super :: vals :: Dcen { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Dcen (val as u8) } # [doc = "Data cache enable"]
pub fn set_dcen (& mut self , val : super :: vals :: Dcen) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "Instruction cache reset"]
pub const fn icrst (& self) -> super :: vals :: Icrst { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Icrst (val as u8) } # [doc = "Instruction cache reset"]
pub fn set_icrst (& mut self , val : super :: vals :: Icrst) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "Data cache reset"]
pub const fn dcrst (& self) -> super :: vals :: Dcrst { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: Dcrst (val as u8) } # [doc = "Data cache reset"]
pub fn set_dcrst (& mut self , val : super :: vals :: Dcrst) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } } impl Default for Acr { fn default () -> Acr { Acr (0) } } # [doc = "Status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr (pub u32) ; impl Sr { # [doc = "End of operation"]
pub const fn eop (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "End of operation"]
pub fn set_eop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Operation error"]
pub const fn operr (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Operation error"]
pub fn set_operr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Write protection error"]
pub const fn wrperr (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Write protection error"]
pub fn set_wrperr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Programming alignment error"]
pub const fn pgaerr (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Programming alignment error"]
pub fn set_pgaerr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Programming parallelism error"]
pub const fn pgperr (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Programming parallelism error"]
pub fn set_pgperr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Programming sequence error"]
pub const fn pgserr (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Programming sequence error"]
pub fn set_pgserr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Busy"]
pub const fn bsy (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Busy"]
pub fn set_bsy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Sr { fn default () -> Sr { Sr (0) } } # [doc = "Flash option control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Optcr (pub u32) ; impl Optcr { # [doc = "Option lock"]
pub const fn optlock (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Option lock"]
pub fn set_optlock (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Option start"]
pub const fn optstrt (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Option start"]
pub fn set_optstrt (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "BOR reset Level"]
pub const fn bor_lev (& self) -> u8 { let val = (self . 0 >> 2usize) & 0x03 ; val as u8 } # [doc = "BOR reset Level"]
pub fn set_bor_lev (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 2usize)) | (((val as u32) & 0x03) << 2usize) ; } # [doc = "WDG_SW User option bytes"]
pub const fn wdg_sw (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "WDG_SW User option bytes"]
pub fn set_wdg_sw (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "nRST_STOP User option bytes"]
pub const fn n_rst_stop (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "nRST_STOP User option bytes"]
pub fn set_n_rst_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "nRST_STDBY User option bytes"]
pub const fn n_rst_stdby (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "nRST_STDBY User option bytes"]
pub fn set_n_rst_stdby (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Read protect"]
pub const fn rdp (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Read protect"]
pub fn set_rdp (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "Not write protect"]
pub const fn n_wrp (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x0fff ; val as u16 } # [doc = "Not write protect"]
pub fn set_n_wrp (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 16usize)) | (((val as u32) & 0x0fff) << 16usize) ; } } impl Default for Optcr { fn default () -> Optcr { Optcr (0) } } }