

# [doc = "Flash"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Flash (pub * mut u8) ; unsafe impl Send for Flash { } unsafe impl Sync for Flash { } impl Flash { # [doc = "Flash access control register"]
pub fn acr (self) -> crate :: common :: Reg < regs :: Acr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Flash key register"]
pub fn keyr (self) -> crate :: common :: Reg < regs :: Keyr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Flash option key register"]
pub fn optkeyr (self) -> crate :: common :: Reg < regs :: Optkeyr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Flash status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Flash control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Flash address register"]
pub fn ar (self) -> crate :: common :: Reg < regs :: Ar , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "Option byte register"]
pub fn obr (self) -> crate :: common :: Reg < regs :: Obr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "Write protection register"]
pub fn wrpr (self) -> crate :: common :: Reg < regs :: Wrpr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Latency (pub u8) ; impl Latency { # [doc = "0 wait states, if 0 < HCLK <= 24 MHz"]
pub const WS0 : Self = Self (0) ; # [doc = "1 wait state, if 24 < HCLK <= 48 MHz"]
pub const WS1 : Self = Self (0x01) ; # [doc = "2 wait states, if 48 < HCLK <= 72 MHz"]
pub const WS2 : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct VddaMonitor (pub u8) ; impl VddaMonitor { # [doc = "VDDA power supply supervisor disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "VDDA power supply supervisor enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Prftbs (pub u8) ; impl Prftbs { # [doc = "Prefetch buffer is disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Prefetch buffer is enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Hlfcya (pub u8) ; impl Hlfcya { # [doc = "Half cycle is disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Half cycle is enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wrprterrr (pub u8) ; impl Wrprterrr { # [doc = "No write protection error occurred"]
pub const NOERROR : Self = Self (0) ; # [doc = "A write protection error occurred"]
pub const ERROR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Opterr (pub u8) ; impl Opterr { # [doc = "The loaded option byte and its complement do not match"]
pub const OPTIONBYTEERROR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Prftbe (pub u8) ; impl Prftbe { # [doc = "Prefetch is disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Prefetch is enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Strt (pub u8) ; impl Strt { # [doc = "Trigger an erase operation"]
pub const START : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mer (pub u8) ; impl Mer { # [doc = "Erase activated for all user sectors"]
pub const MASSERASE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pgerrr (pub u8) ; impl Pgerrr { # [doc = "No programming error occurred"]
pub const NOERROR : Self = Self (0) ; # [doc = "A programming error occurred"]
pub const ERROR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct SdadcVddMonitor (pub u8) ; impl SdadcVddMonitor { # [doc = "VDDSD12 monitoring disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "VDDSD12 monitoring enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Opter (pub u8) ; impl Opter { # [doc = "Erase option byte activated"]
pub const OPTIONBYTEERASE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Eopw (pub u8) ; impl Eopw { # [doc = "Reset EOP event"]
pub const RESET : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Per (pub u8) ; impl Per { # [doc = "Erase activated for selected page"]
pub const PAGEERASE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Eopr (pub u8) ; impl Eopr { # [doc = "No EOP event occurred"]
pub const NOEVENT : Self = Self (0) ; # [doc = "An EOP event occurred"]
pub const EVENT : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct NBoot (pub u8) ; impl NBoot { # [doc = "Together with BOOT0, select the device boot mode"]
pub const DISABLED : Self = Self (0) ; # [doc = "Together with BOOT0, select the device boot mode"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lockw (pub u8) ; impl Lockw { # [doc = "Lock the FLASH_CR register"]
pub const LOCK : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Bsyr (pub u8) ; impl Bsyr { # [doc = "No write/erase operation is in progress"]
pub const INACTIVE : Self = Self (0) ; # [doc = "No write/erase operation is in progress"]
pub const ACTIVE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct WdgSw (pub u8) ; impl WdgSw { # [doc = "Hardware watchdog"]
pub const HARDWARE : Self = Self (0) ; # [doc = "Software watchdog"]
pub const SOFTWARE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Errie (pub u8) ; impl Errie { # [doc = "Error interrupt generation disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Error interrupt generation enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pg (pub u8) ; impl Pg { # [doc = "Flash programming activated"]
pub const PROGRAM : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Optpg (pub u8) ; impl Optpg { # [doc = "Program option byte activated"]
pub const OPTIONBYTEPROGRAMMING : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lockr (pub u8) ; impl Lockr { # [doc = "FLASH_CR register is unlocked"]
pub const UNLOCKED : Self = Self (0) ; # [doc = "FLASH_CR register is locked"]
pub const LOCKED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct NRstStdby (pub u8) ; impl NRstStdby { # [doc = "Reset generated when entering Standby mode"]
pub const RESET : Self = Self (0) ; # [doc = "No reset generated"]
pub const NORESET : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct NRstStop (pub u8) ; impl NRstStop { # [doc = "Reset generated when entering Stop mode"]
pub const RESET : Self = Self (0) ; # [doc = "No reset generated"]
pub const NORESET : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wrprterrw (pub u8) ; impl Wrprterrw { # [doc = "Reset write protection error"]
pub const RESET : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct OblLaunch (pub u8) ; impl OblLaunch { # [doc = "Force option byte loading inactive"]
pub const INACTIVE : Self = Self (0) ; # [doc = "Force option byte loading active"]
pub const ACTIVE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Optwre (pub u8) ; impl Optwre { # [doc = "Option byte write enabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Option byte write disabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pgerrw (pub u8) ; impl Pgerrw { # [doc = "Reset programming error"]
pub const RESET : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct SramParityCheck (pub u8) ; impl SramParityCheck { # [doc = "RAM parity check disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "RAM parity check enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rdprt (pub u8) ; impl Rdprt { # [doc = "Level 0"]
pub const LEVEL0 : Self = Self (0) ; # [doc = "Level 1"]
pub const LEVEL1 : Self = Self (0x01) ; # [doc = "Level 2"]
pub const LEVEL2 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Eopie (pub u8) ; impl Eopie { # [doc = "End of operation interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "End of operation interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } } pub mod regs { # [doc = "Option byte register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Obr (pub u32) ; impl Obr { # [doc = "Option byte error"]
pub const fn opterr (& self) -> super :: vals :: Opterr { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Opterr (val as u8) } # [doc = "Option byte error"]
pub fn set_opterr (& mut self , val : super :: vals :: Opterr) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Read protection Level status"]
pub const fn rdprt (& self) -> super :: vals :: Rdprt { let val = (self . 0 >> 1usize) & 0x03 ; super :: vals :: Rdprt (val as u8) } # [doc = "Read protection Level status"]
pub fn set_rdprt (& mut self , val : super :: vals :: Rdprt) { self . 0 = (self . 0 & ! (0x03 << 1usize)) | (((val . 0 as u32) & 0x03) << 1usize) ; } # [doc = "WDG_SW"]
pub const fn wdg_sw (& self) -> super :: vals :: WdgSw { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: WdgSw (val as u8) } # [doc = "WDG_SW"]
pub fn set_wdg_sw (& mut self , val : super :: vals :: WdgSw) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "nRST_STOP"]
pub const fn n_rst_stop (& self) -> super :: vals :: NRstStop { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: NRstStop (val as u8) } # [doc = "nRST_STOP"]
pub fn set_n_rst_stop (& mut self , val : super :: vals :: NRstStop) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "nRST_STDBY"]
pub const fn n_rst_stdby (& self) -> super :: vals :: NRstStdby { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: NRstStdby (val as u8) } # [doc = "nRST_STDBY"]
pub fn set_n_rst_stdby (& mut self , val : super :: vals :: NRstStdby) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "BOOT1"]
pub const fn n_boot1 (& self) -> super :: vals :: NBoot { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: NBoot (val as u8) } # [doc = "BOOT1"]
pub fn set_n_boot1 (& mut self , val : super :: vals :: NBoot) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } # [doc = "VDDA_MONITOR"]
pub const fn vdda_monitor (& self) -> super :: vals :: VddaMonitor { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: VddaMonitor (val as u8) } # [doc = "VDDA_MONITOR"]
pub fn set_vdda_monitor (& mut self , val : super :: vals :: VddaMonitor) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } # [doc = "SRAM_PARITY_CHECK"]
pub const fn sram_parity_check (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "SRAM_PARITY_CHECK"]
pub fn set_sram_parity_check (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "SDADC12_VDD_MONITOR"]
pub const fn sdadc12_vdd_monitor (& self) -> super :: vals :: SdadcVddMonitor { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: SdadcVddMonitor (val as u8) } # [doc = "SDADC12_VDD_MONITOR"]
pub fn set_sdadc12_vdd_monitor (& mut self , val : super :: vals :: SdadcVddMonitor) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } # [doc = "Data0"]
pub const fn data0 (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Data0"]
pub fn set_data0 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } # [doc = "Data1"]
pub const fn data1 (& self) -> u8 { let val = (self . 0 >> 24usize) & 0xff ; val as u8 } # [doc = "Data1"]
pub fn set_data1 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 24usize)) | (((val as u32) & 0xff) << 24usize) ; } } impl Default for Obr { fn default () -> Obr { Obr (0) } } # [doc = "Flash address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ar (pub u32) ; impl Ar { # [doc = "Flash address"]
pub const fn far (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Flash address"]
pub fn set_far (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Ar { fn default () -> Ar { Ar (0) } } # [doc = "Flash access control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Acr (pub u32) ; impl Acr { # [doc = "LATENCY"]
pub const fn latency (& self) -> super :: vals :: Latency { let val = (self . 0 >> 0usize) & 0x07 ; super :: vals :: Latency (val as u8) } # [doc = "LATENCY"]
pub fn set_latency (& mut self , val : super :: vals :: Latency) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val . 0 as u32) & 0x07) << 0usize) ; } # [doc = "Flash half cycle access enable"]
pub const fn hlfcya (& self) -> super :: vals :: Hlfcya { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Hlfcya (val as u8) } # [doc = "Flash half cycle access enable"]
pub fn set_hlfcya (& mut self , val : super :: vals :: Hlfcya) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "PRFTBE"]
pub const fn prftbe (& self) -> super :: vals :: Prftbe { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Prftbe (val as u8) } # [doc = "PRFTBE"]
pub fn set_prftbe (& mut self , val : super :: vals :: Prftbe) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "PRFTBS"]
pub const fn prftbs (& self) -> super :: vals :: Prftbs { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Prftbs (val as u8) } # [doc = "PRFTBS"]
pub fn set_prftbs (& mut self , val : super :: vals :: Prftbs) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } } impl Default for Acr { fn default () -> Acr { Acr (0) } } # [doc = "Flash status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr (pub u32) ; impl Sr { # [doc = "Busy"]
pub const fn bsy (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Busy"]
pub fn set_bsy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Programming error"]
pub const fn pgerr (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Programming error"]
pub fn set_pgerr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Write protection error"]
pub const fn wrprterr (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Write protection error"]
pub fn set_wrprterr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "End of operation"]
pub const fn eop (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "End of operation"]
pub fn set_eop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } } impl Default for Sr { fn default () -> Sr { Sr (0) } } # [doc = "Flash key register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Keyr (pub u32) ; impl Keyr { # [doc = "Flash Key"]
pub const fn fkeyr (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Flash Key"]
pub fn set_fkeyr (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Keyr { fn default () -> Keyr { Keyr (0) } } # [doc = "Flash option key register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Optkeyr (pub u32) ; impl Optkeyr { # [doc = "Option byte key"]
pub const fn optkeyr (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Option byte key"]
pub fn set_optkeyr (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Optkeyr { fn default () -> Optkeyr { Optkeyr (0) } } # [doc = "Flash control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Programming"]
pub const fn pg (& self) -> super :: vals :: Pg { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Pg (val as u8) } # [doc = "Programming"]
pub fn set_pg (& mut self , val : super :: vals :: Pg) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Page erase"]
pub const fn per (& self) -> super :: vals :: Per { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Per (val as u8) } # [doc = "Page erase"]
pub fn set_per (& mut self , val : super :: vals :: Per) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Mass erase"]
pub const fn mer (& self) -> super :: vals :: Mer { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Mer (val as u8) } # [doc = "Mass erase"]
pub fn set_mer (& mut self , val : super :: vals :: Mer) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Option byte programming"]
pub const fn optpg (& self) -> super :: vals :: Optpg { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Optpg (val as u8) } # [doc = "Option byte programming"]
pub fn set_optpg (& mut self , val : super :: vals :: Optpg) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "Option byte erase"]
pub const fn opter (& self) -> super :: vals :: Opter { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Opter (val as u8) } # [doc = "Option byte erase"]
pub fn set_opter (& mut self , val : super :: vals :: Opter) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "Start"]
pub const fn strt (& self) -> super :: vals :: Strt { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Strt (val as u8) } # [doc = "Start"]
pub fn set_strt (& mut self , val : super :: vals :: Strt) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } # [doc = "Lock"]
pub const fn lock (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Lock"]
pub fn set_lock (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Option bytes write enable"]
pub const fn optwre (& self) -> super :: vals :: Optwre { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Optwre (val as u8) } # [doc = "Option bytes write enable"]
pub fn set_optwre (& mut self , val : super :: vals :: Optwre) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "Error interrupt enable"]
pub const fn errie (& self) -> super :: vals :: Errie { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Errie (val as u8) } # [doc = "Error interrupt enable"]
pub fn set_errie (& mut self , val : super :: vals :: Errie) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "End of operation interrupt enable"]
pub const fn eopie (& self) -> super :: vals :: Eopie { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: Eopie (val as u8) } # [doc = "End of operation interrupt enable"]
pub fn set_eopie (& mut self , val : super :: vals :: Eopie) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } # [doc = "Force option byte loading"]
pub const fn obl_launch (& self) -> super :: vals :: OblLaunch { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: OblLaunch (val as u8) } # [doc = "Force option byte loading"]
pub fn set_obl_launch (& mut self , val : super :: vals :: OblLaunch) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "Write protection register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Wrpr (pub u32) ; impl Wrpr { # [doc = "Write protect"]
pub const fn wrp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Write protect"]
pub fn set_wrp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Wrpr { fn default () -> Wrpr { Wrpr (0) } } }