

# [doc = "FLASH"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Flash (pub * mut u8) ; unsafe impl Send for Flash { } unsafe impl Sync for Flash { } impl Flash { # [doc = "Flash access control register"]
pub fn acr (self) -> crate :: common :: Reg < regs :: Acr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Flash key register"]
pub fn keyr (self) -> crate :: common :: Reg < regs :: Keyr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Flash option key register"]
pub fn optkeyr (self) -> crate :: common :: Reg < regs :: Optkeyr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Flash address register"]
pub fn ar (self) -> crate :: common :: Reg < regs :: Ar , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "Option byte register"]
pub fn obr (self) -> crate :: common :: Reg < regs :: Obr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "Write protection register"]
pub fn wrpr (self) -> crate :: common :: Reg < regs :: Wrpr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } } pub mod regs { # [doc = "Flash address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ar (pub u32) ; impl Ar { # [doc = "Flash Address"]
pub const fn far (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Flash Address"]
pub fn set_far (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Ar { fn default () -> Ar { Ar (0) } } # [doc = "Flash option key register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Optkeyr (pub u32) ; impl Optkeyr { # [doc = "Option byte key"]
pub const fn optkey (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Option byte key"]
pub fn set_optkey (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Optkeyr { fn default () -> Optkeyr { Optkeyr (0) } } # [doc = "Flash access control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Acr (pub u32) ; impl Acr { # [doc = "Latency"]
pub const fn latency (& self) -> super :: vals :: Latency { let val = (self . 0 >> 0usize) & 0x07 ; super :: vals :: Latency (val as u8) } # [doc = "Latency"]
pub fn set_latency (& mut self , val : super :: vals :: Latency) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val . 0 as u32) & 0x07) << 0usize) ; } # [doc = "Flash half cycle access enable"]
pub const fn hlfcya (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Flash half cycle access enable"]
pub fn set_hlfcya (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Prefetch buffer enable"]
pub const fn prftbe (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Prefetch buffer enable"]
pub fn set_prftbe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Prefetch buffer status"]
pub const fn prftbs (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Prefetch buffer status"]
pub fn set_prftbs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } } impl Default for Acr { fn default () -> Acr { Acr (0) } } # [doc = "Write protection register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Wrpr (pub u32) ; impl Wrpr { # [doc = "Write protect"]
pub const fn wrp (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Write protect"]
pub fn set_wrp (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Wrpr { fn default () -> Wrpr { Wrpr (0) } } # [doc = "Status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr (pub u32) ; impl Sr { # [doc = "Busy"]
pub const fn bsy (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Busy"]
pub fn set_bsy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Programming error"]
pub const fn pgerr (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Programming error"]
pub fn set_pgerr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Write protection error"]
pub const fn wrprterr (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Write protection error"]
pub fn set_wrprterr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "End of operation"]
pub const fn eop (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "End of operation"]
pub fn set_eop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } } impl Default for Sr { fn default () -> Sr { Sr (0) } } # [doc = "Option byte register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Obr (pub u32) ; impl Obr { # [doc = "Option byte error"]
pub const fn opterr (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Option byte error"]
pub fn set_opterr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Read protection"]
pub const fn rdprt (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Read protection"]
pub fn set_rdprt (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "WDG_SW"]
pub const fn wdg_sw (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "WDG_SW"]
pub fn set_wdg_sw (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "nRST_STOP"]
pub const fn n_rst_stop (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "nRST_STOP"]
pub fn set_n_rst_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "nRST_STDBY"]
pub const fn n_rst_stdby (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "nRST_STDBY"]
pub fn set_n_rst_stdby (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Data0"]
pub const fn data0 (& self) -> u8 { let val = (self . 0 >> 10usize) & 0xff ; val as u8 } # [doc = "Data0"]
pub fn set_data0 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 10usize)) | (((val as u32) & 0xff) << 10usize) ; } # [doc = "Data1"]
pub const fn data1 (& self) -> u8 { let val = (self . 0 >> 18usize) & 0xff ; val as u8 } # [doc = "Data1"]
pub fn set_data1 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 18usize)) | (((val as u32) & 0xff) << 18usize) ; } } impl Default for Obr { fn default () -> Obr { Obr (0) } } # [doc = "Control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Programming"]
pub const fn pg (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Programming"]
pub fn set_pg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Page Erase"]
pub const fn per (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Page Erase"]
pub fn set_per (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Mass Erase"]
pub const fn mer (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Mass Erase"]
pub fn set_mer (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Option byte programming"]
pub const fn optpg (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Option byte programming"]
pub fn set_optpg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Option byte erase"]
pub const fn opter (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Option byte erase"]
pub fn set_opter (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Start"]
pub const fn strt (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Start"]
pub fn set_strt (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Lock"]
pub const fn lock (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Lock"]
pub fn set_lock (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Option bytes write enable"]
pub const fn optwre (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Option bytes write enable"]
pub fn set_optwre (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Error interrupt enable"]
pub const fn errie (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Error interrupt enable"]
pub fn set_errie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "End of operation interrupt enable"]
pub const fn eopie (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "End of operation interrupt enable"]
pub fn set_eopie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "Flash key register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Keyr (pub u32) ; impl Keyr { # [doc = "FPEC key"]
pub const fn key (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "FPEC key"]
pub fn set_key (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Keyr { fn default () -> Keyr { Keyr (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Latency (pub u8) ; impl Latency { # [doc = "Zero wait state, if 0 < SYSCLK≤ 24 MHz"]
pub const WS0 : Self = Self (0) ; # [doc = "One wait state, if 24 MHz < SYSCLK ≤ 48 MHz"]
pub const WS1 : Self = Self (0x01) ; # [doc = "Two wait states, if 48 MHz < SYSCLK ≤ 72 MHz"]
pub const WS2 : Self = Self (0x02) ; } }