

# [doc = "CPU-specific registers"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cpu (pub * mut u8) ; unsafe impl Send for Cpu { } unsafe impl Sync for Cpu { } impl Cpu { # [doc = "CPU x interrupt mask register"]
pub fn imr (self , n : usize) -> crate :: common :: Reg < regs :: Lines , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize + n * 16usize)) } } # [doc = "CPU x event mask register"]
pub fn emr (self , n : usize) -> crate :: common :: Reg < regs :: Lines , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize + n * 16usize)) } } } # [doc = "External interrupt/event controller"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Exti (pub * mut u8) ; unsafe impl Send for Exti { } unsafe impl Sync for Exti { } impl Exti { # [doc = "rising trigger selection register"]
pub fn rtsr (self , n : usize) -> crate :: common :: Reg < regs :: Lines , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize + n * 32usize)) } } # [doc = "falling trigger selection register"]
pub fn ftsr (self , n : usize) -> crate :: common :: Reg < regs :: Lines , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize + n * 32usize)) } } # [doc = "software interrupt event register"]
pub fn swier (self , n : usize) -> crate :: common :: Reg < regs :: Lines , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize + n * 32usize)) } } # [doc = "EXTI pending register"]
pub fn pr (self , n : usize) -> crate :: common :: Reg < regs :: Lines , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize + n * 32usize)) } } # [doc = "CPU specific registers"]
pub fn cpu (self , n : usize) -> Cpu { assert ! (n < 2usize) ; unsafe { Cpu (self . 0 . add (128usize + n * 64usize)) } } } pub mod regs { # [doc = "EXTI lines register, 1 bit per line"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Lines (pub u32) ; impl Lines { # [doc = "EXTI line"]
pub fn line (& self , n : usize) -> bool { assert ! (n < 32usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "EXTI line"]
pub fn set_line (& mut self , n : usize , val : bool) { assert ! (n < 32usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Lines { fn default () -> Lines { Lines (0) } } }