

# [doc = "External interrupt/event controller"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Exti (pub * mut u8) ; unsafe impl Send for Exti { } unsafe impl Sync for Exti { } impl Exti { # [doc = "Rising Trigger selection register"]
pub fn rtsr (self , n : usize) -> crate :: common :: Reg < regs :: Lines , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize + n * 32usize)) } } # [doc = "Falling Trigger selection register"]
pub fn ftsr (self , n : usize) -> crate :: common :: Reg < regs :: Lines , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize + n * 32usize)) } } # [doc = "Software interrupt event register"]
pub fn swier (self , n : usize) -> crate :: common :: Reg < regs :: Lines , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize + n * 32usize)) } } # [doc = "Rising pending register"]
pub fn rpr (self , n : usize) -> crate :: common :: Reg < regs :: Lines , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize + n * 32usize)) } } # [doc = "Falling pending register"]
pub fn fpr (self , n : usize) -> crate :: common :: Reg < regs :: Lines , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize + n * 32usize)) } } # [doc = "Security configuration register"]
pub fn seccfgr (self , n : usize) -> crate :: common :: Reg < regs :: Seccfgr , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize + n * 36usize)) } } # [doc = "Privilege configuration register"]
pub fn privcfgr (self , n : usize) -> crate :: common :: Reg < regs :: Privcfgr , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize + n * 28usize)) } } # [doc = "Configuration register"]
pub fn exticr (self , n : usize) -> crate :: common :: Reg < regs :: Exticr , crate :: common :: RW > { assert ! (n < 4usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (96usize + n * 4usize)) } } # [doc = "EXTI lock register"]
pub fn lockrg (self) -> crate :: common :: Reg < regs :: Lockrg , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (112usize)) } } # [doc = "Interrupt mask register"]
pub fn imr (self , n : usize) -> crate :: common :: Reg < regs :: Lines , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (128usize + n * 16usize)) } } # [doc = "Event mask register"]
pub fn emr (self , n : usize) -> crate :: common :: Reg < regs :: Lines , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (132usize + n * 16usize)) } } } pub mod regs { # [doc = "Privilege configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Privcfgr (pub u32) ; impl Privcfgr { # [doc = "Security enable on event input x"]
pub fn priv_ (& self , n : usize) -> bool { assert ! (n < 32usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Security enable on event input x"]
pub fn set_priv_ (& mut self , n : usize , val : bool) { assert ! (n < 32usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Privcfgr { fn default () -> Privcfgr { Privcfgr (0) } } # [doc = "external interrupt configuration register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Exticr (pub u32) ; impl Exticr { # [doc = "EXTI configuration bits"]
pub fn exti (& self , n : usize) -> u8 { assert ! (n < 4usize) ; let offs = 0usize + n * 8usize ; let val = (self . 0 >> offs) & 0xff ; val as u8 } # [doc = "EXTI configuration bits"]
pub fn set_exti (& mut self , n : usize , val : u8) { assert ! (n < 4usize) ; let offs = 0usize + n * 8usize ; self . 0 = (self . 0 & ! (0xff << offs)) | (((val as u32) & 0xff) << offs) ; } } impl Default for Exticr { fn default () -> Exticr { Exticr (0) } } # [doc = "EXTI lock register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Lockrg (pub u32) ; impl Lockrg { # [doc = "LOCK"]
pub const fn lock (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LOCK"]
pub fn set_lock (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } } impl Default for Lockrg { fn default () -> Lockrg { Lockrg (0) } } # [doc = "Security configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Seccfgr (pub u32) ; impl Seccfgr { # [doc = "Security enable on event input x"]
pub fn sec (& self , n : usize) -> bool { assert ! (n < 32usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Security enable on event input x"]
pub fn set_sec (& mut self , n : usize , val : bool) { assert ! (n < 32usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Seccfgr { fn default () -> Seccfgr { Seccfgr (0) } } # [doc = "EXTI lines register, 1 bit per line"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Lines (pub u32) ; impl Lines { # [doc = "EXTI line"]
pub fn line (& self , n : usize) -> bool { assert ! (n < 32usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "EXTI line"]
pub fn set_line (& mut self , n : usize , val : bool) { assert ! (n < 32usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Lines { fn default () -> Lines { Lines (0) } } }