

# [doc = "Ethernet Peripheral"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Eth (pub * mut u8) ; unsafe impl Send for Eth { } unsafe impl Sync for Eth { } impl Eth { # [doc = "Ethernet: media access control (MAC)"]
pub fn ethernet_mac (self) -> EthernetMac { unsafe { EthernetMac (self . 0 . add (0usize)) } } # [doc = "Ethernet: Precision Time Protocol (PTP)"]
pub fn ethernet_ptp (self) -> EthernetPtp { unsafe { EthernetPtp (self . 0 . add (1792usize)) } } # [doc = "Ethernet: DMA mode register (DMA)"]
pub fn ethernet_dma (self) -> EthernetDma { unsafe { EthernetDma (self . 0 . add (4096usize)) } } } # [doc = "Ethernet: DMA controller operation"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct EthernetDma (pub * mut u8) ; unsafe impl Send for EthernetDma { } unsafe impl Sync for EthernetDma { } impl EthernetDma { # [doc = "Ethernet DMA bus mode register"]
pub fn dmabmr (self) -> crate :: common :: Reg < regs :: Dmabmr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Ethernet DMA transmit poll demand register"]
pub fn dmatpdr (self) -> crate :: common :: Reg < regs :: Dmatpdr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "EHERNET DMA receive poll demand register"]
pub fn dmarpdr (self) -> crate :: common :: Reg < regs :: Dmarpdr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Ethernet DMA receive descriptor list address register"]
pub fn dmardlar (self) -> crate :: common :: Reg < regs :: Dmardlar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Ethernet DMA transmit descriptor list address register"]
pub fn dmatdlar (self) -> crate :: common :: Reg < regs :: Dmatdlar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Ethernet DMA status register"]
pub fn dmasr (self) -> crate :: common :: Reg < regs :: Dmasr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "Ethernet DMA operation mode register"]
pub fn dmaomr (self) -> crate :: common :: Reg < regs :: Dmaomr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "Ethernet DMA interrupt enable register"]
pub fn dmaier (self) -> crate :: common :: Reg < regs :: Dmaier , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "Ethernet DMA missed frame and buffer overflow counter register"]
pub fn dmamfbocr (self) -> crate :: common :: Reg < regs :: Dmamfbocr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "Ethernet DMA receive status watchdog timer register"]
pub fn dmarswtr (self) -> crate :: common :: Reg < regs :: Dmarswtr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "Ethernet DMA current host transmit descriptor register"]
pub fn dmachtdr (self) -> crate :: common :: Reg < regs :: Dmachtdr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "Ethernet DMA current host receive descriptor register"]
pub fn dmachrdr (self) -> crate :: common :: Reg < regs :: Dmachrdr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } # [doc = "Ethernet DMA current host transmit buffer address register"]
pub fn dmachtbar (self) -> crate :: common :: Reg < regs :: Dmachtbar , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (80usize)) } } # [doc = "Ethernet DMA current host receive buffer address register"]
pub fn dmachrbar (self) -> crate :: common :: Reg < regs :: Dmachrbar , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (84usize)) } } } # [doc = "Ethernet: media access control (MAC)"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct EthernetMac (pub * mut u8) ; unsafe impl Send for EthernetMac { } unsafe impl Sync for EthernetMac { } impl EthernetMac { # [doc = "Ethernet MAC configuration register"]
pub fn maccr (self) -> crate :: common :: Reg < regs :: Maccr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Ethernet MAC frame filter register"]
pub fn macffr (self) -> crate :: common :: Reg < regs :: Macffr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Ethernet MAC hash table high register"]
pub fn machthr (self) -> crate :: common :: Reg < regs :: Machthr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Ethernet MAC hash table low register"]
pub fn machtlr (self) -> crate :: common :: Reg < regs :: Machtlr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Ethernet MAC MII address register"]
pub fn macmiiar (self) -> crate :: common :: Reg < regs :: Macmiiar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Ethernet MAC MII data register"]
pub fn macmiidr (self) -> crate :: common :: Reg < regs :: Macmiidr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "Ethernet MAC flow control register"]
pub fn macfcr (self) -> crate :: common :: Reg < regs :: Macfcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "Ethernet MAC VLAN tag register"]
pub fn macvlantr (self) -> crate :: common :: Reg < regs :: Macvlantr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "Ethernet MAC remote wakeup frame filter register"]
pub fn macrwuffr (self) -> crate :: common :: Reg < u32 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "Ethernet MAC PMT control and status register"]
pub fn macpmtcsr (self) -> crate :: common :: Reg < regs :: Macpmtcsr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "Ethernet MAC debug register"]
pub fn macdbgr (self) -> crate :: common :: Reg < regs :: Macdbgr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize)) } } # [doc = "Ethernet MAC interrupt status register"]
pub fn macsr (self) -> crate :: common :: Reg < regs :: Macsr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } # [doc = "Ethernet MAC interrupt mask register"]
pub fn macimr (self) -> crate :: common :: Reg < regs :: Macimr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (60usize)) } } # [doc = "Ethernet MAC address 0 high register"]
pub fn maca0hr (self) -> crate :: common :: Reg < regs :: Maca0hr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (64usize)) } } # [doc = "Ethernet MAC address 0 low register"]
pub fn maca0lr (self) -> crate :: common :: Reg < regs :: Maca0lr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (68usize)) } } # [doc = "Ethernet MAC address 1 high register"]
pub fn maca1hr (self) -> crate :: common :: Reg < regs :: Maca1hr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "Ethernet MAC address1 low register"]
pub fn maca1lr (self) -> crate :: common :: Reg < regs :: Maca1lr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } # [doc = "Ethernet MAC address 2 high register"]
pub fn maca2hr (self) -> crate :: common :: Reg < regs :: Maca2hr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (80usize)) } } # [doc = "Ethernet MAC address 2 low register"]
pub fn maca2lr (self) -> crate :: common :: Reg < regs :: Maca2lr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (84usize)) } } # [doc = "Ethernet MAC address 3 high register"]
pub fn maca3hr (self) -> crate :: common :: Reg < regs :: Maca3hr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (88usize)) } } # [doc = "Ethernet MAC address 3 low register"]
pub fn maca3lr (self) -> crate :: common :: Reg < regs :: Maca3lr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (92usize)) } } # [doc = "Ethernet MMC control register"]
pub fn mmccr (self) -> crate :: common :: Reg < regs :: Mmccr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (256usize)) } } # [doc = "Ethernet MMC receive interrupt register"]
pub fn mmcrir (self) -> crate :: common :: Reg < regs :: Mmcrir , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (260usize)) } } # [doc = "Ethernet MMC transmit interrupt register"]
pub fn mmctir (self) -> crate :: common :: Reg < regs :: Mmctir , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (264usize)) } } # [doc = "Ethernet MMC receive interrupt mask register"]
pub fn mmcrimr (self) -> crate :: common :: Reg < regs :: Mmcrimr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (268usize)) } } # [doc = "Ethernet MMC transmit interrupt mask register"]
pub fn mmctimr (self) -> crate :: common :: Reg < regs :: Mmctimr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (272usize)) } } # [doc = "Ethernet MMC transmitted good frames after a single collision counter"]
pub fn mmctgfsccr (self) -> crate :: common :: Reg < regs :: Mmctgfsccr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (332usize)) } } # [doc = "Ethernet MMC transmitted good frames after more than a single collision"]
pub fn mmctgfmsccr (self) -> crate :: common :: Reg < regs :: Mmctgfmsccr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (336usize)) } } # [doc = "Ethernet MMC transmitted good frames counter register"]
pub fn mmctgfcr (self) -> crate :: common :: Reg < regs :: Mmctgfcr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (360usize)) } } # [doc = "Ethernet MMC received frames with CRC error counter register"]
pub fn mmcrfcecr (self) -> crate :: common :: Reg < regs :: Mmcrfcecr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (404usize)) } } # [doc = "Ethernet MMC received frames with alignment error counter register"]
pub fn mmcrfaecr (self) -> crate :: common :: Reg < regs :: Mmcrfaecr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (408usize)) } } # [doc = "MMC received good unicast frames counter register"]
pub fn mmcrgufcr (self) -> crate :: common :: Reg < regs :: Mmcrgufcr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (452usize)) } } } # [doc = "Ethernet: Precision time protocol"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct EthernetPtp (pub * mut u8) ; unsafe impl Send for EthernetPtp { } unsafe impl Sync for EthernetPtp { } impl EthernetPtp { # [doc = "Ethernet PTP time stamp control register"]
pub fn ptptscr (self) -> crate :: common :: Reg < regs :: Ptptscr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Ethernet PTP subsecond increment register"]
pub fn ptpssir (self) -> crate :: common :: Reg < regs :: Ptpssir , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Ethernet PTP time stamp high register"]
pub fn ptptshr (self) -> crate :: common :: Reg < regs :: Ptptshr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Ethernet PTP time stamp low register"]
pub fn ptptslr (self) -> crate :: common :: Reg < regs :: Ptptslr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "Ethernet PTP time stamp high update register"]
pub fn ptptshur (self) -> crate :: common :: Reg < regs :: Ptptshur , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "Ethernet PTP time stamp low update register"]
pub fn ptptslur (self) -> crate :: common :: Reg < regs :: Ptptslur , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "Ethernet PTP time stamp addend register"]
pub fn ptptsar (self) -> crate :: common :: Reg < regs :: Ptptsar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "Ethernet PTP target time high register"]
pub fn ptptthr (self) -> crate :: common :: Reg < regs :: Ptptthr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "Ethernet PTP target time low register"]
pub fn ptpttlr (self) -> crate :: common :: Reg < regs :: Ptpttlr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "Ethernet PTP time stamp status register"]
pub fn ptptssr (self) -> crate :: common :: Reg < regs :: Ptptssr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "Ethernet PTP PPS control register"]
pub fn ptpppscr (self) -> crate :: common :: Reg < regs :: Ptpppscr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } } pub mod regs { # [doc = "Ethernet MMC transmitted good frames after more than a single collision"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Mmctgfmsccr (pub u32) ; impl Mmctgfmsccr { # [doc = "TGFMSCC"]
pub const fn tgfmscc (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "TGFMSCC"]
pub fn set_tgfmscc (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Mmctgfmsccr { fn default () -> Mmctgfmsccr { Mmctgfmsccr (0) } } # [doc = "Ethernet PTP PPS control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ptpppscr (pub u32) ; impl Ptpppscr { # [doc = "TSSO"]
pub const fn tsso (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TSSO"]
pub fn set_tsso (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TSTTR"]
pub const fn tsttr (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TSTTR"]
pub fn set_tsttr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } } impl Default for Ptpppscr { fn default () -> Ptpppscr { Ptpppscr (0) } } # [doc = "Ethernet DMA status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dmasr (pub u32) ; impl Dmasr { # [doc = "Transmit status"]
pub const fn ts (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Transmit status"]
pub fn set_ts (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Transmit process stopped status"]
pub const fn tpss (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Transmit process stopped status"]
pub fn set_tpss (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Transmit buffer unavailable status"]
pub const fn tbus (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Transmit buffer unavailable status"]
pub fn set_tbus (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Transmit jabber timeout status"]
pub const fn tjts (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Transmit jabber timeout status"]
pub fn set_tjts (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Receive overflow status"]
pub const fn ros (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Receive overflow status"]
pub fn set_ros (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Transmit underflow status"]
pub const fn tus (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Transmit underflow status"]
pub fn set_tus (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Receive status"]
pub const fn rs (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Receive status"]
pub fn set_rs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Receive buffer unavailable status"]
pub const fn rbus (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Receive buffer unavailable status"]
pub fn set_rbus (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Receive process stopped status"]
pub const fn rpss (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Receive process stopped status"]
pub fn set_rpss (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "PWTS"]
pub const fn pwts (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "PWTS"]
pub fn set_pwts (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Early transmit status"]
pub const fn ets (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Early transmit status"]
pub fn set_ets (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Fatal bus error status"]
pub const fn fbes (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "Fatal bus error status"]
pub fn set_fbes (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Early receive status"]
pub const fn ers (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Early receive status"]
pub fn set_ers (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Abnormal interrupt summary"]
pub const fn ais (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Abnormal interrupt summary"]
pub fn set_ais (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Normal interrupt summary"]
pub const fn nis (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Normal interrupt summary"]
pub fn set_nis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Receive process state"]
pub const fn rps (& self) -> super :: vals :: Rps { let val = (self . 0 >> 17usize) & 0x07 ; super :: vals :: Rps (val as u8) } # [doc = "Receive process state"]
pub fn set_rps (& mut self , val : super :: vals :: Rps) { self . 0 = (self . 0 & ! (0x07 << 17usize)) | (((val . 0 as u32) & 0x07) << 17usize) ; } # [doc = "Transmit process state"]
pub const fn tps (& self) -> super :: vals :: Tps { let val = (self . 0 >> 20usize) & 0x07 ; super :: vals :: Tps (val as u8) } # [doc = "Transmit process state"]
pub fn set_tps (& mut self , val : super :: vals :: Tps) { self . 0 = (self . 0 & ! (0x07 << 20usize)) | (((val . 0 as u32) & 0x07) << 20usize) ; } # [doc = "Error bits status"]
pub const fn ebs (& self) -> u8 { let val = (self . 0 >> 23usize) & 0x07 ; val as u8 } # [doc = "Error bits status"]
pub fn set_ebs (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 23usize)) | (((val as u32) & 0x07) << 23usize) ; } # [doc = "MMC status"]
pub const fn mmcs (& self) -> bool { let val = (self . 0 >> 27usize) & 0x01 ; val != 0 } # [doc = "MMC status"]
pub fn set_mmcs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 27usize)) | (((val as u32) & 0x01) << 27usize) ; } # [doc = "PMT status"]
pub const fn pmts (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "PMT status"]
pub fn set_pmts (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "Time stamp trigger status"]
pub const fn tsts (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "Time stamp trigger status"]
pub fn set_tsts (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } } impl Default for Dmasr { fn default () -> Dmasr { Dmasr (0) } } # [doc = "Ethernet DMA current host receive buffer address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dmachrbar (pub u32) ; impl Dmachrbar { # [doc = "Host receive buffer address pointer"]
pub const fn hrbap (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Host receive buffer address pointer"]
pub fn set_hrbap (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Dmachrbar { fn default () -> Dmachrbar { Dmachrbar (0) } } # [doc = "Ethernet PTP time stamp low register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ptptslr (pub u32) ; impl Ptptslr { # [doc = "STSS"]
pub const fn stss (& self) -> u32 { let val = (self . 0 >> 0usize) & 0x7fff_ffff ; val as u32 } # [doc = "STSS"]
pub fn set_stss (& mut self , val : u32) { self . 0 = (self . 0 & ! (0x7fff_ffff << 0usize)) | (((val as u32) & 0x7fff_ffff) << 0usize) ; } # [doc = "STPNS"]
pub const fn stpns (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "STPNS"]
pub fn set_stpns (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Ptptslr { fn default () -> Ptptslr { Ptptslr (0) } } # [doc = "Ethernet DMA operation mode register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dmaomr (pub u32) ; impl Dmaomr { # [doc = "Start/stop receive"]
pub const fn sr (& self) -> super :: vals :: DmaomrSr { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: DmaomrSr (val as u8) } # [doc = "Start/stop receive"]
pub fn set_sr (& mut self , val : super :: vals :: DmaomrSr) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Operate on second frame"]
pub const fn osf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Operate on second frame"]
pub fn set_osf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Receive threshold control"]
pub const fn rtc (& self) -> super :: vals :: Rtc { let val = (self . 0 >> 3usize) & 0x03 ; super :: vals :: Rtc (val as u8) } # [doc = "Receive threshold control"]
pub fn set_rtc (& mut self , val : super :: vals :: Rtc) { self . 0 = (self . 0 & ! (0x03 << 3usize)) | (((val . 0 as u32) & 0x03) << 3usize) ; } # [doc = "Forward undersized good frames"]
pub const fn fugf (& self) -> super :: vals :: Fugf { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Fugf (val as u8) } # [doc = "Forward undersized good frames"]
pub fn set_fugf (& mut self , val : super :: vals :: Fugf) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } # [doc = "Forward error frames"]
pub const fn fef (& self) -> super :: vals :: Fef { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Fef (val as u8) } # [doc = "Forward error frames"]
pub fn set_fef (& mut self , val : super :: vals :: Fef) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "Start/stop transmission"]
pub const fn st (& self) -> super :: vals :: St { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: St (val as u8) } # [doc = "Start/stop transmission"]
pub fn set_st (& mut self , val : super :: vals :: St) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } # [doc = "Transmit threshold control"]
pub const fn ttc (& self) -> super :: vals :: Ttc { let val = (self . 0 >> 14usize) & 0x07 ; super :: vals :: Ttc (val as u8) } # [doc = "Transmit threshold control"]
pub fn set_ttc (& mut self , val : super :: vals :: Ttc) { self . 0 = (self . 0 & ! (0x07 << 14usize)) | (((val . 0 as u32) & 0x07) << 14usize) ; } # [doc = "Flush transmit FIFO"]
pub const fn ftf (& self) -> super :: vals :: Ftf { let val = (self . 0 >> 20usize) & 0x01 ; super :: vals :: Ftf (val as u8) } # [doc = "Flush transmit FIFO"]
pub fn set_ftf (& mut self , val : super :: vals :: Ftf) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val . 0 as u32) & 0x01) << 20usize) ; } # [doc = "Transmit store and forward"]
pub const fn tsf (& self) -> super :: vals :: Tsf { let val = (self . 0 >> 21usize) & 0x01 ; super :: vals :: Tsf (val as u8) } # [doc = "Transmit store and forward"]
pub fn set_tsf (& mut self , val : super :: vals :: Tsf) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val . 0 as u32) & 0x01) << 21usize) ; } # [doc = "Disable flushing of received frames"]
pub const fn dfrf (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Disable flushing of received frames"]
pub fn set_dfrf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Receive store and forward"]
pub const fn rsf (& self) -> super :: vals :: Rsf { let val = (self . 0 >> 25usize) & 0x01 ; super :: vals :: Rsf (val as u8) } # [doc = "Receive store and forward"]
pub fn set_rsf (& mut self , val : super :: vals :: Rsf) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val . 0 as u32) & 0x01) << 25usize) ; } # [doc = "Dropping of TCP/IP checksum error frames disable"]
pub const fn dtcefd (& self) -> super :: vals :: Dtcefd { let val = (self . 0 >> 26usize) & 0x01 ; super :: vals :: Dtcefd (val as u8) } # [doc = "Dropping of TCP/IP checksum error frames disable"]
pub fn set_dtcefd (& mut self , val : super :: vals :: Dtcefd) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val . 0 as u32) & 0x01) << 26usize) ; } } impl Default for Dmaomr { fn default () -> Dmaomr { Dmaomr (0) } } # [doc = "Ethernet PTP target time low register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ptpttlr (pub u32) ; impl Ptpttlr { # [doc = "TTSL"]
pub const fn ttsl (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "TTSL"]
pub fn set_ttsl (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Ptpttlr { fn default () -> Ptpttlr { Ptpttlr (0) } } # [doc = "Ethernet DMA receive descriptor list address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dmardlar (pub u32) ; impl Dmardlar { # [doc = "Start of receive list"]
pub const fn srl (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Start of receive list"]
pub fn set_srl (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Dmardlar { fn default () -> Dmardlar { Dmardlar (0) } } # [doc = "Ethernet DMA receive status watchdog timer register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dmarswtr (pub u32) ; impl Dmarswtr { # [doc = "Receive status watchdog timer count"]
pub const fn rswtc (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Receive status watchdog timer count"]
pub fn set_rswtc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } } impl Default for Dmarswtr { fn default () -> Dmarswtr { Dmarswtr (0) } } # [doc = "Ethernet MAC address 1 high register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Maca1hr (pub u32) ; impl Maca1hr { # [doc = "MACA1H"]
pub const fn maca1h (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "MACA1H"]
pub fn set_maca1h (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "MBC"]
pub const fn mbc (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x3f ; val as u8 } # [doc = "MBC"]
pub fn set_mbc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x3f << 24usize)) | (((val as u32) & 0x3f) << 24usize) ; } # [doc = "SA"]
pub const fn sa (& self) -> super :: vals :: MacahrSa { let val = (self . 0 >> 30usize) & 0x01 ; super :: vals :: MacahrSa (val as u8) } # [doc = "SA"]
pub fn set_sa (& mut self , val : super :: vals :: MacahrSa) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val . 0 as u32) & 0x01) << 30usize) ; } # [doc = "AE"]
pub const fn ae (& self) -> super :: vals :: MacahrAe { let val = (self . 0 >> 31usize) & 0x01 ; super :: vals :: MacahrAe (val as u8) } # [doc = "AE"]
pub fn set_ae (& mut self , val : super :: vals :: MacahrAe) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val . 0 as u32) & 0x01) << 31usize) ; } } impl Default for Maca1hr { fn default () -> Maca1hr { Maca1hr (0) } } # [doc = "Ethernet MAC frame filter register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Macffr (pub u32) ; impl Macffr { # [doc = "Promiscuous mode"]
pub const fn pm (& self) -> super :: vals :: Pm { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Pm (val as u8) } # [doc = "Promiscuous mode"]
pub fn set_pm (& mut self , val : super :: vals :: Pm) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Hash unicast"]
pub const fn hu (& self) -> super :: vals :: Hu { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Hu (val as u8) } # [doc = "Hash unicast"]
pub fn set_hu (& mut self , val : super :: vals :: Hu) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Hash multicast"]
pub const fn hm (& self) -> super :: vals :: Hm { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Hm (val as u8) } # [doc = "Hash multicast"]
pub fn set_hm (& mut self , val : super :: vals :: Hm) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Destination address unique filtering"]
pub const fn daif (& self) -> super :: vals :: Daif { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Daif (val as u8) } # [doc = "Destination address unique filtering"]
pub fn set_daif (& mut self , val : super :: vals :: Daif) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "Pass all multicast"]
pub const fn pam (& self) -> super :: vals :: Pam { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Pam (val as u8) } # [doc = "Pass all multicast"]
pub fn set_pam (& mut self , val : super :: vals :: Pam) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "Broadcast frames disable"]
pub const fn bfd (& self) -> super :: vals :: Bfd { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Bfd (val as u8) } # [doc = "Broadcast frames disable"]
pub fn set_bfd (& mut self , val : super :: vals :: Bfd) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "Pass control frames"]
pub const fn pcf (& self) -> super :: vals :: Pcf { let val = (self . 0 >> 6usize) & 0x03 ; super :: vals :: Pcf (val as u8) } # [doc = "Pass control frames"]
pub fn set_pcf (& mut self , val : super :: vals :: Pcf) { self . 0 = (self . 0 & ! (0x03 << 6usize)) | (((val . 0 as u32) & 0x03) << 6usize) ; } # [doc = "Source address inverse filtering"]
pub const fn saif (& self) -> super :: vals :: Saif { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Saif (val as u8) } # [doc = "Source address inverse filtering"]
pub fn set_saif (& mut self , val : super :: vals :: Saif) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "Source address filter"]
pub const fn saf (& self) -> super :: vals :: Saf { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Saf (val as u8) } # [doc = "Source address filter"]
pub fn set_saf (& mut self , val : super :: vals :: Saf) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "Hash or perfect filter"]
pub const fn hpf (& self) -> super :: vals :: Hpf { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Hpf (val as u8) } # [doc = "Hash or perfect filter"]
pub fn set_hpf (& mut self , val : super :: vals :: Hpf) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "Receive all"]
pub const fn ra (& self) -> super :: vals :: Ra { let val = (self . 0 >> 31usize) & 0x01 ; super :: vals :: Ra (val as u8) } # [doc = "Receive all"]
pub fn set_ra (& mut self , val : super :: vals :: Ra) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val . 0 as u32) & 0x01) << 31usize) ; } } impl Default for Macffr { fn default () -> Macffr { Macffr (0) } } # [doc = "Ethernet PTP target time high register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ptptthr (pub u32) ; impl Ptptthr { # [doc = "0"]
pub const fn ttsh (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "0"]
pub fn set_ttsh (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Ptptthr { fn default () -> Ptptthr { Ptptthr (0) } } # [doc = "Ethernet MAC address 2 high register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Maca2hr (pub u32) ; impl Maca2hr { # [doc = "MAC2AH"]
pub const fn maca2h (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "MAC2AH"]
pub fn set_maca2h (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "MBC"]
pub const fn mbc (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x3f ; val as u8 } # [doc = "MBC"]
pub fn set_mbc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x3f << 24usize)) | (((val as u32) & 0x3f) << 24usize) ; } # [doc = "SA"]
pub const fn sa (& self) -> super :: vals :: MacahrSa { let val = (self . 0 >> 30usize) & 0x01 ; super :: vals :: MacahrSa (val as u8) } # [doc = "SA"]
pub fn set_sa (& mut self , val : super :: vals :: MacahrSa) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val . 0 as u32) & 0x01) << 30usize) ; } # [doc = "AE"]
pub const fn ae (& self) -> super :: vals :: MacahrAe { let val = (self . 0 >> 31usize) & 0x01 ; super :: vals :: MacahrAe (val as u8) } # [doc = "AE"]
pub fn set_ae (& mut self , val : super :: vals :: MacahrAe) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val . 0 as u32) & 0x01) << 31usize) ; } } impl Default for Maca2hr { fn default () -> Maca2hr { Maca2hr (0) } } # [doc = "Ethernet DMA current host transmit buffer address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dmachtbar (pub u32) ; impl Dmachtbar { # [doc = "Host transmit buffer address pointer"]
pub const fn htbap (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Host transmit buffer address pointer"]
pub fn set_htbap (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Dmachtbar { fn default () -> Dmachtbar { Dmachtbar (0) } } # [doc = "Ethernet DMA bus mode register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dmabmr (pub u32) ; impl Dmabmr { # [doc = "Software reset"]
pub const fn sr (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Software reset"]
pub fn set_sr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMA arbitration"]
pub const fn da (& self) -> super :: vals :: Da { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Da (val as u8) } # [doc = "DMA arbitration"]
pub fn set_da (& mut self , val : super :: vals :: Da) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Descriptor skip length"]
pub const fn dsl (& self) -> u8 { let val = (self . 0 >> 2usize) & 0x1f ; val as u8 } # [doc = "Descriptor skip length"]
pub fn set_dsl (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 2usize)) | (((val as u32) & 0x1f) << 2usize) ; } # [doc = "Enhanced descriptor format enable"]
pub const fn edfe (& self) -> super :: vals :: Edfe { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Edfe (val as u8) } # [doc = "Enhanced descriptor format enable"]
pub fn set_edfe (& mut self , val : super :: vals :: Edfe) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "Programmable burst length"]
pub const fn pbl (& self) -> super :: vals :: Pbl { let val = (self . 0 >> 8usize) & 0x3f ; super :: vals :: Pbl (val as u8) } # [doc = "Programmable burst length"]
pub fn set_pbl (& mut self , val : super :: vals :: Pbl) { self . 0 = (self . 0 & ! (0x3f << 8usize)) | (((val . 0 as u32) & 0x3f) << 8usize) ; } # [doc = "Rx-Tx priority ratio"]
pub const fn pm (& self) -> super :: vals :: PriorityRxOverTx { let val = (self . 0 >> 14usize) & 0x03 ; super :: vals :: PriorityRxOverTx (val as u8) } # [doc = "Rx-Tx priority ratio"]
pub fn set_pm (& mut self , val : super :: vals :: PriorityRxOverTx) { self . 0 = (self . 0 & ! (0x03 << 14usize)) | (((val . 0 as u32) & 0x03) << 14usize) ; } # [doc = "Fixed burst"]
pub const fn fb (& self) -> super :: vals :: Fb { let val = (self . 0 >> 16usize) & 0x01 ; super :: vals :: Fb (val as u8) } # [doc = "Fixed burst"]
pub fn set_fb (& mut self , val : super :: vals :: Fb) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val . 0 as u32) & 0x01) << 16usize) ; } # [doc = "Rx DMA PBL"]
pub const fn rdp (& self) -> super :: vals :: Rdp { let val = (self . 0 >> 17usize) & 0x3f ; super :: vals :: Rdp (val as u8) } # [doc = "Rx DMA PBL"]
pub fn set_rdp (& mut self , val : super :: vals :: Rdp) { self . 0 = (self . 0 & ! (0x3f << 17usize)) | (((val . 0 as u32) & 0x3f) << 17usize) ; } # [doc = "Use separate PBL"]
pub const fn usp (& self) -> super :: vals :: Usp { let val = (self . 0 >> 23usize) & 0x01 ; super :: vals :: Usp (val as u8) } # [doc = "Use separate PBL"]
pub fn set_usp (& mut self , val : super :: vals :: Usp) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val . 0 as u32) & 0x01) << 23usize) ; } # [doc = "4xPBL mode"]
pub const fn fpm (& self) -> super :: vals :: Fpm { let val = (self . 0 >> 24usize) & 0x01 ; super :: vals :: Fpm (val as u8) } # [doc = "4xPBL mode"]
pub fn set_fpm (& mut self , val : super :: vals :: Fpm) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val . 0 as u32) & 0x01) << 24usize) ; } # [doc = "Address-aligned beats"]
pub const fn aab (& self) -> super :: vals :: Aab { let val = (self . 0 >> 25usize) & 0x01 ; super :: vals :: Aab (val as u8) } # [doc = "Address-aligned beats"]
pub fn set_aab (& mut self , val : super :: vals :: Aab) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val . 0 as u32) & 0x01) << 25usize) ; } # [doc = "Mixed burst"]
pub const fn mb (& self) -> super :: vals :: Mb { let val = (self . 0 >> 26usize) & 0x01 ; super :: vals :: Mb (val as u8) } # [doc = "Mixed burst"]
pub fn set_mb (& mut self , val : super :: vals :: Mb) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val . 0 as u32) & 0x01) << 26usize) ; } } impl Default for Dmabmr { fn default () -> Dmabmr { Dmabmr (0) } } # [doc = "Ethernet DMA missed frame and buffer overflow counter register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dmamfbocr (pub u32) ; impl Dmamfbocr { # [doc = "Missed frames by the controller"]
pub const fn mfc (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Missed frames by the controller"]
pub fn set_mfc (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "Overflow bit for missed frame counter"]
pub const fn omfc (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Overflow bit for missed frame counter"]
pub fn set_omfc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Missed frames by the application"]
pub const fn mfa (& self) -> u16 { let val = (self . 0 >> 17usize) & 0x07ff ; val as u16 } # [doc = "Missed frames by the application"]
pub fn set_mfa (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x07ff << 17usize)) | (((val as u32) & 0x07ff) << 17usize) ; } # [doc = "Overflow bit for FIFO overflow counter"]
pub const fn ofoc (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "Overflow bit for FIFO overflow counter"]
pub fn set_ofoc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } } impl Default for Dmamfbocr { fn default () -> Dmamfbocr { Dmamfbocr (0) } } # [doc = "Ethernet PTP time stamp high register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ptptshr (pub u32) ; impl Ptptshr { # [doc = "STS"]
pub const fn sts (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "STS"]
pub fn set_sts (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Ptptshr { fn default () -> Ptptshr { Ptptshr (0) } } # [doc = "Ethernet PTP time stamp low update register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ptptslur (pub u32) ; impl Ptptslur { # [doc = "TSUSS"]
pub const fn tsuss (& self) -> u32 { let val = (self . 0 >> 0usize) & 0x7fff_ffff ; val as u32 } # [doc = "TSUSS"]
pub fn set_tsuss (& mut self , val : u32) { self . 0 = (self . 0 & ! (0x7fff_ffff << 0usize)) | (((val as u32) & 0x7fff_ffff) << 0usize) ; } # [doc = "TSUPNS"]
pub const fn tsupns (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "TSUPNS"]
pub fn set_tsupns (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Ptptslur { fn default () -> Ptptslur { Ptptslur (0) } } # [doc = "Ethernet MMC receive interrupt register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Mmcrir (pub u32) ; impl Mmcrir { # [doc = "Received frames CRC error status"]
pub const fn rfces (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Received frames CRC error status"]
pub fn set_rfces (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Received frames alignment error status"]
pub const fn rfaes (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Received frames alignment error status"]
pub fn set_rfaes (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Received good Unicast frames status"]
pub const fn rgufs (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "Received good Unicast frames status"]
pub fn set_rgufs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } } impl Default for Mmcrir { fn default () -> Mmcrir { Mmcrir (0) } } # [doc = "Ethernet PTP time stamp status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ptptssr (pub u32) ; impl Ptptssr { # [doc = "TSSO"]
pub const fn tsso (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TSSO"]
pub fn set_tsso (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TSSO"]
pub const fn tsttr (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TSSO"]
pub fn set_tsttr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } } impl Default for Ptptssr { fn default () -> Ptptssr { Ptptssr (0) } } # [doc = "Ethernet MAC MII address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Macmiiar (pub u32) ; impl Macmiiar { # [doc = "MII busy"]
pub const fn mb (& self) -> super :: vals :: MbProgress { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: MbProgress (val as u8) } # [doc = "MII busy"]
pub fn set_mb (& mut self , val : super :: vals :: MbProgress) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "MII write"]
pub const fn mw (& self) -> super :: vals :: Mw { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Mw (val as u8) } # [doc = "MII write"]
pub fn set_mw (& mut self , val : super :: vals :: Mw) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Clock range"]
pub const fn cr (& self) -> super :: vals :: Cr { let val = (self . 0 >> 2usize) & 0x07 ; super :: vals :: Cr (val as u8) } # [doc = "Clock range"]
pub fn set_cr (& mut self , val : super :: vals :: Cr) { self . 0 = (self . 0 & ! (0x07 << 2usize)) | (((val . 0 as u32) & 0x07) << 2usize) ; } # [doc = "MII register - select the desired MII register in the PHY device"]
pub const fn mr (& self) -> u8 { let val = (self . 0 >> 6usize) & 0x1f ; val as u8 } # [doc = "MII register - select the desired MII register in the PHY device"]
pub fn set_mr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 6usize)) | (((val as u32) & 0x1f) << 6usize) ; } # [doc = "PHY address - select which of possible 32 PHYs is being accessed"]
pub const fn pa (& self) -> u8 { let val = (self . 0 >> 11usize) & 0x1f ; val as u8 } # [doc = "PHY address - select which of possible 32 PHYs is being accessed"]
pub fn set_pa (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 11usize)) | (((val as u32) & 0x1f) << 11usize) ; } } impl Default for Macmiiar { fn default () -> Macmiiar { Macmiiar (0) } } # [doc = "Ethernet PTP subsecond increment register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ptpssir (pub u32) ; impl Ptpssir { # [doc = "STSSI"]
pub const fn stssi (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "STSSI"]
pub fn set_stssi (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } } impl Default for Ptpssir { fn default () -> Ptpssir { Ptpssir (0) } } # [doc = "Ethernet MMC transmitted good frames counter register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Mmctgfcr (pub u32) ; impl Mmctgfcr { # [doc = "HTL"]
pub const fn tgfc (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "HTL"]
pub fn set_tgfc (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Mmctgfcr { fn default () -> Mmctgfcr { Mmctgfcr (0) } } # [doc = "Ethernet MAC address1 low register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Maca1lr (pub u32) ; impl Maca1lr { # [doc = "MACA1LR"]
pub const fn maca1l (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "MACA1LR"]
pub fn set_maca1l (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Maca1lr { fn default () -> Maca1lr { Maca1lr (0) } } # [doc = "Ethernet MMC receive interrupt mask register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Mmcrimr (pub u32) ; impl Mmcrimr { # [doc = "Received frame CRC error mask"]
pub const fn rfcem (& self) -> super :: vals :: Rfcem { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Rfcem (val as u8) } # [doc = "Received frame CRC error mask"]
pub fn set_rfcem (& mut self , val : super :: vals :: Rfcem) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "Received frames alignment error mask"]
pub const fn rfaem (& self) -> super :: vals :: Rfaem { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Rfaem (val as u8) } # [doc = "Received frames alignment error mask"]
pub fn set_rfaem (& mut self , val : super :: vals :: Rfaem) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } # [doc = "Received good Unicast frames mask"]
pub const fn rgufm (& self) -> super :: vals :: Rgufm { let val = (self . 0 >> 17usize) & 0x01 ; super :: vals :: Rgufm (val as u8) } # [doc = "Received good Unicast frames mask"]
pub fn set_rgufm (& mut self , val : super :: vals :: Rgufm) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val . 0 as u32) & 0x01) << 17usize) ; } } impl Default for Mmcrimr { fn default () -> Mmcrimr { Mmcrimr (0) } } # [doc = "Ethernet MAC PMT control and status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Macpmtcsr (pub u32) ; impl Macpmtcsr { # [doc = "Power down"]
pub const fn pd (& self) -> super :: vals :: Pd { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Pd (val as u8) } # [doc = "Power down"]
pub fn set_pd (& mut self , val : super :: vals :: Pd) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Magic packet enable"]
pub const fn mpe (& self) -> super :: vals :: Mpe { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Mpe (val as u8) } # [doc = "Magic packet enable"]
pub fn set_mpe (& mut self , val : super :: vals :: Mpe) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Wakeup frame enable"]
pub const fn wfe (& self) -> super :: vals :: Wfe { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Wfe (val as u8) } # [doc = "Wakeup frame enable"]
pub fn set_wfe (& mut self , val : super :: vals :: Wfe) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Magic packet received"]
pub const fn mpr (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Magic packet received"]
pub fn set_mpr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Wakeup frame received"]
pub const fn wfr (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Wakeup frame received"]
pub fn set_wfr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Global unicast"]
pub const fn gu (& self) -> super :: vals :: Gu { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Gu (val as u8) } # [doc = "Global unicast"]
pub fn set_gu (& mut self , val : super :: vals :: Gu) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "Wakeup frame filter register pointer reset"]
pub const fn wffrpr (& self) -> super :: vals :: Wffrpr { let val = (self . 0 >> 31usize) & 0x01 ; super :: vals :: Wffrpr (val as u8) } # [doc = "Wakeup frame filter register pointer reset"]
pub fn set_wffrpr (& mut self , val : super :: vals :: Wffrpr) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val . 0 as u32) & 0x01) << 31usize) ; } } impl Default for Macpmtcsr { fn default () -> Macpmtcsr { Macpmtcsr (0) } } # [doc = "Ethernet MMC received frames with CRC error counter register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Mmcrfcecr (pub u32) ; impl Mmcrfcecr { # [doc = "RFCFC"]
pub const fn rfcfc (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "RFCFC"]
pub fn set_rfcfc (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Mmcrfcecr { fn default () -> Mmcrfcecr { Mmcrfcecr (0) } } # [doc = "Ethernet MMC transmit interrupt register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Mmctir (pub u32) ; impl Mmctir { # [doc = "Transmitted good frames single collision status"]
pub const fn tgfscs (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Transmitted good frames single collision status"]
pub fn set_tgfscs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Transmitted good frames more than single collision status"]
pub const fn tgfmscs (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Transmitted good frames more than single collision status"]
pub fn set_tgfmscs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Transmitted good frames status"]
pub const fn tgfs (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Transmitted good frames status"]
pub fn set_tgfs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } } impl Default for Mmctir { fn default () -> Mmctir { Mmctir (0) } } # [doc = "Ethernet DMA current host transmit descriptor register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dmachtdr (pub u32) ; impl Dmachtdr { # [doc = "Host transmit descriptor address pointer"]
pub const fn htdap (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Host transmit descriptor address pointer"]
pub fn set_htdap (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Dmachtdr { fn default () -> Dmachtdr { Dmachtdr (0) } } # [doc = "MMC received good unicast frames counter register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Mmcrgufcr (pub u32) ; impl Mmcrgufcr { # [doc = "RGUFC"]
pub const fn rgufc (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "RGUFC"]
pub fn set_rgufc (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Mmcrgufcr { fn default () -> Mmcrgufcr { Mmcrgufcr (0) } } # [doc = "Ethernet MMC received frames with alignment error counter register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Mmcrfaecr (pub u32) ; impl Mmcrfaecr { # [doc = "RFAEC"]
pub const fn rfaec (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "RFAEC"]
pub fn set_rfaec (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Mmcrfaecr { fn default () -> Mmcrfaecr { Mmcrfaecr (0) } } # [doc = "Ethernet MAC address 0 high register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Maca0hr (pub u32) ; impl Maca0hr { # [doc = "MAC address0 high"]
pub const fn maca0h (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "MAC address0 high"]
pub fn set_maca0h (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "Always 1"]
pub const fn mo (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Always 1"]
pub fn set_mo (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Maca0hr { fn default () -> Maca0hr { Maca0hr (0) } } # [doc = "Ethernet MAC address 0 low register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Maca0lr (pub u32) ; impl Maca0lr { # [doc = "0"]
pub const fn maca0l (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "0"]
pub fn set_maca0l (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Maca0lr { fn default () -> Maca0lr { Maca0lr (0) } } # [doc = "EHERNET DMA receive poll demand register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dmarpdr (pub u32) ; impl Dmarpdr { # [doc = "Receive poll demand"]
pub const fn rpd (& self) -> super :: vals :: Rpd { let val = (self . 0 >> 0usize) & 0xffff_ffff ; super :: vals :: Rpd (val as u32) } # [doc = "Receive poll demand"]
pub fn set_rpd (& mut self , val : super :: vals :: Rpd) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val . 0 as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Dmarpdr { fn default () -> Dmarpdr { Dmarpdr (0) } } # [doc = "Ethernet DMA transmit poll demand register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dmatpdr (pub u32) ; impl Dmatpdr { # [doc = "Transmit poll demand"]
pub const fn tpd (& self) -> super :: vals :: Tpd { let val = (self . 0 >> 0usize) & 0xffff_ffff ; super :: vals :: Tpd (val as u32) } # [doc = "Transmit poll demand"]
pub fn set_tpd (& mut self , val : super :: vals :: Tpd) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val . 0 as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Dmatpdr { fn default () -> Dmatpdr { Dmatpdr (0) } } # [doc = "Ethernet PTP time stamp high update register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ptptshur (pub u32) ; impl Ptptshur { # [doc = "TSUS"]
pub const fn tsus (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "TSUS"]
pub fn set_tsus (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Ptptshur { fn default () -> Ptptshur { Ptptshur (0) } } # [doc = "Ethernet MAC hash table high register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Machthr (pub u32) ; impl Machthr { # [doc = "Upper 32 bits of hash table"]
pub const fn hth (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Upper 32 bits of hash table"]
pub fn set_hth (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Machthr { fn default () -> Machthr { Machthr (0) } } # [doc = "Ethernet MAC hash table low register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Machtlr (pub u32) ; impl Machtlr { # [doc = "Lower 32 bits of hash table"]
pub const fn htl (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Lower 32 bits of hash table"]
pub fn set_htl (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Machtlr { fn default () -> Machtlr { Machtlr (0) } } # [doc = "Ethernet DMA transmit descriptor list address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dmatdlar (pub u32) ; impl Dmatdlar { # [doc = "Start of transmit list"]
pub const fn stl (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Start of transmit list"]
pub fn set_stl (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Dmatdlar { fn default () -> Dmatdlar { Dmatdlar (0) } } # [doc = "Ethernet MAC debug register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Macdbgr (pub u32) ; impl Macdbgr { # [doc = "MAC MII receive protocol engine active"]
pub const fn mmrpea (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "MAC MII receive protocol engine active"]
pub fn set_mmrpea (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "MAC small FIFO read/write controllers status"]
pub const fn msfrwcs (& self) -> u8 { let val = (self . 0 >> 1usize) & 0x03 ; val as u8 } # [doc = "MAC small FIFO read/write controllers status"]
pub fn set_msfrwcs (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 1usize)) | (((val as u32) & 0x03) << 1usize) ; } # [doc = "Rx FIFO write controller active"]
pub const fn rfwra (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Rx FIFO write controller active"]
pub fn set_rfwra (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Rx FIFO read controller status"]
pub const fn rfrcs (& self) -> u8 { let val = (self . 0 >> 5usize) & 0x03 ; val as u8 } # [doc = "Rx FIFO read controller status"]
pub fn set_rfrcs (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 5usize)) | (((val as u32) & 0x03) << 5usize) ; } # [doc = "Rx FIFO fill level"]
pub const fn rffl (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x03 ; val as u8 } # [doc = "Rx FIFO fill level"]
pub fn set_rffl (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val as u32) & 0x03) << 8usize) ; } # [doc = "MAC MII transmit engine active"]
pub const fn mmtea (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "MAC MII transmit engine active"]
pub fn set_mmtea (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "MAC transmit frame controller status"]
pub const fn mtfcs (& self) -> u8 { let val = (self . 0 >> 17usize) & 0x03 ; val as u8 } # [doc = "MAC transmit frame controller status"]
pub fn set_mtfcs (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 17usize)) | (((val as u32) & 0x03) << 17usize) ; } # [doc = "MAC transmitter in pause"]
pub const fn mtp (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "MAC transmitter in pause"]
pub fn set_mtp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Tx FIFO read status"]
pub const fn tfrs (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x03 ; val as u8 } # [doc = "Tx FIFO read status"]
pub fn set_tfrs (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val as u32) & 0x03) << 20usize) ; } # [doc = "Tx FIFO write active"]
pub const fn tfwa (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "Tx FIFO write active"]
pub fn set_tfwa (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Tx FIFO not empty"]
pub const fn tfne (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Tx FIFO not empty"]
pub fn set_tfne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Tx FIFO full"]
pub const fn tff (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Tx FIFO full"]
pub fn set_tff (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for Macdbgr { fn default () -> Macdbgr { Macdbgr (0) } } # [doc = "Ethernet DMA current host receive descriptor register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dmachrdr (pub u32) ; impl Dmachrdr { # [doc = "Host receive descriptor address pointer"]
pub const fn hrdap (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Host receive descriptor address pointer"]
pub fn set_hrdap (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Dmachrdr { fn default () -> Dmachrdr { Dmachrdr (0) } } # [doc = "Ethernet MAC address 2 low register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Maca2lr (pub u32) ; impl Maca2lr { # [doc = "MACA2L"]
pub const fn maca2l (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "MACA2L"]
pub fn set_maca2l (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Maca2lr { fn default () -> Maca2lr { Maca2lr (0) } } # [doc = "Ethernet MAC interrupt mask register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Macimr (pub u32) ; impl Macimr { # [doc = "PMT interrupt mask"]
pub const fn pmtim (& self) -> super :: vals :: Pmtim { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Pmtim (val as u8) } # [doc = "PMT interrupt mask"]
pub fn set_pmtim (& mut self , val : super :: vals :: Pmtim) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "Time stamp trigger interrupt mask"]
pub const fn tstim (& self) -> super :: vals :: Tstim { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Tstim (val as u8) } # [doc = "Time stamp trigger interrupt mask"]
pub fn set_tstim (& mut self , val : super :: vals :: Tstim) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } } impl Default for Macimr { fn default () -> Macimr { Macimr (0) } } # [doc = "Ethernet DMA interrupt enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dmaier (pub u32) ; impl Dmaier { # [doc = "Transmit interrupt enable"]
pub const fn tie (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Transmit interrupt enable"]
pub fn set_tie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Transmit process stopped interrupt enable"]
pub const fn tpsie (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Transmit process stopped interrupt enable"]
pub fn set_tpsie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Transmit buffer unavailable interrupt enable"]
pub const fn tbuie (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Transmit buffer unavailable interrupt enable"]
pub fn set_tbuie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Transmit jabber timeout interrupt enable"]
pub const fn tjtie (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Transmit jabber timeout interrupt enable"]
pub fn set_tjtie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Receive overflow interrupt enable"]
pub const fn roie (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Receive overflow interrupt enable"]
pub fn set_roie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Transmit underflow interrupt enable"]
pub const fn tuie (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Transmit underflow interrupt enable"]
pub fn set_tuie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Receive interrupt enable"]
pub const fn rie (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Receive interrupt enable"]
pub fn set_rie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Receive buffer unavailable interrupt enable"]
pub const fn rbuie (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Receive buffer unavailable interrupt enable"]
pub fn set_rbuie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Receive process stopped interrupt enable"]
pub const fn rpsie (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Receive process stopped interrupt enable"]
pub fn set_rpsie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Receive watchdog timeout interrupt enable"]
pub const fn rwtie (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Receive watchdog timeout interrupt enable"]
pub fn set_rwtie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Early transmit interrupt enable"]
pub const fn etie (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Early transmit interrupt enable"]
pub fn set_etie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Fatal bus error interrupt enable"]
pub const fn fbeie (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "Fatal bus error interrupt enable"]
pub fn set_fbeie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Early receive interrupt enable"]
pub const fn erie (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "Early receive interrupt enable"]
pub fn set_erie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "Abnormal interrupt summary enable"]
pub const fn aise (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Abnormal interrupt summary enable"]
pub fn set_aise (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Normal interrupt summary enable"]
pub const fn nise (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Normal interrupt summary enable"]
pub fn set_nise (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Dmaier { fn default () -> Dmaier { Dmaier (0) } } # [doc = "Ethernet MAC interrupt status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Macsr (pub u32) ; impl Macsr { # [doc = "PMT status"]
pub const fn pmts (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "PMT status"]
pub fn set_pmts (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "MMC status"]
pub const fn mmcs (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "MMC status"]
pub fn set_mmcs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "MMC receive status"]
pub const fn mmcrs (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "MMC receive status"]
pub fn set_mmcrs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "MMC transmit status"]
pub const fn mmcts (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "MMC transmit status"]
pub fn set_mmcts (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Time stamp trigger status"]
pub const fn tsts (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Time stamp trigger status"]
pub fn set_tsts (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } } impl Default for Macsr { fn default () -> Macsr { Macsr (0) } } # [doc = "Ethernet PTP time stamp addend register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ptptsar (pub u32) ; impl Ptptsar { # [doc = "TSA"]
pub const fn tsa (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "TSA"]
pub fn set_tsa (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Ptptsar { fn default () -> Ptptsar { Ptptsar (0) } } # [doc = "Ethernet MAC address 3 low register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Maca3lr (pub u32) ; impl Maca3lr { # [doc = "MBCA3L"]
pub const fn maca3l (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "MBCA3L"]
pub fn set_maca3l (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Maca3lr { fn default () -> Maca3lr { Maca3lr (0) } } # [doc = "Ethernet MAC configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Maccr (pub u32) ; impl Maccr { # [doc = "Receiver enable"]
pub const fn re (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Receiver enable"]
pub fn set_re (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Transmitter enable"]
pub const fn te (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Transmitter enable"]
pub fn set_te (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Deferral check"]
pub const fn dc (& self) -> super :: vals :: Dc { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Dc (val as u8) } # [doc = "Deferral check"]
pub fn set_dc (& mut self , val : super :: vals :: Dc) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "Back-off limit"]
pub const fn bl (& self) -> super :: vals :: Bl { let val = (self . 0 >> 5usize) & 0x03 ; super :: vals :: Bl (val as u8) } # [doc = "Back-off limit"]
pub fn set_bl (& mut self , val : super :: vals :: Bl) { self . 0 = (self . 0 & ! (0x03 << 5usize)) | (((val . 0 as u32) & 0x03) << 5usize) ; } # [doc = "Automatic pad/CRC stripping"]
pub const fn apcs (& self) -> super :: vals :: Apcs { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Apcs (val as u8) } # [doc = "Automatic pad/CRC stripping"]
pub fn set_apcs (& mut self , val : super :: vals :: Apcs) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "Retry disable"]
pub const fn rd (& self) -> super :: vals :: Rd { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Rd (val as u8) } # [doc = "Retry disable"]
pub fn set_rd (& mut self , val : super :: vals :: Rd) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "IPv4 checksum offload"]
pub const fn ipco (& self) -> super :: vals :: Ipco { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Ipco (val as u8) } # [doc = "IPv4 checksum offload"]
pub fn set_ipco (& mut self , val : super :: vals :: Ipco) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "Duplex mode"]
pub const fn dm (& self) -> super :: vals :: Dm { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Dm (val as u8) } # [doc = "Duplex mode"]
pub fn set_dm (& mut self , val : super :: vals :: Dm) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "Loopback mode"]
pub const fn lm (& self) -> super :: vals :: Lm { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: Lm (val as u8) } # [doc = "Loopback mode"]
pub fn set_lm (& mut self , val : super :: vals :: Lm) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } # [doc = "Receive own disable"]
pub const fn rod (& self) -> super :: vals :: Rod { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: Rod (val as u8) } # [doc = "Receive own disable"]
pub fn set_rod (& mut self , val : super :: vals :: Rod) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } # [doc = "Fast Ethernet speed"]
pub const fn fes (& self) -> super :: vals :: Fes { let val = (self . 0 >> 14usize) & 0x01 ; super :: vals :: Fes (val as u8) } # [doc = "Fast Ethernet speed"]
pub fn set_fes (& mut self , val : super :: vals :: Fes) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val . 0 as u32) & 0x01) << 14usize) ; } # [doc = "Carrier sense disable"]
pub const fn csd (& self) -> super :: vals :: Csd { let val = (self . 0 >> 16usize) & 0x01 ; super :: vals :: Csd (val as u8) } # [doc = "Carrier sense disable"]
pub fn set_csd (& mut self , val : super :: vals :: Csd) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val . 0 as u32) & 0x01) << 16usize) ; } # [doc = "Interframe gap"]
pub const fn ifg (& self) -> super :: vals :: Ifg { let val = (self . 0 >> 17usize) & 0x07 ; super :: vals :: Ifg (val as u8) } # [doc = "Interframe gap"]
pub fn set_ifg (& mut self , val : super :: vals :: Ifg) { self . 0 = (self . 0 & ! (0x07 << 17usize)) | (((val . 0 as u32) & 0x07) << 17usize) ; } # [doc = "Jabber disable"]
pub const fn jd (& self) -> super :: vals :: Jd { let val = (self . 0 >> 22usize) & 0x01 ; super :: vals :: Jd (val as u8) } # [doc = "Jabber disable"]
pub fn set_jd (& mut self , val : super :: vals :: Jd) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val . 0 as u32) & 0x01) << 22usize) ; } # [doc = "Watchdog disable"]
pub const fn wd (& self) -> super :: vals :: Wd { let val = (self . 0 >> 23usize) & 0x01 ; super :: vals :: Wd (val as u8) } # [doc = "Watchdog disable"]
pub fn set_wd (& mut self , val : super :: vals :: Wd) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val . 0 as u32) & 0x01) << 23usize) ; } # [doc = "CRC stripping for type frames"]
pub const fn cstf (& self) -> super :: vals :: Cstf { let val = (self . 0 >> 25usize) & 0x01 ; super :: vals :: Cstf (val as u8) } # [doc = "CRC stripping for type frames"]
pub fn set_cstf (& mut self , val : super :: vals :: Cstf) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val . 0 as u32) & 0x01) << 25usize) ; } } impl Default for Maccr { fn default () -> Maccr { Maccr (0) } } # [doc = "Ethernet PTP time stamp control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ptptscr (pub u32) ; impl Ptptscr { # [doc = "TSE"]
pub const fn tse (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TSE"]
pub fn set_tse (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TSFCU"]
pub const fn tsfcu (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TSFCU"]
pub fn set_tsfcu (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TSSTI"]
pub const fn tssti (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TSSTI"]
pub fn set_tssti (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TSSTU"]
pub const fn tsstu (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "TSSTU"]
pub fn set_tsstu (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "TSITE"]
pub const fn tsite (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TSITE"]
pub fn set_tsite (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TTSARU"]
pub const fn ttsaru (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TTSARU"]
pub fn set_ttsaru (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "TSSARFE"]
pub const fn tssarfe (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "TSSARFE"]
pub fn set_tssarfe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "TSSSR"]
pub const fn tsssr (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "TSSSR"]
pub fn set_tsssr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "TSPTPPSV2E"]
pub const fn tsptppsv2e (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "TSPTPPSV2E"]
pub fn set_tsptppsv2e (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "TSSPTPOEFE"]
pub const fn tssptpoefe (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TSSPTPOEFE"]
pub fn set_tssptpoefe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "TSSIPV6FE"]
pub const fn tssipv6fe (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "TSSIPV6FE"]
pub fn set_tssipv6fe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "TSSIPV4FE"]
pub const fn tssipv4fe (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "TSSIPV4FE"]
pub fn set_tssipv4fe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "TSSEME"]
pub const fn tsseme (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "TSSEME"]
pub fn set_tsseme (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "TSSMRME"]
pub const fn tssmrme (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "TSSMRME"]
pub fn set_tssmrme (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "TSCNT"]
pub const fn tscnt (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x03 ; val as u8 } # [doc = "TSCNT"]
pub fn set_tscnt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val as u32) & 0x03) << 16usize) ; } # [doc = "TSPFFMAE"]
pub const fn tspffmae (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TSPFFMAE"]
pub fn set_tspffmae (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } } impl Default for Ptptscr { fn default () -> Ptptscr { Ptptscr (0) } } # [doc = "Ethernet MMC transmit interrupt mask register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Mmctimr (pub u32) ; impl Mmctimr { # [doc = "Transmitted good frames single collision mask"]
pub const fn tgfscm (& self) -> super :: vals :: Tgfscm { let val = (self . 0 >> 14usize) & 0x01 ; super :: vals :: Tgfscm (val as u8) } # [doc = "Transmitted good frames single collision mask"]
pub fn set_tgfscm (& mut self , val : super :: vals :: Tgfscm) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val . 0 as u32) & 0x01) << 14usize) ; } # [doc = "Transmitted good frames more than single collision mask"]
pub const fn tgfmscm (& self) -> super :: vals :: Tgfmscm { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Tgfmscm (val as u8) } # [doc = "Transmitted good frames more than single collision mask"]
pub fn set_tgfmscm (& mut self , val : super :: vals :: Tgfmscm) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } # [doc = "Transmitted good frames mask"]
pub const fn tgfm (& self) -> super :: vals :: Tgfm { let val = (self . 0 >> 16usize) & 0x01 ; super :: vals :: Tgfm (val as u8) } # [doc = "Transmitted good frames mask"]
pub fn set_tgfm (& mut self , val : super :: vals :: Tgfm) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val . 0 as u32) & 0x01) << 16usize) ; } } impl Default for Mmctimr { fn default () -> Mmctimr { Mmctimr (0) } } # [doc = "Ethernet MMC control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Mmccr (pub u32) ; impl Mmccr { # [doc = "Counter reset"]
pub const fn cr (& self) -> super :: vals :: CounterReset { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: CounterReset (val as u8) } # [doc = "Counter reset"]
pub fn set_cr (& mut self , val : super :: vals :: CounterReset) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Counter stop rollover"]
pub const fn csr (& self) -> super :: vals :: Csr { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Csr (val as u8) } # [doc = "Counter stop rollover"]
pub fn set_csr (& mut self , val : super :: vals :: Csr) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Reset on read"]
pub const fn ror (& self) -> super :: vals :: Ror { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Ror (val as u8) } # [doc = "Reset on read"]
pub fn set_ror (& mut self , val : super :: vals :: Ror) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "MMC counter freeze"]
pub const fn mcf (& self) -> super :: vals :: Mcf { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Mcf (val as u8) } # [doc = "MMC counter freeze"]
pub fn set_mcf (& mut self , val : super :: vals :: Mcf) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "MMC counter preset"]
pub const fn mcp (& self) -> super :: vals :: Mcp { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Mcp (val as u8) } # [doc = "MMC counter preset"]
pub fn set_mcp (& mut self , val : super :: vals :: Mcp) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "MMC counter Full-Half preset"]
pub const fn mcfhp (& self) -> super :: vals :: Mcfhp { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Mcfhp (val as u8) } # [doc = "MMC counter Full-Half preset"]
pub fn set_mcfhp (& mut self , val : super :: vals :: Mcfhp) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } } impl Default for Mmccr { fn default () -> Mmccr { Mmccr (0) } } # [doc = "Ethernet MAC MII data register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Macmiidr (pub u32) ; impl Macmiidr { # [doc = "MII data read from/written to the PHY"]
pub const fn md (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "MII data read from/written to the PHY"]
pub fn set_md (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Macmiidr { fn default () -> Macmiidr { Macmiidr (0) } } # [doc = "Ethernet MAC flow control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Macfcr (pub u32) ; impl Macfcr { # [doc = "Flow control busy/back pressure activate"]
pub const fn fcb (& self) -> super :: vals :: Fcb { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Fcb (val as u8) } # [doc = "Flow control busy/back pressure activate"]
pub fn set_fcb (& mut self , val : super :: vals :: Fcb) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Transmit flow control enable"]
pub const fn tfce (& self) -> super :: vals :: Tfce { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Tfce (val as u8) } # [doc = "Transmit flow control enable"]
pub fn set_tfce (& mut self , val : super :: vals :: Tfce) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Receive flow control enable"]
pub const fn rfce (& self) -> super :: vals :: Rfce { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Rfce (val as u8) } # [doc = "Receive flow control enable"]
pub fn set_rfce (& mut self , val : super :: vals :: Rfce) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Unicast pause frame detect"]
pub const fn upfd (& self) -> super :: vals :: Upfd { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Upfd (val as u8) } # [doc = "Unicast pause frame detect"]
pub fn set_upfd (& mut self , val : super :: vals :: Upfd) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "Pause low threshold"]
pub const fn plt (& self) -> super :: vals :: Plt { let val = (self . 0 >> 4usize) & 0x03 ; super :: vals :: Plt (val as u8) } # [doc = "Pause low threshold"]
pub fn set_plt (& mut self , val : super :: vals :: Plt) { self . 0 = (self . 0 & ! (0x03 << 4usize)) | (((val . 0 as u32) & 0x03) << 4usize) ; } # [doc = "Zero-quanta pause disable"]
pub const fn zqpd (& self) -> super :: vals :: Zqpd { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Zqpd (val as u8) } # [doc = "Zero-quanta pause disable"]
pub fn set_zqpd (& mut self , val : super :: vals :: Zqpd) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "Pause time"]
pub const fn pt (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Pause time"]
pub fn set_pt (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for Macfcr { fn default () -> Macfcr { Macfcr (0) } } # [doc = "Ethernet MMC transmitted good frames after a single collision counter"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Mmctgfsccr (pub u32) ; impl Mmctgfsccr { # [doc = "Transmitted good frames single collision counter"]
pub const fn tgfscc (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Transmitted good frames single collision counter"]
pub fn set_tgfscc (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Mmctgfsccr { fn default () -> Mmctgfsccr { Mmctgfsccr (0) } } # [doc = "Ethernet MAC VLAN tag register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Macvlantr (pub u32) ; impl Macvlantr { # [doc = "VLAN tag identifier (for receive frames)"]
pub const fn vlanti (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "VLAN tag identifier (for receive frames)"]
pub fn set_vlanti (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "12-bit VLAN tag comparison"]
pub const fn vlantc (& self) -> super :: vals :: Vlantc { let val = (self . 0 >> 16usize) & 0x01 ; super :: vals :: Vlantc (val as u8) } # [doc = "12-bit VLAN tag comparison"]
pub fn set_vlantc (& mut self , val : super :: vals :: Vlantc) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val . 0 as u32) & 0x01) << 16usize) ; } } impl Default for Macvlantr { fn default () -> Macvlantr { Macvlantr (0) } } # [doc = "Ethernet MAC address 3 high register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Maca3hr (pub u32) ; impl Maca3hr { # [doc = "MACA3H"]
pub const fn maca3h (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "MACA3H"]
pub fn set_maca3h (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "MBC"]
pub const fn mbc (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x3f ; val as u8 } # [doc = "MBC"]
pub fn set_mbc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x3f << 24usize)) | (((val as u32) & 0x3f) << 24usize) ; } # [doc = "SA"]
pub const fn sa (& self) -> super :: vals :: MacahrSa { let val = (self . 0 >> 30usize) & 0x01 ; super :: vals :: MacahrSa (val as u8) } # [doc = "SA"]
pub fn set_sa (& mut self , val : super :: vals :: MacahrSa) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val . 0 as u32) & 0x01) << 30usize) ; } # [doc = "AE"]
pub const fn ae (& self) -> super :: vals :: MacahrAe { let val = (self . 0 >> 31usize) & 0x01 ; super :: vals :: MacahrAe (val as u8) } # [doc = "AE"]
pub fn set_ae (& mut self , val : super :: vals :: MacahrAe) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val . 0 as u32) & 0x01) << 31usize) ; } } impl Default for Maca3hr { fn default () -> Maca3hr { Maca3hr (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct MacahrSa (pub u8) ; impl MacahrSa { # [doc = "This address is used for comparison with DA fields of the received frame"]
pub const DESTINATION : Self = Self (0) ; # [doc = "This address is used for comparison with SA fields of received frames"]
pub const SOURCE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mcfhp (pub u8) ; impl Mcfhp { # [doc = "When MCP is set, MMC counters are preset to almost-half value 0x7FFF_FFF0"]
pub const ALMOSTHALF : Self = Self (0) ; # [doc = "When MCP is set, MMC counters are preset to almost-full value 0xFFFF_FFF0"]
pub const ALMOSTFULL : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lm (pub u8) ; impl Lm { # [doc = "Normal mode"]
pub const NORMAL : Self = Self (0) ; # [doc = "MAC operates in loopback mode at the MII"]
pub const LOOPBACK : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mw (pub u8) ; impl Mw { # [doc = "Read operation"]
pub const READ : Self = Self (0) ; # [doc = "Write operation"]
pub const WRITE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mcp (pub u8) ; impl Mcp { # [doc = "MMC counters will be preset to almost full or almost half. Cleared automatically"]
pub const PRESET : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct PriorityRxOverTx (pub u8) ; impl PriorityRxOverTx { # [doc = "RxDMA priority over TxDMA is 1:1"]
pub const ONETOONE : Self = Self (0) ; # [doc = "RxDMA priority over TxDMA is 2:1"]
pub const TWOTOONE : Self = Self (0x01) ; # [doc = "RxDMA priority over TxDMA is 3:1"]
pub const THREETOONE : Self = Self (0x02) ; # [doc = "RxDMA priority over TxDMA is 4:1"]
pub const FOURTOONE : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fpm (pub u8) ; impl Fpm { # [doc = "PBL values used as-is"]
pub const X1 : Self = Self (0) ; # [doc = "PBL values multiplied by 4"]
pub const X4 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ttc (pub u8) ; impl Ttc { # [doc = "64 bytes"]
pub const TTC64 : Self = Self (0) ; # [doc = "128 bytes"]
pub const TTC128 : Self = Self (0x01) ; # [doc = "192 bytes"]
pub const TTC192 : Self = Self (0x02) ; # [doc = "256 bytes"]
pub const TTC256 : Self = Self (0x03) ; # [doc = "40 bytes"]
pub const TTC40 : Self = Self (0x04) ; # [doc = "32 bytes"]
pub const TTC32 : Self = Self (0x05) ; # [doc = "24 bytes"]
pub const TTC24 : Self = Self (0x06) ; # [doc = "16 bytes"]
pub const TTC16 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Bfd (pub u8) ; impl Bfd { # [doc = "Address filters pass all received broadcast frames"]
pub const ENABLED : Self = Self (0) ; # [doc = "Address filters filter all incoming broadcast frames"]
pub const DISABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Hu (pub u8) ; impl Hu { # [doc = "MAC performs a perfect destination address filtering for unicast frames"]
pub const PERFECT : Self = Self (0) ; # [doc = "MAC performs destination address filtering of received unicast frames according to the hash table"]
pub const HASH : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Jd (pub u8) ; impl Jd { # [doc = "Jabber enabled, transmit frames up to 2048 bytes"]
pub const ENABLED : Self = Self (0) ; # [doc = "Jabber disabled, transmit frames up to 16384 bytes"]
pub const DISABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tstim (pub u8) ; impl Tstim { # [doc = "Time stamp interrupt generation enabled"]
pub const UNMASKED : Self = Self (0) ; # [doc = "Time stamp interrupt generation disabled"]
pub const MASKED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pm (pub u8) ; impl Pm { # [doc = "Normal address filtering"]
pub const DISABLED : Self = Self (0) ; # [doc = "Address filters pass all incoming frames regardless of their destination or source address"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Upfd (pub u8) ; impl Upfd { # [doc = "MAC detects only a Pause frame with the multicast address specified in the 802.3x standard"]
pub const DISABLED : Self = Self (0) ; # [doc = "MAC additionally detects Pause frames with the station's unicast address"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Saf (pub u8) ; impl Saf { # [doc = "Source address ignored"]
pub const DISABLED : Self = Self (0) ; # [doc = "MAC drops frames that fail the source address filter"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Apcs (pub u8) ; impl Apcs { # [doc = "MAC passes all incoming frames unmodified"]
pub const DISABLED : Self = Self (0) ; # [doc = "MAC strips the Pad/FCS field on incoming frames only for lengths less than or equal to 1500 bytes"]
pub const STRIP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tgfmscm (pub u8) ; impl Tgfmscm { # [doc = "Transmitted-good-multiple-collision half-full interrupt enabled"]
pub const UNMASKED : Self = Self (0) ; # [doc = "Transmitted-good-multiple-collision half-full interrupt disabled"]
pub const MASKED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rfce (pub u8) ; impl Rfce { # [doc = "Pause frames are not decoded"]
pub const DISABLED : Self = Self (0) ; # [doc = "MAC decodes received Pause frames and disables its transmitted for a specified time"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cstf (pub u8) ; impl Cstf { # [doc = "CRC not stripped"]
pub const DISABLED : Self = Self (0) ; # [doc = "CRC stripped"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rd (pub u8) ; impl Rd { # [doc = "MAC attempts retries based on the settings of BL"]
pub const ENABLED : Self = Self (0) ; # [doc = "MAC attempts only 1 transmission"]
pub const DISABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Bl (pub u8) ; impl Bl { # [doc = "For retransmission n, wait up to 2^min(n, 10) time slots"]
pub const BL10 : Self = Self (0) ; # [doc = "For retransmission n, wait up to 2^min(n, 8) time slots"]
pub const BL8 : Self = Self (0x01) ; # [doc = "For retransmission n, wait up to 2^min(n, 4) time slots"]
pub const BL4 : Self = Self (0x02) ; # [doc = "For retransmission n, wait up to 2^min(n, 1) time slots"]
pub const BL1 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mcf (pub u8) ; impl Mcf { # [doc = "All MMC counters update normally"]
pub const UNFROZEN : Self = Self (0) ; # [doc = "All MMC counters frozen to their current value"]
pub const FROZEN : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pmtim (pub u8) ; impl Pmtim { # [doc = "PMT Status interrupt generation enabled"]
pub const UNMASKED : Self = Self (0) ; # [doc = "PMT Status interrupt generation disabled"]
pub const MASKED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pam (pub u8) ; impl Pam { # [doc = "Filtering of multicast frames depends on HM"]
pub const DISABLED : Self = Self (0) ; # [doc = "All received frames with a multicast destination address are passed"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ipco (pub u8) ; impl Ipco { # [doc = "IPv4 checksum offload disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "IPv4 checksums are checked in received frames"]
pub const OFFLOAD : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wffrpr (pub u8) ; impl Wffrpr { # [doc = "Reset wakeup frame filter register point to 0b000. Automatically cleared"]
pub const RESET : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pcf (pub u8) ; impl Pcf { # [doc = "MAC prevents all control frames from reaching the application"]
pub const PREVENTALL : Self = Self (0) ; # [doc = "MAC forwards all control frames to application except Pause"]
pub const FORWARDALLEXCEPTPAUSE : Self = Self (0x01) ; # [doc = "MAC forwards all control frames to application even if they fail the address filter"]
pub const FORWARDALL : Self = Self (0x02) ; # [doc = "MAC forwards control frames that pass the address filter"]
pub const FORWARDALLFILTERED : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rfaem (pub u8) ; impl Rfaem { # [doc = "Received-alignment-error counter half-full interrupt enabled"]
pub const UNMASKED : Self = Self (0) ; # [doc = "Received-alignment-error counter half-full interrupt disabled"]
pub const MASKED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dm (pub u8) ; impl Dm { # [doc = "MAC operates in half-duplex mode"]
pub const HALFDUPLEX : Self = Self (0) ; # [doc = "MAC operates in full-duplex mode"]
pub const FULLDUPLEX : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Edfe (pub u8) ; impl Edfe { # [doc = "Normal descriptor format"]
pub const DISABLED : Self = Self (0) ; # [doc = "Enhanced 32-byte descriptor format, required for timestamping and IPv4 checksum offload"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dtcefd (pub u8) ; impl Dtcefd { # [doc = "Drop frames with errors only in the receive checksum offload engine"]
pub const ENABLED : Self = Self (0) ; # [doc = "Do not drop frames that only have errors in the receive checksum offload engine"]
pub const DISABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rod (pub u8) ; impl Rod { # [doc = "MAC receives all packets from PHY while transmitting"]
pub const ENABLED : Self = Self (0) ; # [doc = "MAC disables reception of frames in half-duplex mode"]
pub const DISABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Re (pub u8) ; impl Re { # [doc = "MAC receive state machine is disabled after the completion of the reception of the current frame"]
pub const DISABLED : Self = Self (0) ; # [doc = "MAC receive state machine is enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mb (pub u8) ; impl Mb { # [doc = "Fixed burst transfers (INCRx and SINGLE) for burst lengths of 16 and below"]
pub const NORMAL : Self = Self (0) ; # [doc = "If FB is low, start all bursts greater than 16 with INCR (undefined burst)"]
pub const MIXED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fugf (pub u8) ; impl Fugf { # [doc = "Rx FIFO drops all frames of less than 64 bytes"]
pub const DROP : Self = Self (0) ; # [doc = "Rx FIFO forwards undersized frames"]
pub const FORWARD : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tsf (pub u8) ; impl Tsf { # [doc = "Transmission starts when the frame size in the Tx FIFO exceeds TTC threshold"]
pub const CUTTHROUGH : Self = Self (0) ; # [doc = "Transmission starts when a full frame is in the Tx FIFO"]
pub const STOREFORWARD : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dc (pub u8) ; impl Dc { # [doc = "MAC defers until CRS signal goes inactive"]
pub const DISABLED : Self = Self (0) ; # [doc = "Deferral check function enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rtc (pub u8) ; impl Rtc { # [doc = "64 bytes"]
pub const RTC64 : Self = Self (0) ; # [doc = "32 bytes"]
pub const RTC32 : Self = Self (0x01) ; # [doc = "96 bytes"]
pub const RTC96 : Self = Self (0x02) ; # [doc = "128 bytes"]
pub const RTC128 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct St (pub u8) ; impl St { # [doc = "Transmission is placed in the Stopped state"]
pub const STOPPED : Self = Self (0) ; # [doc = "Transmission is placed in Running state"]
pub const STARTED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fes (pub u8) ; impl Fes { # [doc = "10 Mbit/s"]
pub const FES10 : Self = Self (0) ; # [doc = "100 Mbit/s"]
pub const FES100 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rsf (pub u8) ; impl Rsf { # [doc = "Rx FIFO operates in cut-through mode, subject to RTC bits"]
pub const CUTTHROUGH : Self = Self (0) ; # [doc = "Frames are read from Rx FIFO after complete frame has been written"]
pub const STOREFORWARD : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rdp (pub u8) ; impl Rdp { # [doc = "1 beat per RxDMA transaction"]
pub const RDP1 : Self = Self (0x01) ; # [doc = "2 beats per RxDMA transaction"]
pub const RDP2 : Self = Self (0x02) ; # [doc = "4 beats per RxDMA transaction"]
pub const RDP4 : Self = Self (0x04) ; # [doc = "8 beats per RxDMA transaction"]
pub const RDP8 : Self = Self (0x08) ; # [doc = "16 beats per RxDMA transaction"]
pub const RDP16 : Self = Self (0x10) ; # [doc = "32 beats per RxDMA transaction"]
pub const RDP32 : Self = Self (0x20) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Zqpd (pub u8) ; impl Zqpd { # [doc = "Normal operation with automatic zero-quanta pause control frame generation"]
pub const ENABLED : Self = Self (0) ; # [doc = "Automatic generation of zero-quanta pause control frames is disabled"]
pub const DISABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wd (pub u8) ; impl Wd { # [doc = "Watchdog enabled, receive frames limited to 2048 bytes"]
pub const ENABLED : Self = Self (0) ; # [doc = "Watchdog disabled, receive frames may be up to to 16384 bytes"]
pub const DISABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Plt (pub u8) ; impl Plt { # [doc = "Pause time minus 4 slot times"]
pub const PLT4 : Self = Self (0) ; # [doc = "Pause time minus 28 slot times"]
pub const PLT28 : Self = Self (0x01) ; # [doc = "Pause time minus 144 slot times"]
pub const PLT144 : Self = Self (0x02) ; # [doc = "Pause time minus 256 slot times"]
pub const PLT256 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fef (pub u8) ; impl Fef { # [doc = "Rx FIFO drops frames with error status"]
pub const DROP : Self = Self (0) ; # [doc = "All frames except runt error frames are forwarded to the DMA"]
pub const FORWARD : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Usp (pub u8) ; impl Usp { # [doc = "PBL value used for both Rx and Tx DMA"]
pub const COMBINED : Self = Self (0) ; # [doc = "RxDMA uses RDP value, TxDMA uses PBL value"]
pub const SEPARATE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct MacahrAe (pub u8) ; impl MacahrAe { # [doc = "Address filters ignore this address"]
pub const DISABLED : Self = Self (0) ; # [doc = "Address filters use this address"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pbl (pub u8) ; impl Pbl { # [doc = "Maximum of 1 beat per DMA transaction"]
pub const PBL1 : Self = Self (0x01) ; # [doc = "Maximum of 2 beats per DMA transaction"]
pub const PBL2 : Self = Self (0x02) ; # [doc = "Maximum of 4 beats per DMA transaction"]
pub const PBL4 : Self = Self (0x04) ; # [doc = "Maximum of 8 beats per DMA transaction"]
pub const PBL8 : Self = Self (0x08) ; # [doc = "Maximum of 16 beats per DMA transaction"]
pub const PBL16 : Self = Self (0x10) ; # [doc = "Maximum of 32 beats per DMA transaction"]
pub const PBL32 : Self = Self (0x20) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cr (pub u8) ; impl Cr { # [doc = "60-100MHz HCLK/42"]
pub const CR_60_100 : Self = Self (0) ; # [doc = "100-150 MHz HCLK/62"]
pub const CR_100_150 : Self = Self (0x01) ; # [doc = "20-35MHz HCLK/16"]
pub const CR_20_35 : Self = Self (0x02) ; # [doc = "35-60MHz HCLK/16"]
pub const CR_35_60 : Self = Self (0x03) ; # [doc = "150-168MHz HCLK/102"]
pub const CR_150_168 : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fcb (pub u8) ; impl Fcb { # [doc = "In half duplex only, deasserts back pressure"]
pub const DISABLEBACKPRESSURE : Self = Self (0) ; # [doc = "In full duplex, initiate a Pause control frame. In half duplex, assert back pressure"]
pub const PAUSEORBACKPRESSURE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ra (pub u8) ; impl Ra { # [doc = "MAC receiver passes on to the application only those frames that have passed the SA/DA address file"]
pub const DISABLED : Self = Self (0) ; # [doc = "MAC receiver passes oll received frames on to the application"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tpd (pub u32) ; impl Tpd { # [doc = "Poll the transmit descriptor list"]
pub const POLL : Self = Self (0) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tgfscm (pub u8) ; impl Tgfscm { # [doc = "Transmitted-good-single-collision half-full interrupt enabled"]
pub const UNMASKED : Self = Self (0) ; # [doc = "Transmitted-good-single-collision half-full interrupt disabled"]
pub const MASKED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rpd (pub u32) ; impl Rpd { # [doc = "Poll the receive descriptor list"]
pub const POLL : Self = Self (0) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct DmabmrSr (pub u8) ; impl DmabmrSr { # [doc = "Reset all MAC subsystem internal registers and logic. Cleared automatically"]
pub const RESET : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wfe (pub u8) ; impl Wfe { # [doc = "No power management event generated due to wakeup frame reception"]
pub const DISABLED : Self = Self (0) ; # [doc = "Enable generation of a power management event due to wakeup frame reception"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Daif (pub u8) ; impl Daif { # [doc = "Normal filtering of frames"]
pub const NORMAL : Self = Self (0) ; # [doc = "Address check block operates in inverse filtering mode for the DA address comparison"]
pub const INVERT : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Hpf (pub u8) ; impl Hpf { # [doc = "If HM or HU is set, only frames that match the Hash filter are passed"]
pub const HASHONLY : Self = Self (0) ; # [doc = "If HM or HU is set, frames that match either the perfect filter or the hash filter are passed"]
pub const HASHORPERFECT : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tps (pub u8) ; impl Tps { # [doc = "Stopped, Reset or Stop Transmit command issued"]
pub const STOPPED : Self = Self (0) ; # [doc = "Running, fetching transmit transfer descriptor"]
pub const RUNNINGFETCHING : Self = Self (0x01) ; # [doc = "Running, waiting for status"]
pub const RUNNINGWAITING : Self = Self (0x02) ; # [doc = "Running, reading data from host memory buffer"]
pub const RUNNINGREADING : Self = Self (0x03) ; # [doc = "Suspended, transmit descriptor unavailable or transmit buffer underflow"]
pub const SUSPENDED : Self = Self (0x06) ; # [doc = "Running, closing transmit descriptor"]
pub const RUNNING : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rgufm (pub u8) ; impl Rgufm { # [doc = "Received-good-unicast counter half-full interrupt enabled"]
pub const UNMASKED : Self = Self (0) ; # [doc = "Received-good-unicast counter half-full interrupt disabled"]
pub const MASKED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Vlantc (pub u8) ; impl Vlantc { # [doc = "Full 16 bit VLAN identifiers are used for comparison and filtering"]
pub const VLANTC16 : Self = Self (0) ; # [doc = "12 bit VLAN identifies are used for comparison and filtering"]
pub const VLANTC12 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Da (pub u8) ; impl Da { # [doc = "Round-robin with Rx:Tx priority given by PM"]
pub const ROUNDROBIN : Self = Self (0) ; # [doc = "Rx has priority over Tx"]
pub const RXPRIORITY : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ftf (pub u8) ; impl Ftf { # [doc = "Transmit FIFO controller logic is reset to its default values. Cleared automatically"]
pub const FLUSH : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rps (pub u8) ; impl Rps { # [doc = "Stopped, reset or Stop Receive command issued"]
pub const STOPPED : Self = Self (0) ; # [doc = "Running, fetching receive transfer descriptor"]
pub const RUNNINGFETCHING : Self = Self (0x01) ; # [doc = "Running, waiting for receive packet"]
pub const RUNNINGWAITING : Self = Self (0x03) ; # [doc = "Suspended, receive descriptor unavailable"]
pub const SUSPENDED : Self = Self (0x04) ; # [doc = "Running, writing data to host memory buffer"]
pub const RUNNINGWRITING : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ifg (pub u8) ; impl Ifg { # [doc = "96 bit times"]
pub const IFG96 : Self = Self (0) ; # [doc = "88 bit times"]
pub const IFG88 : Self = Self (0x01) ; # [doc = "80 bit times"]
pub const IFG80 : Self = Self (0x02) ; # [doc = "72 bit times"]
pub const IFG72 : Self = Self (0x03) ; # [doc = "64 bit times"]
pub const IFG64 : Self = Self (0x04) ; # [doc = "56 bit times"]
pub const IFG56 : Self = Self (0x05) ; # [doc = "48 bit times"]
pub const IFG48 : Self = Self (0x06) ; # [doc = "40 bit times"]
pub const IFG40 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Gu (pub u8) ; impl Gu { # [doc = "Normal operation"]
pub const DISABLED : Self = Self (0) ; # [doc = "Any unicast packet filtered by the MAC address recognition may be a wakeup frame"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fb (pub u8) ; impl Fb { # [doc = "AHB uses SINGLE and INCR burst transfers"]
pub const VARIABLE : Self = Self (0) ; # [doc = "AHB uses only fixed burst transfers"]
pub const FIXED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Aab (pub u8) ; impl Aab { # [doc = "Bursts are not aligned"]
pub const UNALIGNED : Self = Self (0) ; # [doc = "Align bursts to start address LS bits. First burst alignment depends on FB bit"]
pub const ALIGNED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Hm (pub u8) ; impl Hm { # [doc = "MAC performs a perfect destination address filtering for multicast frames"]
pub const PERFECT : Self = Self (0) ; # [doc = "MAC performs destination address filtering of received multicast frames according to the hash table"]
pub const HASH : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Csd (pub u8) ; impl Csd { # [doc = "Errors generated due to loss of carrier"]
pub const ENABLED : Self = Self (0) ; # [doc = "No error generated due to loss of carrier"]
pub const DISABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Te (pub u8) ; impl Te { # [doc = "MAC transmit state machine is disabled after completion of the transmission of the current frame"]
pub const DISABLED : Self = Self (0) ; # [doc = "MAC transmit state machine is enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Csr (pub u8) ; impl Csr { # [doc = "Counters roll over to zero after reaching the maximum value"]
pub const DISABLED : Self = Self (0) ; # [doc = "Counters do not roll over to zero after reaching the maximum value"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ror (pub u8) ; impl Ror { # [doc = "MMC counters do not reset on read"]
pub const DISABLED : Self = Self (0) ; # [doc = "MMC counters reset to zero after read"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rfcem (pub u8) ; impl Rfcem { # [doc = "Received-crc-error counter half-full interrupt enabled"]
pub const UNMASKED : Self = Self (0) ; # [doc = "Received-crc-error counter half-full interrupt disabled"]
pub const MASKED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mpe (pub u8) ; impl Mpe { # [doc = "No power management event generated due to Magic Packet reception"]
pub const DISABLED : Self = Self (0) ; # [doc = "Enable generation of a power management event due to Magic Packet reception"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tfce (pub u8) ; impl Tfce { # [doc = "In full duplex, flow control is disabled. In half duplex, back pressure is disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "In full duplex, flow control is enabled. In half duplex, back pressure is enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Saif (pub u8) ; impl Saif { # [doc = "Source address filter operates normally"]
pub const NORMAL : Self = Self (0) ; # [doc = "Source address filter operation inverted"]
pub const INVERT : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct MbProgress (pub u8) ; impl MbProgress { # [doc = "This bit is set to 1 by the application to indicate that a read or write access is in progress"]
pub const BUSY : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct DmaomrSr (pub u8) ; impl DmaomrSr { # [doc = "Reception is stopped after transfer of the current frame"]
pub const STOPPED : Self = Self (0) ; # [doc = "Reception is placed in the Running state"]
pub const STARTED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pd (pub u8) ; impl Pd { # [doc = "All received frames will be dropped. Cleared automatically when a magic packet or wakeup frame is received"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct CounterReset (pub u8) ; impl CounterReset { # [doc = "Reset all counters. Cleared automatically"]
pub const RESET : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tgfm (pub u8) ; impl Tgfm { # [doc = "Transmitted-good counter half-full interrupt enabled"]
pub const UNMASKED : Self = Self (0) ; # [doc = "Transmitted-good counter half-full interrupt disabled"]
pub const MASKED : Self = Self (0x01) ; } }