

# [doc = "DMAMUX"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dmamux (pub * mut u8) ; unsafe impl Send for Dmamux { } unsafe impl Sync for Dmamux { } impl Dmamux { # [doc = "DMAMux - DMA request line multiplexer channel x control register"]
pub fn ccr (self , n : usize) -> crate :: common :: Reg < regs :: Ccr , crate :: common :: RW > { assert ! (n < 16usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize + n * 4usize)) } } # [doc = "DMAMUX request line multiplexer interrupt channel status register"]
pub fn csr (self) -> crate :: common :: Reg < regs :: Csr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (128usize)) } } # [doc = "DMAMUX request line multiplexer interrupt clear flag register"]
pub fn cfr (self) -> crate :: common :: Reg < regs :: Csr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (132usize)) } } # [doc = "DMAMux - DMA request generator channel x control register"]
pub fn rgcr (self , n : usize) -> crate :: common :: Reg < regs :: Rgcr , crate :: common :: RW > { assert ! (n < 8usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (256usize + n * 4usize)) } } # [doc = "DMAMux - DMA request generator status register"]
pub fn rgsr (self) -> crate :: common :: Reg < regs :: Rgsr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (320usize)) } } # [doc = "DMAMux - DMA request generator clear flag register"]
pub fn rgcfr (self) -> crate :: common :: Reg < regs :: Rgsr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (324usize)) } } } pub mod regs { # [doc = "DMAMux - DMA request generator channel x control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rgcr (pub u32) ; impl Rgcr { # [doc = "DMA request trigger input selected"]
pub const fn sig_id (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x1f ; val as u8 } # [doc = "DMA request trigger input selected"]
pub fn set_sig_id (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 0usize)) | (((val as u32) & 0x1f) << 0usize) ; } # [doc = "Interrupt enable at trigger event overrun"]
pub const fn oie (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Interrupt enable at trigger event overrun"]
pub fn set_oie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "DMA request generator channel enable/disable"]
pub const fn ge (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "DMA request generator channel enable/disable"]
pub fn set_ge (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "DMA request generator trigger event type selection Defines the trigger event on the selected DMA request trigger input"]
pub const fn gpol (& self) -> super :: vals :: Pol { let val = (self . 0 >> 17usize) & 0x03 ; super :: vals :: Pol (val as u8) } # [doc = "DMA request generator trigger event type selection Defines the trigger event on the selected DMA request trigger input"]
pub fn set_gpol (& mut self , val : super :: vals :: Pol) { self . 0 = (self . 0 & ! (0x03 << 17usize)) | (((val . 0 as u32) & 0x03) << 17usize) ; } # [doc = "Number of DMA requests to generate Defines the number of DMA requests generated after a trigger event, then stop generating. The actual number of generated DMA requests is GNBREQ+1. Note: This field can only be written when GE bit is reset."]
pub const fn gnbreq (& self) -> u8 { let val = (self . 0 >> 19usize) & 0x1f ; val as u8 } # [doc = "Number of DMA requests to generate Defines the number of DMA requests generated after a trigger event, then stop generating. The actual number of generated DMA requests is GNBREQ+1. Note: This field can only be written when GE bit is reset."]
pub fn set_gnbreq (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 19usize)) | (((val as u32) & 0x1f) << 19usize) ; } } impl Default for Rgcr { fn default () -> Rgcr { Rgcr (0) } } # [doc = "DMAMUX request line multiplexer interrupt channel status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Csr (pub u32) ; impl Csr { # [doc = "Synchronization overrun event flag"]
pub fn sof (& self , n : usize) -> bool { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Synchronization overrun event flag"]
pub fn set_sof (& mut self , n : usize , val : bool) { assert ! (n < 16usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Csr { fn default () -> Csr { Csr (0) } } # [doc = "DMAMux - DMA request line multiplexer channel x control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ccr (pub u32) ; impl Ccr { # [doc = "Input DMA request line selected"]
pub const fn dmareq_id (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Input DMA request line selected"]
pub fn set_dmareq_id (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Interrupt enable at synchronization event overrun"]
pub const fn soie (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Interrupt enable at synchronization event overrun"]
pub fn set_soie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Event generation enable/disable"]
pub const fn ege (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Event generation enable/disable"]
pub fn set_ege (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Synchronous operating mode enable/disable"]
pub const fn se (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "Synchronous operating mode enable/disable"]
pub fn set_se (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "Synchronization event type selector Defines the synchronization event on the selected synchronization input:"]
pub const fn spol (& self) -> super :: vals :: Pol { let val = (self . 0 >> 17usize) & 0x03 ; super :: vals :: Pol (val as u8) } # [doc = "Synchronization event type selector Defines the synchronization event on the selected synchronization input:"]
pub fn set_spol (& mut self , val : super :: vals :: Pol) { self . 0 = (self . 0 & ! (0x03 << 17usize)) | (((val . 0 as u32) & 0x03) << 17usize) ; } # [doc = "Number of DMA requests to forward Defines the number of DMA requests forwarded before output event is generated. In synchronous mode, it also defines the number of DMA requests to forward after a synchronization event, then stop forwarding. The actual number of DMA requests forwarded is NBREQ+1. Note: This field can only be written when both SE and EGE bits are reset."]
pub const fn nbreq (& self) -> u8 { let val = (self . 0 >> 19usize) & 0x1f ; val as u8 } # [doc = "Number of DMA requests to forward Defines the number of DMA requests forwarded before output event is generated. In synchronous mode, it also defines the number of DMA requests to forward after a synchronization event, then stop forwarding. The actual number of DMA requests forwarded is NBREQ+1. Note: This field can only be written when both SE and EGE bits are reset."]
pub fn set_nbreq (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 19usize)) | (((val as u32) & 0x1f) << 19usize) ; } # [doc = "Synchronization input selected"]
pub const fn sync_id (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x1f ; val as u8 } # [doc = "Synchronization input selected"]
pub fn set_sync_id (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 24usize)) | (((val as u32) & 0x1f) << 24usize) ; } } impl Default for Ccr { fn default () -> Ccr { Ccr (0) } } # [doc = "DMAMux - DMA request generator status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rgsr (pub u32) ; impl Rgsr { # [doc = "Trigger event overrun flag The flag is set when a trigger event occurs on DMA request generator channel x, while the DMA request generator counter value is lower than GNBREQ. The flag is cleared by writing 1 to the corresponding COFx bit in DMAMUX_RGCFR register."]
pub fn of (& self , n : usize) -> bool { assert ! (n < 8usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Trigger event overrun flag The flag is set when a trigger event occurs on DMA request generator channel x, while the DMA request generator counter value is lower than GNBREQ. The flag is cleared by writing 1 to the corresponding COFx bit in DMAMUX_RGCFR register."]
pub fn set_of (& mut self , n : usize , val : bool) { assert ! (n < 8usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Rgsr { fn default () -> Rgsr { Rgsr (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pol (pub u8) ; impl Pol { # [doc = "No event, i.e. no synchronization nor detection"]
pub const NOEDGE : Self = Self (0) ; # [doc = "Rising edge"]
pub const RISINGEDGE : Self = Self (0x01) ; # [doc = "Falling edge"]
pub const FALLINGEDGE : Self = Self (0x02) ; # [doc = "Rising and falling edges"]
pub const BOTHEDGES : Self = Self (0x03) ; } }