

# [doc = "Stream cluster: S?CR, S?NDTR, S?M0AR, S?M1AR and S?FCR registers"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct St (pub * mut u8) ; unsafe impl Send for St { } unsafe impl Sync for St { } impl St { # [doc = "stream x configuration register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "stream x number of data register"]
pub fn ndtr (self) -> crate :: common :: Reg < regs :: Ndtr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "stream x peripheral address register"]
pub fn par (self) -> crate :: common :: Reg < u32 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "stream x memory 0 address register"]
pub fn m0ar (self) -> crate :: common :: Reg < u32 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "stream x memory 1 address register"]
pub fn m1ar (self) -> crate :: common :: Reg < u32 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "stream x FIFO control register"]
pub fn fcr (self) -> crate :: common :: Reg < regs :: Fcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } } # [doc = "DMA controller"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dma (pub * mut u8) ; unsafe impl Send for Dma { } unsafe impl Sync for Dma { } impl Dma { # [doc = "low interrupt status register"]
pub fn isr (self , n : usize) -> crate :: common :: Reg < regs :: Ixr , crate :: common :: R > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize + n * 4usize)) } } # [doc = "low interrupt flag clear register"]
pub fn ifcr (self , n : usize) -> crate :: common :: Reg < regs :: Ixr , crate :: common :: W > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize + n * 4usize)) } } # [doc = "Stream cluster: S?CR, S?NDTR, S?M0AR, S?M1AR and S?FCR registers"]
pub fn st (self , n : usize) -> St { assert ! (n < 8usize) ; unsafe { St (self . 0 . add (16usize + n * 24usize)) } } } pub mod regs { # [doc = "stream x configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Stream enable / flag stream ready when read low"]
pub const fn en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Stream enable / flag stream ready when read low"]
pub fn set_en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Direct mode error interrupt enable"]
pub const fn dmeie (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Direct mode error interrupt enable"]
pub fn set_dmeie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Transfer error interrupt enable"]
pub const fn teie (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Transfer error interrupt enable"]
pub fn set_teie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Half transfer interrupt enable"]
pub const fn htie (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Half transfer interrupt enable"]
pub fn set_htie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Transfer complete interrupt enable"]
pub const fn tcie (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Transfer complete interrupt enable"]
pub fn set_tcie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Peripheral flow controller"]
pub const fn pfctrl (& self) -> super :: vals :: Pfctrl { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Pfctrl (val as u8) } # [doc = "Peripheral flow controller"]
pub fn set_pfctrl (& mut self , val : super :: vals :: Pfctrl) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "Data transfer direction"]
pub const fn dir (& self) -> super :: vals :: Dir { let val = (self . 0 >> 6usize) & 0x03 ; super :: vals :: Dir (val as u8) } # [doc = "Data transfer direction"]
pub fn set_dir (& mut self , val : super :: vals :: Dir) { self . 0 = (self . 0 & ! (0x03 << 6usize)) | (((val . 0 as u32) & 0x03) << 6usize) ; } # [doc = "Circular mode"]
pub const fn circ (& self) -> super :: vals :: Circ { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Circ (val as u8) } # [doc = "Circular mode"]
pub fn set_circ (& mut self , val : super :: vals :: Circ) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "Peripheral increment mode"]
pub const fn pinc (& self) -> super :: vals :: Inc { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Inc (val as u8) } # [doc = "Peripheral increment mode"]
pub fn set_pinc (& mut self , val : super :: vals :: Inc) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "Memory increment mode"]
pub const fn minc (& self) -> super :: vals :: Inc { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Inc (val as u8) } # [doc = "Memory increment mode"]
pub fn set_minc (& mut self , val : super :: vals :: Inc) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "Peripheral data size"]
pub const fn psize (& self) -> super :: vals :: Size { let val = (self . 0 >> 11usize) & 0x03 ; super :: vals :: Size (val as u8) } # [doc = "Peripheral data size"]
pub fn set_psize (& mut self , val : super :: vals :: Size) { self . 0 = (self . 0 & ! (0x03 << 11usize)) | (((val . 0 as u32) & 0x03) << 11usize) ; } # [doc = "Memory data size"]
pub const fn msize (& self) -> super :: vals :: Size { let val = (self . 0 >> 13usize) & 0x03 ; super :: vals :: Size (val as u8) } # [doc = "Memory data size"]
pub fn set_msize (& mut self , val : super :: vals :: Size) { self . 0 = (self . 0 & ! (0x03 << 13usize)) | (((val . 0 as u32) & 0x03) << 13usize) ; } # [doc = "Peripheral increment offset size"]
pub const fn pincos (& self) -> super :: vals :: Pincos { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Pincos (val as u8) } # [doc = "Peripheral increment offset size"]
pub fn set_pincos (& mut self , val : super :: vals :: Pincos) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } # [doc = "Priority level"]
pub const fn pl (& self) -> super :: vals :: Pl { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: Pl (val as u8) } # [doc = "Priority level"]
pub fn set_pl (& mut self , val : super :: vals :: Pl) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } # [doc = "Double buffer mode"]
pub const fn dbm (& self) -> super :: vals :: Dbm { let val = (self . 0 >> 18usize) & 0x01 ; super :: vals :: Dbm (val as u8) } # [doc = "Double buffer mode"]
pub fn set_dbm (& mut self , val : super :: vals :: Dbm) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val . 0 as u32) & 0x01) << 18usize) ; } # [doc = "Current target (only in double buffer mode)"]
pub const fn ct (& self) -> super :: vals :: Ct { let val = (self . 0 >> 19usize) & 0x01 ; super :: vals :: Ct (val as u8) } # [doc = "Current target (only in double buffer mode)"]
pub fn set_ct (& mut self , val : super :: vals :: Ct) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val . 0 as u32) & 0x01) << 19usize) ; } # [doc = "Peripheral burst transfer configuration"]
pub const fn pburst (& self) -> super :: vals :: Burst { let val = (self . 0 >> 21usize) & 0x03 ; super :: vals :: Burst (val as u8) } # [doc = "Peripheral burst transfer configuration"]
pub fn set_pburst (& mut self , val : super :: vals :: Burst) { self . 0 = (self . 0 & ! (0x03 << 21usize)) | (((val . 0 as u32) & 0x03) << 21usize) ; } # [doc = "Memory burst transfer configuration"]
pub const fn mburst (& self) -> super :: vals :: Burst { let val = (self . 0 >> 23usize) & 0x03 ; super :: vals :: Burst (val as u8) } # [doc = "Memory burst transfer configuration"]
pub fn set_mburst (& mut self , val : super :: vals :: Burst) { self . 0 = (self . 0 & ! (0x03 << 23usize)) | (((val . 0 as u32) & 0x03) << 23usize) ; } # [doc = "Channel selection"]
pub const fn chsel (& self) -> u8 { let val = (self . 0 >> 25usize) & 0x0f ; val as u8 } # [doc = "Channel selection"]
pub fn set_chsel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 25usize)) | (((val as u32) & 0x0f) << 25usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "stream x number of data register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ndtr (pub u32) ; impl Ndtr { # [doc = "Number of data items to transfer"]
pub const fn ndt (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Number of data items to transfer"]
pub fn set_ndt (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Ndtr { fn default () -> Ndtr { Ndtr (0) } } # [doc = "interrupt register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ixr (pub u32) ; impl Ixr { # [doc = "Stream x FIFO error interrupt flag (x=3..0)"]
pub fn feif (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 0usize + ([0usize , 6usize , 16usize , 22usize]
[n]
as usize) ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Stream x FIFO error interrupt flag (x=3..0)"]
pub fn set_feif (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 0usize + ([0usize , 6usize , 16usize , 22usize]
[n]
as usize) ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Stream x direct mode error interrupt flag (x=3..0)"]
pub fn dmeif (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 2usize + ([0usize , 6usize , 16usize , 22usize]
[n]
as usize) ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Stream x direct mode error interrupt flag (x=3..0)"]
pub fn set_dmeif (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 2usize + ([0usize , 6usize , 16usize , 22usize]
[n]
as usize) ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Stream x transfer error interrupt flag (x=3..0)"]
pub fn teif (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 3usize + ([0usize , 6usize , 16usize , 22usize]
[n]
as usize) ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Stream x transfer error interrupt flag (x=3..0)"]
pub fn set_teif (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 3usize + ([0usize , 6usize , 16usize , 22usize]
[n]
as usize) ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Stream x half transfer interrupt flag (x=3..0)"]
pub fn htif (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 4usize + ([0usize , 6usize , 16usize , 22usize]
[n]
as usize) ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Stream x half transfer interrupt flag (x=3..0)"]
pub fn set_htif (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 4usize + ([0usize , 6usize , 16usize , 22usize]
[n]
as usize) ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Stream x transfer complete interrupt flag (x = 3..0)"]
pub fn tcif (& self , n : usize) -> bool { assert ! (n < 4usize) ; let offs = 5usize + ([0usize , 6usize , 16usize , 22usize]
[n]
as usize) ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Stream x transfer complete interrupt flag (x = 3..0)"]
pub fn set_tcif (& mut self , n : usize , val : bool) { assert ! (n < 4usize) ; let offs = 5usize + ([0usize , 6usize , 16usize , 22usize]
[n]
as usize) ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Ixr { fn default () -> Ixr { Ixr (0) } } # [doc = "stream x FIFO control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fcr (pub u32) ; impl Fcr { # [doc = "FIFO threshold selection"]
pub const fn fth (& self) -> super :: vals :: Fth { let val = (self . 0 >> 0usize) & 0x03 ; super :: vals :: Fth (val as u8) } # [doc = "FIFO threshold selection"]
pub fn set_fth (& mut self , val : super :: vals :: Fth) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val . 0 as u32) & 0x03) << 0usize) ; } # [doc = "Direct mode disable"]
pub const fn dmdis (& self) -> super :: vals :: Dmdis { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Dmdis (val as u8) } # [doc = "Direct mode disable"]
pub fn set_dmdis (& mut self , val : super :: vals :: Dmdis) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "FIFO status"]
pub const fn fs (& self) -> super :: vals :: Fs { let val = (self . 0 >> 3usize) & 0x07 ; super :: vals :: Fs (val as u8) } # [doc = "FIFO status"]
pub fn set_fs (& mut self , val : super :: vals :: Fs) { self . 0 = (self . 0 & ! (0x07 << 3usize)) | (((val . 0 as u32) & 0x07) << 3usize) ; } # [doc = "FIFO error interrupt enable"]
pub const fn feie (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "FIFO error interrupt enable"]
pub fn set_feie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } } impl Default for Fcr { fn default () -> Fcr { Fcr (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pincos (pub u8) ; impl Pincos { # [doc = "The offset size for the peripheral address calculation is linked to the PSIZE"]
pub const PSIZE : Self = Self (0) ; # [doc = "The offset size for the peripheral address calculation is fixed to 4 (32-bit alignment)"]
pub const FIXED4 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ct (pub u8) ; impl Ct { # [doc = "The current target memory is Memory 0"]
pub const MEMORY0 : Self = Self (0) ; # [doc = "The current target memory is Memory 1"]
pub const MEMORY1 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Size (pub u8) ; impl Size { # [doc = "Byte (8-bit)"]
pub const BITS8 : Self = Self (0) ; # [doc = "Half-word (16-bit)"]
pub const BITS16 : Self = Self (0x01) ; # [doc = "Word (32-bit)"]
pub const BITS32 : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dir (pub u8) ; impl Dir { # [doc = "Peripheral-to-memory"]
pub const PERIPHERALTOMEMORY : Self = Self (0) ; # [doc = "Memory-to-peripheral"]
pub const MEMORYTOPERIPHERAL : Self = Self (0x01) ; # [doc = "Memory-to-memory"]
pub const MEMORYTOMEMORY : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fth (pub u8) ; impl Fth { # [doc = "1/4 full FIFO"]
pub const QUARTER : Self = Self (0) ; # [doc = "1/2 full FIFO"]
pub const HALF : Self = Self (0x01) ; # [doc = "3/4 full FIFO"]
pub const THREEQUARTERS : Self = Self (0x02) ; # [doc = "Full FIFO"]
pub const FULL : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pl (pub u8) ; impl Pl { # [doc = "Low"]
pub const LOW : Self = Self (0) ; # [doc = "Medium"]
pub const MEDIUM : Self = Self (0x01) ; # [doc = "High"]
pub const HIGH : Self = Self (0x02) ; # [doc = "Very high"]
pub const VERYHIGH : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fs (pub u8) ; impl Fs { # [doc = "0 < fifo_level < 1/4"]
pub const QUARTER1 : Self = Self (0) ; # [doc = "1/4 <= fifo_level < 1/2"]
pub const QUARTER2 : Self = Self (0x01) ; # [doc = "1/2 <= fifo_level < 3/4"]
pub const QUARTER3 : Self = Self (0x02) ; # [doc = "3/4 <= fifo_level < full"]
pub const QUARTER4 : Self = Self (0x03) ; # [doc = "FIFO is empty"]
pub const EMPTY : Self = Self (0x04) ; # [doc = "FIFO is full"]
pub const FULL : Self = Self (0x05) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Burst (pub u8) ; impl Burst { # [doc = "Single transfer"]
pub const SINGLE : Self = Self (0) ; # [doc = "Incremental burst of 4 beats"]
pub const INCR4 : Self = Self (0x01) ; # [doc = "Incremental burst of 8 beats"]
pub const INCR8 : Self = Self (0x02) ; # [doc = "Incremental burst of 16 beats"]
pub const INCR16 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dbm (pub u8) ; impl Dbm { # [doc = "No buffer switching at the end of transfer"]
pub const DISABLED : Self = Self (0) ; # [doc = "Memory target switched at the end of the DMA transfer"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Circ (pub u8) ; impl Circ { # [doc = "Circular mode disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Circular mode enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Inc (pub u8) ; impl Inc { # [doc = "Address pointer is fixed"]
pub const FIXED : Self = Self (0) ; # [doc = "Address pointer is incremented after each data transfer"]
pub const INCREMENTED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dmdis (pub u8) ; impl Dmdis { # [doc = "Direct mode is enabled"]
pub const ENABLED : Self = Self (0) ; # [doc = "Direct mode is disabled"]
pub const DISABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pfctrl (pub u8) ; impl Pfctrl { # [doc = "The DMA is the flow controller"]
pub const DMA : Self = Self (0) ; # [doc = "The peripheral is the flow controller"]
pub const PERIPHERAL : Self = Self (0x01) ; } }