

# [doc = "DMA2D"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dma2d (pub * mut u8) ; unsafe impl Send for Dma2d { } unsafe impl Sync for Dma2d { } impl Dma2d { # [doc = "DMA2D control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "DMA2D Interrupt Status Register"]
pub fn isr (self) -> crate :: common :: Reg < regs :: Isr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "DMA2D interrupt flag clear register"]
pub fn ifcr (self) -> crate :: common :: Reg < regs :: Ifcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "DMA2D foreground memory address register"]
pub fn fgmar (self) -> crate :: common :: Reg < regs :: Fgmar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "DMA2D foreground offset register"]
pub fn fgor (self) -> crate :: common :: Reg < regs :: Fgor , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "DMA2D background memory address register"]
pub fn bgmar (self) -> crate :: common :: Reg < regs :: Bgmar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "DMA2D background offset register"]
pub fn bgor (self) -> crate :: common :: Reg < regs :: Bgor , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "DMA2D foreground PFC control register"]
pub fn fgpfccr (self) -> crate :: common :: Reg < regs :: Fgpfccr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "DMA2D foreground color register"]
pub fn fgcolr (self) -> crate :: common :: Reg < regs :: Fgcolr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "DMA2D background PFC control register"]
pub fn bgpfccr (self) -> crate :: common :: Reg < regs :: Bgpfccr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "DMA2D background color register"]
pub fn bgcolr (self) -> crate :: common :: Reg < regs :: Bgcolr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "DMA2D foreground CLUT memory address register"]
pub fn fgcmar (self) -> crate :: common :: Reg < regs :: Fgcmar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "DMA2D background CLUT memory address register"]
pub fn bgcmar (self) -> crate :: common :: Reg < regs :: Bgcmar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "DMA2D output PFC control register"]
pub fn opfccr (self) -> crate :: common :: Reg < regs :: Opfccr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize)) } } # [doc = "DMA2D output color register"]
pub fn ocolr (self) -> crate :: common :: Reg < regs :: Ocolr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } # [doc = "DMA2D output memory address register"]
pub fn omar (self) -> crate :: common :: Reg < regs :: Omar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (60usize)) } } # [doc = "DMA2D output offset register"]
pub fn oor (self) -> crate :: common :: Reg < regs :: Oor , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (64usize)) } } # [doc = "DMA2D number of line register"]
pub fn nlr (self) -> crate :: common :: Reg < regs :: Nlr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (68usize)) } } # [doc = "DMA2D line watermark register"]
pub fn lwr (self) -> crate :: common :: Reg < regs :: Lwr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "DMA2D AXI master timer configuration register"]
pub fn amtcr (self) -> crate :: common :: Reg < regs :: Amtcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } } pub mod regs { # [doc = "DMA2D interrupt flag clear register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ifcr (pub u32) ; impl Ifcr { # [doc = "Clear Transfer error interrupt flag Programming this bit to 1 clears the TEIF flag in the DMA2D_ISR register"]
pub const fn cteif (& self) -> super :: vals :: Cteif { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Cteif (val as u8) } # [doc = "Clear Transfer error interrupt flag Programming this bit to 1 clears the TEIF flag in the DMA2D_ISR register"]
pub fn set_cteif (& mut self , val : super :: vals :: Cteif) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Clear transfer complete interrupt flag Programming this bit to 1 clears the TCIF flag in the DMA2D_ISR register"]
pub const fn ctcif (& self) -> super :: vals :: Ctcif { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Ctcif (val as u8) } # [doc = "Clear transfer complete interrupt flag Programming this bit to 1 clears the TCIF flag in the DMA2D_ISR register"]
pub fn set_ctcif (& mut self , val : super :: vals :: Ctcif) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Clear transfer watermark interrupt flag Programming this bit to 1 clears the TWIF flag in the DMA2D_ISR register"]
pub const fn ctwif (& self) -> super :: vals :: Ctwif { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Ctwif (val as u8) } # [doc = "Clear transfer watermark interrupt flag Programming this bit to 1 clears the TWIF flag in the DMA2D_ISR register"]
pub fn set_ctwif (& mut self , val : super :: vals :: Ctwif) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Clear CLUT access error interrupt flag Programming this bit to 1 clears the CAEIF flag in the DMA2D_ISR register"]
pub const fn caecif (& self) -> super :: vals :: Caecif { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Caecif (val as u8) } # [doc = "Clear CLUT access error interrupt flag Programming this bit to 1 clears the CAEIF flag in the DMA2D_ISR register"]
pub fn set_caecif (& mut self , val : super :: vals :: Caecif) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "Clear CLUT transfer complete interrupt flag Programming this bit to 1 clears the CTCIF flag in the DMA2D_ISR register"]
pub const fn cctcif (& self) -> super :: vals :: Cctcif { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Cctcif (val as u8) } # [doc = "Clear CLUT transfer complete interrupt flag Programming this bit to 1 clears the CTCIF flag in the DMA2D_ISR register"]
pub fn set_cctcif (& mut self , val : super :: vals :: Cctcif) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "Clear configuration error interrupt flag Programming this bit to 1 clears the CEIF flag in the DMA2D_ISR register"]
pub const fn cceif (& self) -> super :: vals :: Cceif { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Cceif (val as u8) } # [doc = "Clear configuration error interrupt flag Programming this bit to 1 clears the CEIF flag in the DMA2D_ISR register"]
pub fn set_cceif (& mut self , val : super :: vals :: Cceif) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } } impl Default for Ifcr { fn default () -> Ifcr { Ifcr (0) } } # [doc = "DMA2D foreground PFC control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fgpfccr (pub u32) ; impl Fgpfccr { # [doc = "Color mode These bits defines the color format of the foreground image. They can only be written when data transfers are disabled. Once the transfer has started, they are read-only. others: meaningless"]
pub const fn cm (& self) -> super :: vals :: FgpfccrCm { let val = (self . 0 >> 0usize) & 0x0f ; super :: vals :: FgpfccrCm (val as u8) } # [doc = "Color mode These bits defines the color format of the foreground image. They can only be written when data transfers are disabled. Once the transfer has started, they are read-only. others: meaningless"]
pub fn set_cm (& mut self , val : super :: vals :: FgpfccrCm) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val . 0 as u32) & 0x0f) << 0usize) ; } # [doc = "CLUT color mode This bit defines the color format of the CLUT. It can only be written when the transfer is disabled. Once the CLUT transfer has started, this bit is read-only."]
pub const fn ccm (& self) -> super :: vals :: FgpfccrCcm { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: FgpfccrCcm (val as u8) } # [doc = "CLUT color mode This bit defines the color format of the CLUT. It can only be written when the transfer is disabled. Once the CLUT transfer has started, this bit is read-only."]
pub fn set_ccm (& mut self , val : super :: vals :: FgpfccrCcm) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "Start This bit can be set to start the automatic loading of the CLUT. It is automatically reset: ** at the end of the transfer ** when the transfer is aborted by the user application by setting the ABORT bit in DMA2D_CR ** when a transfer error occurs ** when the transfer has not started due to a configuration error or another transfer operation already ongoing (data transfer or automatic background CLUT transfer)."]
pub const fn start (& self) -> super :: vals :: FgpfccrStart { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: FgpfccrStart (val as u8) } # [doc = "Start This bit can be set to start the automatic loading of the CLUT. It is automatically reset: ** at the end of the transfer ** when the transfer is aborted by the user application by setting the ABORT bit in DMA2D_CR ** when a transfer error occurs ** when the transfer has not started due to a configuration error or another transfer operation already ongoing (data transfer or automatic background CLUT transfer)."]
pub fn set_start (& mut self , val : super :: vals :: FgpfccrStart) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "CLUT size These bits define the size of the CLUT used for the foreground image. Once the CLUT transfer has started, this field is read-only. The number of CLUT entries is equal to CS[7:0]
+ 1."]
pub const fn cs (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "CLUT size These bits define the size of the CLUT used for the foreground image. Once the CLUT transfer has started, this field is read-only. The number of CLUT entries is equal to CS[7:0]
+ 1."]
pub fn set_cs (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "Alpha mode These bits select the alpha channel value to be used for the foreground image. They can only be written data the transfer are disabled. Once the transfer has started, they become read-only. other configurations are meaningless"]
pub const fn am (& self) -> super :: vals :: FgpfccrAm { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: FgpfccrAm (val as u8) } # [doc = "Alpha mode These bits select the alpha channel value to be used for the foreground image. They can only be written data the transfer are disabled. Once the transfer has started, they become read-only. other configurations are meaningless"]
pub fn set_am (& mut self , val : super :: vals :: FgpfccrAm) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } # [doc = "Chroma Sub-Sampling These bits define the chroma sub-sampling mode for YCbCr color mode. Once the transfer has started, these bits are read-only. others: meaningless"]
pub const fn css (& self) -> u8 { let val = (self . 0 >> 18usize) & 0x03 ; val as u8 } # [doc = "Chroma Sub-Sampling These bits define the chroma sub-sampling mode for YCbCr color mode. Once the transfer has started, these bits are read-only. others: meaningless"]
pub fn set_css (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 18usize)) | (((val as u32) & 0x03) << 18usize) ; } # [doc = "Alpha Inverted This bit inverts the alpha value. Once the transfer has started, this bit is read-only."]
pub const fn ai (& self) -> super :: vals :: FgpfccrAi { let val = (self . 0 >> 20usize) & 0x01 ; super :: vals :: FgpfccrAi (val as u8) } # [doc = "Alpha Inverted This bit inverts the alpha value. Once the transfer has started, this bit is read-only."]
pub fn set_ai (& mut self , val : super :: vals :: FgpfccrAi) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val . 0 as u32) & 0x01) << 20usize) ; } # [doc = "Red Blue Swap This bit allows to swap the R &amp; B to support BGR or ABGR color formats. Once the transfer has started, this bit is read-only."]
pub const fn rbs (& self) -> super :: vals :: FgpfccrRbs { let val = (self . 0 >> 21usize) & 0x01 ; super :: vals :: FgpfccrRbs (val as u8) } # [doc = "Red Blue Swap This bit allows to swap the R &amp; B to support BGR or ABGR color formats. Once the transfer has started, this bit is read-only."]
pub fn set_rbs (& mut self , val : super :: vals :: FgpfccrRbs) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val . 0 as u32) & 0x01) << 21usize) ; } # [doc = "Alpha value These bits define a fixed alpha channel value which can replace the original alpha value or be multiplied by the original alpha value according to the alpha mode selected through the AM[1:0]
bits. These bits can only be written when data transfers are disabled. Once a transfer has started, they become read-only."]
pub const fn alpha (& self) -> u8 { let val = (self . 0 >> 24usize) & 0xff ; val as u8 } # [doc = "Alpha value These bits define a fixed alpha channel value which can replace the original alpha value or be multiplied by the original alpha value according to the alpha mode selected through the AM[1:0]
bits. These bits can only be written when data transfers are disabled. Once a transfer has started, they become read-only."]
pub fn set_alpha (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 24usize)) | (((val as u32) & 0xff) << 24usize) ; } } impl Default for Fgpfccr { fn default () -> Fgpfccr { Fgpfccr (0) } } # [doc = "DMA2D Interrupt Status Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Isr (pub u32) ; impl Isr { # [doc = "Transfer error interrupt flag This bit is set when an error occurs during a DMA transfer (data transfer or automatic CLUT loading)."]
pub const fn teif (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Transfer error interrupt flag This bit is set when an error occurs during a DMA transfer (data transfer or automatic CLUT loading)."]
pub fn set_teif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Transfer complete interrupt flag This bit is set when a DMA2D transfer operation is complete (data transfer only)."]
pub const fn tcif (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Transfer complete interrupt flag This bit is set when a DMA2D transfer operation is complete (data transfer only)."]
pub fn set_tcif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Transfer watermark interrupt flag This bit is set when the last pixel of the watermarked line has been transferred."]
pub const fn twif (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Transfer watermark interrupt flag This bit is set when the last pixel of the watermarked line has been transferred."]
pub fn set_twif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "CLUT access error interrupt flag This bit is set when the CPU accesses the CLUT while the CLUT is being automatically copied from a system memory to the internal DMA2D."]
pub const fn caeif (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "CLUT access error interrupt flag This bit is set when the CPU accesses the CLUT while the CLUT is being automatically copied from a system memory to the internal DMA2D."]
pub fn set_caeif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "CLUT transfer complete interrupt flag This bit is set when the CLUT copy from a system memory area to the internal DMA2D memory is complete."]
pub const fn ctcif (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "CLUT transfer complete interrupt flag This bit is set when the CLUT copy from a system memory area to the internal DMA2D memory is complete."]
pub fn set_ctcif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Configuration error interrupt flag This bit is set when the START bit of DMA2D_CR, DMA2DFGPFCCR or DMA2D_BGPFCCR is set and a wrong configuration has been programmed."]
pub const fn ceif (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Configuration error interrupt flag This bit is set when the START bit of DMA2D_CR, DMA2DFGPFCCR or DMA2D_BGPFCCR is set and a wrong configuration has been programmed."]
pub fn set_ceif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } } impl Default for Isr { fn default () -> Isr { Isr (0) } } # [doc = "DMA2D foreground offset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fgor (pub u32) ; impl Fgor { # [doc = "Line offset Line offset used for the foreground expressed in pixel. This value is used to generate the address. It is added at the end of each line to determine the starting address of the next line. These bits can only be written when data transfers are disabled. Once a data transfer has started, they become read-only. If the image format is 4-bit per pixel, the line offset must be even."]
pub const fn lo (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Line offset Line offset used for the foreground expressed in pixel. This value is used to generate the address. It is added at the end of each line to determine the starting address of the next line. These bits can only be written when data transfers are disabled. Once a data transfer has started, they become read-only. If the image format is 4-bit per pixel, the line offset must be even."]
pub fn set_lo (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Fgor { fn default () -> Fgor { Fgor (0) } } # [doc = "DMA2D foreground memory address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fgmar (pub u32) ; impl Fgmar { # [doc = "Memory address Address of the data used for the foreground image. This register can only be written when data transfers are disabled. Once the data transfer has started, this register is read-only. The address alignment must match the image format selected e.g. a 32-bit per pixel format must be 32-bit aligned, a 16-bit per pixel format must be 16-bit aligned and a 4-bit per pixel format must be 8-bit aligned."]
pub const fn ma (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Memory address Address of the data used for the foreground image. This register can only be written when data transfers are disabled. Once the data transfer has started, this register is read-only. The address alignment must match the image format selected e.g. a 32-bit per pixel format must be 32-bit aligned, a 16-bit per pixel format must be 16-bit aligned and a 4-bit per pixel format must be 8-bit aligned."]
pub fn set_ma (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Fgmar { fn default () -> Fgmar { Fgmar (0) } } # [doc = "DMA2D background color register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bgcolr (pub u32) ; impl Bgcolr { # [doc = "Blue Value These bits define the blue value for the A4 or A8 mode of the background. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub const fn blue (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Blue Value These bits define the blue value for the A4 or A8 mode of the background. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub fn set_blue (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Green Value These bits define the green value for the A4 or A8 mode of the background. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub const fn green (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Green Value These bits define the green value for the A4 or A8 mode of the background. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub fn set_green (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "Red Value These bits define the red value for the A4 or A8 mode of the background. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub const fn red (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Red Value These bits define the red value for the A4 or A8 mode of the background. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub fn set_red (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } } impl Default for Bgcolr { fn default () -> Bgcolr { Bgcolr (0) } } # [doc = "DMA2D foreground color register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fgcolr (pub u32) ; impl Fgcolr { # [doc = "Blue Value These bits defines the blue value for the A4 or A8 mode of the foreground image. They can only be written when data transfers are disabled. Once the transfer has started, They are read-only."]
pub const fn blue (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Blue Value These bits defines the blue value for the A4 or A8 mode of the foreground image. They can only be written when data transfers are disabled. Once the transfer has started, They are read-only."]
pub fn set_blue (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Green Value These bits defines the green value for the A4 or A8 mode of the foreground image. They can only be written when data transfers are disabled. Once the transfer has started, They are read-only."]
pub const fn green (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Green Value These bits defines the green value for the A4 or A8 mode of the foreground image. They can only be written when data transfers are disabled. Once the transfer has started, They are read-only."]
pub fn set_green (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "Red Value These bits defines the red value for the A4 or A8 mode of the foreground image. They can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub const fn red (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Red Value These bits defines the red value for the A4 or A8 mode of the foreground image. They can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub fn set_red (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } } impl Default for Fgcolr { fn default () -> Fgcolr { Fgcolr (0) } } # [doc = "DMA2D output memory address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Omar (pub u32) ; impl Omar { # [doc = "Memory Address Address of the data used for the output FIFO. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only. The address alignment must match the image format selected e.g. a 32-bit per pixel format must be 32-bit aligned and a 16-bit per pixel format must be 16-bit aligned."]
pub const fn ma (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Memory Address Address of the data used for the output FIFO. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only. The address alignment must match the image format selected e.g. a 32-bit per pixel format must be 32-bit aligned and a 16-bit per pixel format must be 16-bit aligned."]
pub fn set_ma (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Omar { fn default () -> Omar { Omar (0) } } # [doc = "DMA2D foreground CLUT memory address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fgcmar (pub u32) ; impl Fgcmar { # [doc = "Memory Address Address of the data used for the CLUT address dedicated to the foreground image. This register can only be written when no transfer is ongoing. Once the CLUT transfer has started, this register is read-only. If the foreground CLUT format is 32-bit, the address must be 32-bit aligned."]
pub const fn ma (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Memory Address Address of the data used for the CLUT address dedicated to the foreground image. This register can only be written when no transfer is ongoing. Once the CLUT transfer has started, this register is read-only. If the foreground CLUT format is 32-bit, the address must be 32-bit aligned."]
pub fn set_ma (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Fgcmar { fn default () -> Fgcmar { Fgcmar (0) } } # [doc = "DMA2D control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Start This bit can be used to launch the DMA2D according to the parameters loaded in the various configuration registers"]
pub const fn start (& self) -> super :: vals :: CrStart { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: CrStart (val as u8) } # [doc = "Start This bit can be used to launch the DMA2D according to the parameters loaded in the various configuration registers"]
pub fn set_start (& mut self , val : super :: vals :: CrStart) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Suspend This bit can be used to suspend the current transfer. This bit is set and reset by software. It is automatically reset by hardware when the START bit is reset."]
pub const fn susp (& self) -> super :: vals :: Susp { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Susp (val as u8) } # [doc = "Suspend This bit can be used to suspend the current transfer. This bit is set and reset by software. It is automatically reset by hardware when the START bit is reset."]
pub fn set_susp (& mut self , val : super :: vals :: Susp) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Abort This bit can be used to abort the current transfer. This bit is set by software and is automatically reset by hardware when the START bit is reset."]
pub const fn abort (& self) -> super :: vals :: Abort { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Abort (val as u8) } # [doc = "Abort This bit can be used to abort the current transfer. This bit is set by software and is automatically reset by hardware when the START bit is reset."]
pub fn set_abort (& mut self , val : super :: vals :: Abort) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Transfer error interrupt enable This bit is set and cleared by software."]
pub const fn teie (& self) -> super :: vals :: Teie { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Teie (val as u8) } # [doc = "Transfer error interrupt enable This bit is set and cleared by software."]
pub fn set_teie (& mut self , val : super :: vals :: Teie) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "Transfer complete interrupt enable This bit is set and cleared by software."]
pub const fn tcie (& self) -> super :: vals :: Tcie { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Tcie (val as u8) } # [doc = "Transfer complete interrupt enable This bit is set and cleared by software."]
pub fn set_tcie (& mut self , val : super :: vals :: Tcie) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "Transfer watermark interrupt enable This bit is set and cleared by software."]
pub const fn twie (& self) -> super :: vals :: Twie { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Twie (val as u8) } # [doc = "Transfer watermark interrupt enable This bit is set and cleared by software."]
pub fn set_twie (& mut self , val : super :: vals :: Twie) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "CLUT access error interrupt enable This bit is set and cleared by software."]
pub const fn caeie (& self) -> super :: vals :: Caeie { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Caeie (val as u8) } # [doc = "CLUT access error interrupt enable This bit is set and cleared by software."]
pub fn set_caeie (& mut self , val : super :: vals :: Caeie) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "CLUT transfer complete interrupt enable This bit is set and cleared by software."]
pub const fn ctcie (& self) -> super :: vals :: Ctcie { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: Ctcie (val as u8) } # [doc = "CLUT transfer complete interrupt enable This bit is set and cleared by software."]
pub fn set_ctcie (& mut self , val : super :: vals :: Ctcie) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } # [doc = "Configuration Error Interrupt Enable This bit is set and cleared by software."]
pub const fn ceie (& self) -> super :: vals :: Ceie { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: Ceie (val as u8) } # [doc = "Configuration Error Interrupt Enable This bit is set and cleared by software."]
pub fn set_ceie (& mut self , val : super :: vals :: Ceie) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } # [doc = "DMA2D mode This bit is set and cleared by software. It cannot be modified while a transfer is ongoing."]
pub const fn mode (& self) -> super :: vals :: Mode { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: Mode (val as u8) } # [doc = "DMA2D mode This bit is set and cleared by software. It cannot be modified while a transfer is ongoing."]
pub fn set_mode (& mut self , val : super :: vals :: Mode) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "DMA2D AXI master timer configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Amtcr (pub u32) ; impl Amtcr { # [doc = "Enable Enables the dead time functionality."]
pub const fn en (& self) -> super :: vals :: En { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: En (val as u8) } # [doc = "Enable Enables the dead time functionality."]
pub fn set_en (& mut self , val : super :: vals :: En) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Dead Time Dead time value in the AXI clock cycle inserted between two consecutive accesses on the AXI master port. These bits represent the minimum guaranteed number of cycles between two consecutive AXI accesses."]
pub const fn dt (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Dead Time Dead time value in the AXI clock cycle inserted between two consecutive accesses on the AXI master port. These bits represent the minimum guaranteed number of cycles between two consecutive AXI accesses."]
pub fn set_dt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } } impl Default for Amtcr { fn default () -> Amtcr { Amtcr (0) } } # [doc = "DMA2D output PFC control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Opfccr (pub u32) ; impl Opfccr { # [doc = "Color mode These bits define the color format of the output image. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only. others: meaningless"]
pub const fn cm (& self) -> super :: vals :: OpfccrCm { let val = (self . 0 >> 0usize) & 0x07 ; super :: vals :: OpfccrCm (val as u8) } # [doc = "Color mode These bits define the color format of the output image. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only. others: meaningless"]
pub fn set_cm (& mut self , val : super :: vals :: OpfccrCm) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val . 0 as u32) & 0x07) << 0usize) ; } # [doc = "Swap Bytes"]
pub const fn sb (& self) -> super :: vals :: Sb { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Sb (val as u8) } # [doc = "Swap Bytes"]
pub fn set_sb (& mut self , val : super :: vals :: Sb) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "Alpha Inverted This bit inverts the alpha value. Once the transfer has started, this bit is read-only."]
pub const fn ai (& self) -> super :: vals :: OpfccrAi { let val = (self . 0 >> 20usize) & 0x01 ; super :: vals :: OpfccrAi (val as u8) } # [doc = "Alpha Inverted This bit inverts the alpha value. Once the transfer has started, this bit is read-only."]
pub fn set_ai (& mut self , val : super :: vals :: OpfccrAi) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val . 0 as u32) & 0x01) << 20usize) ; } # [doc = "Red Blue Swap This bit allows to swap the R &amp; B to support BGR or ABGR color formats. Once the transfer has started, this bit is read-only."]
pub const fn rbs (& self) -> super :: vals :: OpfccrRbs { let val = (self . 0 >> 21usize) & 0x01 ; super :: vals :: OpfccrRbs (val as u8) } # [doc = "Red Blue Swap This bit allows to swap the R &amp; B to support BGR or ABGR color formats. Once the transfer has started, this bit is read-only."]
pub fn set_rbs (& mut self , val : super :: vals :: OpfccrRbs) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val . 0 as u32) & 0x01) << 21usize) ; } } impl Default for Opfccr { fn default () -> Opfccr { Opfccr (0) } } # [doc = "DMA2D number of line register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Nlr (pub u32) ; impl Nlr { # [doc = "Number of lines Number of lines of the area to be transferred. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub const fn nl (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Number of lines Number of lines of the area to be transferred. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub fn set_nl (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "Pixel per lines Number of pixels per lines of the area to be transferred. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only. If any of the input image format is 4-bit per pixel, pixel per lines must be even."]
pub const fn pl (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x3fff ; val as u16 } # [doc = "Pixel per lines Number of pixels per lines of the area to be transferred. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only. If any of the input image format is 4-bit per pixel, pixel per lines must be even."]
pub fn set_pl (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x3fff << 16usize)) | (((val as u32) & 0x3fff) << 16usize) ; } } impl Default for Nlr { fn default () -> Nlr { Nlr (0) } } # [doc = "DMA2D output offset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Oor (pub u32) ; impl Oor { # [doc = "Line Offset Line offset used for the output (expressed in pixels). This value is used for the address generation. It is added at the end of each line to determine the starting address of the next line. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub const fn lo (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Line Offset Line offset used for the output (expressed in pixels). This value is used for the address generation. It is added at the end of each line to determine the starting address of the next line. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub fn set_lo (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Oor { fn default () -> Oor { Oor (0) } } # [doc = "DMA2D background memory address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bgmar (pub u32) ; impl Bgmar { # [doc = "Memory address Address of the data used for the background image. This register can only be written when data transfers are disabled. Once a data transfer has started, this register is read-only. The address alignment must match the image format selected e.g. a 32-bit per pixel format must be 32-bit aligned, a 16-bit per pixel format must be 16-bit aligned and a 4-bit per pixel format must be 8-bit aligned."]
pub const fn ma (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Memory address Address of the data used for the background image. This register can only be written when data transfers are disabled. Once a data transfer has started, this register is read-only. The address alignment must match the image format selected e.g. a 32-bit per pixel format must be 32-bit aligned, a 16-bit per pixel format must be 16-bit aligned and a 4-bit per pixel format must be 8-bit aligned."]
pub fn set_ma (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bgmar { fn default () -> Bgmar { Bgmar (0) } } # [doc = "DMA2D background CLUT memory address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bgcmar (pub u32) ; impl Bgcmar { # [doc = "Memory address Address of the data used for the CLUT address dedicated to the background image. This register can only be written when no transfer is on going. Once the CLUT transfer has started, this register is read-only. If the background CLUT format is 32-bit, the address must be 32-bit aligned."]
pub const fn ma (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Memory address Address of the data used for the CLUT address dedicated to the background image. This register can only be written when no transfer is on going. Once the CLUT transfer has started, this register is read-only. If the background CLUT format is 32-bit, the address must be 32-bit aligned."]
pub fn set_ma (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bgcmar { fn default () -> Bgcmar { Bgcmar (0) } } # [doc = "DMA2D background offset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bgor (pub u32) ; impl Bgor { # [doc = "Line offset Line offset used for the background image (expressed in pixel). This value is used for the address generation. It is added at the end of each line to determine the starting address of the next line. These bits can only be written when data transfers are disabled. Once data transfer has started, they become read-only. If the image format is 4-bit per pixel, the line offset must be even."]
pub const fn lo (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Line offset Line offset used for the background image (expressed in pixel). This value is used for the address generation. It is added at the end of each line to determine the starting address of the next line. These bits can only be written when data transfers are disabled. Once data transfer has started, they become read-only. If the image format is 4-bit per pixel, the line offset must be even."]
pub fn set_lo (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Bgor { fn default () -> Bgor { Bgor (0) } } # [doc = "DMA2D line watermark register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Lwr (pub u32) ; impl Lwr { # [doc = "Line watermark These bits allow to configure the line watermark for interrupt generation. An interrupt is raised when the last pixel of the watermarked line has been transferred. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub const fn lw (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Line watermark These bits allow to configure the line watermark for interrupt generation. An interrupt is raised when the last pixel of the watermarked line has been transferred. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub fn set_lw (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Lwr { fn default () -> Lwr { Lwr (0) } } # [doc = "DMA2D output color register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ocolr (pub u32) ; impl Ocolr { # [doc = "Blue Value These bits define the blue value of the output image. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub const fn blue (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Blue Value These bits define the blue value of the output image. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub fn set_blue (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Green Value These bits define the green value of the output image. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub const fn green (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Green Value These bits define the green value of the output image. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub fn set_green (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "Red Value These bits define the red value of the output image. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub const fn red (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Red Value These bits define the red value of the output image. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub fn set_red (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } # [doc = "Alpha Channel Value These bits define the alpha channel of the output color. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub const fn alpha (& self) -> u8 { let val = (self . 0 >> 24usize) & 0xff ; val as u8 } # [doc = "Alpha Channel Value These bits define the alpha channel of the output color. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub fn set_alpha (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 24usize)) | (((val as u32) & 0xff) << 24usize) ; } } impl Default for Ocolr { fn default () -> Ocolr { Ocolr (0) } } # [doc = "DMA2D background PFC control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bgpfccr (pub u32) ; impl Bgpfccr { # [doc = "Color mode These bits define the color format of the foreground image. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only. others: meaningless"]
pub const fn cm (& self) -> super :: vals :: BgpfccrCm { let val = (self . 0 >> 0usize) & 0x0f ; super :: vals :: BgpfccrCm (val as u8) } # [doc = "Color mode These bits define the color format of the foreground image. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only. others: meaningless"]
pub fn set_cm (& mut self , val : super :: vals :: BgpfccrCm) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val . 0 as u32) & 0x0f) << 0usize) ; } # [doc = "CLUT Color mode These bits define the color format of the CLUT. This register can only be written when the transfer is disabled. Once the CLUT transfer has started, this bit is read-only."]
pub const fn ccm (& self) -> super :: vals :: BgpfccrCcm { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: BgpfccrCcm (val as u8) } # [doc = "CLUT Color mode These bits define the color format of the CLUT. This register can only be written when the transfer is disabled. Once the CLUT transfer has started, this bit is read-only."]
pub fn set_ccm (& mut self , val : super :: vals :: BgpfccrCcm) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "Start This bit is set to start the automatic loading of the CLUT. This bit is automatically reset: ** at the end of the transfer ** when the transfer is aborted by the user application by setting the ABORT bit in the DMA2D_CR ** when a transfer error occurs ** when the transfer has not started due to a configuration error or another transfer operation already on going (data transfer or automatic BackGround CLUT transfer)."]
pub const fn start (& self) -> super :: vals :: BgpfccrStart { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: BgpfccrStart (val as u8) } # [doc = "Start This bit is set to start the automatic loading of the CLUT. This bit is automatically reset: ** at the end of the transfer ** when the transfer is aborted by the user application by setting the ABORT bit in the DMA2D_CR ** when a transfer error occurs ** when the transfer has not started due to a configuration error or another transfer operation already on going (data transfer or automatic BackGround CLUT transfer)."]
pub fn set_start (& mut self , val : super :: vals :: BgpfccrStart) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "CLUT size These bits define the size of the CLUT used for the BG. Once the CLUT transfer has started, this field is read-only. The number of CLUT entries is equal to CS[7:0]
+ 1."]
pub const fn cs (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "CLUT size These bits define the size of the CLUT used for the BG. Once the CLUT transfer has started, this field is read-only. The number of CLUT entries is equal to CS[7:0]
+ 1."]
pub fn set_cs (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "Alpha mode These bits define which alpha channel value to be used for the background image. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only. others: meaningless"]
pub const fn am (& self) -> super :: vals :: BgpfccrAm { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: BgpfccrAm (val as u8) } # [doc = "Alpha mode These bits define which alpha channel value to be used for the background image. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only. others: meaningless"]
pub fn set_am (& mut self , val : super :: vals :: BgpfccrAm) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } # [doc = "Alpha Inverted This bit inverts the alpha value. Once the transfer has started, this bit is read-only."]
pub const fn ai (& self) -> super :: vals :: BgpfccrAi { let val = (self . 0 >> 20usize) & 0x01 ; super :: vals :: BgpfccrAi (val as u8) } # [doc = "Alpha Inverted This bit inverts the alpha value. Once the transfer has started, this bit is read-only."]
pub fn set_ai (& mut self , val : super :: vals :: BgpfccrAi) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val . 0 as u32) & 0x01) << 20usize) ; } # [doc = "Red Blue Swap This bit allows to swap the R &amp; B to support BGR or ABGR color formats. Once the transfer has started, this bit is read-only."]
pub const fn rbs (& self) -> super :: vals :: BgpfccrRbs { let val = (self . 0 >> 21usize) & 0x01 ; super :: vals :: BgpfccrRbs (val as u8) } # [doc = "Red Blue Swap This bit allows to swap the R &amp; B to support BGR or ABGR color formats. Once the transfer has started, this bit is read-only."]
pub fn set_rbs (& mut self , val : super :: vals :: BgpfccrRbs) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val . 0 as u32) & 0x01) << 21usize) ; } # [doc = "Alpha value These bits define a fixed alpha channel value which can replace the original alpha value or be multiplied with the original alpha value according to the alpha mode selected with bits AM[1: 0]. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub const fn alpha (& self) -> u8 { let val = (self . 0 >> 24usize) & 0xff ; val as u8 } # [doc = "Alpha value These bits define a fixed alpha channel value which can replace the original alpha value or be multiplied with the original alpha value according to the alpha mode selected with bits AM[1: 0]. These bits can only be written when data transfers are disabled. Once the transfer has started, they are read-only."]
pub fn set_alpha (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 24usize)) | (((val as u32) & 0xff) << 24usize) ; } } impl Default for Bgpfccr { fn default () -> Bgpfccr { Bgpfccr (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct OpfccrCm (pub u8) ; impl OpfccrCm { # [doc = "ARGB8888"]
pub const ARGB8888 : Self = Self (0) ; # [doc = "RGB888"]
pub const RGB888 : Self = Self (0x01) ; # [doc = "RGB565"]
pub const RGB565 : Self = Self (0x02) ; # [doc = "ARGB1555"]
pub const ARGB1555 : Self = Self (0x03) ; # [doc = "ARGB4444"]
pub const ARGB4444 : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cctcif (pub u8) ; impl Cctcif { # [doc = "Clear the CTCIF flag in the ISR register"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct FgpfccrAi (pub u8) ; impl FgpfccrAi { # [doc = "Regular alpha"]
pub const REGULARALPHA : Self = Self (0) ; # [doc = "Inverted alpha"]
pub const INVERTEDALPHA : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct FgpfccrAm (pub u8) ; impl FgpfccrAm { # [doc = "No modification of alpha channel"]
pub const NOMODIFY : Self = Self (0) ; # [doc = "Replace with value in ALPHA[7:0]"]
pub const REPLACE : Self = Self (0x01) ; # [doc = "Multiply with value in ALPHA[7:0]"]
pub const MULTIPLY : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Caeie (pub u8) ; impl Caeie { # [doc = "CAE interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "CAE interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ceie (pub u8) ; impl Ceie { # [doc = "CE interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "CE interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct OpfccrRbs (pub u8) ; impl OpfccrRbs { # [doc = "No Red Blue Swap (RGB or ARGB)"]
pub const REGULAR : Self = Self (0) ; # [doc = "Red Blue Swap (BGR or ABGR)"]
pub const SWAP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ctwif (pub u8) ; impl Ctwif { # [doc = "Clear the TWIF flag in the ISR register"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct OpfccrAi (pub u8) ; impl OpfccrAi { # [doc = "Regular alpha"]
pub const REGULARALPHA : Self = Self (0) ; # [doc = "Inverted alpha"]
pub const INVERTEDALPHA : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ctcif (pub u8) ; impl Ctcif { # [doc = "Clear the TCIF flag in the ISR register"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Twie (pub u8) ; impl Twie { # [doc = "TW interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "TW interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cceif (pub u8) ; impl Cceif { # [doc = "Clear the CEIF flag in the ISR register"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mode (pub u8) ; impl Mode { # [doc = "Memory-to-memory (FG fetch only)"]
pub const MEMORYTOMEMORY : Self = Self (0) ; # [doc = "Memory-to-memory with PFC (FG fetch only with FG PFC active)"]
pub const MEMORYTOMEMORYPFC : Self = Self (0x01) ; # [doc = "Memory-to-memory with blending (FG and BG fetch with PFC and blending)"]
pub const MEMORYTOMEMORYPFCBLENDING : Self = Self (0x02) ; # [doc = "Register-to-memory"]
pub const REGISTERTOMEMORY : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct BgpfccrCm (pub u8) ; impl BgpfccrCm { # [doc = "Color mode ARGB8888"]
pub const ARGB8888 : Self = Self (0) ; # [doc = "Color mode RGB888"]
pub const RGB888 : Self = Self (0x01) ; # [doc = "Color mode RGB565"]
pub const RGB565 : Self = Self (0x02) ; # [doc = "Color mode ARGB1555"]
pub const ARGB1555 : Self = Self (0x03) ; # [doc = "Color mode ARGB4444"]
pub const ARGB4444 : Self = Self (0x04) ; # [doc = "Color mode L8"]
pub const L8 : Self = Self (0x05) ; # [doc = "Color mode AL44"]
pub const AL44 : Self = Self (0x06) ; # [doc = "Color mode AL88"]
pub const AL88 : Self = Self (0x07) ; # [doc = "Color mode L4"]
pub const L4 : Self = Self (0x08) ; # [doc = "Color mode A8"]
pub const A8 : Self = Self (0x09) ; # [doc = "Color mode A4"]
pub const A4 : Self = Self (0x0a) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct En (pub u8) ; impl En { # [doc = "Disabled AHB/AXI dead-time functionality"]
pub const DISABLED : Self = Self (0) ; # [doc = "Enabled AHB/AXI dead-time functionality"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct BgpfccrAm (pub u8) ; impl BgpfccrAm { # [doc = "No modification of alpha channel"]
pub const NOMODIFY : Self = Self (0) ; # [doc = "Replace with value in ALPHA[7:0]"]
pub const REPLACE : Self = Self (0x01) ; # [doc = "Multiply with value in ALPHA[7:0]"]
pub const MULTIPLY : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Caecif (pub u8) ; impl Caecif { # [doc = "Clear the CAEIF flag in the ISR register"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Sb (pub u8) ; impl Sb { # [doc = "Regular byte order"]
pub const REGULAR : Self = Self (0) ; # [doc = "Bytes are swapped two by two"]
pub const SWAPBYTES : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cteif (pub u8) ; impl Cteif { # [doc = "Clear the TEIF flag in the ISR register"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct FgpfccrStart (pub u8) ; impl FgpfccrStart { # [doc = "Start the automatic loading of the CLUT"]
pub const START : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct BgpfccrStart (pub u8) ; impl BgpfccrStart { # [doc = "Start the automatic loading of the CLUT"]
pub const START : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct BgpfccrAi (pub u8) ; impl BgpfccrAi { # [doc = "Regular alpha"]
pub const REGULARALPHA : Self = Self (0) ; # [doc = "Inverted alpha"]
pub const INVERTEDALPHA : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tcie (pub u8) ; impl Tcie { # [doc = "TC interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "TC interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Teie (pub u8) ; impl Teie { # [doc = "TE interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "TE interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct BgpfccrRbs (pub u8) ; impl BgpfccrRbs { # [doc = "No Red Blue Swap (RGB or ARGB)"]
pub const REGULAR : Self = Self (0) ; # [doc = "Red Blue Swap (BGR or ABGR)"]
pub const SWAP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct CrStart (pub u8) ; impl CrStart { # [doc = "Launch the DMA2D"]
pub const START : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct FgpfccrRbs (pub u8) ; impl FgpfccrRbs { # [doc = "No Red Blue Swap (RGB or ARGB)"]
pub const REGULAR : Self = Self (0) ; # [doc = "Red Blue Swap (BGR or ABGR)"]
pub const SWAP : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Abort (pub u8) ; impl Abort { # [doc = "Transfer abort requested"]
pub const ABORTREQUEST : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ctcie (pub u8) ; impl Ctcie { # [doc = "CTC interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "CTC interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct BgpfccrCcm (pub u8) ; impl BgpfccrCcm { # [doc = "CLUT color format ARGB8888"]
pub const ARGB8888 : Self = Self (0) ; # [doc = "CLUT color format RGB888"]
pub const RGB888 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct FgpfccrCcm (pub u8) ; impl FgpfccrCcm { # [doc = "CLUT color format ARGB8888"]
pub const ARGB8888 : Self = Self (0) ; # [doc = "CLUT color format RGB888"]
pub const RGB888 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Susp (pub u8) ; impl Susp { # [doc = "Transfer not suspended"]
pub const NOTSUSPENDED : Self = Self (0) ; # [doc = "Transfer suspended"]
pub const SUSPENDED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct FgpfccrCm (pub u8) ; impl FgpfccrCm { # [doc = "Color mode ARGB8888"]
pub const ARGB8888 : Self = Self (0) ; # [doc = "Color mode RGB888"]
pub const RGB888 : Self = Self (0x01) ; # [doc = "Color mode RGB565"]
pub const RGB565 : Self = Self (0x02) ; # [doc = "Color mode ARGB1555"]
pub const ARGB1555 : Self = Self (0x03) ; # [doc = "Color mode ARGB4444"]
pub const ARGB4444 : Self = Self (0x04) ; # [doc = "Color mode L8"]
pub const L8 : Self = Self (0x05) ; # [doc = "Color mode AL44"]
pub const AL44 : Self = Self (0x06) ; # [doc = "Color mode AL88"]
pub const AL88 : Self = Self (0x07) ; # [doc = "Color mode L4"]
pub const L4 : Self = Self (0x08) ; # [doc = "Color mode A8"]
pub const A8 : Self = Self (0x09) ; # [doc = "Color mode A4"]
pub const A4 : Self = Self (0x0a) ; # [doc = "Color mode YCbCr"]
pub const YCBCR : Self = Self (0x0b) ; } }