

# [doc = "DMA2D controller"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dma2d (pub * mut u8) ; unsafe impl Send for Dma2d { } unsafe impl Sync for Dma2d { } impl Dma2d { # [doc = "control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Interrupt Status Register"]
pub fn isr (self) -> crate :: common :: Reg < regs :: Isr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "interrupt flag clear register"]
pub fn ifcr (self) -> crate :: common :: Reg < regs :: Ifcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "foreground memory address register"]
pub fn fgmar (self) -> crate :: common :: Reg < regs :: Fgmar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "foreground offset register"]
pub fn fgor (self) -> crate :: common :: Reg < regs :: Fgor , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "background memory address register"]
pub fn bgmar (self) -> crate :: common :: Reg < regs :: Bgmar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "background offset register"]
pub fn bgor (self) -> crate :: common :: Reg < regs :: Bgor , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "foreground PFC control register"]
pub fn fgpfccr (self) -> crate :: common :: Reg < regs :: Fgpfccr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "foreground color register"]
pub fn fgcolr (self) -> crate :: common :: Reg < regs :: Fgcolr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "background PFC control register"]
pub fn bgpfccr (self) -> crate :: common :: Reg < regs :: Bgpfccr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "background color register"]
pub fn bgcolr (self) -> crate :: common :: Reg < regs :: Bgcolr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "foreground CLUT memory address register"]
pub fn fgcmar (self) -> crate :: common :: Reg < regs :: Fgcmar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "background CLUT memory address register"]
pub fn bgcmar (self) -> crate :: common :: Reg < regs :: Bgcmar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "output PFC control register"]
pub fn opfccr (self) -> crate :: common :: Reg < regs :: Opfccr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize)) } } # [doc = "output color register"]
pub fn ocolr (self) -> crate :: common :: Reg < regs :: Ocolr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } # [doc = "output memory address register"]
pub fn omar (self) -> crate :: common :: Reg < regs :: Omar , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (60usize)) } } # [doc = "output offset register"]
pub fn oor (self) -> crate :: common :: Reg < regs :: Oor , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (64usize)) } } # [doc = "number of line register"]
pub fn nlr (self) -> crate :: common :: Reg < regs :: Nlr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (68usize)) } } # [doc = "line watermark register"]
pub fn lwr (self) -> crate :: common :: Reg < regs :: Lwr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "AHB master timer configuration register"]
pub fn amtcr (self) -> crate :: common :: Reg < regs :: Amtcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } # [doc = "FGCLUT"]
pub fn fgclut (self) -> crate :: common :: Reg < regs :: Fgclut , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (1024usize)) } } # [doc = "BGCLUT"]
pub fn bgclut (self) -> crate :: common :: Reg < regs :: Bgclut , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (2048usize)) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cceif (pub u8) ; impl Cceif { # [doc = "Clear the CEIF flag in the ISR register"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Caecif (pub u8) ; impl Caecif { # [doc = "Clear the CAEIF flag in the ISR register"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct FgpfccrCm (pub u8) ; impl FgpfccrCm { # [doc = "Color mode ARGB8888"]
pub const ARGB8888 : Self = Self (0) ; # [doc = "Color mode RGB888"]
pub const RGB888 : Self = Self (0x01) ; # [doc = "Color mode RGB565"]
pub const RGB565 : Self = Self (0x02) ; # [doc = "Color mode ARGB1555"]
pub const ARGB1555 : Self = Self (0x03) ; # [doc = "Color mode ARGB4444"]
pub const ARGB4444 : Self = Self (0x04) ; # [doc = "Color mode L8"]
pub const L8 : Self = Self (0x05) ; # [doc = "Color mode AL44"]
pub const AL44 : Self = Self (0x06) ; # [doc = "Color mode AL88"]
pub const AL88 : Self = Self (0x07) ; # [doc = "Color mode L4"]
pub const L4 : Self = Self (0x08) ; # [doc = "Color mode A8"]
pub const A8 : Self = Self (0x09) ; # [doc = "Color mode A4"]
pub const A4 : Self = Self (0x0a) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ctwif (pub u8) ; impl Ctwif { # [doc = "Clear the TWIF flag in the ISR register"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Mode (pub u8) ; impl Mode { # [doc = "Memory-to-memory (FG fetch only)"]
pub const MEMORYTOMEMORY : Self = Self (0) ; # [doc = "Memory-to-memory with PFC (FG fetch only with FG PFC active)"]
pub const MEMORYTOMEMORYPFC : Self = Self (0x01) ; # [doc = "Memory-to-memory with blending (FG and BG fetch with PFC and blending)"]
pub const MEMORYTOMEMORYPFCBLENDING : Self = Self (0x02) ; # [doc = "Register-to-memory"]
pub const REGISTERTOMEMORY : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct FgpfccrAm (pub u8) ; impl FgpfccrAm { # [doc = "No modification of alpha channel"]
pub const NOMODIFY : Self = Self (0) ; # [doc = "Replace with value in ALPHA[7:0]"]
pub const REPLACE : Self = Self (0x01) ; # [doc = "Multiply with value in ALPHA[7:0]"]
pub const MULTIPLY : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct BgpfccrAm (pub u8) ; impl BgpfccrAm { # [doc = "No modification of alpha channel"]
pub const NOMODIFY : Self = Self (0) ; # [doc = "Replace with value in ALPHA[7:0]"]
pub const REPLACE : Self = Self (0x01) ; # [doc = "Multiply with value in ALPHA[7:0]"]
pub const MULTIPLY : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Susp (pub u8) ; impl Susp { # [doc = "Transfer not suspended"]
pub const NOTSUSPENDED : Self = Self (0) ; # [doc = "Transfer suspended"]
pub const SUSPENDED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct CrStart (pub u8) ; impl CrStart { # [doc = "Launch the DMA2D"]
pub const START : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Caeie (pub u8) ; impl Caeie { # [doc = "CAE interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "CAE interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct En (pub u8) ; impl En { # [doc = "Disabled AHB/AXI dead-time functionality"]
pub const DISABLED : Self = Self (0) ; # [doc = "Enabled AHB/AXI dead-time functionality"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tcie (pub u8) ; impl Tcie { # [doc = "TC interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "TC interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct BgpfccrStart (pub u8) ; impl BgpfccrStart { # [doc = "Start the automatic loading of the CLUT"]
pub const START : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ctcif (pub u8) ; impl Ctcif { # [doc = "Clear the TCIF flag in the ISR register"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ctcie (pub u8) ; impl Ctcie { # [doc = "CTC interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "CTC interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Teie (pub u8) ; impl Teie { # [doc = "TE interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "TE interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct BgpfccrCcm (pub u8) ; impl BgpfccrCcm { # [doc = "CLUT color format ARGB8888"]
pub const ARGB8888 : Self = Self (0) ; # [doc = "CLUT color format RGB888"]
pub const RGB888 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cteif (pub u8) ; impl Cteif { # [doc = "Clear the TEIF flag in the ISR register"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct OpfccrCm (pub u8) ; impl OpfccrCm { # [doc = "ARGB8888"]
pub const ARGB8888 : Self = Self (0) ; # [doc = "RGB888"]
pub const RGB888 : Self = Self (0x01) ; # [doc = "RGB565"]
pub const RGB565 : Self = Self (0x02) ; # [doc = "ARGB1555"]
pub const ARGB1555 : Self = Self (0x03) ; # [doc = "ARGB4444"]
pub const ARGB4444 : Self = Self (0x04) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ceie (pub u8) ; impl Ceie { # [doc = "CE interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "CE interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Abort (pub u8) ; impl Abort { # [doc = "Transfer abort requested"]
pub const ABORTREQUEST : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct BgpfccrCm (pub u8) ; impl BgpfccrCm { # [doc = "Color mode ARGB8888"]
pub const ARGB8888 : Self = Self (0) ; # [doc = "Color mode RGB888"]
pub const RGB888 : Self = Self (0x01) ; # [doc = "Color mode RGB565"]
pub const RGB565 : Self = Self (0x02) ; # [doc = "Color mode ARGB1555"]
pub const ARGB1555 : Self = Self (0x03) ; # [doc = "Color mode ARGB4444"]
pub const ARGB4444 : Self = Self (0x04) ; # [doc = "Color mode L8"]
pub const L8 : Self = Self (0x05) ; # [doc = "Color mode AL44"]
pub const AL44 : Self = Self (0x06) ; # [doc = "Color mode AL88"]
pub const AL88 : Self = Self (0x07) ; # [doc = "Color mode L4"]
pub const L4 : Self = Self (0x08) ; # [doc = "Color mode A8"]
pub const A8 : Self = Self (0x09) ; # [doc = "Color mode A4"]
pub const A4 : Self = Self (0x0a) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cctcif (pub u8) ; impl Cctcif { # [doc = "Clear the CTCIF flag in the ISR register"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct FgpfccrCcm (pub u8) ; impl FgpfccrCcm { # [doc = "CLUT color format ARGB8888"]
pub const ARGB8888 : Self = Self (0) ; # [doc = "CLUT color format RGB888"]
pub const RGB888 : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct FgpfccrStart (pub u8) ; impl FgpfccrStart { # [doc = "Start the automatic loading of the CLUT"]
pub const START : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Twie (pub u8) ; impl Twie { # [doc = "TW interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "TW interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } } pub mod regs { # [doc = "foreground color register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fgcolr (pub u32) ; impl Fgcolr { # [doc = "Blue Value"]
pub const fn blue (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Blue Value"]
pub fn set_blue (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Green Value"]
pub const fn green (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Green Value"]
pub fn set_green (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "Red Value"]
pub const fn red (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Red Value"]
pub fn set_red (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } } impl Default for Fgcolr { fn default () -> Fgcolr { Fgcolr (0) } } # [doc = "BGCLUT"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bgclut (pub u32) ; impl Bgclut { # [doc = "BLUE"]
pub const fn blue (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "BLUE"]
pub fn set_blue (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "GREEN"]
pub const fn green (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "GREEN"]
pub fn set_green (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "RED"]
pub const fn red (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "RED"]
pub fn set_red (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } # [doc = "APLHA"]
pub const fn aplha (& self) -> u8 { let val = (self . 0 >> 24usize) & 0xff ; val as u8 } # [doc = "APLHA"]
pub fn set_aplha (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 24usize)) | (((val as u32) & 0xff) << 24usize) ; } } impl Default for Bgclut { fn default () -> Bgclut { Bgclut (0) } } # [doc = "AHB master timer configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Amtcr (pub u32) ; impl Amtcr { # [doc = "Enable"]
pub const fn en (& self) -> super :: vals :: En { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: En (val as u8) } # [doc = "Enable"]
pub fn set_en (& mut self , val : super :: vals :: En) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Dead Time"]
pub const fn dt (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Dead Time"]
pub fn set_dt (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } } impl Default for Amtcr { fn default () -> Amtcr { Amtcr (0) } } # [doc = "background offset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bgor (pub u32) ; impl Bgor { # [doc = "Line offset"]
pub const fn lo (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x3fff ; val as u16 } # [doc = "Line offset"]
pub fn set_lo (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x3fff << 0usize)) | (((val as u32) & 0x3fff) << 0usize) ; } } impl Default for Bgor { fn default () -> Bgor { Bgor (0) } } # [doc = "background memory address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bgmar (pub u32) ; impl Bgmar { # [doc = "Memory address"]
pub const fn ma (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Memory address"]
pub fn set_ma (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bgmar { fn default () -> Bgmar { Bgmar (0) } } # [doc = "output color register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ocolr (pub u32) ; impl Ocolr { # [doc = "Blue Value"]
pub const fn blue (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Blue Value"]
pub fn set_blue (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Green Value"]
pub const fn green (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Green Value"]
pub fn set_green (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "Red Value"]
pub const fn red (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Red Value"]
pub fn set_red (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } # [doc = "Alpha Channel Value"]
pub const fn aplha (& self) -> u8 { let val = (self . 0 >> 24usize) & 0xff ; val as u8 } # [doc = "Alpha Channel Value"]
pub fn set_aplha (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 24usize)) | (((val as u32) & 0xff) << 24usize) ; } } impl Default for Ocolr { fn default () -> Ocolr { Ocolr (0) } } # [doc = "line watermark register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Lwr (pub u32) ; impl Lwr { # [doc = "Line watermark"]
pub const fn lw (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Line watermark"]
pub fn set_lw (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Lwr { fn default () -> Lwr { Lwr (0) } } # [doc = "background PFC control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bgpfccr (pub u32) ; impl Bgpfccr { # [doc = "Color mode"]
pub const fn cm (& self) -> super :: vals :: BgpfccrCm { let val = (self . 0 >> 0usize) & 0x0f ; super :: vals :: BgpfccrCm (val as u8) } # [doc = "Color mode"]
pub fn set_cm (& mut self , val : super :: vals :: BgpfccrCm) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val . 0 as u32) & 0x0f) << 0usize) ; } # [doc = "CLUT Color mode"]
pub const fn ccm (& self) -> super :: vals :: BgpfccrCcm { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: BgpfccrCcm (val as u8) } # [doc = "CLUT Color mode"]
pub fn set_ccm (& mut self , val : super :: vals :: BgpfccrCcm) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "Start"]
pub const fn start (& self) -> super :: vals :: BgpfccrStart { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: BgpfccrStart (val as u8) } # [doc = "Start"]
pub fn set_start (& mut self , val : super :: vals :: BgpfccrStart) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "CLUT size"]
pub const fn cs (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "CLUT size"]
pub fn set_cs (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "Alpha mode"]
pub const fn am (& self) -> super :: vals :: BgpfccrAm { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: BgpfccrAm (val as u8) } # [doc = "Alpha mode"]
pub fn set_am (& mut self , val : super :: vals :: BgpfccrAm) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } # [doc = "Alpha value"]
pub const fn alpha (& self) -> u8 { let val = (self . 0 >> 24usize) & 0xff ; val as u8 } # [doc = "Alpha value"]
pub fn set_alpha (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 24usize)) | (((val as u32) & 0xff) << 24usize) ; } } impl Default for Bgpfccr { fn default () -> Bgpfccr { Bgpfccr (0) } } # [doc = "output offset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Oor (pub u32) ; impl Oor { # [doc = "Line Offset"]
pub const fn lo (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x3fff ; val as u16 } # [doc = "Line Offset"]
pub fn set_lo (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x3fff << 0usize)) | (((val as u32) & 0x3fff) << 0usize) ; } } impl Default for Oor { fn default () -> Oor { Oor (0) } } # [doc = "background color register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bgcolr (pub u32) ; impl Bgcolr { # [doc = "Blue Value"]
pub const fn blue (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Blue Value"]
pub fn set_blue (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Green Value"]
pub const fn green (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Green Value"]
pub fn set_green (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "Red Value"]
pub const fn red (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Red Value"]
pub fn set_red (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } } impl Default for Bgcolr { fn default () -> Bgcolr { Bgcolr (0) } } # [doc = "output memory address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Omar (pub u32) ; impl Omar { # [doc = "Memory Address"]
pub const fn ma (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Memory Address"]
pub fn set_ma (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Omar { fn default () -> Omar { Omar (0) } } # [doc = "number of line register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Nlr (pub u32) ; impl Nlr { # [doc = "Number of lines"]
pub const fn nl (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Number of lines"]
pub fn set_nl (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "Pixel per lines"]
pub const fn pl (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x3fff ; val as u16 } # [doc = "Pixel per lines"]
pub fn set_pl (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x3fff << 16usize)) | (((val as u32) & 0x3fff) << 16usize) ; } } impl Default for Nlr { fn default () -> Nlr { Nlr (0) } } # [doc = "foreground CLUT memory address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fgcmar (pub u32) ; impl Fgcmar { # [doc = "Memory Address"]
pub const fn ma (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Memory Address"]
pub fn set_ma (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Fgcmar { fn default () -> Fgcmar { Fgcmar (0) } } # [doc = "output PFC control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Opfccr (pub u32) ; impl Opfccr { # [doc = "Color mode"]
pub const fn cm (& self) -> super :: vals :: OpfccrCm { let val = (self . 0 >> 0usize) & 0x07 ; super :: vals :: OpfccrCm (val as u8) } # [doc = "Color mode"]
pub fn set_cm (& mut self , val : super :: vals :: OpfccrCm) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val . 0 as u32) & 0x07) << 0usize) ; } } impl Default for Opfccr { fn default () -> Opfccr { Opfccr (0) } } # [doc = "interrupt flag clear register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ifcr (pub u32) ; impl Ifcr { # [doc = "Clear Transfer error interrupt flag"]
pub const fn cteif (& self) -> super :: vals :: Cteif { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Cteif (val as u8) } # [doc = "Clear Transfer error interrupt flag"]
pub fn set_cteif (& mut self , val : super :: vals :: Cteif) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Clear transfer complete interrupt flag"]
pub const fn ctcif (& self) -> super :: vals :: Ctcif { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Ctcif (val as u8) } # [doc = "Clear transfer complete interrupt flag"]
pub fn set_ctcif (& mut self , val : super :: vals :: Ctcif) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Clear transfer watermark interrupt flag"]
pub const fn ctwif (& self) -> super :: vals :: Ctwif { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Ctwif (val as u8) } # [doc = "Clear transfer watermark interrupt flag"]
pub fn set_ctwif (& mut self , val : super :: vals :: Ctwif) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Clear CLUT access error interrupt flag"]
pub const fn caecif (& self) -> super :: vals :: Caecif { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Caecif (val as u8) } # [doc = "Clear CLUT access error interrupt flag"]
pub fn set_caecif (& mut self , val : super :: vals :: Caecif) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "Clear CLUT transfer complete interrupt flag"]
pub const fn cctcif (& self) -> super :: vals :: Cctcif { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Cctcif (val as u8) } # [doc = "Clear CLUT transfer complete interrupt flag"]
pub fn set_cctcif (& mut self , val : super :: vals :: Cctcif) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "Clear configuration error interrupt flag"]
pub const fn cceif (& self) -> super :: vals :: Cceif { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Cceif (val as u8) } # [doc = "Clear configuration error interrupt flag"]
pub fn set_cceif (& mut self , val : super :: vals :: Cceif) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } } impl Default for Ifcr { fn default () -> Ifcr { Ifcr (0) } } # [doc = "Interrupt Status Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Isr (pub u32) ; impl Isr { # [doc = "Transfer error interrupt flag"]
pub const fn teif (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Transfer error interrupt flag"]
pub fn set_teif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Transfer complete interrupt flag"]
pub const fn tcif (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Transfer complete interrupt flag"]
pub fn set_tcif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Transfer watermark interrupt flag"]
pub const fn twif (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Transfer watermark interrupt flag"]
pub fn set_twif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "CLUT access error interrupt flag"]
pub const fn caeif (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "CLUT access error interrupt flag"]
pub fn set_caeif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "CLUT transfer complete interrupt flag"]
pub const fn ctcif (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "CLUT transfer complete interrupt flag"]
pub fn set_ctcif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Configuration error interrupt flag"]
pub const fn ceif (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Configuration error interrupt flag"]
pub fn set_ceif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } } impl Default for Isr { fn default () -> Isr { Isr (0) } } # [doc = "foreground offset register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fgor (pub u32) ; impl Fgor { # [doc = "Line offset"]
pub const fn lo (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x3fff ; val as u16 } # [doc = "Line offset"]
pub fn set_lo (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x3fff << 0usize)) | (((val as u32) & 0x3fff) << 0usize) ; } } impl Default for Fgor { fn default () -> Fgor { Fgor (0) } } # [doc = "control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Start"]
pub const fn start (& self) -> super :: vals :: CrStart { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: CrStart (val as u8) } # [doc = "Start"]
pub fn set_start (& mut self , val : super :: vals :: CrStart) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Suspend"]
pub const fn susp (& self) -> super :: vals :: Susp { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Susp (val as u8) } # [doc = "Suspend"]
pub fn set_susp (& mut self , val : super :: vals :: Susp) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Abort"]
pub const fn abort (& self) -> super :: vals :: Abort { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Abort (val as u8) } # [doc = "Abort"]
pub fn set_abort (& mut self , val : super :: vals :: Abort) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Transfer error interrupt enable"]
pub const fn teie (& self) -> super :: vals :: Teie { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Teie (val as u8) } # [doc = "Transfer error interrupt enable"]
pub fn set_teie (& mut self , val : super :: vals :: Teie) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "Transfer complete interrupt enable"]
pub const fn tcie (& self) -> super :: vals :: Tcie { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Tcie (val as u8) } # [doc = "Transfer complete interrupt enable"]
pub fn set_tcie (& mut self , val : super :: vals :: Tcie) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "Transfer watermark interrupt enable"]
pub const fn twie (& self) -> super :: vals :: Twie { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Twie (val as u8) } # [doc = "Transfer watermark interrupt enable"]
pub fn set_twie (& mut self , val : super :: vals :: Twie) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "CLUT access error interrupt enable"]
pub const fn caeie (& self) -> super :: vals :: Caeie { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Caeie (val as u8) } # [doc = "CLUT access error interrupt enable"]
pub fn set_caeie (& mut self , val : super :: vals :: Caeie) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "CLUT transfer complete interrupt enable"]
pub const fn ctcie (& self) -> super :: vals :: Ctcie { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: Ctcie (val as u8) } # [doc = "CLUT transfer complete interrupt enable"]
pub fn set_ctcie (& mut self , val : super :: vals :: Ctcie) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } # [doc = "Configuration Error Interrupt Enable"]
pub const fn ceie (& self) -> super :: vals :: Ceie { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: Ceie (val as u8) } # [doc = "Configuration Error Interrupt Enable"]
pub fn set_ceie (& mut self , val : super :: vals :: Ceie) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } # [doc = "DMA2D mode"]
pub const fn mode (& self) -> super :: vals :: Mode { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: Mode (val as u8) } # [doc = "DMA2D mode"]
pub fn set_mode (& mut self , val : super :: vals :: Mode) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "FGCLUT"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fgclut (pub u32) ; impl Fgclut { # [doc = "BLUE"]
pub const fn blue (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "BLUE"]
pub fn set_blue (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "GREEN"]
pub const fn green (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "GREEN"]
pub fn set_green (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "RED"]
pub const fn red (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "RED"]
pub fn set_red (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } # [doc = "APLHA"]
pub const fn aplha (& self) -> u8 { let val = (self . 0 >> 24usize) & 0xff ; val as u8 } # [doc = "APLHA"]
pub fn set_aplha (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 24usize)) | (((val as u32) & 0xff) << 24usize) ; } } impl Default for Fgclut { fn default () -> Fgclut { Fgclut (0) } } # [doc = "background CLUT memory address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Bgcmar (pub u32) ; impl Bgcmar { # [doc = "Memory address"]
pub const fn ma (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Memory address"]
pub fn set_ma (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Bgcmar { fn default () -> Bgcmar { Bgcmar (0) } } # [doc = "foreground memory address register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fgmar (pub u32) ; impl Fgmar { # [doc = "Memory address"]
pub const fn ma (& self) -> u32 { let val = (self . 0 >> 0usize) & 0xffff_ffff ; val as u32 } # [doc = "Memory address"]
pub fn set_ma (& mut self , val : u32) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Fgmar { fn default () -> Fgmar { Fgmar (0) } } # [doc = "foreground PFC control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fgpfccr (pub u32) ; impl Fgpfccr { # [doc = "Color mode"]
pub const fn cm (& self) -> super :: vals :: FgpfccrCm { let val = (self . 0 >> 0usize) & 0x0f ; super :: vals :: FgpfccrCm (val as u8) } # [doc = "Color mode"]
pub fn set_cm (& mut self , val : super :: vals :: FgpfccrCm) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val . 0 as u32) & 0x0f) << 0usize) ; } # [doc = "CLUT color mode"]
pub const fn ccm (& self) -> super :: vals :: FgpfccrCcm { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: FgpfccrCcm (val as u8) } # [doc = "CLUT color mode"]
pub fn set_ccm (& mut self , val : super :: vals :: FgpfccrCcm) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "Start"]
pub const fn start (& self) -> super :: vals :: FgpfccrStart { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: FgpfccrStart (val as u8) } # [doc = "Start"]
pub fn set_start (& mut self , val : super :: vals :: FgpfccrStart) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "CLUT size"]
pub const fn cs (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "CLUT size"]
pub fn set_cs (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "Alpha mode"]
pub const fn am (& self) -> super :: vals :: FgpfccrAm { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: FgpfccrAm (val as u8) } # [doc = "Alpha mode"]
pub fn set_am (& mut self , val : super :: vals :: FgpfccrAm) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } # [doc = "Alpha value"]
pub const fn alpha (& self) -> u8 { let val = (self . 0 >> 24usize) & 0xff ; val as u8 } # [doc = "Alpha value"]
pub fn set_alpha (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 24usize)) | (((val as u32) & 0xff) << 24usize) ; } } impl Default for Fgpfccr { fn default () -> Fgpfccr { Fgpfccr (0) } } }