

# [doc = "Digital camera interface"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dcmi (pub * mut u8) ; unsafe impl Send for Dcmi { } unsafe impl Sync for Dcmi { } impl Dcmi { # [doc = "control register 1"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "raw interrupt status register"]
pub fn ris (self) -> crate :: common :: Reg < regs :: Ris , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "interrupt enable register"]
pub fn ier (self) -> crate :: common :: Reg < regs :: Ier , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "masked interrupt status register"]
pub fn mis (self) -> crate :: common :: Reg < regs :: Mis , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "interrupt clear register"]
pub fn icr (self) -> crate :: common :: Reg < regs :: Icr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "embedded synchronization code register"]
pub fn escr (self) -> crate :: common :: Reg < regs :: Escr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "embedded synchronization unmask register"]
pub fn esur (self) -> crate :: common :: Reg < regs :: Esur , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "crop window start"]
pub fn cwstrt (self) -> crate :: common :: Reg < regs :: Cwstrt , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "crop window size"]
pub fn cwsize (self) -> crate :: common :: Reg < regs :: Cwsize , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "data register"]
pub fn dr (self) -> crate :: common :: Reg < regs :: Dr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } } pub mod regs { # [doc = "status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr (pub u32) ; impl Sr { # [doc = "HSYNC"]
pub const fn hsync (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "HSYNC"]
pub fn set_hsync (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "VSYNC"]
pub const fn vsync (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "VSYNC"]
pub fn set_vsync (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "FIFO not empty"]
pub const fn fne (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "FIFO not empty"]
pub fn set_fne (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } } impl Default for Sr { fn default () -> Sr { Sr (0) } } # [doc = "interrupt clear register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Icr (pub u32) ; impl Icr { # [doc = "Capture complete interrupt status clear"]
pub const fn frame_isc (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Capture complete interrupt status clear"]
pub fn set_frame_isc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Overrun interrupt status clear"]
pub const fn ovr_isc (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Overrun interrupt status clear"]
pub fn set_ovr_isc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Synchronization error interrupt status clear"]
pub const fn err_isc (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Synchronization error interrupt status clear"]
pub fn set_err_isc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Vertical synch interrupt status clear"]
pub const fn vsync_isc (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Vertical synch interrupt status clear"]
pub fn set_vsync_isc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "line interrupt status clear"]
pub const fn line_isc (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "line interrupt status clear"]
pub fn set_line_isc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } } impl Default for Icr { fn default () -> Icr { Icr (0) } } # [doc = "data register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dr (pub u32) ; impl Dr { # [doc = "Data byte 0"]
pub const fn byte0 (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Data byte 0"]
pub fn set_byte0 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Data byte 1"]
pub const fn byte1 (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Data byte 1"]
pub fn set_byte1 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "Data byte 2"]
pub const fn byte2 (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Data byte 2"]
pub fn set_byte2 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } # [doc = "Data byte 3"]
pub const fn byte3 (& self) -> u8 { let val = (self . 0 >> 24usize) & 0xff ; val as u8 } # [doc = "Data byte 3"]
pub fn set_byte3 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 24usize)) | (((val as u32) & 0xff) << 24usize) ; } } impl Default for Dr { fn default () -> Dr { Dr (0) } } # [doc = "crop window start"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cwstrt (pub u32) ; impl Cwstrt { # [doc = "Horizontal offset count"]
pub const fn hoffcnt (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x3fff ; val as u16 } # [doc = "Horizontal offset count"]
pub fn set_hoffcnt (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x3fff << 0usize)) | (((val as u32) & 0x3fff) << 0usize) ; } # [doc = "Vertical start line count"]
pub const fn vst (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x1fff ; val as u16 } # [doc = "Vertical start line count"]
pub fn set_vst (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x1fff << 16usize)) | (((val as u32) & 0x1fff) << 16usize) ; } } impl Default for Cwstrt { fn default () -> Cwstrt { Cwstrt (0) } } # [doc = "embedded synchronization unmask register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Esur (pub u32) ; impl Esur { # [doc = "Frame start delimiter unmask"]
pub const fn fsu (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Frame start delimiter unmask"]
pub fn set_fsu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Line start delimiter unmask"]
pub const fn lsu (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Line start delimiter unmask"]
pub fn set_lsu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "Line end delimiter unmask"]
pub const fn leu (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Line end delimiter unmask"]
pub fn set_leu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } # [doc = "Frame end delimiter unmask"]
pub const fn feu (& self) -> u8 { let val = (self . 0 >> 24usize) & 0xff ; val as u8 } # [doc = "Frame end delimiter unmask"]
pub fn set_feu (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 24usize)) | (((val as u32) & 0xff) << 24usize) ; } } impl Default for Esur { fn default () -> Esur { Esur (0) } } # [doc = "interrupt enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ier (pub u32) ; impl Ier { # [doc = "Capture complete interrupt enable"]
pub const fn frame_ie (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Capture complete interrupt enable"]
pub fn set_frame_ie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Overrun interrupt enable"]
pub const fn ovr_ie (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Overrun interrupt enable"]
pub fn set_ovr_ie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Synchronization error interrupt enable"]
pub const fn err_ie (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Synchronization error interrupt enable"]
pub fn set_err_ie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "VSYNC interrupt enable"]
pub const fn vsync_ie (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "VSYNC interrupt enable"]
pub fn set_vsync_ie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Line interrupt enable"]
pub const fn line_ie (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Line interrupt enable"]
pub fn set_line_ie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } } impl Default for Ier { fn default () -> Ier { Ier (0) } } # [doc = "raw interrupt status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ris (pub u32) ; impl Ris { # [doc = "Capture complete raw interrupt status"]
pub const fn frame_ris (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Capture complete raw interrupt status"]
pub fn set_frame_ris (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Overrun raw interrupt status"]
pub const fn ovr_ris (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Overrun raw interrupt status"]
pub fn set_ovr_ris (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Synchronization error raw interrupt status"]
pub const fn err_ris (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Synchronization error raw interrupt status"]
pub fn set_err_ris (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "VSYNC raw interrupt status"]
pub const fn vsync_ris (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "VSYNC raw interrupt status"]
pub fn set_vsync_ris (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Line raw interrupt status"]
pub const fn line_ris (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Line raw interrupt status"]
pub fn set_line_ris (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } } impl Default for Ris { fn default () -> Ris { Ris (0) } } # [doc = "crop window size"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cwsize (pub u32) ; impl Cwsize { # [doc = "Capture count"]
pub const fn capcnt (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x3fff ; val as u16 } # [doc = "Capture count"]
pub fn set_capcnt (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x3fff << 0usize)) | (((val as u32) & 0x3fff) << 0usize) ; } # [doc = "Vertical line count"]
pub const fn vline (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x3fff ; val as u16 } # [doc = "Vertical line count"]
pub fn set_vline (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x3fff << 16usize)) | (((val as u32) & 0x3fff) << 16usize) ; } } impl Default for Cwsize { fn default () -> Cwsize { Cwsize (0) } } # [doc = "masked interrupt status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Mis (pub u32) ; impl Mis { # [doc = "Capture complete masked interrupt status"]
pub const fn frame_mis (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Capture complete masked interrupt status"]
pub fn set_frame_mis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Overrun masked interrupt status"]
pub const fn ovr_mis (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Overrun masked interrupt status"]
pub fn set_ovr_mis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Synchronization error masked interrupt status"]
pub const fn err_mis (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Synchronization error masked interrupt status"]
pub fn set_err_mis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "VSYNC masked interrupt status"]
pub const fn vsync_mis (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "VSYNC masked interrupt status"]
pub fn set_vsync_mis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Line masked interrupt status"]
pub const fn line_mis (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Line masked interrupt status"]
pub fn set_line_mis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } } impl Default for Mis { fn default () -> Mis { Mis (0) } } # [doc = "embedded synchronization code register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Escr (pub u32) ; impl Escr { # [doc = "Frame start delimiter code"]
pub const fn fsc (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "Frame start delimiter code"]
pub fn set_fsc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "Line start delimiter code"]
pub const fn lsc (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "Line start delimiter code"]
pub fn set_lsc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "Line end delimiter code"]
pub const fn lec (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Line end delimiter code"]
pub fn set_lec (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } # [doc = "Frame end delimiter code"]
pub const fn fec (& self) -> u8 { let val = (self . 0 >> 24usize) & 0xff ; val as u8 } # [doc = "Frame end delimiter code"]
pub fn set_fec (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 24usize)) | (((val as u32) & 0xff) << 24usize) ; } } impl Default for Escr { fn default () -> Escr { Escr (0) } } # [doc = "control register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Capture enable"]
pub const fn capture (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Capture enable"]
pub fn set_capture (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Capture mode"]
pub const fn cm (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Capture mode"]
pub fn set_cm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Crop feature"]
pub const fn crop (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Crop feature"]
pub fn set_crop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "JPEG format"]
pub const fn jpeg (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "JPEG format"]
pub fn set_jpeg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Embedded synchronization select"]
pub const fn ess (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Embedded synchronization select"]
pub fn set_ess (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Pixel clock polarity"]
pub const fn pckpol (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Pixel clock polarity"]
pub fn set_pckpol (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Horizontal synchronization polarity"]
pub const fn hspol (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Horizontal synchronization polarity"]
pub fn set_hspol (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Vertical synchronization polarity"]
pub const fn vspol (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Vertical synchronization polarity"]
pub fn set_vspol (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Frame capture rate control"]
pub const fn fcrc (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x03 ; val as u8 } # [doc = "Frame capture rate control"]
pub fn set_fcrc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val as u32) & 0x03) << 8usize) ; } # [doc = "Extended data mode"]
pub const fn edm (& self) -> u8 { let val = (self . 0 >> 10usize) & 0x03 ; val as u8 } # [doc = "Extended data mode"]
pub fn set_edm (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 10usize)) | (((val as u32) & 0x03) << 10usize) ; } # [doc = "DCMI enable"]
pub const fn enable (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "DCMI enable"]
pub fn set_enable (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } }