

# [doc = "Microcontroller Debug Unit"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dbgmcu (pub * mut u8) ; unsafe impl Send for Dbgmcu { } unsafe impl Sync for Dbgmcu { } impl Dbgmcu { # [doc = "Identity Code Register"]
pub fn idcoder (self) -> crate :: common :: Reg < regs :: Idcoder , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Configuration Register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "CPU1 APB1 Peripheral Freeze Register 1"]
pub fn apb1fzr1 (self) -> crate :: common :: Reg < regs :: Apb1fzr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (60usize)) } } # [doc = "CPU2 APB1 Peripheral Freeze Register 1 [dual core device"]
pub fn c2apb1fzr1 (self) -> crate :: common :: Reg < regs :: C2apb1fzr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (64usize)) } } # [doc = "CPU1 APB1 Peripheral Freeze Register 2"]
pub fn apb1fzr2 (self) -> crate :: common :: Reg < regs :: Apb1fzr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (68usize)) } } # [doc = "CPU2 APB1 Peripheral Freeze Register 2 [dual core device"]
pub fn c2apb1fzr2 (self) -> crate :: common :: Reg < regs :: C2apb1fzr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "CPU1 APB2 Peripheral Freeze Register"]
pub fn apb2fzr (self) -> crate :: common :: Reg < regs :: Apb2fzr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } # [doc = "CPU2 APB2 Peripheral Freeze Register [dual core device"]
pub fn c2apb2fzr (self) -> crate :: common :: Reg < regs :: C2apb2fzr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (80usize)) } } } pub mod regs { # [doc = "CPU2 APB1 Peripheral Freeze Register 1 [dual core device"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apb1fzr1 (pub u32) ; impl C2apb1fzr1 { # [doc = "TIM2"]
pub const fn tim2 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2"]
pub fn set_tim2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "RTC"]
pub const fn rtc (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "RTC"]
pub fn set_rtc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "IWDG"]
pub const fn iwdg (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "IWDG"]
pub fn set_iwdg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "I2C1"]
pub const fn i2c1 (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1"]
pub fn set_i2c1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2"]
pub const fn i2c2 (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2"]
pub fn set_i2c2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "I2C3"]
pub const fn i2c3 (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "I2C3"]
pub fn set_i2c3 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "LPTIM1"]
pub const fn lptim1 (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "LPTIM1"]
pub fn set_lptim1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for C2apb1fzr1 { fn default () -> C2apb1fzr1 { C2apb1fzr1 (0) } } # [doc = "CPU1 APB1 Peripheral Freeze Register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1fzr2 (pub u32) ; impl Apb1fzr2 { # [doc = "LPTIM2"]
pub const fn lptim2 (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "LPTIM2"]
pub fn set_lptim2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "LPTIM3"]
pub const fn lptim3 (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "LPTIM3"]
pub fn set_lptim3 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } } impl Default for Apb1fzr2 { fn default () -> Apb1fzr2 { Apb1fzr2 (0) } } # [doc = "CPU1 APB2 Peripheral Freeze Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2fzr (pub u32) ; impl Apb2fzr { # [doc = "TIM1"]
pub const fn tim1 (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1"]
pub fn set_tim1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "TIM16"]
pub const fn tim16 (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16"]
pub fn set_tim16 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17"]
pub const fn tim17 (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17"]
pub fn set_tim17 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } } impl Default for Apb2fzr { fn default () -> Apb2fzr { Apb2fzr (0) } } # [doc = "CPU2 APB2 Peripheral Freeze Register [dual core device"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apb2fzr (pub u32) ; impl C2apb2fzr { # [doc = "TIM1"]
pub const fn tim1 (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1"]
pub fn set_tim1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "TIM16"]
pub const fn tim16 (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16"]
pub fn set_tim16 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17"]
pub const fn tim17 (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17"]
pub fn set_tim17 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } } impl Default for C2apb2fzr { fn default () -> C2apb2fzr { C2apb2fzr (0) } } # [doc = "Identity Code Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Idcoder (pub u32) ; impl Idcoder { # [doc = "Device ID"]
pub const fn dev_id (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Device ID"]
pub fn set_dev_id (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "Revision"]
pub const fn rev_id (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Revision"]
pub fn set_rev_id (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for Idcoder { fn default () -> Idcoder { Idcoder (0) } } # [doc = "CPU1 APB1 Peripheral Freeze Register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1fzr1 (pub u32) ; impl Apb1fzr1 { # [doc = "TIM2 stop in CPU1 debug"]
pub const fn tim2 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 stop in CPU1 debug"]
pub fn set_tim2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "RTC stop in CPU1 debug"]
pub const fn rtc (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "RTC stop in CPU1 debug"]
pub fn set_rtc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "WWDG stop in CPU1 debug"]
pub const fn wwdg (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "WWDG stop in CPU1 debug"]
pub fn set_wwdg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "IWDG stop in CPU1 debug"]
pub const fn iwdg (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "IWDG stop in CPU1 debug"]
pub fn set_iwdg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "I2C1 SMBUS timeout stop in CPU1 debug"]
pub const fn i2c1 (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 SMBUS timeout stop in CPU1 debug"]
pub fn set_i2c1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 SMBUS timeout stop in CPU1 debug"]
pub const fn i2c2 (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 SMBUS timeout stop in CPU1 debug"]
pub fn set_i2c2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "I2C3 SMBUS timeout stop in CPU1 debug"]
pub const fn i2c3 (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "I2C3 SMBUS timeout stop in CPU1 debug"]
pub fn set_i2c3 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "LPTIM1 stop in CPU1 debug"]
pub const fn lptim1 (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "LPTIM1 stop in CPU1 debug"]
pub fn set_lptim1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb1fzr1 { fn default () -> Apb1fzr1 { Apb1fzr1 (0) } } # [doc = "CPU2 APB1 Peripheral Freeze Register 2 [dual core device"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apb1fzr2 (pub u32) ; impl C2apb1fzr2 { # [doc = "LPTIM2"]
pub const fn lptim2 (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "LPTIM2"]
pub fn set_lptim2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "LPTIM3"]
pub const fn lptim3 (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "LPTIM3"]
pub fn set_lptim3 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } } impl Default for C2apb1fzr2 { fn default () -> C2apb1fzr2 { C2apb1fzr2 (0) } } # [doc = "Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Allow debug in SLEEP mode"]
pub const fn dbg_sleep (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Allow debug in SLEEP mode"]
pub fn set_dbg_sleep (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Allow debug in STOP mode"]
pub const fn dbg_stop (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Allow debug in STOP mode"]
pub fn set_dbg_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Allow debug in STANDBY mode"]
pub const fn dbg_standby (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Allow debug in STANDBY mode"]
pub fn set_dbg_standby (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } }