

# [doc = "Debug support"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dbgmcu (pub * mut u8) ; unsafe impl Send for Dbgmcu { } unsafe impl Sync for Dbgmcu { } impl Dbgmcu { # [doc = "MCU Device ID Code Register"]
pub fn idcode (self) -> crate :: common :: Reg < regs :: Idcode , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Debug MCU Configuration Register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "APB1 Low Freeze Register CPU1"]
pub fn apb1fzr1 (self) -> crate :: common :: Reg < regs :: Apb1fzr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (60usize)) } } # [doc = "APB1 Low Freeze Register CPU2"]
pub fn c2ap_b1fzr1 (self) -> crate :: common :: Reg < regs :: C2apB1fzr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (64usize)) } } # [doc = "APB1 High Freeze Register CPU1"]
pub fn apb1fzr2 (self) -> crate :: common :: Reg < regs :: Apb1fzr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (68usize)) } } # [doc = "APB1 High Freeze Register CPU2"]
pub fn c2apb1fzr2 (self) -> crate :: common :: Reg < regs :: C2apb1fzr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "APB2 Freeze Register CPU2"]
pub fn c2apb2fzr (self) -> crate :: common :: Reg < regs :: C2apb2fzr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "APB2 Freeze Register CPU1"]
pub fn apb2fzr (self) -> crate :: common :: Reg < regs :: Apb2fzr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } } pub mod regs { # [doc = "APB2 Freeze Register CPU2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apb2fzr (pub u32) ; impl C2apb2fzr { # [doc = "TIM1 counter stopped when core is halted"]
pub const fn tim1 (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1 counter stopped when core is halted"]
pub fn set_tim1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "TIM16 counter stopped when core is halted"]
pub const fn tim16 (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 counter stopped when core is halted"]
pub fn set_tim16 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 counter stopped when core is halted"]
pub const fn tim17 (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 counter stopped when core is halted"]
pub fn set_tim17 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } } impl Default for C2apb2fzr { fn default () -> C2apb2fzr { C2apb2fzr (0) } } # [doc = "APB1 High Freeze Register CPU1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1fzr2 (pub u32) ; impl Apb1fzr2 { # [doc = "LPTIM2 counter stopped when core is halted"]
pub const fn lptim2 (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "LPTIM2 counter stopped when core is halted"]
pub fn set_lptim2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } } impl Default for Apb1fzr2 { fn default () -> Apb1fzr2 { Apb1fzr2 (0) } } # [doc = "APB1 Low Freeze Register CPU2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apB1fzr1 (pub u32) ; impl C2apB1fzr1 { # [doc = "LPTIM2 counter stopped when core is halted"]
pub const fn lptim2 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "LPTIM2 counter stopped when core is halted"]
pub fn set_lptim2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "RTC counter stopped when core is halted"]
pub const fn rtc (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "RTC counter stopped when core is halted"]
pub fn set_rtc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "IWDG stopped when core is halted"]
pub const fn iwdg (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "IWDG stopped when core is halted"]
pub fn set_iwdg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "I2C1 SMBUS timeout stopped when core is halted"]
pub const fn i2c1 (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 SMBUS timeout stopped when core is halted"]
pub fn set_i2c1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C3 SMBUS timeout stopped when core is halted"]
pub const fn i2c3 (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "I2C3 SMBUS timeout stopped when core is halted"]
pub fn set_i2c3 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "LPTIM1 counter stopped when core is halted"]
pub const fn lptim1 (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "LPTIM1 counter stopped when core is halted"]
pub fn set_lptim1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for C2apB1fzr1 { fn default () -> C2apB1fzr1 { C2apB1fzr1 (0) } } # [doc = "MCU Device ID Code Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Idcode (pub u32) ; impl Idcode { # [doc = "Device Identifier"]
pub const fn dev_id (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Device Identifier"]
pub fn set_dev_id (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "Revision Identifier"]
pub const fn rev_id (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Revision Identifier"]
pub fn set_rev_id (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for Idcode { fn default () -> Idcode { Idcode (0) } } # [doc = "APB1 High Freeze Register CPU2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct C2apb1fzr2 (pub u32) ; impl C2apb1fzr2 { # [doc = "LPTIM2 counter stopped when core is halted"]
pub const fn lptim2 (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "LPTIM2 counter stopped when core is halted"]
pub fn set_lptim2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } } impl Default for C2apb1fzr2 { fn default () -> C2apb1fzr2 { C2apb1fzr2 (0) } } # [doc = "Debug MCU Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Debug Sleep Mode"]
pub const fn dbg_sleep (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Debug Sleep Mode"]
pub fn set_dbg_sleep (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Debug Stop Mode"]
pub const fn dbg_stop (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Debug Stop Mode"]
pub fn set_dbg_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Debug Standby Mode"]
pub const fn dbg_standby (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Debug Standby Mode"]
pub fn set_dbg_standby (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Trace port and clock enable"]
pub const fn trace_ioen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Trace port and clock enable"]
pub fn set_trace_ioen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "External trigger output enable"]
pub const fn trgoen (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "External trigger output enable"]
pub fn set_trgoen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "APB2 Freeze Register CPU1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2fzr (pub u32) ; impl Apb2fzr { # [doc = "TIM1 counter stopped when core is halted"]
pub const fn tim1 (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1 counter stopped when core is halted"]
pub fn set_tim1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "TIM16 counter stopped when core is halted"]
pub const fn tim16 (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 counter stopped when core is halted"]
pub fn set_tim16 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 counter stopped when core is halted"]
pub const fn tim17 (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 counter stopped when core is halted"]
pub fn set_tim17 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } } impl Default for Apb2fzr { fn default () -> Apb2fzr { Apb2fzr (0) } } # [doc = "APB1 Low Freeze Register CPU1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1fzr1 (pub u32) ; impl Apb1fzr1 { # [doc = "Debug Timer 2 stopped when Core is halted"]
pub const fn tim2 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Debug Timer 2 stopped when Core is halted"]
pub fn set_tim2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "RTC counter stopped when core is halted"]
pub const fn rtc (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "RTC counter stopped when core is halted"]
pub fn set_rtc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "WWDG counter stopped when core is halted"]
pub const fn wwdg (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "WWDG counter stopped when core is halted"]
pub fn set_wwdg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "IWDG counter stopped when core is halted"]
pub const fn iwdg (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "IWDG counter stopped when core is halted"]
pub fn set_iwdg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Debug I2C1 SMBUS timeout stopped when Core is halted"]
pub const fn i2c1 (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Debug I2C1 SMBUS timeout stopped when Core is halted"]
pub fn set_i2c1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Debug I2C3 SMBUS timeout stopped when core is halted"]
pub const fn i2c3 (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Debug I2C3 SMBUS timeout stopped when core is halted"]
pub fn set_i2c3 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Debug LPTIM1 stopped when Core is halted"]
pub const fn lptim1 (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "Debug LPTIM1 stopped when Core is halted"]
pub fn set_lptim1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb1fzr1 { fn default () -> Apb1fzr1 { Apb1fzr1 (0) } } }