

# [doc = "debug support"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dbgmcu (pub * mut u8) ; unsafe impl Send for Dbgmcu { } unsafe impl Sync for Dbgmcu { } impl Dbgmcu { # [doc = "DBGMCU_IDCODE"]
pub fn idcode (self) -> crate :: common :: Reg < regs :: Idcode , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Debug MCU configuration register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Debug MCU APB1 freeze register1"]
pub fn apb1_fz (self) -> crate :: common :: Reg < regs :: Apb1Fz , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Debug MCU APB1 freeze register 2"]
pub fn apb2_fz (self) -> crate :: common :: Reg < regs :: Apb2Fz , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } } pub mod regs { # [doc = "Debug MCU configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Debug Sleep mode"]
pub const fn dbg_sleep (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Debug Sleep mode"]
pub fn set_dbg_sleep (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Debug Stop mode"]
pub const fn dbg_stop (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Debug Stop mode"]
pub fn set_dbg_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Debug Standby mode"]
pub const fn dbg_standby (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Debug Standby mode"]
pub fn set_dbg_standby (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Trace pin assignment control"]
pub const fn trace_ioen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Trace pin assignment control"]
pub fn set_trace_ioen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Trace pin assignment control"]
pub const fn trace_mode (& self) -> u8 { let val = (self . 0 >> 6usize) & 0x03 ; val as u8 } # [doc = "Trace pin assignment control"]
pub fn set_trace_mode (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 6usize)) | (((val as u32) & 0x03) << 6usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "Debug MCU APB1 freeze register1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1Fz (pub u32) ; impl Apb1Fz { # [doc = "TIM2 counter stopped when core is halted"]
pub const fn dbg_tim2_stop (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 counter stopped when core is halted"]
pub fn set_dbg_tim2_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM3 counter stopped when core is halted"]
pub const fn dbg_tim3_stop (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM3 counter stopped when core is halted"]
pub fn set_dbg_tim3_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TIM4 counter stopped when core is halted"]
pub const fn dbg_tim4_stop (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM4 counter stopped when core is halted"]
pub fn set_dbg_tim4_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM5 counter stopped when core is halted"]
pub const fn dbg_tim5_stop (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "TIM5 counter stopped when core is halted"]
pub fn set_dbg_tim5_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "TIM6 counter stopped when core is halted"]
pub const fn dbg_tim6_stop (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TIM6 counter stopped when core is halted"]
pub fn set_dbg_tim6_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TIM7 counter stopped when core is halted"]
pub const fn dbg_tim7_stop (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM7 counter stopped when core is halted"]
pub fn set_dbg_tim7_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Debug RTC stopped when core is halted"]
pub const fn dbg_rtc_stop (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Debug RTC stopped when core is halted"]
pub fn set_dbg_rtc_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Debug window watchdog stopped when core is halted"]
pub const fn dbg_wwdg_stop (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Debug window watchdog stopped when core is halted"]
pub fn set_dbg_wwdg_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "Debug independent watchdog stopped when core is halted"]
pub const fn dbg_iwdg_stop (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Debug independent watchdog stopped when core is halted"]
pub fn set_dbg_iwdg_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "SMBUS timeout mode stopped when core is halted"]
pub const fn dbg_i2c1_smbus_timeout (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "SMBUS timeout mode stopped when core is halted"]
pub fn set_dbg_i2c1_smbus_timeout (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "SMBUS timeout mode stopped when core is halted"]
pub const fn dbg_i2c2_smbus_timeout (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "SMBUS timeout mode stopped when core is halted"]
pub fn set_dbg_i2c2_smbus_timeout (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } } impl Default for Apb1Fz { fn default () -> Apb1Fz { Apb1Fz (0) } } # [doc = "Debug MCU APB1 freeze register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2Fz (pub u32) ; impl Apb2Fz { # [doc = "TIM counter stopped when core is halted"]
pub const fn dbg_tim9_stop (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM counter stopped when core is halted"]
pub fn set_dbg_tim9_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM counter stopped when core is halted"]
pub const fn dbg_tim10_stop (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "TIM counter stopped when core is halted"]
pub fn set_dbg_tim10_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "TIM counter stopped when core is halted"]
pub const fn dbg_tim11_stop (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TIM counter stopped when core is halted"]
pub fn set_dbg_tim11_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } } impl Default for Apb2Fz { fn default () -> Apb2Fz { Apb2Fz (0) } } # [doc = "DBGMCU_IDCODE"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Idcode (pub u32) ; impl Idcode { # [doc = "Device identifier"]
pub const fn dev_id (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Device identifier"]
pub fn set_dev_id (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "Revision identifie"]
pub const fn rev_id (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Revision identifie"]
pub fn set_rev_id (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for Idcode { fn default () -> Idcode { Idcode (0) } } }