

# [doc = "Debug support"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dbgmcu (pub * mut u8) ; unsafe impl Send for Dbgmcu { } unsafe impl Sync for Dbgmcu { } impl Dbgmcu { # [doc = "MCU Device ID Code Register"]
pub fn idcode (self) -> crate :: common :: Reg < regs :: Idcode , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Debug MCU Configuration Register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "APB Low Freeze Register"]
pub fn apb1fzr (self) -> crate :: common :: Reg < regs :: Apb1fzr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "APB High Freeze Register"]
pub fn apb2fzr (self) -> crate :: common :: Reg < regs :: Apb2fzr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } } pub mod regs { # [doc = "APB Low Freeze Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1fzr (pub u32) ; impl Apb1fzr { # [doc = "Debug Timer 2 stopped when Core is halted"]
pub const fn tim2 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Debug Timer 2 stopped when Core is halted"]
pub fn set_tim2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Debug Timer 6 stopped when Core is halted"]
pub const fn tim6 (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Debug Timer 6 stopped when Core is halted"]
pub fn set_tim6 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Debug RTC stopped when Core is halted"]
pub const fn rtc (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Debug RTC stopped when Core is halted"]
pub fn set_rtc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Debug Window Wachdog stopped when Core is halted"]
pub const fn wwdg (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Debug Window Wachdog stopped when Core is halted"]
pub fn set_wwdg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "Debug Independent Wachdog stopped when Core is halted"]
pub const fn iwdg (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Debug Independent Wachdog stopped when Core is halted"]
pub fn set_iwdg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "I2C1 SMBUS timeout mode stopped when core is halted"]
pub const fn i2c1 (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "I2C1 SMBUS timeout mode stopped when core is halted"]
pub fn set_i2c1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "I2C2 SMBUS timeout mode stopped when core is halted"]
pub const fn i2c2 (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "I2C2 SMBUS timeout mode stopped when core is halted"]
pub fn set_i2c2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "LPTIM1 counter stopped when core is halted"]
pub const fn lptim (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "LPTIM1 counter stopped when core is halted"]
pub fn set_lptim (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Apb1fzr { fn default () -> Apb1fzr { Apb1fzr (0) } } # [doc = "MCU Device ID Code Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Idcode (pub u32) ; impl Idcode { # [doc = "Device Identifier"]
pub const fn dev_id (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Device Identifier"]
pub fn set_dev_id (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "Revision Identifier"]
pub const fn rev_id (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Revision Identifier"]
pub fn set_rev_id (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for Idcode { fn default () -> Idcode { Idcode (0) } } # [doc = "APB High Freeze Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2fzr (pub u32) ; impl Apb2fzr { # [doc = "Debug Timer 21 stopped when Core is halted"]
pub const fn tim21 (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Debug Timer 21 stopped when Core is halted"]
pub fn set_tim21 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Debug Timer 22 stopped when Core is halted"]
pub const fn tim22 (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Debug Timer 22 stopped when Core is halted"]
pub fn set_tim22 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } } impl Default for Apb2fzr { fn default () -> Apb2fzr { Apb2fzr (0) } } # [doc = "Debug MCU Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Debug Sleep Mode"]
pub const fn dbg_sleep (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Debug Sleep Mode"]
pub fn set_dbg_sleep (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Debug Stop Mode"]
pub const fn dbg_stop (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Debug Stop Mode"]
pub fn set_dbg_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Debug Standby Mode"]
pub const fn dbg_standby (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Debug Standby Mode"]
pub fn set_dbg_standby (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } }