

# [doc = "Debug support"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dbgmcu (pub * mut u8) ; unsafe impl Send for Dbgmcu { } unsafe impl Sync for Dbgmcu { } impl Dbgmcu { # [doc = "IDCODE"]
pub fn idcode (self) -> crate :: common :: Reg < regs :: Idcode , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Control Register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Debug MCU APB1 Freeze register"]
pub fn apb1fzr (self) -> crate :: common :: Reg < regs :: Apb1fzr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Debug MCU APB2 Freeze register"]
pub fn apb2fzr (self) -> crate :: common :: Reg < regs :: Apb2fzr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } } pub mod regs { # [doc = "Debug MCU APB2 Freeze register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2fzr (pub u32) ; impl Apb2fzr { # [doc = "TIM1 counter stopped when core is halted"]
pub const fn tim1 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM1 counter stopped when core is halted"]
pub fn set_tim1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM8 counter stopped when core is halted"]
pub const fn tim8 (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM8 counter stopped when core is halted"]
pub fn set_tim8 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TIM9 counter stopped when core is halted"]
pub const fn tim9 (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM9 counter stopped when core is halted"]
pub fn set_tim9 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM10 counter stopped when core is halted"]
pub const fn tim10 (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM10 counter stopped when core is halted"]
pub fn set_tim10 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM11 counter stopped when core is halted"]
pub const fn tim11 (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM11 counter stopped when core is halted"]
pub fn set_tim11 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } } impl Default for Apb2fzr { fn default () -> Apb2fzr { Apb2fzr (0) } } # [doc = "IDCODE"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Idcode (pub u32) ; impl Idcode { # [doc = "DEV_ID"]
pub const fn dev_id (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "DEV_ID"]
pub fn set_dev_id (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "REV_ID"]
pub const fn rev_id (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "REV_ID"]
pub fn set_rev_id (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for Idcode { fn default () -> Idcode { Idcode (0) } } # [doc = "Control Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "DBG_SLEEP"]
pub const fn dbg_sleep (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DBG_SLEEP"]
pub fn set_dbg_sleep (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DBG_STOP"]
pub const fn dbg_stop (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DBG_STOP"]
pub fn set_dbg_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "DBG_STANDBY"]
pub const fn dbg_standby (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "DBG_STANDBY"]
pub fn set_dbg_standby (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TRACE_IOEN"]
pub const fn trace_ioen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TRACE_IOEN"]
pub fn set_trace_ioen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "TRACE_MODE"]
pub const fn trace_mode (& self) -> u8 { let val = (self . 0 >> 6usize) & 0x03 ; val as u8 } # [doc = "TRACE_MODE"]
pub fn set_trace_mode (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 6usize)) | (((val as u32) & 0x03) << 6usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "Debug MCU APB1 Freeze register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1fzr (pub u32) ; impl Apb1fzr { # [doc = "TIM2"]
pub const fn tim2 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2"]
pub fn set_tim2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM3"]
pub const fn tim3 (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM3"]
pub fn set_tim3 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TIM4"]
pub const fn tim4 (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TIM4"]
pub fn set_tim4 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "TIM5"]
pub const fn tim5 (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "TIM5"]
pub fn set_tim5 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "TIM6"]
pub const fn tim6 (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TIM6"]
pub fn set_tim6 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TIM7"]
pub const fn tim7 (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM7"]
pub fn set_tim7 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "TIM12"]
pub const fn tim12 (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "TIM12"]
pub fn set_tim12 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "TIM13"]
pub const fn tim13 (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "TIM13"]
pub fn set_tim13 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "TIM14"]
pub const fn tim14 (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "TIM14"]
pub fn set_tim14 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "LPTIM1"]
pub const fn lptim1 (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "LPTIM1"]
pub fn set_lptim1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "RTC"]
pub const fn rtc (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "RTC"]
pub fn set_rtc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "WWDG"]
pub const fn wwdg (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "WWDG"]
pub fn set_wwdg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "IWDG"]
pub const fn iwdg (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "IWDG"]
pub fn set_iwdg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "CAN3"]
pub const fn can3 (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "CAN3"]
pub fn set_can3 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "DBG_I2C1_SMBUS_TIMEOUT"]
pub const fn dbg_i2c1_smbus_timeout (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "DBG_I2C1_SMBUS_TIMEOUT"]
pub fn set_dbg_i2c1_smbus_timeout (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "DBG_I2C2_SMBUS_TIMEOUT"]
pub const fn dbg_i2c2_smbus_timeout (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "DBG_I2C2_SMBUS_TIMEOUT"]
pub fn set_dbg_i2c2_smbus_timeout (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "DBG_I2C3_SMBUS_TIMEOUT"]
pub const fn dbg_i2c3_smbus_timeout (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "DBG_I2C3_SMBUS_TIMEOUT"]
pub fn set_dbg_i2c3_smbus_timeout (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "DBG_I2C4SMBUS_TIMEOUT"]
pub const fn dbg_i2c4_smbus_timeout (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "DBG_I2C4SMBUS_TIMEOUT"]
pub fn set_dbg_i2c4_smbus_timeout (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "CAN1"]
pub const fn can1 (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "CAN1"]
pub fn set_can1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "CAN2"]
pub const fn can2 (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "CAN2"]
pub fn set_can2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } } impl Default for Apb1fzr { fn default () -> Apb1fzr { Apb1fzr (0) } } }