

# [doc = "Debug support"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dbgmcu (pub * mut u8) ; unsafe impl Send for Dbgmcu { } unsafe impl Sync for Dbgmcu { } impl Dbgmcu { # [doc = "MCU Device ID Code Register"]
pub fn idcode (self) -> crate :: common :: Reg < regs :: Idcode , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Debug MCU Configuration Register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "APB Low Freeze Register"]
pub fn apb1fzr (self) -> crate :: common :: Reg < regs :: Apb1fzr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "APB High Freeze Register"]
pub fn apb2fzr (self) -> crate :: common :: Reg < regs :: Apb2fzr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } } pub mod regs { # [doc = "Debug MCU Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Debug Sleep mode"]
pub const fn dbg_sleep (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Debug Sleep mode"]
pub fn set_dbg_sleep (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Debug Stop Mode"]
pub const fn dbg_stop (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Debug Stop Mode"]
pub fn set_dbg_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Debug Standby Mode"]
pub const fn dbg_standby (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Debug Standby Mode"]
pub fn set_dbg_standby (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Trace pin assignment control"]
pub const fn trace_ioen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Trace pin assignment control"]
pub fn set_trace_ioen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Trace pin assignment control"]
pub const fn trace_mode (& self) -> u8 { let val = (self . 0 >> 6usize) & 0x03 ; val as u8 } # [doc = "Trace pin assignment control"]
pub fn set_trace_mode (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 6usize)) | (((val as u32) & 0x03) << 6usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "MCU Device ID Code Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Idcode (pub u32) ; impl Idcode { # [doc = "Device Identifier"]
pub const fn dev_id (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Device Identifier"]
pub fn set_dev_id (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "Revision Identifier"]
pub const fn rev_id (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Revision Identifier"]
pub fn set_rev_id (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for Idcode { fn default () -> Idcode { Idcode (0) } } # [doc = "APB High Freeze Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2fzr (pub u32) ; impl Apb2fzr { # [doc = "Debug Timer 15 stopped when Core is halted"]
pub const fn tim15 (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Debug Timer 15 stopped when Core is halted"]
pub fn set_tim15 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Debug Timer 16 stopped when Core is halted"]
pub const fn tim16 (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Debug Timer 16 stopped when Core is halted"]
pub fn set_tim16 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Debug Timer 17 stopped when Core is halted"]
pub const fn tim17 (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Debug Timer 17 stopped when Core is halted"]
pub fn set_tim17 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Debug Timer 19 stopped when Core is halted"]
pub const fn tim19 (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Debug Timer 19 stopped when Core is halted"]
pub fn set_tim19 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } } impl Default for Apb2fzr { fn default () -> Apb2fzr { Apb2fzr (0) } } # [doc = "APB Low Freeze Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1fzr (pub u32) ; impl Apb1fzr { # [doc = "Debug Timer 2 stopped when Core is halted"]
pub const fn tim2 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Debug Timer 2 stopped when Core is halted"]
pub fn set_tim2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Debug Timer 3 stopped when Core is halted"]
pub const fn tim3 (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Debug Timer 3 stopped when Core is halted"]
pub fn set_tim3 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Debug Timer 4 stopped when Core is halted"]
pub const fn tim4 (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Debug Timer 4 stopped when Core is halted"]
pub fn set_tim4 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Debug Timer 5 stopped when Core is halted"]
pub const fn tim5 (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Debug Timer 5 stopped when Core is halted"]
pub fn set_tim5 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Debug Timer 6 stopped when Core is halted"]
pub const fn tim6 (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Debug Timer 6 stopped when Core is halted"]
pub fn set_tim6 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "Debug Timer 7 stopped when Core is halted"]
pub const fn tim7 (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Debug Timer 7 stopped when Core is halted"]
pub fn set_tim7 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Debug Timer 12 stopped when Core is halted"]
pub const fn tim12 (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Debug Timer 12 stopped when Core is halted"]
pub fn set_tim12 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Debug Timer 13 stopped when Core is halted"]
pub const fn tim13 (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Debug Timer 13 stopped when Core is halted"]
pub fn set_tim13 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Debug Timer 14 stopped when Core is halted"]
pub const fn tim14 (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Debug Timer 14 stopped when Core is halted"]
pub fn set_tim14 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Debug Timer 18 stopped when Core is halted"]
pub const fn tim18 (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Debug Timer 18 stopped when Core is halted"]
pub fn set_tim18 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Debug RTC stopped when Core is halted"]
pub const fn rtc (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Debug RTC stopped when Core is halted"]
pub fn set_rtc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Debug Window Wachdog stopped when Core is halted"]
pub const fn wwdg (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Debug Window Wachdog stopped when Core is halted"]
pub fn set_wwdg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "Debug Independent Wachdog stopped when Core is halted"]
pub const fn iwdg (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Debug Independent Wachdog stopped when Core is halted"]
pub fn set_iwdg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "SMBUS timeout mode stopped when Core is halted"]
pub const fn i2c1_smbus_timeout (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "SMBUS timeout mode stopped when Core is halted"]
pub fn set_i2c1_smbus_timeout (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "SMBUS timeout mode stopped when Core is halted"]
pub const fn i2c2_smbus_timeout (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "SMBUS timeout mode stopped when Core is halted"]
pub fn set_i2c2_smbus_timeout (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Debug CAN stopped when core is halted"]
pub const fn can (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Debug CAN stopped when core is halted"]
pub fn set_can (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for Apb1fzr { fn default () -> Apb1fzr { Apb1fzr (0) } } }