

# [doc = "Debug support"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dbgmcu (pub * mut u8) ; unsafe impl Send for Dbgmcu { } unsafe impl Sync for Dbgmcu { } impl Dbgmcu { # [doc = "MCU Device ID Code Register"]
pub fn idcode (self) -> crate :: common :: Reg < regs :: Idcode , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Debug MCU Configuration Register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Debug MCU APB1 freeze register"]
pub fn apb1_fz (self) -> crate :: common :: Reg < regs :: Apb1Fz , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Debug MCU APB2 freeze register"]
pub fn apb2_fz (self) -> crate :: common :: Reg < regs :: Apb2Fz , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } } pub mod regs { # [doc = "Debug MCU APB1 freeze register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb1Fz (pub u32) ; impl Apb1Fz { # [doc = "TIM2 counter stopped when core is halted"]
pub const fn tim2 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TIM2 counter stopped when core is halted"]
pub fn set_tim2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "TIM3 counter stopped when core is halted"]
pub const fn tim3 (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "TIM3 counter stopped when core is halted"]
pub fn set_tim3 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TIM6 counter stopped when core is halted"]
pub const fn tim6 (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "TIM6 counter stopped when core is halted"]
pub fn set_tim6 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TIM7 counter stopped when core is halted"]
pub const fn tim7 (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "TIM7 counter stopped when core is halted"]
pub fn set_tim7 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "TIM14 counter stopped when core is halted"]
pub const fn tim14 (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "TIM14 counter stopped when core is halted"]
pub fn set_tim14 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Debug RTC stopped when core is halted"]
pub const fn rtc (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Debug RTC stopped when core is halted"]
pub fn set_rtc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Debug window watchdog stopped when core is halted"]
pub const fn wwdg (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Debug window watchdog stopped when core is halted"]
pub fn set_wwdg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "Debug independent watchdog stopped when core is halted"]
pub const fn iwdg (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Debug independent watchdog stopped when core is halted"]
pub fn set_iwdg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "SMBUS timeout mode stopped when core is halted"]
pub const fn dbg_i2c1_smbus_timeout (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "SMBUS timeout mode stopped when core is halted"]
pub fn set_dbg_i2c1_smbus_timeout (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "CAN stopped when core is halted"]
pub const fn can (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "CAN stopped when core is halted"]
pub fn set_can (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } } impl Default for Apb1Fz { fn default () -> Apb1Fz { Apb1Fz (0) } } # [doc = "Debug MCU Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Debug Stop Mode"]
pub const fn dbg_stop (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Debug Stop Mode"]
pub fn set_dbg_stop (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Debug Standby Mode"]
pub const fn dbg_standby (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Debug Standby Mode"]
pub fn set_dbg_standby (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "Debug MCU APB2 freeze register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Apb2Fz (pub u32) ; impl Apb2Fz { # [doc = "TIM1 counter stopped when core is halted"]
pub const fn tim1 (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "TIM1 counter stopped when core is halted"]
pub fn set_tim1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "TIM15 counter stopped when core is halted"]
pub const fn tim15 (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "TIM15 counter stopped when core is halted"]
pub fn set_tim15 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "TIM16 counter stopped when core is halted"]
pub const fn tim16 (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "TIM16 counter stopped when core is halted"]
pub fn set_tim16 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "TIM17 counter stopped when core is halted"]
pub const fn tim17 (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "TIM17 counter stopped when core is halted"]
pub fn set_tim17 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } } impl Default for Apb2Fz { fn default () -> Apb2Fz { Apb2Fz (0) } } # [doc = "MCU Device ID Code Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Idcode (pub u32) ; impl Idcode { # [doc = "Device Identifier"]
pub const fn dev_id (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Device Identifier"]
pub fn set_dev_id (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "Division Identifier"]
pub const fn div_id (& self) -> u8 { let val = (self . 0 >> 12usize) & 0x0f ; val as u8 } # [doc = "Division Identifier"]
pub fn set_div_id (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 12usize)) | (((val as u32) & 0x0f) << 12usize) ; } # [doc = "Revision Identifier"]
pub const fn rev_id (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Revision Identifier"]
pub fn set_rev_id (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for Idcode { fn default () -> Idcode { Idcode (0) } } }