

# [doc = "Digital-to-analog converter"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dac (pub * mut u8) ; unsafe impl Send for Dac { } unsafe impl Sync for Dac { } impl Dac { # [doc = "control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "software trigger register"]
pub fn swtrigr (self) -> crate :: common :: Reg < regs :: Swtrigr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "channel1 12-bit right-aligned data holding register"]
pub fn dhr12r1 (self) -> crate :: common :: Reg < regs :: Dhr12r1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "channel1 12-bit left-aligned data holding register"]
pub fn dhr12l1 (self) -> crate :: common :: Reg < regs :: Dhr12l1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "channel1 8-bit right-aligned data holding register"]
pub fn dhr8r1 (self) -> crate :: common :: Reg < regs :: Dhr8r1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "channel2 12-bit right aligned data holding register"]
pub fn dhr12r2 (self) -> crate :: common :: Reg < regs :: Dhr12r2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "channel2 12-bit left aligned data holding register"]
pub fn dhr12l2 (self) -> crate :: common :: Reg < regs :: Dhr12l2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "channel2 8-bit right-aligned data holding register"]
pub fn dhr8r2 (self) -> crate :: common :: Reg < regs :: Dhr8r2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "Dual DAC 12-bit right-aligned data holding register"]
pub fn dhr12rd (self) -> crate :: common :: Reg < regs :: Dhr12rd , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "DUAL DAC 12-bit left aligned data holding register"]
pub fn dhr12ld (self) -> crate :: common :: Reg < regs :: Dhr12ld , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "DUAL DAC 8-bit right aligned data holding register"]
pub fn dhr8rd (self) -> crate :: common :: Reg < regs :: Dhr8rd , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "channel1 data output register"]
pub fn dor1 (self) -> crate :: common :: Reg < regs :: Dor1 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "channel2 data output register"]
pub fn dor2 (self) -> crate :: common :: Reg < regs :: Dor2 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize)) } } # [doc = "calibration control register"]
pub fn ccr (self) -> crate :: common :: Reg < regs :: Ccr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } # [doc = "mode control register"]
pub fn mcr (self) -> crate :: common :: Reg < regs :: Mcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (60usize)) } } # [doc = "Sample and Hold sample time register 1"]
pub fn shsr1 (self) -> crate :: common :: Reg < regs :: Shsr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (64usize)) } } # [doc = "Sample and Hold sample time register 2"]
pub fn shsr2 (self) -> crate :: common :: Reg < regs :: Shsr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (68usize)) } } # [doc = "Sample and Hold hold time register"]
pub fn shhr (self) -> crate :: common :: Reg < regs :: Shhr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (72usize)) } } # [doc = "Sample and Hold refresh time register"]
pub fn shrr (self) -> crate :: common :: Reg < regs :: Shrr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tsel2 (pub u8) ; impl Tsel2 { # [doc = "Timer 6 TRGO event"]
pub const TIM6_TRGO : Self = Self (0) ; # [doc = "Timer 8 TRGO event"]
pub const TIM8_TRGO : Self = Self (0x01) ; # [doc = "Timer 7 TRGO event"]
pub const TIM7_TRGO : Self = Self (0x02) ; # [doc = "Timer 5 TRGO event"]
pub const TIM5_TRGO : Self = Self (0x03) ; # [doc = "Timer 2 TRGO event"]
pub const TIM2_TRGO : Self = Self (0x04) ; # [doc = "Timer 4 TRGO event"]
pub const TIM4_TRGO : Self = Self (0x05) ; # [doc = "EXTI line9"]
pub const EXTI9 : Self = Self (0x06) ; # [doc = "Software trigger"]
pub const SOFTWARE : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wave (pub u8) ; impl Wave { # [doc = "Wave generation disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Noise wave generation enabled"]
pub const NOISE : Self = Self (0x01) ; # [doc = "Triangle wave generation enabled"]
pub const TRIANGLE : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tsel1 (pub u8) ; impl Tsel1 { # [doc = "Timer 6 TRGO event"]
pub const TIM6_TRGO : Self = Self (0) ; # [doc = "Timer 3 TRGO event"]
pub const TIM3_TRGO : Self = Self (0x01) ; # [doc = "Timer 7 TRGO event"]
pub const TIM7_TRGO : Self = Self (0x02) ; # [doc = "Timer 15 TRGO event"]
pub const TIM15_TRGO : Self = Self (0x03) ; # [doc = "Timer 2 TRGO event"]
pub const TIM2_TRGO : Self = Self (0x04) ; # [doc = "EXTI line9"]
pub const EXTI9 : Self = Self (0x06) ; # [doc = "Software trigger"]
pub const SOFTWARE : Self = Self (0x07) ; } } pub mod regs { # [doc = "status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr (pub u32) ; impl Sr { # [doc = "DAC channel1 DMA underrun flag"]
pub const fn dmaudr1 (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "DAC channel1 DMA underrun flag"]
pub fn set_dmaudr1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "DAC Channel 1 calibration offset status"]
pub const fn cal_flag1 (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "DAC Channel 1 calibration offset status"]
pub fn set_cal_flag1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "DAC Channel 1 busy writing sample time flag"]
pub const fn bwst1 (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "DAC Channel 1 busy writing sample time flag"]
pub fn set_bwst1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "DAC channel2 DMA underrun flag"]
pub const fn dmaudr2 (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC channel2 DMA underrun flag"]
pub fn set_dmaudr2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "DAC Channel 2 calibration offset status"]
pub const fn cal_flag2 (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "DAC Channel 2 calibration offset status"]
pub fn set_cal_flag2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "DAC Channel 2 busy writing sample time flag"]
pub const fn bwst2 (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "DAC Channel 2 busy writing sample time flag"]
pub fn set_bwst2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Sr { fn default () -> Sr { Sr (0) } } # [doc = "calibration control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ccr (pub u32) ; impl Ccr { # [doc = "DAC Channel 1 offset trimming value"]
pub const fn otrim1 (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x1f ; val as u8 } # [doc = "DAC Channel 1 offset trimming value"]
pub fn set_otrim1 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 0usize)) | (((val as u32) & 0x1f) << 0usize) ; } # [doc = "DAC Channel 2 offset trimming value"]
pub const fn otrim2 (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x1f ; val as u8 } # [doc = "DAC Channel 2 offset trimming value"]
pub fn set_otrim2 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 16usize)) | (((val as u32) & 0x1f) << 16usize) ; } } impl Default for Ccr { fn default () -> Ccr { Ccr (0) } } # [doc = "channel2 12-bit left aligned data holding register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dhr12l2 (pub u32) ; impl Dhr12l2 { # [doc = "DAC channel2 12-bit left-aligned data"]
pub const fn dacc2dhr (& self) -> u16 { let val = (self . 0 >> 4usize) & 0x0fff ; val as u16 } # [doc = "DAC channel2 12-bit left-aligned data"]
pub fn set_dacc2dhr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 4usize)) | (((val as u32) & 0x0fff) << 4usize) ; } } impl Default for Dhr12l2 { fn default () -> Dhr12l2 { Dhr12l2 (0) } } # [doc = "control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "DAC channel1 enable"]
pub const fn en1 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DAC channel1 enable"]
pub fn set_en1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DAC channel1 trigger enable"]
pub const fn ten1 (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "DAC channel1 trigger enable"]
pub fn set_ten1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "DAC channel1 trigger selection"]
pub const fn tsel1 (& self) -> super :: vals :: Tsel1 { let val = (self . 0 >> 3usize) & 0x07 ; super :: vals :: Tsel1 (val as u8) } # [doc = "DAC channel1 trigger selection"]
pub fn set_tsel1 (& mut self , val : super :: vals :: Tsel1) { self . 0 = (self . 0 & ! (0x07 << 3usize)) | (((val . 0 as u32) & 0x07) << 3usize) ; } # [doc = "DAC channel1 noise/triangle wave generation enable"]
pub const fn wave1 (& self) -> super :: vals :: Wave { let val = (self . 0 >> 6usize) & 0x03 ; super :: vals :: Wave (val as u8) } # [doc = "DAC channel1 noise/triangle wave generation enable"]
pub fn set_wave1 (& mut self , val : super :: vals :: Wave) { self . 0 = (self . 0 & ! (0x03 << 6usize)) | (((val . 0 as u32) & 0x03) << 6usize) ; } # [doc = "DAC channel1 mask/amplitude selector"]
pub const fn mamp1 (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "DAC channel1 mask/amplitude selector"]
pub fn set_mamp1 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "DAC channel1 DMA enable"]
pub const fn dmaen1 (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "DAC channel1 DMA enable"]
pub fn set_dmaen1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "DAC channel1 DMA Underrun Interrupt enable"]
pub const fn dmaudrie1 (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "DAC channel1 DMA Underrun Interrupt enable"]
pub fn set_dmaudrie1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "DAC Channel 1 calibration enable"]
pub const fn cen1 (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "DAC Channel 1 calibration enable"]
pub fn set_cen1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "DAC channel2 enable"]
pub const fn en2 (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "DAC channel2 enable"]
pub fn set_en2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "DAC channel2 trigger enable"]
pub const fn ten2 (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "DAC channel2 trigger enable"]
pub fn set_ten2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "DAC channel2 trigger selection"]
pub const fn tsel2 (& self) -> super :: vals :: Tsel2 { let val = (self . 0 >> 19usize) & 0x07 ; super :: vals :: Tsel2 (val as u8) } # [doc = "DAC channel2 trigger selection"]
pub fn set_tsel2 (& mut self , val : super :: vals :: Tsel2) { self . 0 = (self . 0 & ! (0x07 << 19usize)) | (((val . 0 as u32) & 0x07) << 19usize) ; } # [doc = "DAC channel2 noise/triangle wave generation enable"]
pub const fn wave2 (& self) -> super :: vals :: Wave { let val = (self . 0 >> 22usize) & 0x03 ; super :: vals :: Wave (val as u8) } # [doc = "DAC channel2 noise/triangle wave generation enable"]
pub fn set_wave2 (& mut self , val : super :: vals :: Wave) { self . 0 = (self . 0 & ! (0x03 << 22usize)) | (((val . 0 as u32) & 0x03) << 22usize) ; } # [doc = "DAC channel2 mask/amplitude selector"]
pub const fn mamp2 (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x0f ; val as u8 } # [doc = "DAC channel2 mask/amplitude selector"]
pub fn set_mamp2 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 24usize)) | (((val as u32) & 0x0f) << 24usize) ; } # [doc = "DAC channel2 DMA enable"]
pub const fn dmaen2 (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "DAC channel2 DMA enable"]
pub fn set_dmaen2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "DAC channel2 DMA underrun interrupt enable"]
pub const fn dmaudrie2 (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DAC channel2 DMA underrun interrupt enable"]
pub fn set_dmaudrie2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "DAC Channel 2 calibration enable"]
pub const fn cen2 (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "DAC Channel 2 calibration enable"]
pub fn set_cen2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "channel2 12-bit right aligned data holding register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dhr12r2 (pub u32) ; impl Dhr12r2 { # [doc = "DAC channel2 12-bit right-aligned data"]
pub const fn dacc2dhr (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "DAC channel2 12-bit right-aligned data"]
pub fn set_dacc2dhr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } } impl Default for Dhr12r2 { fn default () -> Dhr12r2 { Dhr12r2 (0) } } # [doc = "Sample and Hold sample time register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Shsr2 (pub u32) ; impl Shsr2 { # [doc = "DAC Channel 2 sample Time"]
pub const fn tsample2 (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x03ff ; val as u16 } # [doc = "DAC Channel 2 sample Time"]
pub fn set_tsample2 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x03ff << 0usize)) | (((val as u32) & 0x03ff) << 0usize) ; } } impl Default for Shsr2 { fn default () -> Shsr2 { Shsr2 (0) } } # [doc = "Sample and Hold refresh time register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Shrr (pub u32) ; impl Shrr { # [doc = "DAC Channel 1 refresh Time"]
pub const fn trefresh1 (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "DAC Channel 1 refresh Time"]
pub fn set_trefresh1 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "DAC Channel 2 refresh Time"]
pub const fn trefresh2 (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "DAC Channel 2 refresh Time"]
pub fn set_trefresh2 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } } impl Default for Shrr { fn default () -> Shrr { Shrr (0) } } # [doc = "DUAL DAC 12-bit left aligned data holding register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dhr12ld (pub u32) ; impl Dhr12ld { # [doc = "DAC channel1 12-bit left-aligned data"]
pub const fn dacc1dhr (& self) -> u16 { let val = (self . 0 >> 4usize) & 0x0fff ; val as u16 } # [doc = "DAC channel1 12-bit left-aligned data"]
pub fn set_dacc1dhr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 4usize)) | (((val as u32) & 0x0fff) << 4usize) ; } # [doc = "DAC channel2 12-bit left-aligned data"]
pub const fn dacc2dhr (& self) -> u16 { let val = (self . 0 >> 20usize) & 0x0fff ; val as u16 } # [doc = "DAC channel2 12-bit left-aligned data"]
pub fn set_dacc2dhr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 20usize)) | (((val as u32) & 0x0fff) << 20usize) ; } } impl Default for Dhr12ld { fn default () -> Dhr12ld { Dhr12ld (0) } } # [doc = "channel1 data output register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dor1 (pub u32) ; impl Dor1 { # [doc = "DAC channel1 data output"]
pub const fn dacc1dor (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "DAC channel1 data output"]
pub fn set_dacc1dor (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } } impl Default for Dor1 { fn default () -> Dor1 { Dor1 (0) } } # [doc = "channel2 8-bit right-aligned data holding register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dhr8r2 (pub u32) ; impl Dhr8r2 { # [doc = "DAC channel2 8-bit right-aligned data"]
pub const fn dacc2dhr (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "DAC channel2 8-bit right-aligned data"]
pub fn set_dacc2dhr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } } impl Default for Dhr8r2 { fn default () -> Dhr8r2 { Dhr8r2 (0) } } # [doc = "channel1 12-bit left-aligned data holding register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dhr12l1 (pub u32) ; impl Dhr12l1 { # [doc = "DAC channel1 12-bit left-aligned data"]
pub const fn dacc1dhr (& self) -> u16 { let val = (self . 0 >> 4usize) & 0x0fff ; val as u16 } # [doc = "DAC channel1 12-bit left-aligned data"]
pub fn set_dacc1dhr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 4usize)) | (((val as u32) & 0x0fff) << 4usize) ; } } impl Default for Dhr12l1 { fn default () -> Dhr12l1 { Dhr12l1 (0) } } # [doc = "channel2 data output register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dor2 (pub u32) ; impl Dor2 { # [doc = "DAC channel2 data output"]
pub const fn dacc2dor (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "DAC channel2 data output"]
pub fn set_dacc2dor (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } } impl Default for Dor2 { fn default () -> Dor2 { Dor2 (0) } } # [doc = "software trigger register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Swtrigr (pub u32) ; impl Swtrigr { # [doc = "DAC channel1 software trigger"]
pub const fn swtrig1 (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DAC channel1 software trigger"]
pub fn set_swtrig1 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DAC channel2 software trigger"]
pub const fn swtrig2 (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DAC channel2 software trigger"]
pub fn set_swtrig2 (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } } impl Default for Swtrigr { fn default () -> Swtrigr { Swtrigr (0) } } # [doc = "DUAL DAC 8-bit right aligned data holding register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dhr8rd (pub u32) ; impl Dhr8rd { # [doc = "DAC channel1 8-bit right-aligned data"]
pub const fn dacc1dhr (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "DAC channel1 8-bit right-aligned data"]
pub fn set_dacc1dhr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "DAC channel2 8-bit right-aligned data"]
pub const fn dacc2dhr (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "DAC channel2 8-bit right-aligned data"]
pub fn set_dacc2dhr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } } impl Default for Dhr8rd { fn default () -> Dhr8rd { Dhr8rd (0) } } # [doc = "channel1 8-bit right-aligned data holding register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dhr8r1 (pub u32) ; impl Dhr8r1 { # [doc = "DAC channel1 8-bit right-aligned data"]
pub const fn dacc1dhr (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "DAC channel1 8-bit right-aligned data"]
pub fn set_dacc1dhr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } } impl Default for Dhr8r1 { fn default () -> Dhr8r1 { Dhr8r1 (0) } } # [doc = "mode control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Mcr (pub u32) ; impl Mcr { # [doc = "DAC Channel 1 mode"]
pub const fn mode1 (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x07 ; val as u8 } # [doc = "DAC Channel 1 mode"]
pub fn set_mode1 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 0usize)) | (((val as u32) & 0x07) << 0usize) ; } # [doc = "DAC Channel 2 mode"]
pub const fn mode2 (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x07 ; val as u8 } # [doc = "DAC Channel 2 mode"]
pub fn set_mode2 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 16usize)) | (((val as u32) & 0x07) << 16usize) ; } } impl Default for Mcr { fn default () -> Mcr { Mcr (0) } } # [doc = "channel1 12-bit right-aligned data holding register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dhr12r1 (pub u32) ; impl Dhr12r1 { # [doc = "DAC channel1 12-bit right-aligned data"]
pub const fn dacc1dhr (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "DAC channel1 12-bit right-aligned data"]
pub fn set_dacc1dhr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } } impl Default for Dhr12r1 { fn default () -> Dhr12r1 { Dhr12r1 (0) } } # [doc = "Sample and Hold hold time register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Shhr (pub u32) ; impl Shhr { # [doc = "DAC Channel 1 hold Time"]
pub const fn thold1 (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x03ff ; val as u16 } # [doc = "DAC Channel 1 hold Time"]
pub fn set_thold1 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x03ff << 0usize)) | (((val as u32) & 0x03ff) << 0usize) ; } # [doc = "DAC Channel 2 hold time"]
pub const fn thold2 (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x03ff ; val as u16 } # [doc = "DAC Channel 2 hold time"]
pub fn set_thold2 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x03ff << 16usize)) | (((val as u32) & 0x03ff) << 16usize) ; } } impl Default for Shhr { fn default () -> Shhr { Shhr (0) } } # [doc = "Dual DAC 12-bit right-aligned data holding register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dhr12rd (pub u32) ; impl Dhr12rd { # [doc = "DAC channel1 12-bit right-aligned data"]
pub const fn dacc1dhr (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "DAC channel1 12-bit right-aligned data"]
pub fn set_dacc1dhr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "DAC channel2 12-bit right-aligned data"]
pub const fn dacc2dhr (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x0fff ; val as u16 } # [doc = "DAC channel2 12-bit right-aligned data"]
pub fn set_dacc2dhr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 16usize)) | (((val as u32) & 0x0fff) << 16usize) ; } } impl Default for Dhr12rd { fn default () -> Dhr12rd { Dhr12rd (0) } } # [doc = "Sample and Hold sample time register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Shsr1 (pub u32) ; impl Shsr1 { # [doc = "DAC Channel 1 sample Time"]
pub const fn tsample1 (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x03ff ; val as u16 } # [doc = "DAC Channel 1 sample Time"]
pub fn set_tsample1 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x03ff << 0usize)) | (((val as u32) & 0x03ff) << 0usize) ; } } impl Default for Shsr1 { fn default () -> Shsr1 { Shsr1 (0) } } }