

# [doc = "Digital-to-analog converter"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dac (pub * mut u8) ; unsafe impl Send for Dac { } unsafe impl Sync for Dac { } impl Dac { # [doc = "control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "software trigger register"]
pub fn swtrigr (self) -> crate :: common :: Reg < regs :: Swtrigr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "channel1 12-bit right-aligned data holding register"]
pub fn dhr12r1 (self) -> crate :: common :: Reg < regs :: Dhr12r1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "channel1 12-bit left aligned data holding register"]
pub fn dhr12l1 (self) -> crate :: common :: Reg < regs :: Dhr12l1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "channel1 8-bit right aligned data holding register"]
pub fn dhr8r1 (self) -> crate :: common :: Reg < regs :: Dhr8r1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "channel2 12-bit right aligned data holding register"]
pub fn dhr12r2 (self) -> crate :: common :: Reg < regs :: Dhr12r2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "channel2 12-bit left aligned data holding register"]
pub fn dhr12l2 (self) -> crate :: common :: Reg < regs :: Dhr12l2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "channel2 8-bit right-aligned data holding register"]
pub fn dhr8r2 (self) -> crate :: common :: Reg < regs :: Dhr8r2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "Dual DAC 12-bit right-aligned data holding register"]
pub fn dhr12rd (self) -> crate :: common :: Reg < regs :: Dhr12rd , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "DUAL DAC 12-bit left aligned data holding register"]
pub fn dhr12ld (self) -> crate :: common :: Reg < regs :: Dhr12ld , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "DUAL DAC 8-bit right aligned data holding register"]
pub fn dhr8rd (self) -> crate :: common :: Reg < regs :: Dhr8rd , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "channel1 data output register"]
pub fn dor1 (self) -> crate :: common :: Reg < regs :: Dor1 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "channel2 data output register"]
pub fn dor2 (self) -> crate :: common :: Reg < regs :: Dor2 , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize)) } } } pub mod regs { # [doc = "software trigger register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Swtrigr (pub u32) ; impl Swtrigr { # [doc = "DAC channel1 software trigger"]
pub fn swtrig (& self , n : usize) -> super :: vals :: Swtrig { assert ! (n < 2usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Swtrig (val as u8) } # [doc = "DAC channel1 software trigger"]
pub fn set_swtrig (& mut self , n : usize , val : super :: vals :: Swtrig) { assert ! (n < 2usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } } impl Default for Swtrigr { fn default () -> Swtrigr { Swtrigr (0) } } # [doc = "control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "DAC channel1 enable"]
pub fn en (& self , n : usize) -> super :: vals :: En { assert ! (n < 2usize) ; let offs = 0usize + n * 16usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: En (val as u8) } # [doc = "DAC channel1 enable"]
pub fn set_en (& mut self , n : usize , val : super :: vals :: En) { assert ! (n < 2usize) ; let offs = 0usize + n * 16usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "DAC channel1 output buffer disable"]
pub fn boff (& self , n : usize) -> super :: vals :: Boff { assert ! (n < 2usize) ; let offs = 1usize + n * 16usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Boff (val as u8) } # [doc = "DAC channel1 output buffer disable"]
pub fn set_boff (& mut self , n : usize , val : super :: vals :: Boff) { assert ! (n < 2usize) ; let offs = 1usize + n * 16usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "DAC channel1 trigger enable"]
pub fn ten (& self , n : usize) -> super :: vals :: Ten { assert ! (n < 2usize) ; let offs = 2usize + n * 16usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Ten (val as u8) } # [doc = "DAC channel1 trigger enable"]
pub fn set_ten (& mut self , n : usize , val : super :: vals :: Ten) { assert ! (n < 2usize) ; let offs = 2usize + n * 16usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "DAC channel1 trigger selection"]
pub fn tsel (& self , n : usize) -> super :: vals :: Tsel1 { assert ! (n < 2usize) ; let offs = 3usize + n * 16usize ; let val = (self . 0 >> offs) & 0x07 ; super :: vals :: Tsel1 (val as u8) } # [doc = "DAC channel1 trigger selection"]
pub fn set_tsel (& mut self , n : usize , val : super :: vals :: Tsel1) { assert ! (n < 2usize) ; let offs = 3usize + n * 16usize ; self . 0 = (self . 0 & ! (0x07 << offs)) | (((val . 0 as u32) & 0x07) << offs) ; } # [doc = "DAC channel1 noise/triangle wave generation enable"]
pub fn wave (& self , n : usize) -> super :: vals :: Wave { assert ! (n < 2usize) ; let offs = 6usize + n * 16usize ; let val = (self . 0 >> offs) & 0x03 ; super :: vals :: Wave (val as u8) } # [doc = "DAC channel1 noise/triangle wave generation enable"]
pub fn set_wave (& mut self , n : usize , val : super :: vals :: Wave) { assert ! (n < 2usize) ; let offs = 6usize + n * 16usize ; self . 0 = (self . 0 & ! (0x03 << offs)) | (((val . 0 as u32) & 0x03) << offs) ; } # [doc = "DAC channel1 mask/amplitude selector"]
pub fn mamp (& self , n : usize) -> u8 { assert ! (n < 2usize) ; let offs = 8usize + n * 16usize ; let val = (self . 0 >> offs) & 0x0f ; val as u8 } # [doc = "DAC channel1 mask/amplitude selector"]
pub fn set_mamp (& mut self , n : usize , val : u8) { assert ! (n < 2usize) ; let offs = 8usize + n * 16usize ; self . 0 = (self . 0 & ! (0x0f << offs)) | (((val as u32) & 0x0f) << offs) ; } # [doc = "DAC channel1 DMA enable"]
pub fn dmaen (& self , n : usize) -> super :: vals :: Dmaen { assert ! (n < 2usize) ; let offs = 12usize + n * 16usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Dmaen (val as u8) } # [doc = "DAC channel1 DMA enable"]
pub fn set_dmaen (& mut self , n : usize , val : super :: vals :: Dmaen) { assert ! (n < 2usize) ; let offs = 12usize + n * 16usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "DAC channel1 DMA Underrun Interrupt enable"]
pub fn dmaudrie (& self , n : usize) -> super :: vals :: Dmaudrie { assert ! (n < 2usize) ; let offs = 13usize + n * 16usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Dmaudrie (val as u8) } # [doc = "DAC channel1 DMA Underrun Interrupt enable"]
pub fn set_dmaudrie (& mut self , n : usize , val : super :: vals :: Dmaudrie) { assert ! (n < 2usize) ; let offs = 13usize + n * 16usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "channel2 8-bit right-aligned data holding register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dhr8r2 (pub u32) ; impl Dhr8r2 { # [doc = "DAC channel2 8-bit right-aligned data"]
pub const fn dacc2dhr (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "DAC channel2 8-bit right-aligned data"]
pub fn set_dacc2dhr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } } impl Default for Dhr8r2 { fn default () -> Dhr8r2 { Dhr8r2 (0) } } # [doc = "channel2 12-bit right aligned data holding register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dhr12r2 (pub u32) ; impl Dhr12r2 { # [doc = "DAC channel2 12-bit right-aligned data"]
pub const fn dacc2dhr (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "DAC channel2 12-bit right-aligned data"]
pub fn set_dacc2dhr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } } impl Default for Dhr12r2 { fn default () -> Dhr12r2 { Dhr12r2 (0) } } # [doc = "Dual DAC 12-bit right-aligned data holding register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dhr12rd (pub u32) ; impl Dhr12rd { # [doc = "DAC channel1 12-bit right-aligned data"]
pub const fn dacc1dhr (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "DAC channel1 12-bit right-aligned data"]
pub fn set_dacc1dhr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } # [doc = "DAC channel2 12-bit right-aligned data"]
pub const fn dacc2dhr (& self) -> u16 { let val = (self . 0 >> 16usize) & 0x0fff ; val as u16 } # [doc = "DAC channel2 12-bit right-aligned data"]
pub fn set_dacc2dhr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 16usize)) | (((val as u32) & 0x0fff) << 16usize) ; } } impl Default for Dhr12rd { fn default () -> Dhr12rd { Dhr12rd (0) } } # [doc = "channel1 12-bit left aligned data holding register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dhr12l1 (pub u32) ; impl Dhr12l1 { # [doc = "DAC channel1 12-bit left-aligned data"]
pub const fn dacc1dhr (& self) -> u16 { let val = (self . 0 >> 4usize) & 0x0fff ; val as u16 } # [doc = "DAC channel1 12-bit left-aligned data"]
pub fn set_dacc1dhr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 4usize)) | (((val as u32) & 0x0fff) << 4usize) ; } } impl Default for Dhr12l1 { fn default () -> Dhr12l1 { Dhr12l1 (0) } } # [doc = "channel2 12-bit left aligned data holding register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dhr12l2 (pub u32) ; impl Dhr12l2 { # [doc = "DAC channel2 12-bit left-aligned data"]
pub const fn dacc2dhr (& self) -> u16 { let val = (self . 0 >> 4usize) & 0x0fff ; val as u16 } # [doc = "DAC channel2 12-bit left-aligned data"]
pub fn set_dacc2dhr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 4usize)) | (((val as u32) & 0x0fff) << 4usize) ; } } impl Default for Dhr12l2 { fn default () -> Dhr12l2 { Dhr12l2 (0) } } # [doc = "channel1 8-bit right aligned data holding register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dhr8r1 (pub u32) ; impl Dhr8r1 { # [doc = "DAC channel1 8-bit right-aligned data"]
pub const fn dacc1dhr (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "DAC channel1 8-bit right-aligned data"]
pub fn set_dacc1dhr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } } impl Default for Dhr8r1 { fn default () -> Dhr8r1 { Dhr8r1 (0) } } # [doc = "DUAL DAC 8-bit right aligned data holding register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dhr8rd (pub u32) ; impl Dhr8rd { # [doc = "DAC channel1 8-bit right-aligned data"]
pub const fn dacc1dhr (& self) -> u8 { let val = (self . 0 >> 0usize) & 0xff ; val as u8 } # [doc = "DAC channel1 8-bit right-aligned data"]
pub fn set_dacc1dhr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 0usize)) | (((val as u32) & 0xff) << 0usize) ; } # [doc = "DAC channel2 8-bit right-aligned data"]
pub const fn dacc2dhr (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "DAC channel2 8-bit right-aligned data"]
pub fn set_dacc2dhr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } } impl Default for Dhr8rd { fn default () -> Dhr8rd { Dhr8rd (0) } } # [doc = "channel1 12-bit right-aligned data holding register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dhr12r1 (pub u32) ; impl Dhr12r1 { # [doc = "DAC channel1 12-bit right-aligned data"]
pub const fn dacc1dhr (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "DAC channel1 12-bit right-aligned data"]
pub fn set_dacc1dhr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } } impl Default for Dhr12r1 { fn default () -> Dhr12r1 { Dhr12r1 (0) } } # [doc = "DUAL DAC 12-bit left aligned data holding register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dhr12ld (pub u32) ; impl Dhr12ld { # [doc = "DAC channel1 12-bit left-aligned data"]
pub const fn dacc1dhr (& self) -> u16 { let val = (self . 0 >> 4usize) & 0x0fff ; val as u16 } # [doc = "DAC channel1 12-bit left-aligned data"]
pub fn set_dacc1dhr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 4usize)) | (((val as u32) & 0x0fff) << 4usize) ; } # [doc = "DAC channel2 12-bit left-aligned data"]
pub const fn dacc2dhr (& self) -> u16 { let val = (self . 0 >> 20usize) & 0x0fff ; val as u16 } # [doc = "DAC channel2 12-bit left-aligned data"]
pub fn set_dacc2dhr (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 20usize)) | (((val as u32) & 0x0fff) << 20usize) ; } } impl Default for Dhr12ld { fn default () -> Dhr12ld { Dhr12ld (0) } } # [doc = "status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr (pub u32) ; impl Sr { # [doc = "DAC channel1 DMA underrun flag"]
pub fn dmaudr (& self , n : usize) -> super :: vals :: Dmaudr { assert ! (n < 2usize) ; let offs = 13usize + n * 16usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Dmaudr (val as u8) } # [doc = "DAC channel1 DMA underrun flag"]
pub fn set_dmaudr (& mut self , n : usize , val : super :: vals :: Dmaudr) { assert ! (n < 2usize) ; let offs = 13usize + n * 16usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } } impl Default for Sr { fn default () -> Sr { Sr (0) } } # [doc = "channel1 data output register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dor1 (pub u32) ; impl Dor1 { # [doc = "DAC channel1 data output"]
pub const fn dacc1dor (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "DAC channel1 data output"]
pub fn set_dacc1dor (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } } impl Default for Dor1 { fn default () -> Dor1 { Dor1 (0) } } # [doc = "channel2 data output register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dor2 (pub u32) ; impl Dor2 { # [doc = "DAC channel2 data output"]
pub const fn dacc2dor (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "DAC channel2 data output"]
pub fn set_dacc2dor (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } } impl Default for Dor2 { fn default () -> Dor2 { Dor2 (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dmaudr (pub u8) ; impl Dmaudr { # [doc = "No DMA underrun error condition occurred for DAC channel X"]
pub const NOUNDERRUN : Self = Self (0) ; # [doc = "DMA underrun error condition occurred for DAC channel X"]
pub const UNDERRUN : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct En (pub u8) ; impl En { # [doc = "DAC channel X disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "DAC channel X enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Swtrig (pub u8) ; impl Swtrig { # [doc = "DAC channel X software trigger disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "DAC channel X software trigger enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dmaen (pub u8) ; impl Dmaen { # [doc = "DAC channel X DMA mode disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "DAC channel X DMA mode enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wave (pub u8) ; impl Wave { # [doc = "Wave generation disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Noise wave generation enabled"]
pub const NOISE : Self = Self (0x01) ; # [doc = "Triangle wave generation enabled"]
pub const TRIANGLE : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Boff (pub u8) ; impl Boff { # [doc = "DAC channel X output buffer enabled"]
pub const ENABLED : Self = Self (0) ; # [doc = "DAC channel X output buffer disabled"]
pub const DISABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dmaudrie (pub u8) ; impl Dmaudrie { # [doc = "DAC channel X DMA Underrun Interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "DAC channel X DMA Underrun Interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tsel2 (pub u8) ; impl Tsel2 { # [doc = "Timer 6 TRGO event"]
pub const TIM6_TRGO : Self = Self (0) ; # [doc = "Timer 8 TRGO event"]
pub const TIM8_TRGO : Self = Self (0x01) ; # [doc = "Timer 7 TRGO event"]
pub const TIM7_TRGO : Self = Self (0x02) ; # [doc = "Timer 5 TRGO event"]
pub const TIM5_TRGO : Self = Self (0x03) ; # [doc = "Timer 2 TRGO event"]
pub const TIM2_TRGO : Self = Self (0x04) ; # [doc = "Timer 4 TRGO event"]
pub const TIM4_TRGO : Self = Self (0x05) ; # [doc = "EXTI line9"]
pub const EXTI9 : Self = Self (0x06) ; # [doc = "Software trigger"]
pub const SOFTWARE : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tsel1 (pub u8) ; impl Tsel1 { # [doc = "Timer 6 TRGO event"]
pub const TIM6_TRGO : Self = Self (0) ; # [doc = "Timer 3 TRGO event"]
pub const TIM3_TRGO : Self = Self (0x01) ; # [doc = "Timer 7 TRGO event"]
pub const TIM7_TRGO : Self = Self (0x02) ; # [doc = "Timer 15 TRGO event"]
pub const TIM15_TRGO : Self = Self (0x03) ; # [doc = "Timer 2 TRGO event"]
pub const TIM2_TRGO : Self = Self (0x04) ; # [doc = "EXTI line9"]
pub const EXTI9 : Self = Self (0x06) ; # [doc = "Software trigger"]
pub const SOFTWARE : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ten (pub u8) ; impl Ten { # [doc = "DAC channel X trigger disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "DAC channel X trigger enabled"]
pub const ENABLED : Self = Self (0x01) ; } }