

# [doc = "Clock recovery system"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Crs (pub * mut u8) ; unsafe impl Send for Crs { } unsafe impl Sync for Crs { } impl Crs { # [doc = "control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "configuration register"]
pub fn cfgr (self) -> crate :: common :: Reg < regs :: Cfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "interrupt and status register"]
pub fn isr (self) -> crate :: common :: Reg < regs :: Isr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "interrupt flag clear register"]
pub fn icr (self) -> crate :: common :: Reg < regs :: Icr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } } pub mod regs { # [doc = "interrupt and status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Isr (pub u32) ; impl Isr { # [doc = "SYNC event OK flag"]
pub const fn syncokf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "SYNC event OK flag"]
pub fn set_syncokf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "SYNC warning flag"]
pub const fn syncwarnf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "SYNC warning flag"]
pub fn set_syncwarnf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Error flag"]
pub const fn errf (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Error flag"]
pub fn set_errf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Expected SYNC flag"]
pub const fn esyncf (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Expected SYNC flag"]
pub fn set_esyncf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "SYNC error"]
pub const fn syncerr (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "SYNC error"]
pub fn set_syncerr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "SYNC missed"]
pub const fn syncmiss (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "SYNC missed"]
pub fn set_syncmiss (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Trimming overflow or underflow"]
pub const fn trimovf (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Trimming overflow or underflow"]
pub fn set_trimovf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Frequency error direction"]
pub const fn fedir (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "Frequency error direction"]
pub fn set_fedir (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "Frequency error capture"]
pub const fn fecap (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Frequency error capture"]
pub fn set_fecap (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for Isr { fn default () -> Isr { Isr (0) } } # [doc = "configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr (pub u32) ; impl Cfgr { # [doc = "Counter reload value"]
pub const fn reload (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Counter reload value"]
pub fn set_reload (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "Frequency error limit"]
pub const fn felim (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "Frequency error limit"]
pub fn set_felim (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } # [doc = "SYNC divider"]
pub const fn syncdiv (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x07 ; val as u8 } # [doc = "SYNC divider"]
pub fn set_syncdiv (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 24usize)) | (((val as u32) & 0x07) << 24usize) ; } # [doc = "SYNC signal source selection"]
pub const fn syncsrc (& self) -> u8 { let val = (self . 0 >> 28usize) & 0x03 ; val as u8 } # [doc = "SYNC signal source selection"]
pub fn set_syncsrc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 28usize)) | (((val as u32) & 0x03) << 28usize) ; } # [doc = "SYNC polarity selection"]
pub const fn syncpol (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "SYNC polarity selection"]
pub fn set_syncpol (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Cfgr { fn default () -> Cfgr { Cfgr (0) } } # [doc = "control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "SYNC event OK interrupt enable"]
pub const fn syncokie (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "SYNC event OK interrupt enable"]
pub fn set_syncokie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "SYNC warning interrupt enable"]
pub const fn syncwarnie (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "SYNC warning interrupt enable"]
pub fn set_syncwarnie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Synchronization or trimming error interrupt enable"]
pub const fn errie (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Synchronization or trimming error interrupt enable"]
pub fn set_errie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Expected SYNC interrupt enable"]
pub const fn esyncie (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Expected SYNC interrupt enable"]
pub fn set_esyncie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Frequency error counter enable"]
pub const fn cen (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Frequency error counter enable"]
pub fn set_cen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Automatic trimming enable"]
pub const fn autotrimen (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Automatic trimming enable"]
pub fn set_autotrimen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Generate software SYNC event"]
pub const fn swsync (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Generate software SYNC event"]
pub fn set_swsync (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "HSI48 oscillator smooth trimming"]
pub const fn trim (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x3f ; val as u8 } # [doc = "HSI48 oscillator smooth trimming"]
pub fn set_trim (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x3f << 8usize)) | (((val as u32) & 0x3f) << 8usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "interrupt flag clear register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Icr (pub u32) ; impl Icr { # [doc = "SYNC event OK clear flag"]
pub const fn syncokc (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "SYNC event OK clear flag"]
pub fn set_syncokc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "SYNC warning clear flag"]
pub const fn syncwarnc (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "SYNC warning clear flag"]
pub fn set_syncwarnc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Error clear flag"]
pub const fn errc (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Error clear flag"]
pub fn set_errc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Expected SYNC clear flag"]
pub const fn esyncc (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Expected SYNC clear flag"]
pub fn set_esyncc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } } impl Default for Icr { fn default () -> Icr { Icr (0) } } }