

# [doc = "Cyclic Redundancy Check calculation unit"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Crc (pub * mut u8) ; unsafe impl Send for Crc { } unsafe impl Sync for Crc { } impl Crc { # [doc = "Data register"]
pub fn dr (self) -> crate :: common :: Reg < u32 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Data register - half-word sized"]
pub fn dr16 (self) -> crate :: common :: Reg < u32 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Data register - byte sized"]
pub fn dr8 (self) -> crate :: common :: Reg < u32 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Independent Data register"]
pub fn idr (self) -> crate :: common :: Reg < u32 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "Initial CRC value"]
pub fn init (self) -> crate :: common :: Reg < u32 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "CRC polynomial"]
pub fn pol (self) -> crate :: common :: Reg < u32 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Polysize (pub u8) ; impl Polysize { # [doc = "32-bit polynomial"]
pub const POLYSIZE32 : Self = Self (0) ; # [doc = "16-bit polynomial"]
pub const POLYSIZE16 : Self = Self (0x01) ; # [doc = "8-bit polynomial"]
pub const POLYSIZE8 : Self = Self (0x02) ; # [doc = "7-bit polynomial"]
pub const POLYSIZE7 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct RevIn (pub u8) ; impl RevIn { # [doc = "Bit order not affected"]
pub const NORMAL : Self = Self (0) ; # [doc = "Bit reversal done by byte"]
pub const BYTE : Self = Self (0x01) ; # [doc = "Bit reversal done by half-word"]
pub const HALFWORD : Self = Self (0x02) ; # [doc = "Bit reversal done by word"]
pub const WORD : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct RevOut (pub u8) ; impl RevOut { # [doc = "Bit order not affected"]
pub const NORMAL : Self = Self (0) ; # [doc = "Bit reversed output"]
pub const REVERSED : Self = Self (0x01) ; } } pub mod regs { # [doc = "Control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "RESET bit"]
pub const fn reset (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "RESET bit"]
pub fn set_reset (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Polynomial size"]
pub const fn polysize (& self) -> super :: vals :: Polysize { let val = (self . 0 >> 3usize) & 0x03 ; super :: vals :: Polysize (val as u8) } # [doc = "Polynomial size"]
pub fn set_polysize (& mut self , val : super :: vals :: Polysize) { self . 0 = (self . 0 & ! (0x03 << 3usize)) | (((val . 0 as u32) & 0x03) << 3usize) ; } # [doc = "Reverse input data"]
pub const fn rev_in (& self) -> super :: vals :: RevIn { let val = (self . 0 >> 5usize) & 0x03 ; super :: vals :: RevIn (val as u8) } # [doc = "Reverse input data"]
pub fn set_rev_in (& mut self , val : super :: vals :: RevIn) { self . 0 = (self . 0 & ! (0x03 << 5usize)) | (((val . 0 as u32) & 0x03) << 5usize) ; } # [doc = "Reverse output data"]
pub const fn rev_out (& self) -> super :: vals :: RevOut { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: RevOut (val as u8) } # [doc = "Reverse output data"]
pub fn set_rev_out (& mut self , val : super :: vals :: RevOut) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } }