

# [doc = "CAN Transmit cluster"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Tx (pub * mut u8) ; unsafe impl Send for Tx { } unsafe impl Sync for Tx { } impl Tx { # [doc = "TX mailbox identifier register"]
pub fn tir (self) -> crate :: common :: Reg < regs :: Tir , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "mailbox data length control and time stamp register"]
pub fn tdtr (self) -> crate :: common :: Reg < regs :: Tdtr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "mailbox data low register"]
pub fn tdlr (self) -> crate :: common :: Reg < regs :: Tdlr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "mailbox data high register"]
pub fn tdhr (self) -> crate :: common :: Reg < regs :: Tdhr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } } # [doc = "Controller area network"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Can (pub * mut u8) ; unsafe impl Send for Can { } unsafe impl Sync for Can { } impl Can { # [doc = "master control register"]
pub fn mcr (self) -> crate :: common :: Reg < regs :: Mcr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "master status register"]
pub fn msr (self) -> crate :: common :: Reg < regs :: Msr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "transmit status register"]
pub fn tsr (self) -> crate :: common :: Reg < regs :: Tsr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "receive FIFO 0 register"]
pub fn rfr (self , n : usize) -> crate :: common :: Reg < regs :: Rfr , crate :: common :: RW > { assert ! (n < 2usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize + n * 4usize)) } } # [doc = "interrupt enable register"]
pub fn ier (self) -> crate :: common :: Reg < regs :: Ier , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "error status register"]
pub fn esr (self) -> crate :: common :: Reg < regs :: Esr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "bit timing register"]
pub fn btr (self) -> crate :: common :: Reg < regs :: Btr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (28usize)) } } # [doc = "CAN Transmit cluster"]
pub fn tx (self , n : usize) -> Tx { assert ! (n < 3usize) ; unsafe { Tx (self . 0 . add (384usize + n * 16usize)) } } # [doc = "CAN Receive cluster"]
pub fn rx (self , n : usize) -> Rx { assert ! (n < 2usize) ; unsafe { Rx (self . 0 . add (432usize + n * 16usize)) } } # [doc = "filter master register"]
pub fn fmr (self) -> crate :: common :: Reg < regs :: Fmr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (512usize)) } } # [doc = "filter mode register"]
pub fn fm1r (self) -> crate :: common :: Reg < regs :: Fm1r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (516usize)) } } # [doc = "filter scale register"]
pub fn fs1r (self) -> crate :: common :: Reg < regs :: Fs1r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (524usize)) } } # [doc = "filter FIFO assignment register"]
pub fn ffa1r (self) -> crate :: common :: Reg < regs :: Ffa1r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (532usize)) } } # [doc = "filter activation register"]
pub fn fa1r (self) -> crate :: common :: Reg < regs :: Fa1r , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (540usize)) } } # [doc = "CAN Filter Bank cluster"]
pub fn fb (self , n : usize) -> Fb { assert ! (n < 28usize) ; unsafe { Fb (self . 0 . add (576usize + n * 8usize)) } } } # [doc = "CAN Receive cluster"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rx (pub * mut u8) ; unsafe impl Send for Rx { } unsafe impl Sync for Rx { } impl Rx { # [doc = "receive FIFO mailbox identifier register"]
pub fn rir (self) -> crate :: common :: Reg < regs :: Rir , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "mailbox data high register"]
pub fn rdtr (self) -> crate :: common :: Reg < regs :: Rdtr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "mailbox data high register"]
pub fn rdlr (self) -> crate :: common :: Reg < regs :: Rdlr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "receive FIFO mailbox data high register"]
pub fn rdhr (self) -> crate :: common :: Reg < regs :: Rdhr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } } # [doc = "CAN Filter Bank cluster"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fb (pub * mut u8) ; unsafe impl Send for Fb { } unsafe impl Sync for Fb { } impl Fb { # [doc = "Filter bank 0 register 1"]
pub fn fr1 (self) -> crate :: common :: Reg < regs :: Fr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "Filter bank 0 register 2"]
pub fn fr2 (self) -> crate :: common :: Reg < regs :: Fr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } } pub mod regs { # [doc = "interrupt enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Esr (pub u32) ; impl Esr { # [doc = "EWGF"]
pub const fn ewgf (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "EWGF"]
pub fn set_ewgf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "EPVF"]
pub const fn epvf (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "EPVF"]
pub fn set_epvf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "BOFF"]
pub const fn boff (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "BOFF"]
pub fn set_boff (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "LEC"]
pub const fn lec (& self) -> super :: vals :: Lec { let val = (self . 0 >> 4usize) & 0x07 ; super :: vals :: Lec (val as u8) } # [doc = "LEC"]
pub fn set_lec (& mut self , val : super :: vals :: Lec) { self . 0 = (self . 0 & ! (0x07 << 4usize)) | (((val . 0 as u32) & 0x07) << 4usize) ; } # [doc = "TEC"]
pub const fn tec (& self) -> u8 { let val = (self . 0 >> 16usize) & 0xff ; val as u8 } # [doc = "TEC"]
pub fn set_tec (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 16usize)) | (((val as u32) & 0xff) << 16usize) ; } # [doc = "REC"]
pub const fn rec (& self) -> u8 { let val = (self . 0 >> 24usize) & 0xff ; val as u8 } # [doc = "REC"]
pub fn set_rec (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 24usize)) | (((val as u32) & 0xff) << 24usize) ; } } impl Default for Esr { fn default () -> Esr { Esr (0) } } # [doc = "receive FIFO mailbox identifier register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rir (pub u32) ; impl Rir { # [doc = "RTR"]
pub const fn rtr (& self) -> super :: vals :: RirRtr { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: RirRtr (val as u8) } # [doc = "RTR"]
pub fn set_rtr (& mut self , val : super :: vals :: RirRtr) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "IDE"]
pub const fn ide (& self) -> super :: vals :: RirIde { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: RirIde (val as u8) } # [doc = "IDE"]
pub fn set_ide (& mut self , val : super :: vals :: RirIde) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "EXID"]
pub const fn exid (& self) -> u32 { let val = (self . 0 >> 3usize) & 0x0003_ffff ; val as u32 } # [doc = "EXID"]
pub fn set_exid (& mut self , val : u32) { self . 0 = (self . 0 & ! (0x0003_ffff << 3usize)) | (((val as u32) & 0x0003_ffff) << 3usize) ; } # [doc = "STID"]
pub const fn stid (& self) -> u16 { let val = (self . 0 >> 21usize) & 0x07ff ; val as u16 } # [doc = "STID"]
pub fn set_stid (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x07ff << 21usize)) | (((val as u32) & 0x07ff) << 21usize) ; } } impl Default for Rir { fn default () -> Rir { Rir (0) } } # [doc = "mailbox data high register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rdlr (pub u32) ; impl Rdlr { # [doc = "DATA0"]
pub fn data (& self , n : usize) -> u8 { assert ! (n < 4usize) ; let offs = 0usize + n * 8usize ; let val = (self . 0 >> offs) & 0xff ; val as u8 } # [doc = "DATA0"]
pub fn set_data (& mut self , n : usize , val : u8) { assert ! (n < 4usize) ; let offs = 0usize + n * 8usize ; self . 0 = (self . 0 & ! (0xff << offs)) | (((val as u32) & 0xff) << offs) ; } } impl Default for Rdlr { fn default () -> Rdlr { Rdlr (0) } } # [doc = "master control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Mcr (pub u32) ; impl Mcr { # [doc = "INRQ"]
pub const fn inrq (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "INRQ"]
pub fn set_inrq (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "SLEEP"]
pub const fn sleep (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "SLEEP"]
pub fn set_sleep (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "TXFP"]
pub const fn txfp (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "TXFP"]
pub fn set_txfp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "RFLM"]
pub const fn rflm (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "RFLM"]
pub fn set_rflm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "NART"]
pub const fn nart (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "NART"]
pub fn set_nart (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "AWUM"]
pub const fn awum (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "AWUM"]
pub fn set_awum (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "ABOM"]
pub const fn abom (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "ABOM"]
pub fn set_abom (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "TTCM"]
pub const fn ttcm (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "TTCM"]
pub fn set_ttcm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "RESET"]
pub const fn reset (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "RESET"]
pub fn set_reset (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "DBF"]
pub const fn dbf (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "DBF"]
pub fn set_dbf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } } impl Default for Mcr { fn default () -> Mcr { Mcr (0) } } # [doc = "receive FIFO 0 register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rfr (pub u32) ; impl Rfr { # [doc = "FMP0"]
pub const fn fmp (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x03 ; val as u8 } # [doc = "FMP0"]
pub fn set_fmp (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val as u32) & 0x03) << 0usize) ; } # [doc = "FULL0"]
pub const fn full (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "FULL0"]
pub fn set_full (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "FOVR0"]
pub const fn fovr (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "FOVR0"]
pub fn set_fovr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "RFOM0"]
pub const fn rfom (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "RFOM0"]
pub fn set_rfom (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } } impl Default for Rfr { fn default () -> Rfr { Rfr (0) } } # [doc = "mailbox data high register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Tdhr (pub u32) ; impl Tdhr { # [doc = "DATA4"]
pub fn data (& self , n : usize) -> u8 { assert ! (n < 4usize) ; let offs = 0usize + n * 8usize ; let val = (self . 0 >> offs) & 0xff ; val as u8 } # [doc = "DATA4"]
pub fn set_data (& mut self , n : usize , val : u8) { assert ! (n < 4usize) ; let offs = 0usize + n * 8usize ; self . 0 = (self . 0 & ! (0xff << offs)) | (((val as u32) & 0xff) << offs) ; } } impl Default for Tdhr { fn default () -> Tdhr { Tdhr (0) } } # [doc = "bit timing register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Btr (pub u32) ; impl Btr { # [doc = "BRP"]
pub const fn brp (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x03ff ; val as u16 } # [doc = "BRP"]
pub fn set_brp (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x03ff << 0usize)) | (((val as u32) & 0x03ff) << 0usize) ; } # [doc = "TS1"]
pub fn ts (& self , n : usize) -> u8 { assert ! (n < 2usize) ; let offs = 16usize + n * 4usize ; let val = (self . 0 >> offs) & 0x0f ; val as u8 } # [doc = "TS1"]
pub fn set_ts (& mut self , n : usize , val : u8) { assert ! (n < 2usize) ; let offs = 16usize + n * 4usize ; self . 0 = (self . 0 & ! (0x0f << offs)) | (((val as u32) & 0x0f) << offs) ; } # [doc = "SJW"]
pub const fn sjw (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x03 ; val as u8 } # [doc = "SJW"]
pub fn set_sjw (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 24usize)) | (((val as u32) & 0x03) << 24usize) ; } # [doc = "LBKM"]
pub const fn lbkm (& self) -> super :: vals :: Lbkm { let val = (self . 0 >> 30usize) & 0x01 ; super :: vals :: Lbkm (val as u8) } # [doc = "LBKM"]
pub fn set_lbkm (& mut self , val : super :: vals :: Lbkm) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val . 0 as u32) & 0x01) << 30usize) ; } # [doc = "SILM"]
pub const fn silm (& self) -> super :: vals :: Silm { let val = (self . 0 >> 31usize) & 0x01 ; super :: vals :: Silm (val as u8) } # [doc = "SILM"]
pub fn set_silm (& mut self , val : super :: vals :: Silm) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val . 0 as u32) & 0x01) << 31usize) ; } } impl Default for Btr { fn default () -> Btr { Btr (0) } } # [doc = "mailbox data high register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rdtr (pub u32) ; impl Rdtr { # [doc = "DLC"]
pub const fn dlc (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "DLC"]
pub fn set_dlc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "FMI"]
pub const fn fmi (& self) -> u8 { let val = (self . 0 >> 8usize) & 0xff ; val as u8 } # [doc = "FMI"]
pub fn set_fmi (& mut self , val : u8) { self . 0 = (self . 0 & ! (0xff << 8usize)) | (((val as u32) & 0xff) << 8usize) ; } # [doc = "TIME"]
pub const fn time (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "TIME"]
pub fn set_time (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for Rdtr { fn default () -> Rdtr { Rdtr (0) } } # [doc = "receive FIFO mailbox data high register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Rdhr (pub u32) ; impl Rdhr { # [doc = "DATA4"]
pub fn data (& self , n : usize) -> u8 { assert ! (n < 4usize) ; let offs = 0usize + n * 8usize ; let val = (self . 0 >> offs) & 0xff ; val as u8 } # [doc = "DATA4"]
pub fn set_data (& mut self , n : usize , val : u8) { assert ! (n < 4usize) ; let offs = 0usize + n * 8usize ; self . 0 = (self . 0 & ! (0xff << offs)) | (((val as u32) & 0xff) << offs) ; } } impl Default for Rdhr { fn default () -> Rdhr { Rdhr (0) } } # [doc = "Filter bank 0 register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fr2 (pub u32) ; impl Fr2 { # [doc = "Filter bits"]
pub fn fb (& self , n : usize) -> bool { assert ! (n < 32usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Filter bits"]
pub fn set_fb (& mut self , n : usize , val : bool) { assert ! (n < 32usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Fr2 { fn default () -> Fr2 { Fr2 (0) } } # [doc = "TX mailbox identifier register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Tir (pub u32) ; impl Tir { # [doc = "TXRQ"]
pub const fn txrq (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "TXRQ"]
pub fn set_txrq (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "RTR"]
pub const fn rtr (& self) -> super :: vals :: TirRtr { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: TirRtr (val as u8) } # [doc = "RTR"]
pub fn set_rtr (& mut self , val : super :: vals :: TirRtr) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "IDE"]
pub const fn ide (& self) -> super :: vals :: TirIde { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: TirIde (val as u8) } # [doc = "IDE"]
pub fn set_ide (& mut self , val : super :: vals :: TirIde) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "EXID"]
pub const fn exid (& self) -> u32 { let val = (self . 0 >> 3usize) & 0x0003_ffff ; val as u32 } # [doc = "EXID"]
pub fn set_exid (& mut self , val : u32) { self . 0 = (self . 0 & ! (0x0003_ffff << 3usize)) | (((val as u32) & 0x0003_ffff) << 3usize) ; } # [doc = "STID"]
pub const fn stid (& self) -> u16 { let val = (self . 0 >> 21usize) & 0x07ff ; val as u16 } # [doc = "STID"]
pub fn set_stid (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x07ff << 21usize)) | (((val as u32) & 0x07ff) << 21usize) ; } } impl Default for Tir { fn default () -> Tir { Tir (0) } } # [doc = "mailbox data low register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Tdlr (pub u32) ; impl Tdlr { # [doc = "DATA0"]
pub fn data (& self , n : usize) -> u8 { assert ! (n < 4usize) ; let offs = 0usize + n * 8usize ; let val = (self . 0 >> offs) & 0xff ; val as u8 } # [doc = "DATA0"]
pub fn set_data (& mut self , n : usize , val : u8) { assert ! (n < 4usize) ; let offs = 0usize + n * 8usize ; self . 0 = (self . 0 & ! (0xff << offs)) | (((val as u32) & 0xff) << offs) ; } } impl Default for Tdlr { fn default () -> Tdlr { Tdlr (0) } } # [doc = "mailbox data length control and time stamp register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Tdtr (pub u32) ; impl Tdtr { # [doc = "DLC"]
pub const fn dlc (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "DLC"]
pub fn set_dlc (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "TGT"]
pub const fn tgt (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "TGT"]
pub fn set_tgt (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "TIME"]
pub const fn time (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "TIME"]
pub fn set_time (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for Tdtr { fn default () -> Tdtr { Tdtr (0) } } # [doc = "interrupt enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ier (pub u32) ; impl Ier { # [doc = "TMEIE"]
pub const fn tmeie (& self) -> super :: vals :: Tmeie { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Tmeie (val as u8) } # [doc = "TMEIE"]
pub fn set_tmeie (& mut self , val : super :: vals :: Tmeie) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "FMPIE0"]
pub fn fmpie (& self , n : usize) -> super :: vals :: Fmpie { assert ! (n < 2usize) ; let offs = 1usize + n * 3usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Fmpie (val as u8) } # [doc = "FMPIE0"]
pub fn set_fmpie (& mut self , n : usize , val : super :: vals :: Fmpie) { assert ! (n < 2usize) ; let offs = 1usize + n * 3usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "FFIE0"]
pub fn ffie (& self , n : usize) -> super :: vals :: Ffie { assert ! (n < 2usize) ; let offs = 2usize + n * 3usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Ffie (val as u8) } # [doc = "FFIE0"]
pub fn set_ffie (& mut self , n : usize , val : super :: vals :: Ffie) { assert ! (n < 2usize) ; let offs = 2usize + n * 3usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "FOVIE0"]
pub fn fovie (& self , n : usize) -> super :: vals :: Fovie { assert ! (n < 2usize) ; let offs = 3usize + n * 3usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Fovie (val as u8) } # [doc = "FOVIE0"]
pub fn set_fovie (& mut self , n : usize , val : super :: vals :: Fovie) { assert ! (n < 2usize) ; let offs = 3usize + n * 3usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "EWGIE"]
pub const fn ewgie (& self) -> super :: vals :: Ewgie { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Ewgie (val as u8) } # [doc = "EWGIE"]
pub fn set_ewgie (& mut self , val : super :: vals :: Ewgie) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "EPVIE"]
pub const fn epvie (& self) -> super :: vals :: Epvie { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Epvie (val as u8) } # [doc = "EPVIE"]
pub fn set_epvie (& mut self , val : super :: vals :: Epvie) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "BOFIE"]
pub const fn bofie (& self) -> super :: vals :: Bofie { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Bofie (val as u8) } # [doc = "BOFIE"]
pub fn set_bofie (& mut self , val : super :: vals :: Bofie) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "LECIE"]
pub const fn lecie (& self) -> super :: vals :: Lecie { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Lecie (val as u8) } # [doc = "LECIE"]
pub fn set_lecie (& mut self , val : super :: vals :: Lecie) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "ERRIE"]
pub const fn errie (& self) -> super :: vals :: Errie { let val = (self . 0 >> 15usize) & 0x01 ; super :: vals :: Errie (val as u8) } # [doc = "ERRIE"]
pub fn set_errie (& mut self , val : super :: vals :: Errie) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val . 0 as u32) & 0x01) << 15usize) ; } # [doc = "WKUIE"]
pub const fn wkuie (& self) -> super :: vals :: Wkuie { let val = (self . 0 >> 16usize) & 0x01 ; super :: vals :: Wkuie (val as u8) } # [doc = "WKUIE"]
pub fn set_wkuie (& mut self , val : super :: vals :: Wkuie) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val . 0 as u32) & 0x01) << 16usize) ; } # [doc = "SLKIE"]
pub const fn slkie (& self) -> super :: vals :: Slkie { let val = (self . 0 >> 17usize) & 0x01 ; super :: vals :: Slkie (val as u8) } # [doc = "SLKIE"]
pub fn set_slkie (& mut self , val : super :: vals :: Slkie) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val . 0 as u32) & 0x01) << 17usize) ; } } impl Default for Ier { fn default () -> Ier { Ier (0) } } # [doc = "Filter bank 0 register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fr1 (pub u32) ; impl Fr1 { # [doc = "Filter bits"]
pub fn fb (& self , n : usize) -> bool { assert ! (n < 32usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Filter bits"]
pub fn set_fb (& mut self , n : usize , val : bool) { assert ! (n < 32usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Fr1 { fn default () -> Fr1 { Fr1 (0) } } # [doc = "filter activation register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fa1r (pub u32) ; impl Fa1r { # [doc = "Filter active"]
pub fn fact (& self , n : usize) -> bool { assert ! (n < 28usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Filter active"]
pub fn set_fact (& mut self , n : usize , val : bool) { assert ! (n < 28usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Fa1r { fn default () -> Fa1r { Fa1r (0) } } # [doc = "filter FIFO assignment register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ffa1r (pub u32) ; impl Ffa1r { # [doc = "Filter FIFO assignment for filter 0"]
pub fn ffa (& self , n : usize) -> bool { assert ! (n < 28usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Filter FIFO assignment for filter 0"]
pub fn set_ffa (& mut self , n : usize , val : bool) { assert ! (n < 28usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Ffa1r { fn default () -> Ffa1r { Ffa1r (0) } } # [doc = "transmit status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Tsr (pub u32) ; impl Tsr { # [doc = "RQCP0"]
pub fn rqcp (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 0usize + n * 8usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "RQCP0"]
pub fn set_rqcp (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 0usize + n * 8usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "TXOK0"]
pub fn txok (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 1usize + n * 8usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "TXOK0"]
pub fn set_txok (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 1usize + n * 8usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "ALST0"]
pub fn alst (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 2usize + n * 8usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "ALST0"]
pub fn set_alst (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 2usize + n * 8usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "TERR0"]
pub fn terr (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 3usize + n * 8usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "TERR0"]
pub fn set_terr (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 3usize + n * 8usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "ABRQ0"]
pub fn abrq (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 7usize + n * 8usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "ABRQ0"]
pub fn set_abrq (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 7usize + n * 8usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "CODE"]
pub const fn code (& self) -> u8 { let val = (self . 0 >> 24usize) & 0x03 ; val as u8 } # [doc = "CODE"]
pub fn set_code (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 24usize)) | (((val as u32) & 0x03) << 24usize) ; } # [doc = "Lowest priority flag for mailbox 0"]
pub fn tme (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 26usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Lowest priority flag for mailbox 0"]
pub fn set_tme (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 26usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Lowest priority flag for mailbox 0"]
pub fn low (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 29usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Lowest priority flag for mailbox 0"]
pub fn set_low (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 29usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Tsr { fn default () -> Tsr { Tsr (0) } } # [doc = "master status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Msr (pub u32) ; impl Msr { # [doc = "INAK"]
pub const fn inak (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "INAK"]
pub fn set_inak (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "SLAK"]
pub const fn slak (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "SLAK"]
pub fn set_slak (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "ERRI"]
pub const fn erri (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "ERRI"]
pub fn set_erri (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "WKUI"]
pub const fn wkui (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "WKUI"]
pub fn set_wkui (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "SLAKI"]
pub const fn slaki (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "SLAKI"]
pub fn set_slaki (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "TXM"]
pub const fn txm (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "TXM"]
pub fn set_txm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "RXM"]
pub const fn rxm (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "RXM"]
pub fn set_rxm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "SAMP"]
pub const fn samp (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "SAMP"]
pub fn set_samp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "RX"]
pub const fn rx (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "RX"]
pub fn set_rx (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } } impl Default for Msr { fn default () -> Msr { Msr (0) } } # [doc = "filter mode register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fm1r (pub u32) ; impl Fm1r { # [doc = "Filter mode"]
pub fn fbm (& self , n : usize) -> bool { assert ! (n < 28usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Filter mode"]
pub fn set_fbm (& mut self , n : usize , val : bool) { assert ! (n < 28usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Fm1r { fn default () -> Fm1r { Fm1r (0) } } # [doc = "filter master register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fmr (pub u32) ; impl Fmr { # [doc = "FINIT"]
pub const fn finit (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "FINIT"]
pub fn set_finit (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "CAN2SB"]
pub const fn can2sb (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x3f ; val as u8 } # [doc = "CAN2SB"]
pub fn set_can2sb (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x3f << 8usize)) | (((val as u32) & 0x3f) << 8usize) ; } } impl Default for Fmr { fn default () -> Fmr { Fmr (0) } } # [doc = "filter scale register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Fs1r (pub u32) ; impl Fs1r { # [doc = "Filter scale configuration"]
pub fn fsc (& self , n : usize) -> bool { assert ! (n < 28usize) ; let offs = 0usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Filter scale configuration"]
pub fn set_fsc (& mut self , n : usize , val : bool) { assert ! (n < 28usize) ; let offs = 0usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Fs1r { fn default () -> Fs1r { Fs1r (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lec (pub u8) ; impl Lec { # [doc = "No Error"]
pub const NOERROR : Self = Self (0) ; # [doc = "Stuff Error"]
pub const STUFF : Self = Self (0x01) ; # [doc = "Form Error"]
pub const FORM : Self = Self (0x02) ; # [doc = "Acknowledgment Error"]
pub const ACK : Self = Self (0x03) ; # [doc = "Bit recessive Error"]
pub const BITRECESSIVE : Self = Self (0x04) ; # [doc = "Bit dominant Error"]
pub const BITDOMINANT : Self = Self (0x05) ; # [doc = "CRC Error"]
pub const CRC : Self = Self (0x06) ; # [doc = "Set by software"]
pub const CUSTOM : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Bofie (pub u8) ; impl Bofie { # [doc = "ERRI bit will not be set when BOFF is set"]
pub const DISABLED : Self = Self (0) ; # [doc = "ERRI bit will be set when BOFF is set"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct RirIde (pub u8) ; impl RirIde { # [doc = "Standard identifier"]
pub const STANDARD : Self = Self (0) ; # [doc = "Extended identifier"]
pub const EXTENDED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fovrw (pub u8) ; impl Fovrw { # [doc = "Clear flag"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lecie (pub u8) ; impl Lecie { # [doc = "ERRI bit will not be set when the error code in LEC[2:0]
is set by hardware on error detection"]
pub const DISABLED : Self = Self (0) ; # [doc = "ERRI bit will be set when the error code in LEC[2:0]
is set by hardware on error detection"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ffie (pub u8) ; impl Ffie { # [doc = "No interrupt when FULL bit is set"]
pub const DISABLED : Self = Self (0) ; # [doc = "Interrupt generated when FULL bit is set"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fullw (pub u8) ; impl Fullw { # [doc = "Clear flag"]
pub const CLEAR : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fullr (pub u8) ; impl Fullr { # [doc = "FIFO x is not full"]
pub const NOTFULL : Self = Self (0) ; # [doc = "FIFO x is full"]
pub const FULL : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct TirIde (pub u8) ; impl TirIde { # [doc = "Standard identifier"]
pub const STANDARD : Self = Self (0) ; # [doc = "Extended identifier"]
pub const EXTENDED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Lbkm (pub u8) ; impl Lbkm { # [doc = "Loop Back Mode disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Loop Back Mode enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fmpie (pub u8) ; impl Fmpie { # [doc = "No interrupt generated when state of FMP[1:0]
bits are not 00b"]
pub const DISABLED : Self = Self (0) ; # [doc = "Interrupt generated when state of FMP[1:0]
bits are not 00b"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fovie (pub u8) ; impl Fovie { # [doc = "No interrupt when FOVR bit is set"]
pub const DISABLED : Self = Self (0) ; # [doc = "Interrupt generated when FOVR bit is set"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Silm (pub u8) ; impl Silm { # [doc = "Normal operation"]
pub const NORMAL : Self = Self (0) ; # [doc = "Silent Mode"]
pub const SILENT : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Errie (pub u8) ; impl Errie { # [doc = "No interrupt will be generated when an error condition is pending in the CAN_ESR"]
pub const DISABLED : Self = Self (0) ; # [doc = "An interrupt will be generation when an error condition is pending in the CAN_ESR"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct TirRtr (pub u8) ; impl TirRtr { # [doc = "Data frame"]
pub const DATA : Self = Self (0) ; # [doc = "Remote frame"]
pub const REMOTE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Fovrr (pub u8) ; impl Fovrr { # [doc = "No FIFO x overrun"]
pub const NOOVERRUN : Self = Self (0) ; # [doc = "FIFO x overrun"]
pub const OVERRUN : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ewgie (pub u8) ; impl Ewgie { # [doc = "ERRI bit will not be set when EWGF is set"]
pub const DISABLED : Self = Self (0) ; # [doc = "ERRI bit will be set when EWGF is set"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Wkuie (pub u8) ; impl Wkuie { # [doc = "No interrupt when WKUI is set"]
pub const DISABLED : Self = Self (0) ; # [doc = "Interrupt generated when WKUI bit is set"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tmeie (pub u8) ; impl Tmeie { # [doc = "No interrupt when RQCPx bit is set"]
pub const DISABLED : Self = Self (0) ; # [doc = "Interrupt generated when RQCPx bit is set"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Slkie (pub u8) ; impl Slkie { # [doc = "No interrupt when SLAKI bit is set"]
pub const DISABLED : Self = Self (0) ; # [doc = "Interrupt generated when SLAKI bit is set"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct RirRtr (pub u8) ; impl RirRtr { # [doc = "Data frame"]
pub const DATA : Self = Self (0) ; # [doc = "Remote frame"]
pub const REMOTE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Epvie (pub u8) ; impl Epvie { # [doc = "ERRI bit will not be set when EPVF is set"]
pub const DISABLED : Self = Self (0) ; # [doc = "ERRI bit will be set when EPVF is set"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Rfomw (pub u8) ; impl Rfomw { # [doc = "Set by software to release the output mailbox of the FIFO"]
pub const RELEASE : Self = Self (0x01) ; } }