

# [doc = "DMA controller"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dma (pub * mut u8) ; unsafe impl Send for Dma { } unsafe impl Sync for Dma { } impl Dma { # [doc = "DMA interrupt status register (DMA_ISR)"]
pub fn isr (self) -> crate :: common :: Reg < regs :: Isr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "DMA interrupt flag clear register (DMA_IFCR)"]
pub fn ifcr (self) -> crate :: common :: Reg < regs :: Isr , crate :: common :: W > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "Channel cluster: CCR?, CNDTR?, CPAR?, and CMAR? registers"]
pub fn ch (self , n : usize) -> Ch { assert ! (n < 8usize) ; unsafe { Ch (self . 0 . add (8usize + n * 20usize)) } } } # [doc = "Channel cluster: CCR?, CNDTR?, CPAR?, and CMAR? registers"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ch (pub * mut u8) ; unsafe impl Send for Ch { } unsafe impl Sync for Ch { } impl Ch { # [doc = "DMA channel configuration register (DMA_CCR)"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "DMA channel 1 number of data register"]
pub fn ndtr (self) -> crate :: common :: Reg < regs :: Ndtr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "DMA channel 1 peripheral address register"]
pub fn par (self) -> crate :: common :: Reg < u32 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "DMA channel 1 memory address register"]
pub fn mar (self) -> crate :: common :: Reg < u32 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Pl (pub u8) ; impl Pl { # [doc = "Low priority"]
pub const LOW : Self = Self (0) ; # [doc = "Medium priority"]
pub const MEDIUM : Self = Self (0x01) ; # [doc = "High priority"]
pub const HIGH : Self = Self (0x02) ; # [doc = "Very high priority"]
pub const VERYHIGH : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Size (pub u8) ; impl Size { # [doc = "8-bit size"]
pub const BITS8 : Self = Self (0) ; # [doc = "16-bit size"]
pub const BITS16 : Self = Self (0x01) ; # [doc = "32-bit size"]
pub const BITS32 : Self = Self (0x02) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dir (pub u8) ; impl Dir { # [doc = "Read from peripheral"]
pub const FROMPERIPHERAL : Self = Self (0) ; # [doc = "Read from memory"]
pub const FROMMEMORY : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Inc (pub u8) ; impl Inc { # [doc = "Increment mode disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Increment mode enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Circ (pub u8) ; impl Circ { # [doc = "Circular buffer disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Circular buffer enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Memmem (pub u8) ; impl Memmem { # [doc = "Memory to memory mode disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Memory to memory mode enabled"]
pub const ENABLED : Self = Self (0x01) ; } } pub mod regs { # [doc = "DMA interrupt status register (DMA_ISR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Isr (pub u32) ; impl Isr { # [doc = "Channel 1 Global interrupt flag"]
pub fn gif (& self , n : usize) -> bool { assert ! (n < 8usize) ; let offs = 0usize + n * 4usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Channel 1 Global interrupt flag"]
pub fn set_gif (& mut self , n : usize , val : bool) { assert ! (n < 8usize) ; let offs = 0usize + n * 4usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Channel 1 Transfer Complete flag"]
pub fn tcif (& self , n : usize) -> bool { assert ! (n < 8usize) ; let offs = 1usize + n * 4usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Channel 1 Transfer Complete flag"]
pub fn set_tcif (& mut self , n : usize , val : bool) { assert ! (n < 8usize) ; let offs = 1usize + n * 4usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Channel 1 Half Transfer Complete flag"]
pub fn htif (& self , n : usize) -> bool { assert ! (n < 8usize) ; let offs = 2usize + n * 4usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Channel 1 Half Transfer Complete flag"]
pub fn set_htif (& mut self , n : usize , val : bool) { assert ! (n < 8usize) ; let offs = 2usize + n * 4usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "Channel 1 Transfer Error flag"]
pub fn teif (& self , n : usize) -> bool { assert ! (n < 8usize) ; let offs = 3usize + n * 4usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "Channel 1 Transfer Error flag"]
pub fn set_teif (& mut self , n : usize , val : bool) { assert ! (n < 8usize) ; let offs = 3usize + n * 4usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } } impl Default for Isr { fn default () -> Isr { Isr (0) } } # [doc = "DMA channel configuration register (DMA_CCR)"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "Channel enable"]
pub const fn en (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Channel enable"]
pub fn set_en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Transfer complete interrupt enable"]
pub const fn tcie (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Transfer complete interrupt enable"]
pub fn set_tcie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Half Transfer interrupt enable"]
pub const fn htie (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Half Transfer interrupt enable"]
pub fn set_htie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Transfer error interrupt enable"]
pub const fn teie (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Transfer error interrupt enable"]
pub fn set_teie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Data transfer direction"]
pub const fn dir (& self) -> super :: vals :: Dir { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Dir (val as u8) } # [doc = "Data transfer direction"]
pub fn set_dir (& mut self , val : super :: vals :: Dir) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "Circular mode"]
pub const fn circ (& self) -> super :: vals :: Circ { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Circ (val as u8) } # [doc = "Circular mode"]
pub fn set_circ (& mut self , val : super :: vals :: Circ) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "Peripheral increment mode"]
pub const fn pinc (& self) -> super :: vals :: Inc { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Inc (val as u8) } # [doc = "Peripheral increment mode"]
pub fn set_pinc (& mut self , val : super :: vals :: Inc) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } # [doc = "Memory increment mode"]
pub const fn minc (& self) -> super :: vals :: Inc { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Inc (val as u8) } # [doc = "Memory increment mode"]
pub fn set_minc (& mut self , val : super :: vals :: Inc) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "Peripheral size"]
pub const fn psize (& self) -> super :: vals :: Size { let val = (self . 0 >> 8usize) & 0x03 ; super :: vals :: Size (val as u8) } # [doc = "Peripheral size"]
pub fn set_psize (& mut self , val : super :: vals :: Size) { self . 0 = (self . 0 & ! (0x03 << 8usize)) | (((val . 0 as u32) & 0x03) << 8usize) ; } # [doc = "Memory size"]
pub const fn msize (& self) -> super :: vals :: Size { let val = (self . 0 >> 10usize) & 0x03 ; super :: vals :: Size (val as u8) } # [doc = "Memory size"]
pub fn set_msize (& mut self , val : super :: vals :: Size) { self . 0 = (self . 0 & ! (0x03 << 10usize)) | (((val . 0 as u32) & 0x03) << 10usize) ; } # [doc = "Channel Priority level"]
pub const fn pl (& self) -> super :: vals :: Pl { let val = (self . 0 >> 12usize) & 0x03 ; super :: vals :: Pl (val as u8) } # [doc = "Channel Priority level"]
pub fn set_pl (& mut self , val : super :: vals :: Pl) { self . 0 = (self . 0 & ! (0x03 << 12usize)) | (((val . 0 as u32) & 0x03) << 12usize) ; } # [doc = "Memory to memory mode"]
pub const fn mem2mem (& self) -> super :: vals :: Memmem { let val = (self . 0 >> 14usize) & 0x01 ; super :: vals :: Memmem (val as u8) } # [doc = "Memory to memory mode"]
pub fn set_mem2mem (& mut self , val : super :: vals :: Memmem) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val . 0 as u32) & 0x01) << 14usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "DMA channel 1 number of data register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ndtr (pub u32) ; impl Ndtr { # [doc = "Number of data to transfer"]
pub const fn ndt (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Number of data to transfer"]
pub fn set_ndt (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Ndtr { fn default () -> Ndtr { Ndtr (0) } } }