

# [doc = "Analog-to-Digital Converter"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct AdcCommon (pub * mut u8) ; unsafe impl Send for AdcCommon { } unsafe impl Sync for AdcCommon { } impl AdcCommon { # [doc = "ADC Common status register"]
pub fn csr (self) -> crate :: common :: Reg < regs :: Csr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "ADC common control register"]
pub fn ccr (self) -> crate :: common :: Reg < regs :: Ccr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "ADC common regular data register for dual and triple modes"]
pub fn cdr (self) -> crate :: common :: Reg < regs :: Cdr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } } pub mod regs { # [doc = "ADC Common status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Csr (pub u32) ; impl Csr { # [doc = "ADDRDY_MST"]
pub const fn addrdy_mst (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "ADDRDY_MST"]
pub fn set_addrdy_mst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "EOSMP_MST"]
pub const fn eosmp_mst (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "EOSMP_MST"]
pub fn set_eosmp_mst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "EOC_MST"]
pub const fn eoc_mst (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "EOC_MST"]
pub fn set_eoc_mst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "EOS_MST"]
pub const fn eos_mst (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "EOS_MST"]
pub fn set_eos_mst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "OVR_MST"]
pub const fn ovr_mst (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "OVR_MST"]
pub fn set_ovr_mst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "JEOC_MST"]
pub const fn jeoc_mst (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "JEOC_MST"]
pub fn set_jeoc_mst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "JEOS_MST"]
pub const fn jeos_mst (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "JEOS_MST"]
pub fn set_jeos_mst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "AWD1_MST"]
pub const fn awd1_mst (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "AWD1_MST"]
pub fn set_awd1_mst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "AWD2_MST"]
pub const fn awd2_mst (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "AWD2_MST"]
pub fn set_awd2_mst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "AWD3_MST"]
pub const fn awd3_mst (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "AWD3_MST"]
pub fn set_awd3_mst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "JQOVF_MST"]
pub const fn jqovf_mst (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "JQOVF_MST"]
pub fn set_jqovf_mst (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "ADRDY_SLV"]
pub const fn adrdy_slv (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "ADRDY_SLV"]
pub fn set_adrdy_slv (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "EOSMP_SLV"]
pub const fn eosmp_slv (& self) -> bool { let val = (self . 0 >> 17usize) & 0x01 ; val != 0 } # [doc = "EOSMP_SLV"]
pub fn set_eosmp_slv (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 17usize)) | (((val as u32) & 0x01) << 17usize) ; } # [doc = "End of regular conversion of the slave ADC"]
pub const fn eoc_slv (& self) -> bool { let val = (self . 0 >> 18usize) & 0x01 ; val != 0 } # [doc = "End of regular conversion of the slave ADC"]
pub fn set_eoc_slv (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 18usize)) | (((val as u32) & 0x01) << 18usize) ; } # [doc = "End of regular sequence flag of the slave ADC"]
pub const fn eos_slv (& self) -> bool { let val = (self . 0 >> 19usize) & 0x01 ; val != 0 } # [doc = "End of regular sequence flag of the slave ADC"]
pub fn set_eos_slv (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 19usize)) | (((val as u32) & 0x01) << 19usize) ; } # [doc = "Overrun flag of the slave ADC"]
pub const fn ovr_slv (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "Overrun flag of the slave ADC"]
pub fn set_ovr_slv (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "End of injected conversion flag of the slave ADC"]
pub const fn jeoc_slv (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "End of injected conversion flag of the slave ADC"]
pub fn set_jeoc_slv (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "End of injected sequence flag of the slave ADC"]
pub const fn jeos_slv (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "End of injected sequence flag of the slave ADC"]
pub fn set_jeos_slv (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Analog watchdog 1 flag of the slave ADC"]
pub const fn awd1_slv (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Analog watchdog 1 flag of the slave ADC"]
pub fn set_awd1_slv (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "Analog watchdog 2 flag of the slave ADC"]
pub const fn awd2_slv (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "Analog watchdog 2 flag of the slave ADC"]
pub fn set_awd2_slv (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "Analog watchdog 3 flag of the slave ADC"]
pub const fn awd3_slv (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "Analog watchdog 3 flag of the slave ADC"]
pub fn set_awd3_slv (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "Injected Context Queue Overflow flag of the slave ADC"]
pub const fn jqovf_slv (& self) -> bool { let val = (self . 0 >> 26usize) & 0x01 ; val != 0 } # [doc = "Injected Context Queue Overflow flag of the slave ADC"]
pub fn set_jqovf_slv (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val as u32) & 0x01) << 26usize) ; } } impl Default for Csr { fn default () -> Csr { Csr (0) } } # [doc = "ADC common control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ccr (pub u32) ; impl Ccr { # [doc = "Multi ADC mode selection"]
pub const fn mult (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x1f ; val as u8 } # [doc = "Multi ADC mode selection"]
pub fn set_mult (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 0usize)) | (((val as u32) & 0x1f) << 0usize) ; } # [doc = "Delay between 2 sampling phases"]
pub const fn delay (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "Delay between 2 sampling phases"]
pub fn set_delay (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "DMA configuration (for multi-ADC mode)"]
pub const fn dmacfg (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "DMA configuration (for multi-ADC mode)"]
pub fn set_dmacfg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "Direct memory access mode for multi ADC mode"]
pub const fn mdma (& self) -> u8 { let val = (self . 0 >> 14usize) & 0x03 ; val as u8 } # [doc = "Direct memory access mode for multi ADC mode"]
pub fn set_mdma (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 14usize)) | (((val as u32) & 0x03) << 14usize) ; } # [doc = "ADC clock mode"]
pub const fn ckmode (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x03 ; val as u8 } # [doc = "ADC clock mode"]
pub fn set_ckmode (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val as u32) & 0x03) << 16usize) ; } # [doc = "VREFINT enable"]
pub const fn vrefen (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "VREFINT enable"]
pub fn set_vrefen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "CH18 selection (Vbat)"]
pub const fn ch18sel (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "CH18 selection (Vbat)"]
pub fn set_ch18sel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "CH17 selection (temperature)"]
pub const fn ch17sel (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "CH17 selection (temperature)"]
pub fn set_ch17sel (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } } impl Default for Ccr { fn default () -> Ccr { Ccr (0) } } # [doc = "ADC common regular data register for dual and triple modes"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cdr (pub u32) ; impl Cdr { # [doc = "Regular data of the master ADC"]
pub const fn rdata_mst (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Regular data of the master ADC"]
pub fn set_rdata_mst (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "Regular data of the slave ADC"]
pub const fn rdata_slv (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "Regular data of the slave ADC"]
pub fn set_rdata_slv (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for Cdr { fn default () -> Cdr { Cdr (0) } } }