

# [doc = "ADC common registers"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct AdcCommon (pub * mut u8) ; unsafe impl Send for AdcCommon { } unsafe impl Sync for AdcCommon { } impl AdcCommon { # [doc = "ADC Common status register"]
pub fn csr (self) -> crate :: common :: Reg < regs :: Csr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "ADC common control register"]
pub fn ccr (self) -> crate :: common :: Reg < regs :: Ccr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "ADC common regular data register for dual and triple modes"]
pub fn cdr (self) -> crate :: common :: Reg < regs :: Cdr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adcpre (pub u8) ; impl Adcpre { # [doc = "PCLK2 divided by 2"]
pub const DIV2 : Self = Self (0) ; # [doc = "PCLK2 divided by 4"]
pub const DIV4 : Self = Self (0x01) ; # [doc = "PCLK2 divided by 6"]
pub const DIV6 : Self = Self (0x02) ; # [doc = "PCLK2 divided by 8"]
pub const DIV8 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Vbate (pub u8) ; impl Vbate { # [doc = "V_BAT channel disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "V_BAT channel enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dds (pub u8) ; impl Dds { # [doc = "No new DMA request is issued after the last transfer"]
pub const SINGLE : Self = Self (0) ; # [doc = "DMA requests are issued as long as data are converted and DMA=01, 10 or 11"]
pub const CONTINUOUS : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Jstrt (pub u8) ; impl Jstrt { # [doc = "No injected channel conversion started"]
pub const NOTSTARTED : Self = Self (0) ; # [doc = "Injected channel conversion has started"]
pub const STARTED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Strt (pub u8) ; impl Strt { # [doc = "No regular channel conversion started"]
pub const NOTSTARTED : Self = Self (0) ; # [doc = "Regular channel conversion has started"]
pub const STARTED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Multi (pub u8) ; impl Multi { # [doc = "All the ADCs independent: independent mode"]
pub const INDEPENDENT : Self = Self (0) ; # [doc = "Dual ADC1 and ADC2, combined regular and injected simultaneous mode"]
pub const DUALRJ : Self = Self (0x01) ; # [doc = "Dual ADC1 and ADC2, combined regular and alternate trigger mode"]
pub const DUALRA : Self = Self (0x02) ; # [doc = "Dual ADC1 and ADC2, injected simultaneous mode only"]
pub const DUALJ : Self = Self (0x05) ; # [doc = "Dual ADC1 and ADC2, regular simultaneous mode only"]
pub const DUALR : Self = Self (0x06) ; # [doc = "Dual ADC1 and ADC2, interleaved mode only"]
pub const DUALI : Self = Self (0x07) ; # [doc = "Dual ADC1 and ADC2, alternate trigger mode only"]
pub const DUALA : Self = Self (0x09) ; # [doc = "Triple ADC, regular and injected simultaneous mode"]
pub const TRIPLERJ : Self = Self (0x11) ; # [doc = "Triple ADC, regular and alternate trigger mode"]
pub const TRIPLERA : Self = Self (0x12) ; # [doc = "Triple ADC, injected simultaneous mode only"]
pub const TRIPLEJ : Self = Self (0x15) ; # [doc = "Triple ADC, regular simultaneous mode only"]
pub const TRIPLER : Self = Self (0x16) ; # [doc = "Triple ADC, interleaved mode only"]
pub const TRIPLEI : Self = Self (0x17) ; # [doc = "Triple ADC, alternate trigger mode only"]
pub const TRIPLEA : Self = Self (0x18) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ovr (pub u8) ; impl Ovr { # [doc = "No overrun occurred"]
pub const NOOVERRUN : Self = Self (0) ; # [doc = "Overrun occurred"]
pub const OVERRUN : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Eoc (pub u8) ; impl Eoc { # [doc = "Conversion is not complete"]
pub const NOTCOMPLETE : Self = Self (0) ; # [doc = "Conversion complete"]
pub const COMPLETE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dma (pub u8) ; impl Dma { # [doc = "DMA mode disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "DMA mode 1 enabled (2 / 3 half-words one by one - 1 then 2 then 3)"]
pub const MODE1 : Self = Self (0x01) ; # [doc = "DMA mode 2 enabled (2 / 3 half-words by pairs - 2&1 then 1&3 then 3&2)"]
pub const MODE2 : Self = Self (0x02) ; # [doc = "DMA mode 3 enabled (2 / 3 half-words by pairs - 2&1 then 1&3 then 3&2)"]
pub const MODE3 : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Awd (pub u8) ; impl Awd { # [doc = "No analog watchdog event occurred"]
pub const NOEVENT : Self = Self (0) ; # [doc = "Analog watchdog event occurred"]
pub const EVENT : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Jeoc (pub u8) ; impl Jeoc { # [doc = "Conversion is not complete"]
pub const NOTCOMPLETE : Self = Self (0) ; # [doc = "Conversion complete"]
pub const COMPLETE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Tsvrefe (pub u8) ; impl Tsvrefe { # [doc = "Temperature sensor and V_REFINT channel disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Temperature sensor and V_REFINT channel enabled"]
pub const ENABLED : Self = Self (0x01) ; } } pub mod regs { # [doc = "ADC common regular data register for dual and triple modes"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cdr (pub u32) ; impl Cdr { # [doc = "1st data item of a pair of regular conversions"]
pub fn data (& self , n : usize) -> u16 { assert ! (n < 2usize) ; let offs = 0usize + n * 16usize ; let val = (self . 0 >> offs) & 0xffff ; val as u16 } # [doc = "1st data item of a pair of regular conversions"]
pub fn set_data (& mut self , n : usize , val : u16) { assert ! (n < 2usize) ; let offs = 0usize + n * 16usize ; self . 0 = (self . 0 & ! (0xffff << offs)) | (((val as u32) & 0xffff) << offs) ; } } impl Default for Cdr { fn default () -> Cdr { Cdr (0) } } # [doc = "ADC common control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ccr (pub u32) ; impl Ccr { # [doc = "Multi ADC mode selection"]
pub const fn multi (& self) -> super :: vals :: Multi { let val = (self . 0 >> 0usize) & 0x1f ; super :: vals :: Multi (val as u8) } # [doc = "Multi ADC mode selection"]
pub fn set_multi (& mut self , val : super :: vals :: Multi) { self . 0 = (self . 0 & ! (0x1f << 0usize)) | (((val . 0 as u32) & 0x1f) << 0usize) ; } # [doc = "Delay between 2 sampling phases"]
pub const fn delay (& self) -> u8 { let val = (self . 0 >> 8usize) & 0x0f ; val as u8 } # [doc = "Delay between 2 sampling phases"]
pub fn set_delay (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 8usize)) | (((val as u32) & 0x0f) << 8usize) ; } # [doc = "DMA disable selection for multi-ADC mode"]
pub const fn dds (& self) -> super :: vals :: Dds { let val = (self . 0 >> 13usize) & 0x01 ; super :: vals :: Dds (val as u8) } # [doc = "DMA disable selection for multi-ADC mode"]
pub fn set_dds (& mut self , val : super :: vals :: Dds) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val . 0 as u32) & 0x01) << 13usize) ; } # [doc = "Direct memory access mode for multi ADC mode"]
pub const fn dma (& self) -> super :: vals :: Dma { let val = (self . 0 >> 14usize) & 0x03 ; super :: vals :: Dma (val as u8) } # [doc = "Direct memory access mode for multi ADC mode"]
pub fn set_dma (& mut self , val : super :: vals :: Dma) { self . 0 = (self . 0 & ! (0x03 << 14usize)) | (((val . 0 as u32) & 0x03) << 14usize) ; } # [doc = "ADC prescaler"]
pub const fn adcpre (& self) -> super :: vals :: Adcpre { let val = (self . 0 >> 16usize) & 0x03 ; super :: vals :: Adcpre (val as u8) } # [doc = "ADC prescaler"]
pub fn set_adcpre (& mut self , val : super :: vals :: Adcpre) { self . 0 = (self . 0 & ! (0x03 << 16usize)) | (((val . 0 as u32) & 0x03) << 16usize) ; } # [doc = "VBAT enable"]
pub const fn vbate (& self) -> super :: vals :: Vbate { let val = (self . 0 >> 22usize) & 0x01 ; super :: vals :: Vbate (val as u8) } # [doc = "VBAT enable"]
pub fn set_vbate (& mut self , val : super :: vals :: Vbate) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val . 0 as u32) & 0x01) << 22usize) ; } # [doc = "Temperature sensor and VREFINT enable"]
pub const fn tsvrefe (& self) -> super :: vals :: Tsvrefe { let val = (self . 0 >> 23usize) & 0x01 ; super :: vals :: Tsvrefe (val as u8) } # [doc = "Temperature sensor and VREFINT enable"]
pub fn set_tsvrefe (& mut self , val : super :: vals :: Tsvrefe) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val . 0 as u32) & 0x01) << 23usize) ; } } impl Default for Ccr { fn default () -> Ccr { Ccr (0) } } # [doc = "ADC common status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Csr (pub u32) ; impl Csr { # [doc = "Analog watchdog flag of ADC 1"]
pub fn awd (& self , n : usize) -> super :: vals :: Awd { assert ! (n < 3usize) ; let offs = 0usize + n * 8usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Awd (val as u8) } # [doc = "Analog watchdog flag of ADC 1"]
pub fn set_awd (& mut self , n : usize , val : super :: vals :: Awd) { assert ! (n < 3usize) ; let offs = 0usize + n * 8usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "End of conversion of ADC 1"]
pub fn eoc (& self , n : usize) -> super :: vals :: Eoc { assert ! (n < 3usize) ; let offs = 1usize + n * 8usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Eoc (val as u8) } # [doc = "End of conversion of ADC 1"]
pub fn set_eoc (& mut self , n : usize , val : super :: vals :: Eoc) { assert ! (n < 3usize) ; let offs = 1usize + n * 8usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "Injected channel end of conversion of ADC 1"]
pub fn jeoc (& self , n : usize) -> super :: vals :: Jeoc { assert ! (n < 3usize) ; let offs = 2usize + n * 8usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Jeoc (val as u8) } # [doc = "Injected channel end of conversion of ADC 1"]
pub fn set_jeoc (& mut self , n : usize , val : super :: vals :: Jeoc) { assert ! (n < 3usize) ; let offs = 2usize + n * 8usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "Injected channel Start flag of ADC 1"]
pub fn jstrt (& self , n : usize) -> super :: vals :: Jstrt { assert ! (n < 3usize) ; let offs = 3usize + n * 8usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Jstrt (val as u8) } # [doc = "Injected channel Start flag of ADC 1"]
pub fn set_jstrt (& mut self , n : usize , val : super :: vals :: Jstrt) { assert ! (n < 3usize) ; let offs = 3usize + n * 8usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "Regular channel Start flag of ADC 1"]
pub fn strt (& self , n : usize) -> super :: vals :: Strt { assert ! (n < 3usize) ; let offs = 4usize + n * 8usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Strt (val as u8) } # [doc = "Regular channel Start flag of ADC 1"]
pub fn set_strt (& mut self , n : usize , val : super :: vals :: Strt) { assert ! (n < 3usize) ; let offs = 4usize + n * 8usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } # [doc = "Overrun flag of ADC 1"]
pub fn ovr (& self , n : usize) -> super :: vals :: Ovr { assert ! (n < 3usize) ; let offs = 5usize + n * 8usize ; let val = (self . 0 >> offs) & 0x01 ; super :: vals :: Ovr (val as u8) } # [doc = "Overrun flag of ADC 1"]
pub fn set_ovr (& mut self , n : usize , val : super :: vals :: Ovr) { assert ! (n < 3usize) ; let offs = 5usize + n * 8usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val . 0 as u32) & 0x01) << offs) ; } } impl Default for Csr { fn default () -> Csr { Csr (0) } } }