

# [doc = "Analog-to-Digital Converter"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Adc (pub * mut u8) ; unsafe impl Send for Adc { } unsafe impl Sync for Adc { } impl Adc { # [doc = "interrupt and status register"]
pub fn isr (self) -> crate :: common :: Reg < regs :: Isr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "interrupt enable register"]
pub fn ier (self) -> crate :: common :: Reg < regs :: Ier , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "control register"]
pub fn cr (self) -> crate :: common :: Reg < regs :: Cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "configuration register"]
pub fn cfgr (self) -> crate :: common :: Reg < regs :: Cfgr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "configuration register"]
pub fn cfgr2 (self) -> crate :: common :: Reg < regs :: Cfgr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "sample time register 1"]
pub fn smpr1 (self) -> crate :: common :: Reg < regs :: Smpr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize)) } } # [doc = "sample time register 2"]
pub fn smpr2 (self) -> crate :: common :: Reg < regs :: Smpr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (24usize)) } } # [doc = "watchdog threshold register 1"]
pub fn tr1 (self) -> crate :: common :: Reg < regs :: Tr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (32usize)) } } # [doc = "watchdog threshold register"]
pub fn tr2 (self) -> crate :: common :: Reg < regs :: Tr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "watchdog threshold register 3"]
pub fn tr3 (self) -> crate :: common :: Reg < regs :: Tr3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "regular sequence register 1"]
pub fn sqr1 (self) -> crate :: common :: Reg < regs :: Sqr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "regular sequence register 2"]
pub fn sqr2 (self) -> crate :: common :: Reg < regs :: Sqr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize)) } } # [doc = "regular sequence register 3"]
pub fn sqr3 (self) -> crate :: common :: Reg < regs :: Sqr3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } # [doc = "regular sequence register 4"]
pub fn sqr4 (self) -> crate :: common :: Reg < regs :: Sqr4 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (60usize)) } } # [doc = "regular Data Register"]
pub fn dr (self) -> crate :: common :: Reg < regs :: Dr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (64usize)) } } # [doc = "injected sequence register"]
pub fn jsqr (self) -> crate :: common :: Reg < regs :: Jsqr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } # [doc = "offset register 1"]
pub fn ofr (self , n : usize) -> crate :: common :: Reg < regs :: Ofr1 , crate :: common :: RW > { assert ! (n < 4usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (96usize + n * 4usize)) } } # [doc = "injected data register 1"]
pub fn jdr (self , n : usize) -> crate :: common :: Reg < regs :: Jdr1 , crate :: common :: R > { assert ! (n < 4usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (128usize + n * 4usize)) } } # [doc = "Analog Watchdog 2 Configuration Register"]
pub fn awd2cr (self) -> crate :: common :: Reg < regs :: Awd2cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (160usize)) } } # [doc = "Analog Watchdog 3 Configuration Register"]
pub fn awd3cr (self) -> crate :: common :: Reg < regs :: Awd3cr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (164usize)) } } # [doc = "Differential Mode Selection Register 2"]
pub fn difsel (self) -> crate :: common :: Reg < regs :: Difsel , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (176usize)) } } # [doc = "Calibration Factors"]
pub fn calfact (self) -> crate :: common :: Reg < regs :: Calfact , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (180usize)) } } } pub mod regs { # [doc = "offset register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ofr2 (pub u32) ; impl Ofr2 { # [doc = "OFFSET2"]
pub fn offset (& self , n : usize) -> u16 { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0x0fff ; val as u16 } # [doc = "OFFSET2"]
pub fn set_offset (& mut self , n : usize , val : u16) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0x0fff << offs)) | (((val as u32) & 0x0fff) << offs) ; } # [doc = "OFFSET2_CH"]
pub const fn offset2_ch (& self) -> u8 { let val = (self . 0 >> 26usize) & 0x1f ; val as u8 } # [doc = "OFFSET2_CH"]
pub fn set_offset2_ch (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 26usize)) | (((val as u32) & 0x1f) << 26usize) ; } # [doc = "OFFSET2_EN"]
pub const fn offset2_en (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "OFFSET2_EN"]
pub fn set_offset2_en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Ofr2 { fn default () -> Ofr2 { Ofr2 (0) } } # [doc = "regular Data Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dr (pub u32) ; impl Dr { # [doc = "regularDATA"]
pub const fn regular_data (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "regularDATA"]
pub fn set_regular_data (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Dr { fn default () -> Dr { Dr (0) } } # [doc = "configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr2 (pub u32) ; impl Cfgr2 { # [doc = "DMAEN"]
pub const fn rovse (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMAEN"]
pub fn set_rovse (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMACFG"]
pub const fn jovse (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DMACFG"]
pub fn set_jovse (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "RES"]
pub const fn ovsr (& self) -> u8 { let val = (self . 0 >> 2usize) & 0x07 ; val as u8 } # [doc = "RES"]
pub fn set_ovsr (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 2usize)) | (((val as u32) & 0x07) << 2usize) ; } # [doc = "ALIGN"]
pub const fn ovss (& self) -> u8 { let val = (self . 0 >> 5usize) & 0x0f ; val as u8 } # [doc = "ALIGN"]
pub fn set_ovss (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 5usize)) | (((val as u32) & 0x0f) << 5usize) ; } # [doc = "EXTSEL"]
pub const fn tovs (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "EXTSEL"]
pub fn set_tovs (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "EXTEN"]
pub const fn rovsm (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "EXTEN"]
pub fn set_rovsm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } } impl Default for Cfgr2 { fn default () -> Cfgr2 { Cfgr2 (0) } } # [doc = "injected data register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Jdr2 (pub u32) ; impl Jdr2 { # [doc = "JDATA2"]
pub fn jdata (& self , n : usize) -> u16 { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0xffff ; val as u16 } # [doc = "JDATA2"]
pub fn set_jdata (& mut self , n : usize , val : u16) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0xffff << offs)) | (((val as u32) & 0xffff) << offs) ; } } impl Default for Jdr2 { fn default () -> Jdr2 { Jdr2 (0) } } # [doc = "injected data register 4"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Jdr4 (pub u32) ; impl Jdr4 { # [doc = "JDATA4"]
pub fn jdata (& self , n : usize) -> u16 { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0xffff ; val as u16 } # [doc = "JDATA4"]
pub fn set_jdata (& mut self , n : usize , val : u16) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0xffff << offs)) | (((val as u32) & 0xffff) << offs) ; } } impl Default for Jdr4 { fn default () -> Jdr4 { Jdr4 (0) } } # [doc = "injected sequence register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Jsqr (pub u32) ; impl Jsqr { # [doc = "JL"]
pub const fn jl (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x03 ; val as u8 } # [doc = "JL"]
pub fn set_jl (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 0usize)) | (((val as u32) & 0x03) << 0usize) ; } # [doc = "JEXTSEL"]
pub const fn jextsel (& self) -> u8 { let val = (self . 0 >> 2usize) & 0x0f ; val as u8 } # [doc = "JEXTSEL"]
pub fn set_jextsel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 2usize)) | (((val as u32) & 0x0f) << 2usize) ; } # [doc = "JEXTEN"]
pub const fn jexten (& self) -> u8 { let val = (self . 0 >> 6usize) & 0x03 ; val as u8 } # [doc = "JEXTEN"]
pub fn set_jexten (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 6usize)) | (((val as u32) & 0x03) << 6usize) ; } # [doc = "JSQ1"]
pub fn jsq (& self , n : usize) -> u8 { assert ! (n < 4usize) ; let offs = 8usize + n * 6usize ; let val = (self . 0 >> offs) & 0x1f ; val as u8 } # [doc = "JSQ1"]
pub fn set_jsq (& mut self , n : usize , val : u8) { assert ! (n < 4usize) ; let offs = 8usize + n * 6usize ; self . 0 = (self . 0 & ! (0x1f << offs)) | (((val as u32) & 0x1f) << offs) ; } } impl Default for Jsqr { fn default () -> Jsqr { Jsqr (0) } } # [doc = "watchdog threshold register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Tr1 (pub u32) ; impl Tr1 { # [doc = "LT1"]
pub fn lt (& self , n : usize) -> u16 { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0x0fff ; val as u16 } # [doc = "LT1"]
pub fn set_lt (& mut self , n : usize , val : u16) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0x0fff << offs)) | (((val as u32) & 0x0fff) << offs) ; } # [doc = "HT1"]
pub fn ht (& self , n : usize) -> u16 { assert ! (n < 1usize) ; let offs = 16usize + n * 0usize ; let val = (self . 0 >> offs) & 0x0fff ; val as u16 } # [doc = "HT1"]
pub fn set_ht (& mut self , n : usize , val : u16) { assert ! (n < 1usize) ; let offs = 16usize + n * 0usize ; self . 0 = (self . 0 & ! (0x0fff << offs)) | (((val as u32) & 0x0fff) << offs) ; } } impl Default for Tr1 { fn default () -> Tr1 { Tr1 (0) } } # [doc = "control register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr (pub u32) ; impl Cr { # [doc = "ADEN"]
pub const fn aden (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "ADEN"]
pub fn set_aden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "ADDIS"]
pub const fn addis (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "ADDIS"]
pub fn set_addis (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "ADSTART"]
pub const fn adstart (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "ADSTART"]
pub fn set_adstart (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "JADSTART"]
pub const fn jadstart (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "JADSTART"]
pub fn set_jadstart (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "ADSTP"]
pub const fn adstp (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "ADSTP"]
pub fn set_adstp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "JADSTP"]
pub const fn jadstp (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "JADSTP"]
pub fn set_jadstp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "ADVREGEN"]
pub const fn advregen (& self) -> bool { let val = (self . 0 >> 28usize) & 0x01 ; val != 0 } # [doc = "ADVREGEN"]
pub fn set_advregen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 28usize)) | (((val as u32) & 0x01) << 28usize) ; } # [doc = "DEEPPWD"]
pub const fn deeppwd (& self) -> bool { let val = (self . 0 >> 29usize) & 0x01 ; val != 0 } # [doc = "DEEPPWD"]
pub fn set_deeppwd (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 29usize)) | (((val as u32) & 0x01) << 29usize) ; } # [doc = "ADCALDIF"]
pub const fn adcaldif (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "ADCALDIF"]
pub fn set_adcaldif (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } # [doc = "ADCAL"]
pub const fn adcal (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "ADCAL"]
pub fn set_adcal (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Cr { fn default () -> Cr { Cr (0) } } # [doc = "regular sequence register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sqr1 (pub u32) ; impl Sqr1 { # [doc = "Regular channel sequence length"]
pub const fn l (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x0f ; val as u8 } # [doc = "Regular channel sequence length"]
pub fn set_l (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 0usize)) | (((val as u32) & 0x0f) << 0usize) ; } # [doc = "SQ1"]
pub fn sq (& self , n : usize) -> u8 { assert ! (n < 4usize) ; let offs = 6usize + n * 6usize ; let val = (self . 0 >> offs) & 0x1f ; val as u8 } # [doc = "SQ1"]
pub fn set_sq (& mut self , n : usize , val : u8) { assert ! (n < 4usize) ; let offs = 6usize + n * 6usize ; self . 0 = (self . 0 & ! (0x1f << offs)) | (((val as u32) & 0x1f) << offs) ; } } impl Default for Sqr1 { fn default () -> Sqr1 { Sqr1 (0) } } # [doc = "regular sequence register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sqr3 (pub u32) ; impl Sqr3 { # [doc = "SQ10"]
pub fn sq (& self , n : usize) -> u8 { assert ! (n < 5usize) ; let offs = 0usize + n * 6usize ; let val = (self . 0 >> offs) & 0x1f ; val as u8 } # [doc = "SQ10"]
pub fn set_sq (& mut self , n : usize , val : u8) { assert ! (n < 5usize) ; let offs = 0usize + n * 6usize ; self . 0 = (self . 0 & ! (0x1f << offs)) | (((val as u32) & 0x1f) << offs) ; } } impl Default for Sqr3 { fn default () -> Sqr3 { Sqr3 (0) } } # [doc = "Differential Mode Selection Register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Difsel (pub u32) ; impl Difsel { # [doc = "Differential mode for channels 15 to 1"]
pub const fn difsel_1_15 (& self) -> u16 { let val = (self . 0 >> 1usize) & 0x7fff ; val as u16 } # [doc = "Differential mode for channels 15 to 1"]
pub fn set_difsel_1_15 (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x7fff << 1usize)) | (((val as u32) & 0x7fff) << 1usize) ; } # [doc = "Differential mode for channels 18 to 16"]
pub const fn difsel_16_18 (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x07 ; val as u8 } # [doc = "Differential mode for channels 18 to 16"]
pub fn set_difsel_16_18 (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 16usize)) | (((val as u32) & 0x07) << 16usize) ; } } impl Default for Difsel { fn default () -> Difsel { Difsel (0) } } # [doc = "Calibration Factors"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Calfact (pub u32) ; impl Calfact { # [doc = "CALFACT_S"]
pub const fn calfact_s (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x7f ; val as u8 } # [doc = "CALFACT_S"]
pub fn set_calfact_s (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 0usize)) | (((val as u32) & 0x7f) << 0usize) ; } # [doc = "CALFACT_D"]
pub const fn calfact_d (& self) -> u8 { let val = (self . 0 >> 16usize) & 0x7f ; val as u8 } # [doc = "CALFACT_D"]
pub fn set_calfact_d (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x7f << 16usize)) | (((val as u32) & 0x7f) << 16usize) ; } } impl Default for Calfact { fn default () -> Calfact { Calfact (0) } } # [doc = "sample time register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Smpr1 (pub u32) ; impl Smpr1 { # [doc = "Channel 0 sampling time selection"]
pub fn smp (& self , n : usize) -> super :: vals :: SampleTime { assert ! (n < 10usize) ; let offs = 0usize + n * 3usize ; let val = (self . 0 >> offs) & 0x07 ; super :: vals :: SampleTime (val as u8) } # [doc = "Channel 0 sampling time selection"]
pub fn set_smp (& mut self , n : usize , val : super :: vals :: SampleTime) { assert ! (n < 10usize) ; let offs = 0usize + n * 3usize ; self . 0 = (self . 0 & ! (0x07 << offs)) | (((val . 0 as u32) & 0x07) << offs) ; } } impl Default for Smpr1 { fn default () -> Smpr1 { Smpr1 (0) } } # [doc = "interrupt and status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Isr (pub u32) ; impl Isr { # [doc = "ADRDY"]
pub const fn adrdy (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "ADRDY"]
pub fn set_adrdy (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "EOSMP"]
pub const fn eosmp (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "EOSMP"]
pub fn set_eosmp (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "EOC"]
pub const fn eoc (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "EOC"]
pub fn set_eoc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "EOS"]
pub const fn eos (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "EOS"]
pub fn set_eos (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "OVR"]
pub const fn ovr (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "OVR"]
pub fn set_ovr (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "JEOC"]
pub const fn jeoc (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "JEOC"]
pub fn set_jeoc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "JEOS"]
pub const fn jeos (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "JEOS"]
pub fn set_jeos (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "AWD1"]
pub fn awd (& self , n : usize) -> bool { assert ! (n < 3usize) ; let offs = 7usize + n * 1usize ; let val = (self . 0 >> offs) & 0x01 ; val != 0 } # [doc = "AWD1"]
pub fn set_awd (& mut self , n : usize , val : bool) { assert ! (n < 3usize) ; let offs = 7usize + n * 1usize ; self . 0 = (self . 0 & ! (0x01 << offs)) | (((val as u32) & 0x01) << offs) ; } # [doc = "JQOVF"]
pub const fn jqovf (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "JQOVF"]
pub fn set_jqovf (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } } impl Default for Isr { fn default () -> Isr { Isr (0) } } # [doc = "sample time register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Smpr2 (pub u32) ; impl Smpr2 { # [doc = "Channel 10 sampling time selection"]
pub fn smp (& self , n : usize) -> super :: vals :: SampleTime { assert ! (n < 9usize) ; let offs = 0usize + n * 3usize ; let val = (self . 0 >> offs) & 0x07 ; super :: vals :: SampleTime (val as u8) } # [doc = "Channel 10 sampling time selection"]
pub fn set_smp (& mut self , n : usize , val : super :: vals :: SampleTime) { assert ! (n < 9usize) ; let offs = 0usize + n * 3usize ; self . 0 = (self . 0 & ! (0x07 << offs)) | (((val . 0 as u32) & 0x07) << offs) ; } } impl Default for Smpr2 { fn default () -> Smpr2 { Smpr2 (0) } } # [doc = "injected data register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Jdr3 (pub u32) ; impl Jdr3 { # [doc = "JDATA3"]
pub fn jdata (& self , n : usize) -> u16 { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0xffff ; val as u16 } # [doc = "JDATA3"]
pub fn set_jdata (& mut self , n : usize , val : u16) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0xffff << offs)) | (((val as u32) & 0xffff) << offs) ; } } impl Default for Jdr3 { fn default () -> Jdr3 { Jdr3 (0) } } # [doc = "regular sequence register 4"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sqr4 (pub u32) ; impl Sqr4 { # [doc = "SQ15"]
pub fn sq (& self , n : usize) -> u8 { assert ! (n < 2usize) ; let offs = 0usize + n * 6usize ; let val = (self . 0 >> offs) & 0x1f ; val as u8 } # [doc = "SQ15"]
pub fn set_sq (& mut self , n : usize , val : u8) { assert ! (n < 2usize) ; let offs = 0usize + n * 6usize ; self . 0 = (self . 0 & ! (0x1f << offs)) | (((val as u32) & 0x1f) << offs) ; } } impl Default for Sqr4 { fn default () -> Sqr4 { Sqr4 (0) } } # [doc = "watchdog threshold register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Tr3 (pub u32) ; impl Tr3 { # [doc = "LT3"]
pub fn lt (& self , n : usize) -> u8 { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0xff ; val as u8 } # [doc = "LT3"]
pub fn set_lt (& mut self , n : usize , val : u8) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0xff << offs)) | (((val as u32) & 0xff) << offs) ; } # [doc = "HT3"]
pub fn ht (& self , n : usize) -> u8 { assert ! (n < 1usize) ; let offs = 16usize + n * 0usize ; let val = (self . 0 >> offs) & 0xff ; val as u8 } # [doc = "HT3"]
pub fn set_ht (& mut self , n : usize , val : u8) { assert ! (n < 1usize) ; let offs = 16usize + n * 0usize ; self . 0 = (self . 0 & ! (0xff << offs)) | (((val as u32) & 0xff) << offs) ; } } impl Default for Tr3 { fn default () -> Tr3 { Tr3 (0) } } # [doc = "injected data register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Jdr1 (pub u32) ; impl Jdr1 { # [doc = "JDATA1"]
pub fn jdata (& self , n : usize) -> u16 { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0xffff ; val as u16 } # [doc = "JDATA1"]
pub fn set_jdata (& mut self , n : usize , val : u16) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0xffff << offs)) | (((val as u32) & 0xffff) << offs) ; } } impl Default for Jdr1 { fn default () -> Jdr1 { Jdr1 (0) } } # [doc = "watchdog threshold register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Tr2 (pub u32) ; impl Tr2 { # [doc = "LT2"]
pub fn lt (& self , n : usize) -> u8 { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0xff ; val as u8 } # [doc = "LT2"]
pub fn set_lt (& mut self , n : usize , val : u8) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0xff << offs)) | (((val as u32) & 0xff) << offs) ; } # [doc = "HT2"]
pub fn ht (& self , n : usize) -> u8 { assert ! (n < 1usize) ; let offs = 16usize + n * 0usize ; let val = (self . 0 >> offs) & 0xff ; val as u8 } # [doc = "HT2"]
pub fn set_ht (& mut self , n : usize , val : u8) { assert ! (n < 1usize) ; let offs = 16usize + n * 0usize ; self . 0 = (self . 0 & ! (0xff << offs)) | (((val as u32) & 0xff) << offs) ; } } impl Default for Tr2 { fn default () -> Tr2 { Tr2 (0) } } # [doc = "Analog Watchdog 2 Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Awd2cr (pub u32) ; impl Awd2cr { # [doc = "AWD2CH"]
pub const fn awd2ch (& self) -> u32 { let val = (self . 0 >> 1usize) & 0x0003_ffff ; val as u32 } # [doc = "AWD2CH"]
pub fn set_awd2ch (& mut self , val : u32) { self . 0 = (self . 0 & ! (0x0003_ffff << 1usize)) | (((val as u32) & 0x0003_ffff) << 1usize) ; } } impl Default for Awd2cr { fn default () -> Awd2cr { Awd2cr (0) } } # [doc = "offset register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ofr3 (pub u32) ; impl Ofr3 { # [doc = "OFFSET3"]
pub fn offset (& self , n : usize) -> u16 { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0x0fff ; val as u16 } # [doc = "OFFSET3"]
pub fn set_offset (& mut self , n : usize , val : u16) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0x0fff << offs)) | (((val as u32) & 0x0fff) << offs) ; } # [doc = "OFFSET3_CH"]
pub const fn offset3_ch (& self) -> u8 { let val = (self . 0 >> 26usize) & 0x1f ; val as u8 } # [doc = "OFFSET3_CH"]
pub fn set_offset3_ch (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 26usize)) | (((val as u32) & 0x1f) << 26usize) ; } # [doc = "OFFSET3_EN"]
pub const fn offset3_en (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "OFFSET3_EN"]
pub fn set_offset3_en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Ofr3 { fn default () -> Ofr3 { Ofr3 (0) } } # [doc = "regular sequence register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sqr2 (pub u32) ; impl Sqr2 { # [doc = "SQ5"]
pub fn sq (& self , n : usize) -> u8 { assert ! (n < 5usize) ; let offs = 0usize + n * 6usize ; let val = (self . 0 >> offs) & 0x1f ; val as u8 } # [doc = "SQ5"]
pub fn set_sq (& mut self , n : usize , val : u8) { assert ! (n < 5usize) ; let offs = 0usize + n * 6usize ; self . 0 = (self . 0 & ! (0x1f << offs)) | (((val as u32) & 0x1f) << offs) ; } } impl Default for Sqr2 { fn default () -> Sqr2 { Sqr2 (0) } } # [doc = "offset register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ofr1 (pub u32) ; impl Ofr1 { # [doc = "OFFSET1"]
pub fn offset (& self , n : usize) -> u16 { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0x0fff ; val as u16 } # [doc = "OFFSET1"]
pub fn set_offset (& mut self , n : usize , val : u16) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0x0fff << offs)) | (((val as u32) & 0x0fff) << offs) ; } # [doc = "OFFSET1_CH"]
pub const fn offset1_ch (& self) -> u8 { let val = (self . 0 >> 26usize) & 0x1f ; val as u8 } # [doc = "OFFSET1_CH"]
pub fn set_offset1_ch (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 26usize)) | (((val as u32) & 0x1f) << 26usize) ; } # [doc = "OFFSET1_EN"]
pub const fn offset1_en (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "OFFSET1_EN"]
pub fn set_offset1_en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Ofr1 { fn default () -> Ofr1 { Ofr1 (0) } } # [doc = "configuration register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cfgr (pub u32) ; impl Cfgr { # [doc = "DMAEN"]
pub const fn dmaen (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "DMAEN"]
pub fn set_dmaen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "DMACFG"]
pub const fn dmacfg (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "DMACFG"]
pub fn set_dmacfg (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "RES"]
pub const fn res (& self) -> super :: vals :: Res { let val = (self . 0 >> 3usize) & 0x03 ; super :: vals :: Res (val as u8) } # [doc = "RES"]
pub fn set_res (& mut self , val : super :: vals :: Res) { self . 0 = (self . 0 & ! (0x03 << 3usize)) | (((val . 0 as u32) & 0x03) << 3usize) ; } # [doc = "ALIGN"]
pub const fn align (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "ALIGN"]
pub fn set_align (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "EXTSEL"]
pub const fn extsel (& self) -> u8 { let val = (self . 0 >> 6usize) & 0x0f ; val as u8 } # [doc = "EXTSEL"]
pub fn set_extsel (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 6usize)) | (((val as u32) & 0x0f) << 6usize) ; } # [doc = "EXTEN"]
pub const fn exten (& self) -> u8 { let val = (self . 0 >> 10usize) & 0x03 ; val as u8 } # [doc = "EXTEN"]
pub fn set_exten (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 10usize)) | (((val as u32) & 0x03) << 10usize) ; } # [doc = "OVRMOD"]
pub const fn ovrmod (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "OVRMOD"]
pub fn set_ovrmod (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "CONT"]
pub const fn cont (& self) -> bool { let val = (self . 0 >> 13usize) & 0x01 ; val != 0 } # [doc = "CONT"]
pub fn set_cont (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 13usize)) | (((val as u32) & 0x01) << 13usize) ; } # [doc = "AUTDLY"]
pub const fn autdly (& self) -> bool { let val = (self . 0 >> 14usize) & 0x01 ; val != 0 } # [doc = "AUTDLY"]
pub fn set_autdly (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 14usize)) | (((val as u32) & 0x01) << 14usize) ; } # [doc = "AUTOFF"]
pub const fn autoff (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "AUTOFF"]
pub fn set_autoff (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "DISCEN"]
pub const fn discen (& self) -> bool { let val = (self . 0 >> 16usize) & 0x01 ; val != 0 } # [doc = "DISCEN"]
pub fn set_discen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 16usize)) | (((val as u32) & 0x01) << 16usize) ; } # [doc = "DISCNUM"]
pub const fn discnum (& self) -> u8 { let val = (self . 0 >> 17usize) & 0x07 ; val as u8 } # [doc = "DISCNUM"]
pub fn set_discnum (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 17usize)) | (((val as u32) & 0x07) << 17usize) ; } # [doc = "JDISCEN"]
pub const fn jdiscen (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "JDISCEN"]
pub fn set_jdiscen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "JQM"]
pub const fn jqm (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "JQM"]
pub fn set_jqm (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "AWD1SGL"]
pub const fn awd1sgl (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "AWD1SGL"]
pub fn set_awd1sgl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "AWD1EN"]
pub const fn awd1en (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "AWD1EN"]
pub fn set_awd1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } # [doc = "JAWD1EN"]
pub const fn jawd1en (& self) -> bool { let val = (self . 0 >> 24usize) & 0x01 ; val != 0 } # [doc = "JAWD1EN"]
pub fn set_jawd1en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 24usize)) | (((val as u32) & 0x01) << 24usize) ; } # [doc = "JAUTO"]
pub const fn jauto (& self) -> bool { let val = (self . 0 >> 25usize) & 0x01 ; val != 0 } # [doc = "JAUTO"]
pub fn set_jauto (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 25usize)) | (((val as u32) & 0x01) << 25usize) ; } # [doc = "AWDCH1CH"]
pub const fn awdch1ch (& self) -> u8 { let val = (self . 0 >> 26usize) & 0x1f ; val as u8 } # [doc = "AWDCH1CH"]
pub fn set_awdch1ch (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 26usize)) | (((val as u32) & 0x1f) << 26usize) ; } } impl Default for Cfgr { fn default () -> Cfgr { Cfgr (0) } } # [doc = "interrupt enable register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ier (pub u32) ; impl Ier { # [doc = "ADRDYIE"]
pub const fn adrdyie (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "ADRDYIE"]
pub fn set_adrdyie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "EOSMPIE"]
pub const fn eosmpie (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "EOSMPIE"]
pub fn set_eosmpie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "EOCIE"]
pub const fn eocie (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "EOCIE"]
pub fn set_eocie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "EOSIE"]
pub const fn eosie (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "EOSIE"]
pub fn set_eosie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "OVRIE"]
pub const fn ovrie (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "OVRIE"]
pub fn set_ovrie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } # [doc = "JEOCIE"]
pub const fn jeocie (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "JEOCIE"]
pub fn set_jeocie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "JEOSIE"]
pub const fn jeosie (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "JEOSIE"]
pub fn set_jeosie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "AWD1IE"]
pub const fn awd1ie (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "AWD1IE"]
pub fn set_awd1ie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "AWD2IE"]
pub const fn awd2ie (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "AWD2IE"]
pub fn set_awd2ie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "AWD3IE"]
pub const fn awd3ie (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "AWD3IE"]
pub fn set_awd3ie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "JQOVFIE"]
pub const fn jqovfie (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "JQOVFIE"]
pub fn set_jqovfie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } } impl Default for Ier { fn default () -> Ier { Ier (0) } } # [doc = "offset register 4"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ofr4 (pub u32) ; impl Ofr4 { # [doc = "OFFSET4"]
pub fn offset (& self , n : usize) -> u16 { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; let val = (self . 0 >> offs) & 0x0fff ; val as u16 } # [doc = "OFFSET4"]
pub fn set_offset (& mut self , n : usize , val : u16) { assert ! (n < 1usize) ; let offs = 0usize + n * 0usize ; self . 0 = (self . 0 & ! (0x0fff << offs)) | (((val as u32) & 0x0fff) << offs) ; } # [doc = "OFFSET4_CH"]
pub const fn offset4_ch (& self) -> u8 { let val = (self . 0 >> 26usize) & 0x1f ; val as u8 } # [doc = "OFFSET4_CH"]
pub fn set_offset4_ch (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 26usize)) | (((val as u32) & 0x1f) << 26usize) ; } # [doc = "OFFSET4_EN"]
pub const fn offset4_en (& self) -> bool { let val = (self . 0 >> 31usize) & 0x01 ; val != 0 } # [doc = "OFFSET4_EN"]
pub fn set_offset4_en (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 31usize)) | (((val as u32) & 0x01) << 31usize) ; } } impl Default for Ofr4 { fn default () -> Ofr4 { Ofr4 (0) } } # [doc = "Analog Watchdog 3 Configuration Register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Awd3cr (pub u32) ; impl Awd3cr { # [doc = "AWD3CH"]
pub const fn awd3ch (& self) -> u32 { let val = (self . 0 >> 1usize) & 0x0003_ffff ; val as u32 } # [doc = "AWD3CH"]
pub fn set_awd3ch (& mut self , val : u32) { self . 0 = (self . 0 & ! (0x0003_ffff << 1usize)) | (((val as u32) & 0x0003_ffff) << 1usize) ; } } impl Default for Awd3cr { fn default () -> Awd3cr { Awd3cr (0) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Res (pub u8) ; impl Res { # [doc = "12-bit resolution"]
pub const TWELVEBIT : Self = Self (0) ; # [doc = "10-bit resolution"]
pub const TENBIT : Self = Self (0x01) ; # [doc = "8-bit resolution"]
pub const EIGHTBIT : Self = Self (0x02) ; # [doc = "6-bit resolution"]
pub const SIXBIT : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct SampleTime (pub u8) ; impl SampleTime { # [doc = "2.5 ADC cycles"]
pub const CYCLES2_5 : Self = Self (0) ; # [doc = "6.5 ADC cycles"]
pub const CYCLES6_5 : Self = Self (0x01) ; # [doc = "12.5 ADC cycles"]
pub const CYCLES12_5 : Self = Self (0x02) ; # [doc = "24.5 ADC cycles"]
pub const CYCLES24_5 : Self = Self (0x03) ; # [doc = "47.5 ADC cycles"]
pub const CYCLES47_5 : Self = Self (0x04) ; # [doc = "92.5 ADC cycles"]
pub const CYCLES92_5 : Self = Self (0x05) ; # [doc = "247.5 ADC cycles"]
pub const CYCLES247_5 : Self = Self (0x06) ; # [doc = "640.5 ADC cycles"]
pub const CYCLES640_5 : Self = Self (0x07) ; } }