

# [doc = "Analog-to-digital converter"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Adc (pub * mut u8) ; unsafe impl Send for Adc { } unsafe impl Sync for Adc { } impl Adc { # [doc = "status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "control register 1"]
pub fn cr1 (self) -> crate :: common :: Reg < regs :: Cr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "control register 2"]
pub fn cr2 (self) -> crate :: common :: Reg < regs :: Cr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "sample time register 1"]
pub fn smpr1 (self) -> crate :: common :: Reg < regs :: Smpr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "sample time register 2"]
pub fn smpr2 (self) -> crate :: common :: Reg < regs :: Smpr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "injected channel data offset register x"]
pub fn jofr (self , n : usize) -> crate :: common :: Reg < regs :: Jofr , crate :: common :: RW > { assert ! (n < 4usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize + n * 4usize)) } } # [doc = "watchdog higher threshold register"]
pub fn htr (self) -> crate :: common :: Reg < regs :: Htr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "watchdog lower threshold register"]
pub fn ltr (self) -> crate :: common :: Reg < regs :: Ltr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "regular sequence register 1"]
pub fn sqr1 (self) -> crate :: common :: Reg < regs :: Sqr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "regular sequence register 2"]
pub fn sqr2 (self) -> crate :: common :: Reg < regs :: Sqr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "regular sequence register 3"]
pub fn sqr3 (self) -> crate :: common :: Reg < regs :: Sqr3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize)) } } # [doc = "injected sequence register"]
pub fn jsqr (self) -> crate :: common :: Reg < regs :: Jsqr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } # [doc = "injected data register x"]
pub fn jdr (self , n : usize) -> crate :: common :: Reg < regs :: Jdr , crate :: common :: R > { assert ! (n < 4usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (60usize + n * 4usize)) } } # [doc = "regular data register"]
pub fn dr (self) -> crate :: common :: Reg < regs :: Dr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Jeocie (pub u8) ; impl Jeocie { # [doc = "JEOC interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "JEOC interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dma (pub u8) ; impl Dma { # [doc = "DMA mode disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "DMA mode enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Jauto (pub u8) ; impl Jauto { # [doc = "Automatic injected group conversion disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Automatic injected group conversion enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Jstrt (pub u8) ; impl Jstrt { # [doc = "No injected channel conversion started"]
pub const NOTSTARTED : Self = Self (0) ; # [doc = "Injected channel conversion has started"]
pub const STARTED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Res (pub u8) ; impl Res { # [doc = "12-bit (15 ADCCLK cycles)"]
pub const TWELVEBIT : Self = Self (0) ; # [doc = "10-bit (13 ADCCLK cycles)"]
pub const TENBIT : Self = Self (0x01) ; # [doc = "8-bit (11 ADCCLK cycles)"]
pub const EIGHTBIT : Self = Self (0x02) ; # [doc = "6-bit (9 ADCCLK cycles)"]
pub const SIXBIT : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Eocie (pub u8) ; impl Eocie { # [doc = "EOC interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "EOC interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Awdsgl (pub u8) ; impl Awdsgl { # [doc = "Analog watchdog enabled on all channels"]
pub const ALLCHANNELS : Self = Self (0) ; # [doc = "Analog watchdog enabled on a single channel"]
pub const SINGLECHANNEL : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Jextsel (pub u8) ; impl Jextsel { # [doc = "Timer 1 TRGO event"]
pub const TIM1TRGO : Self = Self (0) ; # [doc = "Timer 1 CC4 event"]
pub const TIM1CC4 : Self = Self (0x01) ; # [doc = "Timer 2 TRGO event"]
pub const TIM2TRGO : Self = Self (0x02) ; # [doc = "Timer 2 CC1 event"]
pub const TIM2CC1 : Self = Self (0x03) ; # [doc = "Timer 3 CC4 event"]
pub const TIM3CC4 : Self = Self (0x04) ; # [doc = "Timer 4 TRGO event"]
pub const TIM4TRGO : Self = Self (0x05) ; # [doc = "Timer 8 CC4 event"]
pub const TIM8CC4 : Self = Self (0x07) ; # [doc = "Timer 1 TRGO(2) event"]
pub const TIM1TRGO2 : Self = Self (0x08) ; # [doc = "Timer 8 TRGO event"]
pub const TIM8TRGO : Self = Self (0x09) ; # [doc = "Timer 8 TRGO(2) event"]
pub const TIM8TRGO2 : Self = Self (0x0a) ; # [doc = "Timer 3 CC3 event"]
pub const TIM3CC3 : Self = Self (0x0b) ; # [doc = "Timer 5 TRGO event"]
pub const TIM5TRGO : Self = Self (0x0c) ; # [doc = "Timer 3 CC1 event"]
pub const TIM3CC1 : Self = Self (0x0d) ; # [doc = "Timer 6 TRGO event"]
pub const TIM6TRGO : Self = Self (0x0e) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ovrie (pub u8) ; impl Ovrie { # [doc = "Overrun interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Overrun interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Jexten (pub u8) ; impl Jexten { # [doc = "Trigger detection disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Trigger detection on the rising edge"]
pub const RISINGEDGE : Self = Self (0x01) ; # [doc = "Trigger detection on the falling edge"]
pub const FALLINGEDGE : Self = Self (0x02) ; # [doc = "Trigger detection on both the rising and falling edges"]
pub const BOTHEDGES : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Extsel (pub u8) ; impl Extsel { # [doc = "Timer 1 CC1 event"]
pub const TIM1CC1 : Self = Self (0) ; # [doc = "Timer 1 CC2 event"]
pub const TIM1CC2 : Self = Self (0x01) ; # [doc = "Timer 1 CC3 event"]
pub const TIM1CC3 : Self = Self (0x02) ; # [doc = "Timer 2 CC2 event"]
pub const TIM2CC2 : Self = Self (0x03) ; # [doc = "Timer 2 CC3 event"]
pub const TIM2CC3 : Self = Self (0x04) ; # [doc = "Timer 2 CC4 event"]
pub const TIM2CC4 : Self = Self (0x05) ; # [doc = "Timer 2 TRGO event"]
pub const TIM2TRGO : Self = Self (0x06) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Eocs (pub u8) ; impl Eocs { # [doc = "The EOC bit is set at the end of each sequence of regular conversions"]
pub const EACHSEQUENCE : Self = Self (0) ; # [doc = "The EOC bit is set at the end of each regular conversion"]
pub const EACHCONVERSION : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Smp (pub u8) ; impl Smp { # [doc = "3 cycles"]
pub const CYCLES3 : Self = Self (0) ; # [doc = "15 cycles"]
pub const CYCLES15 : Self = Self (0x01) ; # [doc = "28 cycles"]
pub const CYCLES28 : Self = Self (0x02) ; # [doc = "56 cycles"]
pub const CYCLES56 : Self = Self (0x03) ; # [doc = "84 cycles"]
pub const CYCLES84 : Self = Self (0x04) ; # [doc = "112 cycles"]
pub const CYCLES112 : Self = Self (0x05) ; # [doc = "144 cycles"]
pub const CYCLES144 : Self = Self (0x06) ; # [doc = "480 cycles"]
pub const CYCLES480 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Jeoc (pub u8) ; impl Jeoc { # [doc = "Conversion is not complete"]
pub const NOTCOMPLETE : Self = Self (0) ; # [doc = "Conversion complete"]
pub const COMPLETE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Awdie (pub u8) ; impl Awdie { # [doc = "Analogue watchdog interrupt disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Analogue watchdog interrupt enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Swstartw (pub u8) ; impl Swstartw { # [doc = "Starts conversion of regular channels"]
pub const START : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct SmprSmpxX (pub u32) ; impl SmprSmpxX { # [doc = "3 cycles"]
pub const CYCLES3 : Self = Self (0) ; # [doc = "15 cycles"]
pub const CYCLES15 : Self = Self (0x01) ; # [doc = "28 cycles"]
pub const CYCLES28 : Self = Self (0x02) ; # [doc = "56 cycles"]
pub const CYCLES56 : Self = Self (0x03) ; # [doc = "84 cycles"]
pub const CYCLES84 : Self = Self (0x04) ; # [doc = "112 cycles"]
pub const CYCLES112 : Self = Self (0x05) ; # [doc = "144 cycles"]
pub const CYCLES144 : Self = Self (0x06) ; # [doc = "480 cycles"]
pub const CYCLES480 : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Align (pub u8) ; impl Align { # [doc = "Right alignment"]
pub const RIGHT : Self = Self (0) ; # [doc = "Left alignment"]
pub const LEFT : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Jswstartw (pub u8) ; impl Jswstartw { # [doc = "Starts conversion of injected channels"]
pub const START : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Discen (pub u8) ; impl Discen { # [doc = "Discontinuous mode on regular channels disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Discontinuous mode on regular channels enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Cont (pub u8) ; impl Cont { # [doc = "Single conversion mode"]
pub const SINGLE : Self = Self (0) ; # [doc = "Continuous conversion mode"]
pub const CONTINUOUS : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Awden (pub u8) ; impl Awden { # [doc = "Analog watchdog disabled on regular channels"]
pub const DISABLED : Self = Self (0) ; # [doc = "Analog watchdog enabled on regular channels"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Ovr (pub u8) ; impl Ovr { # [doc = "No overrun occurred"]
pub const NOOVERRUN : Self = Self (0) ; # [doc = "Overrun occurred"]
pub const OVERRUN : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Exten (pub u8) ; impl Exten { # [doc = "Trigger detection disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Trigger detection on the rising edge"]
pub const RISINGEDGE : Self = Self (0x01) ; # [doc = "Trigger detection on the falling edge"]
pub const FALLINGEDGE : Self = Self (0x02) ; # [doc = "Trigger detection on both the rising and falling edges"]
pub const BOTHEDGES : Self = Self (0x03) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dds (pub u8) ; impl Dds { # [doc = "No new DMA request is issued after the last transfer"]
pub const SINGLE : Self = Self (0) ; # [doc = "DMA requests are issued as long as data are converted and DMA=1"]
pub const CONTINUOUS : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Adon (pub u8) ; impl Adon { # [doc = "Disable ADC conversion and go to power down mode"]
pub const DISABLED : Self = Self (0) ; # [doc = "Enable ADC"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Strt (pub u8) ; impl Strt { # [doc = "No regular channel conversion started"]
pub const NOTSTARTED : Self = Self (0) ; # [doc = "Regular channel conversion has started"]
pub const STARTED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Jdiscen (pub u8) ; impl Jdiscen { # [doc = "Discontinuous mode on injected channels disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Discontinuous mode on injected channels enabled"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Awd (pub u8) ; impl Awd { # [doc = "No analog watchdog event occurred"]
pub const NOEVENT : Self = Self (0) ; # [doc = "Analog watchdog event occurred"]
pub const EVENT : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Jawden (pub u8) ; impl Jawden { # [doc = "Analog watchdog disabled on injected channels"]
pub const DISABLED : Self = Self (0) ; # [doc = "Analog watchdog enabled on injected channels"]
pub const ENABLED : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Eoc (pub u8) ; impl Eoc { # [doc = "Conversion is not complete"]
pub const NOTCOMPLETE : Self = Self (0) ; # [doc = "Conversion complete"]
pub const COMPLETE : Self = Self (0x01) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Scan (pub u8) ; impl Scan { # [doc = "Scan mode disabled"]
pub const DISABLED : Self = Self (0) ; # [doc = "Scan mode enabled"]
pub const ENABLED : Self = Self (0x01) ; } } pub mod regs { # [doc = "regular sequence register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sqr3 (pub u32) ; impl Sqr3 { # [doc = "1st conversion in regular sequence"]
pub fn sq (& self , n : usize) -> u8 { assert ! (n < 6usize) ; let offs = 0usize + n * 5usize ; let val = (self . 0 >> offs) & 0x1f ; val as u8 } # [doc = "1st conversion in regular sequence"]
pub fn set_sq (& mut self , n : usize , val : u8) { assert ! (n < 6usize) ; let offs = 0usize + n * 5usize ; self . 0 = (self . 0 & ! (0x1f << offs)) | (((val as u32) & 0x1f) << offs) ; } } impl Default for Sqr3 { fn default () -> Sqr3 { Sqr3 (0) } } # [doc = "injected sequence register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Jsqr (pub u32) ; impl Jsqr { # [doc = "1st conversion in injected sequence"]
pub fn jsq (& self , n : usize) -> u8 { assert ! (n < 4usize) ; let offs = 0usize + n * 5usize ; let val = (self . 0 >> offs) & 0x1f ; val as u8 } # [doc = "1st conversion in injected sequence"]
pub fn set_jsq (& mut self , n : usize , val : u8) { assert ! (n < 4usize) ; let offs = 0usize + n * 5usize ; self . 0 = (self . 0 & ! (0x1f << offs)) | (((val as u32) & 0x1f) << offs) ; } # [doc = "Injected sequence length"]
pub const fn jl (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x03 ; val as u8 } # [doc = "Injected sequence length"]
pub fn set_jl (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val as u32) & 0x03) << 20usize) ; } } impl Default for Jsqr { fn default () -> Jsqr { Jsqr (0) } } # [doc = "watchdog lower threshold register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ltr (pub u32) ; impl Ltr { # [doc = "Analog watchdog lower threshold"]
pub const fn lt (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Analog watchdog lower threshold"]
pub fn set_lt (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } } impl Default for Ltr { fn default () -> Ltr { Ltr (0) } } # [doc = "sample time register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Smpr2 (pub u32) ; impl Smpr2 { # [doc = "Channel 0 sampling time selection"]
pub fn smp (& self , n : usize) -> super :: vals :: Smp { assert ! (n < 10usize) ; let offs = 0usize + n * 3usize ; let val = (self . 0 >> offs) & 0x07 ; super :: vals :: Smp (val as u8) } # [doc = "Channel 0 sampling time selection"]
pub fn set_smp (& mut self , n : usize , val : super :: vals :: Smp) { assert ! (n < 10usize) ; let offs = 0usize + n * 3usize ; self . 0 = (self . 0 & ! (0x07 << offs)) | (((val . 0 as u32) & 0x07) << offs) ; } # [doc = "Sample time bits"]
pub const fn smpx_x (& self) -> super :: vals :: SmprSmpxX { let val = (self . 0 >> 0usize) & 0xffff_ffff ; super :: vals :: SmprSmpxX (val as u32) } # [doc = "Sample time bits"]
pub fn set_smpx_x (& mut self , val : super :: vals :: SmprSmpxX) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val . 0 as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Smpr2 { fn default () -> Smpr2 { Smpr2 (0) } } # [doc = "injected data register x"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Jdr (pub u32) ; impl Jdr { # [doc = "Injected data"]
pub const fn jdata (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Injected data"]
pub fn set_jdata (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Jdr { fn default () -> Jdr { Jdr (0) } } # [doc = "sample time register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Smpr1 (pub u32) ; impl Smpr1 { # [doc = "Channel 10 sampling time selection"]
pub fn smp (& self , n : usize) -> super :: vals :: Smp { assert ! (n < 9usize) ; let offs = 0usize + n * 3usize ; let val = (self . 0 >> offs) & 0x07 ; super :: vals :: Smp (val as u8) } # [doc = "Channel 10 sampling time selection"]
pub fn set_smp (& mut self , n : usize , val : super :: vals :: Smp) { assert ! (n < 9usize) ; let offs = 0usize + n * 3usize ; self . 0 = (self . 0 & ! (0x07 << offs)) | (((val . 0 as u32) & 0x07) << offs) ; } # [doc = "Sample time bits"]
pub const fn smpx_x (& self) -> super :: vals :: SmprSmpxX { let val = (self . 0 >> 0usize) & 0xffff_ffff ; super :: vals :: SmprSmpxX (val as u32) } # [doc = "Sample time bits"]
pub fn set_smpx_x (& mut self , val : super :: vals :: SmprSmpxX) { self . 0 = (self . 0 & ! (0xffff_ffff << 0usize)) | (((val . 0 as u32) & 0xffff_ffff) << 0usize) ; } } impl Default for Smpr1 { fn default () -> Smpr1 { Smpr1 (0) } } # [doc = "injected channel data offset register x"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Jofr (pub u32) ; impl Jofr { # [doc = "Data offset for injected channel x"]
pub const fn joffset (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Data offset for injected channel x"]
pub fn set_joffset (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } } impl Default for Jofr { fn default () -> Jofr { Jofr (0) } } # [doc = "regular sequence register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sqr1 (pub u32) ; impl Sqr1 { # [doc = "13th conversion in regular sequence"]
pub fn sq (& self , n : usize) -> u8 { assert ! (n < 4usize) ; let offs = 0usize + n * 5usize ; let val = (self . 0 >> offs) & 0x1f ; val as u8 } # [doc = "13th conversion in regular sequence"]
pub fn set_sq (& mut self , n : usize , val : u8) { assert ! (n < 4usize) ; let offs = 0usize + n * 5usize ; self . 0 = (self . 0 & ! (0x1f << offs)) | (((val as u32) & 0x1f) << offs) ; } # [doc = "Regular channel sequence length"]
pub const fn l (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x0f ; val as u8 } # [doc = "Regular channel sequence length"]
pub fn set_l (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 20usize)) | (((val as u32) & 0x0f) << 20usize) ; } } impl Default for Sqr1 { fn default () -> Sqr1 { Sqr1 (0) } } # [doc = "status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr (pub u32) ; impl Sr { # [doc = "Analog watchdog flag"]
pub const fn awd (& self) -> super :: vals :: Awd { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Awd (val as u8) } # [doc = "Analog watchdog flag"]
pub fn set_awd (& mut self , val : super :: vals :: Awd) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Regular channel end of conversion"]
pub const fn eoc (& self) -> super :: vals :: Eoc { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Eoc (val as u8) } # [doc = "Regular channel end of conversion"]
pub fn set_eoc (& mut self , val : super :: vals :: Eoc) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Injected channel end of conversion"]
pub const fn jeoc (& self) -> super :: vals :: Jeoc { let val = (self . 0 >> 2usize) & 0x01 ; super :: vals :: Jeoc (val as u8) } # [doc = "Injected channel end of conversion"]
pub fn set_jeoc (& mut self , val : super :: vals :: Jeoc) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val . 0 as u32) & 0x01) << 2usize) ; } # [doc = "Injected channel start flag"]
pub const fn jstrt (& self) -> super :: vals :: Jstrt { let val = (self . 0 >> 3usize) & 0x01 ; super :: vals :: Jstrt (val as u8) } # [doc = "Injected channel start flag"]
pub fn set_jstrt (& mut self , val : super :: vals :: Jstrt) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val . 0 as u32) & 0x01) << 3usize) ; } # [doc = "Regular channel start flag"]
pub const fn strt (& self) -> super :: vals :: Strt { let val = (self . 0 >> 4usize) & 0x01 ; super :: vals :: Strt (val as u8) } # [doc = "Regular channel start flag"]
pub fn set_strt (& mut self , val : super :: vals :: Strt) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val . 0 as u32) & 0x01) << 4usize) ; } # [doc = "Overrun"]
pub const fn ovr (& self) -> super :: vals :: Ovr { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Ovr (val as u8) } # [doc = "Overrun"]
pub fn set_ovr (& mut self , val : super :: vals :: Ovr) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } } impl Default for Sr { fn default () -> Sr { Sr (0) } } # [doc = "control register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr1 (pub u32) ; impl Cr1 { # [doc = "Analog watchdog channel select bits"]
pub const fn awdch (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x1f ; val as u8 } # [doc = "Analog watchdog channel select bits"]
pub fn set_awdch (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 0usize)) | (((val as u32) & 0x1f) << 0usize) ; } # [doc = "Interrupt enable for EOC"]
pub const fn eocie (& self) -> super :: vals :: Eocie { let val = (self . 0 >> 5usize) & 0x01 ; super :: vals :: Eocie (val as u8) } # [doc = "Interrupt enable for EOC"]
pub fn set_eocie (& mut self , val : super :: vals :: Eocie) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val . 0 as u32) & 0x01) << 5usize) ; } # [doc = "Analog watchdog interrupt enable"]
pub const fn awdie (& self) -> super :: vals :: Awdie { let val = (self . 0 >> 6usize) & 0x01 ; super :: vals :: Awdie (val as u8) } # [doc = "Analog watchdog interrupt enable"]
pub fn set_awdie (& mut self , val : super :: vals :: Awdie) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val . 0 as u32) & 0x01) << 6usize) ; } # [doc = "Interrupt enable for injected channels"]
pub const fn jeocie (& self) -> super :: vals :: Jeocie { let val = (self . 0 >> 7usize) & 0x01 ; super :: vals :: Jeocie (val as u8) } # [doc = "Interrupt enable for injected channels"]
pub fn set_jeocie (& mut self , val : super :: vals :: Jeocie) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val . 0 as u32) & 0x01) << 7usize) ; } # [doc = "Scan mode"]
pub const fn scan (& self) -> super :: vals :: Scan { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Scan (val as u8) } # [doc = "Scan mode"]
pub fn set_scan (& mut self , val : super :: vals :: Scan) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "Enable the watchdog on a single channel in scan mode"]
pub const fn awdsgl (& self) -> super :: vals :: Awdsgl { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Awdsgl (val as u8) } # [doc = "Enable the watchdog on a single channel in scan mode"]
pub fn set_awdsgl (& mut self , val : super :: vals :: Awdsgl) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "Automatic injected group conversion"]
pub const fn jauto (& self) -> super :: vals :: Jauto { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Jauto (val as u8) } # [doc = "Automatic injected group conversion"]
pub fn set_jauto (& mut self , val : super :: vals :: Jauto) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "Discontinuous mode on regular channels"]
pub const fn discen (& self) -> super :: vals :: Discen { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Discen (val as u8) } # [doc = "Discontinuous mode on regular channels"]
pub fn set_discen (& mut self , val : super :: vals :: Discen) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "Discontinuous mode on injected channels"]
pub const fn jdiscen (& self) -> super :: vals :: Jdiscen { let val = (self . 0 >> 12usize) & 0x01 ; super :: vals :: Jdiscen (val as u8) } # [doc = "Discontinuous mode on injected channels"]
pub fn set_jdiscen (& mut self , val : super :: vals :: Jdiscen) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val . 0 as u32) & 0x01) << 12usize) ; } # [doc = "Discontinuous mode channel count"]
pub const fn discnum (& self) -> u8 { let val = (self . 0 >> 13usize) & 0x07 ; val as u8 } # [doc = "Discontinuous mode channel count"]
pub fn set_discnum (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 13usize)) | (((val as u32) & 0x07) << 13usize) ; } # [doc = "Analog watchdog enable on injected channels"]
pub const fn jawden (& self) -> super :: vals :: Jawden { let val = (self . 0 >> 22usize) & 0x01 ; super :: vals :: Jawden (val as u8) } # [doc = "Analog watchdog enable on injected channels"]
pub fn set_jawden (& mut self , val : super :: vals :: Jawden) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val . 0 as u32) & 0x01) << 22usize) ; } # [doc = "Analog watchdog enable on regular channels"]
pub const fn awden (& self) -> super :: vals :: Awden { let val = (self . 0 >> 23usize) & 0x01 ; super :: vals :: Awden (val as u8) } # [doc = "Analog watchdog enable on regular channels"]
pub fn set_awden (& mut self , val : super :: vals :: Awden) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val . 0 as u32) & 0x01) << 23usize) ; } # [doc = "Resolution"]
pub const fn res (& self) -> super :: vals :: Res { let val = (self . 0 >> 24usize) & 0x03 ; super :: vals :: Res (val as u8) } # [doc = "Resolution"]
pub fn set_res (& mut self , val : super :: vals :: Res) { self . 0 = (self . 0 & ! (0x03 << 24usize)) | (((val . 0 as u32) & 0x03) << 24usize) ; } # [doc = "Overrun interrupt enable"]
pub const fn ovrie (& self) -> super :: vals :: Ovrie { let val = (self . 0 >> 26usize) & 0x01 ; super :: vals :: Ovrie (val as u8) } # [doc = "Overrun interrupt enable"]
pub fn set_ovrie (& mut self , val : super :: vals :: Ovrie) { self . 0 = (self . 0 & ! (0x01 << 26usize)) | (((val . 0 as u32) & 0x01) << 26usize) ; } } impl Default for Cr1 { fn default () -> Cr1 { Cr1 (0) } } # [doc = "regular data register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dr (pub u32) ; impl Dr { # [doc = "Regular data"]
pub const fn data (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Regular data"]
pub fn set_data (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Dr { fn default () -> Dr { Dr (0) } } # [doc = "regular sequence register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sqr2 (pub u32) ; impl Sqr2 { # [doc = "7th conversion in regular sequence"]
pub fn sq (& self , n : usize) -> u8 { assert ! (n < 6usize) ; let offs = 0usize + n * 5usize ; let val = (self . 0 >> offs) & 0x1f ; val as u8 } # [doc = "7th conversion in regular sequence"]
pub fn set_sq (& mut self , n : usize , val : u8) { assert ! (n < 6usize) ; let offs = 0usize + n * 5usize ; self . 0 = (self . 0 & ! (0x1f << offs)) | (((val as u32) & 0x1f) << offs) ; } } impl Default for Sqr2 { fn default () -> Sqr2 { Sqr2 (0) } } # [doc = "control register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr2 (pub u32) ; impl Cr2 { # [doc = "A/D Converter ON / OFF"]
pub const fn adon (& self) -> super :: vals :: Adon { let val = (self . 0 >> 0usize) & 0x01 ; super :: vals :: Adon (val as u8) } # [doc = "A/D Converter ON / OFF"]
pub fn set_adon (& mut self , val : super :: vals :: Adon) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val . 0 as u32) & 0x01) << 0usize) ; } # [doc = "Continuous conversion"]
pub const fn cont (& self) -> super :: vals :: Cont { let val = (self . 0 >> 1usize) & 0x01 ; super :: vals :: Cont (val as u8) } # [doc = "Continuous conversion"]
pub fn set_cont (& mut self , val : super :: vals :: Cont) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val . 0 as u32) & 0x01) << 1usize) ; } # [doc = "Direct memory access mode (for single ADC mode)"]
pub const fn dma (& self) -> super :: vals :: Dma { let val = (self . 0 >> 8usize) & 0x01 ; super :: vals :: Dma (val as u8) } # [doc = "Direct memory access mode (for single ADC mode)"]
pub fn set_dma (& mut self , val : super :: vals :: Dma) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val . 0 as u32) & 0x01) << 8usize) ; } # [doc = "DMA disable selection (for single ADC mode)"]
pub const fn dds (& self) -> super :: vals :: Dds { let val = (self . 0 >> 9usize) & 0x01 ; super :: vals :: Dds (val as u8) } # [doc = "DMA disable selection (for single ADC mode)"]
pub fn set_dds (& mut self , val : super :: vals :: Dds) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val . 0 as u32) & 0x01) << 9usize) ; } # [doc = "End of conversion selection"]
pub const fn eocs (& self) -> super :: vals :: Eocs { let val = (self . 0 >> 10usize) & 0x01 ; super :: vals :: Eocs (val as u8) } # [doc = "End of conversion selection"]
pub fn set_eocs (& mut self , val : super :: vals :: Eocs) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val . 0 as u32) & 0x01) << 10usize) ; } # [doc = "Data alignment"]
pub const fn align (& self) -> super :: vals :: Align { let val = (self . 0 >> 11usize) & 0x01 ; super :: vals :: Align (val as u8) } # [doc = "Data alignment"]
pub fn set_align (& mut self , val : super :: vals :: Align) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val . 0 as u32) & 0x01) << 11usize) ; } # [doc = "External event select for injected group"]
pub const fn jextsel (& self) -> super :: vals :: Jextsel { let val = (self . 0 >> 16usize) & 0x0f ; super :: vals :: Jextsel (val as u8) } # [doc = "External event select for injected group"]
pub fn set_jextsel (& mut self , val : super :: vals :: Jextsel) { self . 0 = (self . 0 & ! (0x0f << 16usize)) | (((val . 0 as u32) & 0x0f) << 16usize) ; } # [doc = "External trigger enable for injected channels"]
pub const fn jexten (& self) -> super :: vals :: Jexten { let val = (self . 0 >> 20usize) & 0x03 ; super :: vals :: Jexten (val as u8) } # [doc = "External trigger enable for injected channels"]
pub fn set_jexten (& mut self , val : super :: vals :: Jexten) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val . 0 as u32) & 0x03) << 20usize) ; } # [doc = "Start conversion of injected channels"]
pub const fn jswstart (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "Start conversion of injected channels"]
pub fn set_jswstart (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "External event select for regular group"]
pub const fn extsel (& self) -> super :: vals :: Extsel { let val = (self . 0 >> 24usize) & 0x0f ; super :: vals :: Extsel (val as u8) } # [doc = "External event select for regular group"]
pub fn set_extsel (& mut self , val : super :: vals :: Extsel) { self . 0 = (self . 0 & ! (0x0f << 24usize)) | (((val . 0 as u32) & 0x0f) << 24usize) ; } # [doc = "External trigger enable for regular channels"]
pub const fn exten (& self) -> super :: vals :: Exten { let val = (self . 0 >> 28usize) & 0x03 ; super :: vals :: Exten (val as u8) } # [doc = "External trigger enable for regular channels"]
pub fn set_exten (& mut self , val : super :: vals :: Exten) { self . 0 = (self . 0 & ! (0x03 << 28usize)) | (((val . 0 as u32) & 0x03) << 28usize) ; } # [doc = "Start conversion of regular channels"]
pub const fn swstart (& self) -> bool { let val = (self . 0 >> 30usize) & 0x01 ; val != 0 } # [doc = "Start conversion of regular channels"]
pub fn set_swstart (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 30usize)) | (((val as u32) & 0x01) << 30usize) ; } } impl Default for Cr2 { fn default () -> Cr2 { Cr2 (0) } } # [doc = "watchdog higher threshold register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Htr (pub u32) ; impl Htr { # [doc = "Analog watchdog higher threshold"]
pub const fn ht (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Analog watchdog higher threshold"]
pub fn set_ht (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } } impl Default for Htr { fn default () -> Htr { Htr (0) } } }