

# [doc = "Analog-to-digital converter"]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Adc (pub * mut u8) ; unsafe impl Send for Adc { } unsafe impl Sync for Adc { } impl Adc { # [doc = "status register"]
pub fn sr (self) -> crate :: common :: Reg < regs :: Sr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (0usize)) } } # [doc = "control register 1"]
pub fn cr1 (self) -> crate :: common :: Reg < regs :: Cr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (4usize)) } } # [doc = "control register 2"]
pub fn cr2 (self) -> crate :: common :: Reg < regs :: Cr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (8usize)) } } # [doc = "sample time register 1"]
pub fn smpr1 (self) -> crate :: common :: Reg < regs :: Smpr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (12usize)) } } # [doc = "sample time register 2"]
pub fn smpr2 (self) -> crate :: common :: Reg < regs :: Smpr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (16usize)) } } # [doc = "injected channel data offset register x"]
pub fn jofr (self , n : usize) -> crate :: common :: Reg < regs :: Jofr , crate :: common :: RW > { assert ! (n < 4usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (20usize + n * 4usize)) } } # [doc = "watchdog higher threshold register"]
pub fn htr (self) -> crate :: common :: Reg < regs :: Htr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (36usize)) } } # [doc = "watchdog lower threshold register"]
pub fn ltr (self) -> crate :: common :: Reg < regs :: Ltr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (40usize)) } } # [doc = "regular sequence register 1"]
pub fn sqr1 (self) -> crate :: common :: Reg < regs :: Sqr1 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (44usize)) } } # [doc = "regular sequence register 2"]
pub fn sqr2 (self) -> crate :: common :: Reg < regs :: Sqr2 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (48usize)) } } # [doc = "regular sequence register 3"]
pub fn sqr3 (self) -> crate :: common :: Reg < regs :: Sqr3 , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (52usize)) } } # [doc = "injected sequence register"]
pub fn jsqr (self) -> crate :: common :: Reg < regs :: Jsqr , crate :: common :: RW > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (56usize)) } } # [doc = "injected data register x"]
pub fn jdr (self , n : usize) -> crate :: common :: Reg < regs :: Jdr , crate :: common :: R > { assert ! (n < 4usize) ; unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (60usize + n * 4usize)) } } # [doc = "regular data register"]
pub fn dr (self) -> crate :: common :: Reg < regs :: Dr , crate :: common :: R > { unsafe { crate :: common :: Reg :: from_ptr (self . 0 . add (76usize)) } } } pub mod vals { # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Extsel (pub u8) ; impl Extsel { # [doc = "Timer 1 TRGO event"]
pub const TIM1TRGO : Self = Self (0) ; # [doc = "Timer 1 CC4 event"]
pub const TIM1CC4 : Self = Self (0x01) ; # [doc = "Timer 2 TRGO event"]
pub const TIM2TRGO : Self = Self (0x02) ; # [doc = "Timer 2 CC1 event"]
pub const TIM2CC1 : Self = Self (0x03) ; # [doc = "Timer 3 CC4 event"]
pub const TIM3CC4 : Self = Self (0x04) ; # [doc = "Timer 4 TRGO event"]
pub const TIM4TRGO : Self = Self (0x05) ; # [doc = "EXTI line 15/Timer 8 CC4 event"]
pub const TIM8CC4 : Self = Self (0x06) ; # [doc = "SWSTART"]
pub const SWSTART : Self = Self (0x07) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct Dualmod (pub u8) ; impl Dualmod { # [doc = "Independent mode."]
pub const INDEPENDENT : Self = Self (0) ; # [doc = "Combined regular simultaneous + injected simultaneous mode"]
pub const REGULARINJECTED : Self = Self (0x01) ; # [doc = "Combined regular simultaneous + alternate trigger mode"]
pub const REGULARALTERNATETRIGGER : Self = Self (0x02) ; # [doc = "Combined injected simultaneous + fast interleaved mode"]
pub const INJECTEDFASTINTERLEAVED : Self = Self (0x03) ; # [doc = "Combined injected simultaneous + slow Interleaved mode"]
pub const INJECTEDSLOWINTERLEAVED : Self = Self (0x04) ; # [doc = "Injected simultaneous mode only"]
pub const INJECTED : Self = Self (0x05) ; # [doc = "Regular simultaneous mode only"]
pub const REGULAR : Self = Self (0x06) ; # [doc = "Fast interleaved mode only"]
pub const FASTINTERLEAVED : Self = Self (0x07) ; # [doc = "Slow interleaved mode only"]
pub const SLOWINTERLEAVED : Self = Self (0x08) ; # [doc = "Alternate trigger mode only"]
pub const ALTERNATETRIGGER : Self = Self (0x09) ; } # [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq , Ord , PartialOrd)]
pub struct SampleTime (pub u8) ; impl SampleTime { # [doc = "1.5 cycles"]
pub const CYCLES1_5 : Self = Self (0) ; # [doc = "7.5 cycles"]
pub const CYCLES7_5 : Self = Self (0x01) ; # [doc = "13.5 cycles"]
pub const CYCLES13_5 : Self = Self (0x02) ; # [doc = "28.5 cycles"]
pub const CYCLES28_5 : Self = Self (0x03) ; # [doc = "41.5 cycles"]
pub const CYCLES41_5 : Self = Self (0x04) ; # [doc = "55.5 cycles"]
pub const CYCLES55_5 : Self = Self (0x05) ; # [doc = "71.5 cycles"]
pub const CYCLES71_5 : Self = Self (0x06) ; # [doc = "239.5 cycles"]
pub const CYCLES239_5 : Self = Self (0x07) ; } } pub mod regs { # [doc = "regular data register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Dr (pub u32) ; impl Dr { # [doc = "Regular data"]
pub const fn data (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Regular data"]
pub fn set_data (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } # [doc = "ADC2 data"]
pub const fn adc2data (& self) -> u16 { let val = (self . 0 >> 16usize) & 0xffff ; val as u16 } # [doc = "ADC2 data"]
pub fn set_adc2data (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 16usize)) | (((val as u32) & 0xffff) << 16usize) ; } } impl Default for Dr { fn default () -> Dr { Dr (0) } } # [doc = "control register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr2 (pub u32) ; impl Cr2 { # [doc = "A/D Converter ON / OFF"]
pub const fn adon (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "A/D Converter ON / OFF"]
pub fn set_adon (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Continuous conversion"]
pub const fn cont (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Continuous conversion"]
pub fn set_cont (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "A/D Calibration"]
pub const fn cal (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "A/D Calibration"]
pub fn set_cal (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Reset calibration"]
pub const fn rstcal (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Reset calibration"]
pub fn set_rstcal (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Direct memory access mode (for single ADC mode)"]
pub const fn dma (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Direct memory access mode (for single ADC mode)"]
pub fn set_dma (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Data alignment"]
pub const fn align (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Data alignment"]
pub fn set_align (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "External event select for injected group"]
pub const fn jextsel (& self) -> super :: vals :: Extsel { let val = (self . 0 >> 12usize) & 0x07 ; super :: vals :: Extsel (val as u8) } # [doc = "External event select for injected group"]
pub fn set_jextsel (& mut self , val : super :: vals :: Extsel) { self . 0 = (self . 0 & ! (0x07 << 12usize)) | (((val . 0 as u32) & 0x07) << 12usize) ; } # [doc = "External trigger conversion mode for injected channels"]
pub const fn jexttrig (& self) -> bool { let val = (self . 0 >> 15usize) & 0x01 ; val != 0 } # [doc = "External trigger conversion mode for injected channels"]
pub fn set_jexttrig (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 15usize)) | (((val as u32) & 0x01) << 15usize) ; } # [doc = "External event select for regular group"]
pub const fn extsel (& self) -> super :: vals :: Extsel { let val = (self . 0 >> 17usize) & 0x07 ; super :: vals :: Extsel (val as u8) } # [doc = "External event select for regular group"]
pub fn set_extsel (& mut self , val : super :: vals :: Extsel) { self . 0 = (self . 0 & ! (0x07 << 17usize)) | (((val . 0 as u32) & 0x07) << 17usize) ; } # [doc = "External trigger conversion mode for regular channels"]
pub const fn exttrig (& self) -> bool { let val = (self . 0 >> 20usize) & 0x01 ; val != 0 } # [doc = "External trigger conversion mode for regular channels"]
pub fn set_exttrig (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 20usize)) | (((val as u32) & 0x01) << 20usize) ; } # [doc = "Start conversion of injected channels"]
pub const fn jswstart (& self) -> bool { let val = (self . 0 >> 21usize) & 0x01 ; val != 0 } # [doc = "Start conversion of injected channels"]
pub fn set_jswstart (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 21usize)) | (((val as u32) & 0x01) << 21usize) ; } # [doc = "Start conversion of regular channels"]
pub const fn swstart (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "Start conversion of regular channels"]
pub fn set_swstart (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Temperature sensor and VREFINT enable"]
pub const fn tsvrefe (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Temperature sensor and VREFINT enable"]
pub fn set_tsvrefe (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } } impl Default for Cr2 { fn default () -> Cr2 { Cr2 (0) } } # [doc = "regular sequence register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sqr2 (pub u32) ; impl Sqr2 { # [doc = "7th to 12th conversion in regular sequence"]
pub fn sq (& self , n : usize) -> u8 { assert ! (n < 6usize) ; let offs = 0usize + n * 5usize ; let val = (self . 0 >> offs) & 0x1f ; val as u8 } # [doc = "7th to 12th conversion in regular sequence"]
pub fn set_sq (& mut self , n : usize , val : u8) { assert ! (n < 6usize) ; let offs = 0usize + n * 5usize ; self . 0 = (self . 0 & ! (0x1f << offs)) | (((val as u32) & 0x1f) << offs) ; } } impl Default for Sqr2 { fn default () -> Sqr2 { Sqr2 (0) } } # [doc = "injected channel data offset register x"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Jofr (pub u32) ; impl Jofr { # [doc = "Data offset for injected channel x"]
pub const fn joffset (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Data offset for injected channel x"]
pub fn set_joffset (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } } impl Default for Jofr { fn default () -> Jofr { Jofr (0) } } # [doc = "sample time register 2"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Smpr2 (pub u32) ; impl Smpr2 { # [doc = "Channel 0 sampling time selection"]
pub fn smp (& self , n : usize) -> super :: vals :: SampleTime { assert ! (n < 10usize) ; let offs = 0usize + n * 3usize ; let val = (self . 0 >> offs) & 0x07 ; super :: vals :: SampleTime (val as u8) } # [doc = "Channel 0 sampling time selection"]
pub fn set_smp (& mut self , n : usize , val : super :: vals :: SampleTime) { assert ! (n < 10usize) ; let offs = 0usize + n * 3usize ; self . 0 = (self . 0 & ! (0x07 << offs)) | (((val . 0 as u32) & 0x07) << offs) ; } } impl Default for Smpr2 { fn default () -> Smpr2 { Smpr2 (0) } } # [doc = "status register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sr (pub u32) ; impl Sr { # [doc = "Analog watchdog flag"]
pub const fn awd (& self) -> bool { let val = (self . 0 >> 0usize) & 0x01 ; val != 0 } # [doc = "Analog watchdog flag"]
pub fn set_awd (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 0usize)) | (((val as u32) & 0x01) << 0usize) ; } # [doc = "Regular channel end of conversion"]
pub const fn eoc (& self) -> bool { let val = (self . 0 >> 1usize) & 0x01 ; val != 0 } # [doc = "Regular channel end of conversion"]
pub fn set_eoc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 1usize)) | (((val as u32) & 0x01) << 1usize) ; } # [doc = "Injected channel end of conversion"]
pub const fn jeoc (& self) -> bool { let val = (self . 0 >> 2usize) & 0x01 ; val != 0 } # [doc = "Injected channel end of conversion"]
pub fn set_jeoc (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 2usize)) | (((val as u32) & 0x01) << 2usize) ; } # [doc = "Injected channel start flag"]
pub const fn jstrt (& self) -> bool { let val = (self . 0 >> 3usize) & 0x01 ; val != 0 } # [doc = "Injected channel start flag"]
pub fn set_jstrt (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 3usize)) | (((val as u32) & 0x01) << 3usize) ; } # [doc = "Regular channel start flag"]
pub const fn strt (& self) -> bool { let val = (self . 0 >> 4usize) & 0x01 ; val != 0 } # [doc = "Regular channel start flag"]
pub fn set_strt (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 4usize)) | (((val as u32) & 0x01) << 4usize) ; } } impl Default for Sr { fn default () -> Sr { Sr (0) } } # [doc = "watchdog lower threshold register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Ltr (pub u32) ; impl Ltr { # [doc = "Analog watchdog lower threshold"]
pub const fn lt (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Analog watchdog lower threshold"]
pub fn set_lt (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } } impl Default for Ltr { fn default () -> Ltr { Ltr (0) } } # [doc = "watchdog higher threshold register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Htr (pub u32) ; impl Htr { # [doc = "Analog watchdog higher threshold"]
pub const fn ht (& self) -> u16 { let val = (self . 0 >> 0usize) & 0x0fff ; val as u16 } # [doc = "Analog watchdog higher threshold"]
pub fn set_ht (& mut self , val : u16) { self . 0 = (self . 0 & ! (0x0fff << 0usize)) | (((val as u32) & 0x0fff) << 0usize) ; } } impl Default for Htr { fn default () -> Htr { Htr (0) } } # [doc = "control register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Cr1 (pub u32) ; impl Cr1 { # [doc = "Analog watchdog channel select bits"]
pub const fn awdch (& self) -> u8 { let val = (self . 0 >> 0usize) & 0x1f ; val as u8 } # [doc = "Analog watchdog channel select bits"]
pub fn set_awdch (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x1f << 0usize)) | (((val as u32) & 0x1f) << 0usize) ; } # [doc = "Interrupt enable for EOC"]
pub const fn eocie (& self) -> bool { let val = (self . 0 >> 5usize) & 0x01 ; val != 0 } # [doc = "Interrupt enable for EOC"]
pub fn set_eocie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 5usize)) | (((val as u32) & 0x01) << 5usize) ; } # [doc = "Analog watchdog interrupt enable"]
pub const fn awdie (& self) -> bool { let val = (self . 0 >> 6usize) & 0x01 ; val != 0 } # [doc = "Analog watchdog interrupt enable"]
pub fn set_awdie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 6usize)) | (((val as u32) & 0x01) << 6usize) ; } # [doc = "Interrupt enable for injected channels"]
pub const fn jeocie (& self) -> bool { let val = (self . 0 >> 7usize) & 0x01 ; val != 0 } # [doc = "Interrupt enable for injected channels"]
pub fn set_jeocie (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 7usize)) | (((val as u32) & 0x01) << 7usize) ; } # [doc = "Scan mode"]
pub const fn scan (& self) -> bool { let val = (self . 0 >> 8usize) & 0x01 ; val != 0 } # [doc = "Scan mode"]
pub fn set_scan (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 8usize)) | (((val as u32) & 0x01) << 8usize) ; } # [doc = "Enable the watchdog on a single channel in scan mode"]
pub const fn awdsgl (& self) -> bool { let val = (self . 0 >> 9usize) & 0x01 ; val != 0 } # [doc = "Enable the watchdog on a single channel in scan mode"]
pub fn set_awdsgl (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 9usize)) | (((val as u32) & 0x01) << 9usize) ; } # [doc = "Automatic injected group conversion"]
pub const fn jauto (& self) -> bool { let val = (self . 0 >> 10usize) & 0x01 ; val != 0 } # [doc = "Automatic injected group conversion"]
pub fn set_jauto (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 10usize)) | (((val as u32) & 0x01) << 10usize) ; } # [doc = "Discontinuous mode on regular channels"]
pub const fn discen (& self) -> bool { let val = (self . 0 >> 11usize) & 0x01 ; val != 0 } # [doc = "Discontinuous mode on regular channels"]
pub fn set_discen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 11usize)) | (((val as u32) & 0x01) << 11usize) ; } # [doc = "Discontinuous mode on injected channels"]
pub const fn jdiscen (& self) -> bool { let val = (self . 0 >> 12usize) & 0x01 ; val != 0 } # [doc = "Discontinuous mode on injected channels"]
pub fn set_jdiscen (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 12usize)) | (((val as u32) & 0x01) << 12usize) ; } # [doc = "Discontinuous mode channel count"]
pub const fn discnum (& self) -> u8 { let val = (self . 0 >> 13usize) & 0x07 ; val as u8 } # [doc = "Discontinuous mode channel count"]
pub fn set_discnum (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x07 << 13usize)) | (((val as u32) & 0x07) << 13usize) ; } # [doc = "Dual mode selection"]
pub const fn dualmod (& self) -> super :: vals :: Dualmod { let val = (self . 0 >> 16usize) & 0x0f ; super :: vals :: Dualmod (val as u8) } # [doc = "Dual mode selection"]
pub fn set_dualmod (& mut self , val : super :: vals :: Dualmod) { self . 0 = (self . 0 & ! (0x0f << 16usize)) | (((val . 0 as u32) & 0x0f) << 16usize) ; } # [doc = "Analog watchdog enable on injected channels"]
pub const fn jawden (& self) -> bool { let val = (self . 0 >> 22usize) & 0x01 ; val != 0 } # [doc = "Analog watchdog enable on injected channels"]
pub fn set_jawden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 22usize)) | (((val as u32) & 0x01) << 22usize) ; } # [doc = "Analog watchdog enable on regular channels"]
pub const fn awden (& self) -> bool { let val = (self . 0 >> 23usize) & 0x01 ; val != 0 } # [doc = "Analog watchdog enable on regular channels"]
pub fn set_awden (& mut self , val : bool) { self . 0 = (self . 0 & ! (0x01 << 23usize)) | (((val as u32) & 0x01) << 23usize) ; } } impl Default for Cr1 { fn default () -> Cr1 { Cr1 (0) } } # [doc = "injected data register x"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Jdr (pub u32) ; impl Jdr { # [doc = "Injected data"]
pub const fn jdata (& self) -> u16 { let val = (self . 0 >> 0usize) & 0xffff ; val as u16 } # [doc = "Injected data"]
pub fn set_jdata (& mut self , val : u16) { self . 0 = (self . 0 & ! (0xffff << 0usize)) | (((val as u32) & 0xffff) << 0usize) ; } } impl Default for Jdr { fn default () -> Jdr { Jdr (0) } } # [doc = "regular sequence register 3"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sqr3 (pub u32) ; impl Sqr3 { # [doc = "1st to 6th conversion in regular sequence"]
pub fn sq (& self , n : usize) -> u8 { assert ! (n < 6usize) ; let offs = 0usize + n * 5usize ; let val = (self . 0 >> offs) & 0x1f ; val as u8 } # [doc = "1st to 6th conversion in regular sequence"]
pub fn set_sq (& mut self , n : usize , val : u8) { assert ! (n < 6usize) ; let offs = 0usize + n * 5usize ; self . 0 = (self . 0 & ! (0x1f << offs)) | (((val as u32) & 0x1f) << offs) ; } } impl Default for Sqr3 { fn default () -> Sqr3 { Sqr3 (0) } } # [doc = "regular sequence register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Sqr1 (pub u32) ; impl Sqr1 { # [doc = "13th to 16th conversion in regular sequence"]
pub fn sq (& self , n : usize) -> u8 { assert ! (n < 4usize) ; let offs = 0usize + n * 5usize ; let val = (self . 0 >> offs) & 0x1f ; val as u8 } # [doc = "13th to 16th conversion in regular sequence"]
pub fn set_sq (& mut self , n : usize , val : u8) { assert ! (n < 4usize) ; let offs = 0usize + n * 5usize ; self . 0 = (self . 0 & ! (0x1f << offs)) | (((val as u32) & 0x1f) << offs) ; } # [doc = "Regular channel sequence length"]
pub const fn l (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x0f ; val as u8 } # [doc = "Regular channel sequence length"]
pub fn set_l (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x0f << 20usize)) | (((val as u32) & 0x0f) << 20usize) ; } } impl Default for Sqr1 { fn default () -> Sqr1 { Sqr1 (0) } } # [doc = "injected sequence register"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Jsqr (pub u32) ; impl Jsqr { # [doc = "1st conversion in injected sequence"]
pub fn jsq (& self , n : usize) -> u8 { assert ! (n < 4usize) ; let offs = 0usize + n * 5usize ; let val = (self . 0 >> offs) & 0x1f ; val as u8 } # [doc = "1st conversion in injected sequence"]
pub fn set_jsq (& mut self , n : usize , val : u8) { assert ! (n < 4usize) ; let offs = 0usize + n * 5usize ; self . 0 = (self . 0 & ! (0x1f << offs)) | (((val as u32) & 0x1f) << offs) ; } # [doc = "Injected sequence length"]
pub const fn jl (& self) -> u8 { let val = (self . 0 >> 20usize) & 0x03 ; val as u8 } # [doc = "Injected sequence length"]
pub fn set_jl (& mut self , val : u8) { self . 0 = (self . 0 & ! (0x03 << 20usize)) | (((val as u32) & 0x03) << 20usize) ; } } impl Default for Jsqr { fn default () -> Jsqr { Jsqr (0) } } # [doc = "sample time register 1"]
# [repr (transparent)]
# [derive (Copy , Clone , Eq , PartialEq)]
pub struct Smpr1 (pub u32) ; impl Smpr1 { # [doc = "Channel x sample time selection"]
pub fn smp (& self , n : usize) -> super :: vals :: SampleTime { assert ! (n < 8usize) ; let offs = 0usize + n * 3usize ; let val = (self . 0 >> offs) & 0x07 ; super :: vals :: SampleTime (val as u8) } # [doc = "Channel x sample time selection"]
pub fn set_smp (& mut self , n : usize , val : super :: vals :: SampleTime) { assert ! (n < 8usize) ; let offs = 0usize + n * 3usize ; self . 0 = (self . 0 & ! (0x07 << offs)) | (((val . 0 as u32) & 0x07) << offs) ; } } impl Default for Smpr1 { fn default () -> Smpr1 { Smpr1 (0) } } }