

# [derive (Copy , Clone , Debug , PartialEq , Eq)]
pub enum Interrupt { # [doc = "0 - WWDG"]
WWDG = 0 , # [doc = "1 - PVD_PVM"]
PVD_PVM = 1 , # [doc = "2 - TAMP_STAMP_LSECSS"]
TAMP_STAMP_LSECSS = 2 , # [doc = "3 - RTC_WKUP"]
RTC_WKUP = 3 , # [doc = "4 - FLASH"]
FLASH = 4 , # [doc = "5 - RCC"]
RCC = 5 , # [doc = "6 - EXTI0"]
EXTI0 = 6 , # [doc = "7 - EXTI1"]
EXTI1 = 7 , # [doc = "8 - EXTI2"]
EXTI2 = 8 , # [doc = "9 - EXTI3"]
EXTI3 = 9 , # [doc = "10 - EXTI4"]
EXTI4 = 10 , # [doc = "11 - DMA1_CHANNEL1"]
DMA1_CHANNEL1 = 11 , # [doc = "12 - DMA1_CHANNEL2"]
DMA1_CHANNEL2 = 12 , # [doc = "13 - DMA1_CHANNEL3"]
DMA1_CHANNEL3 = 13 , # [doc = "14 - DMA1_CHANNEL4"]
DMA1_CHANNEL4 = 14 , # [doc = "15 - DMA1_CHANNEL5"]
DMA1_CHANNEL5 = 15 , # [doc = "16 - DMA1_CHANNEL6"]
DMA1_CHANNEL6 = 16 , # [doc = "17 - DMA1_CHANNEL7"]
DMA1_CHANNEL7 = 17 , # [doc = "18 - ADC1"]
ADC1 = 18 , # [doc = "21 - C2SEV_PWR_C2H"]
C2SEV_PWR_C2H = 21 , # [doc = "22 - COMP"]
COMP = 22 , # [doc = "23 - EXTI9_5"]
EXTI9_5 = 23 , # [doc = "24 - TIM1_BRK"]
TIM1_BRK = 24 , # [doc = "25 - TIM1_UP"]
TIM1_UP = 25 , # [doc = "26 - TIM1_TRG_COM"]
TIM1_TRG_COM = 26 , # [doc = "27 - TIM1_CC"]
TIM1_CC = 27 , # [doc = "28 - TIM2"]
TIM2 = 28 , # [doc = "29 - PKA"]
PKA = 29 , # [doc = "30 - I2C1_EV"]
I2C1_EV = 30 , # [doc = "31 - I2C1_ER"]
I2C1_ER = 31 , # [doc = "34 - SPI1"]
SPI1 = 34 , # [doc = "36 - USART1"]
USART1 = 36 , # [doc = "37 - LPUART1"]
LPUART1 = 37 , # [doc = "39 - TSC"]
TSC = 39 , # [doc = "40 - EXTI15_10"]
EXTI15_10 = 40 , # [doc = "41 - RTC_ALARM"]
RTC_ALARM = 41 , # [doc = "44 - IPCC_C1_RX"]
IPCC_C1_RX = 44 , # [doc = "45 - IPCC_C1_TX"]
IPCC_C1_TX = 45 , # [doc = "46 - HSEM"]
HSEM = 46 , # [doc = "47 - LPTIM1"]
LPTIM1 = 47 , # [doc = "48 - LPTIM2"]
LPTIM2 = 48 , # [doc = "52 - AES2"]
AES2 = 52 , # [doc = "53 - RNG"]
RNG = 53 , # [doc = "54 - FPU"]
FPU = 54 , # [doc = "62 - DMAMUX1_OVR"]
DMAMUX1_OVR = 62 , } unsafe impl cortex_m :: interrupt :: InterruptNumber for Interrupt { # [inline (always)]
fn number (self) -> u16 { self as u16 } } # [cfg (feature = "rt")]
mod _vectors { extern "C" { fn WWDG () ; fn PVD_PVM () ; fn TAMP_STAMP_LSECSS () ; fn RTC_WKUP () ; fn FLASH () ; fn RCC () ; fn EXTI0 () ; fn EXTI1 () ; fn EXTI2 () ; fn EXTI3 () ; fn EXTI4 () ; fn DMA1_CHANNEL1 () ; fn DMA1_CHANNEL2 () ; fn DMA1_CHANNEL3 () ; fn DMA1_CHANNEL4 () ; fn DMA1_CHANNEL5 () ; fn DMA1_CHANNEL6 () ; fn DMA1_CHANNEL7 () ; fn ADC1 () ; fn C2SEV_PWR_C2H () ; fn COMP () ; fn EXTI9_5 () ; fn TIM1_BRK () ; fn TIM1_UP () ; fn TIM1_TRG_COM () ; fn TIM1_CC () ; fn TIM2 () ; fn PKA () ; fn I2C1_EV () ; fn I2C1_ER () ; fn SPI1 () ; fn USART1 () ; fn LPUART1 () ; fn TSC () ; fn EXTI15_10 () ; fn RTC_ALARM () ; fn IPCC_C1_RX () ; fn IPCC_C1_TX () ; fn HSEM () ; fn LPTIM1 () ; fn LPTIM2 () ; fn AES2 () ; fn RNG () ; fn FPU () ; fn DMAMUX1_OVR () ; } pub union Vector { _handler : unsafe extern "C" fn () , _reserved : u32 , } # [link_section = ".vector_table.interrupts"]
# [no_mangle]
pub static __INTERRUPTS : [Vector ; 63]
= [Vector { _handler : WWDG } , Vector { _handler : PVD_PVM } , Vector { _handler : TAMP_STAMP_LSECSS } , Vector { _handler : RTC_WKUP } , Vector { _handler : FLASH } , Vector { _handler : RCC } , Vector { _handler : EXTI0 } , Vector { _handler : EXTI1 } , Vector { _handler : EXTI2 } , Vector { _handler : EXTI3 } , Vector { _handler : EXTI4 } , Vector { _handler : DMA1_CHANNEL1 } , Vector { _handler : DMA1_CHANNEL2 } , Vector { _handler : DMA1_CHANNEL3 } , Vector { _handler : DMA1_CHANNEL4 } , Vector { _handler : DMA1_CHANNEL5 } , Vector { _handler : DMA1_CHANNEL6 } , Vector { _handler : DMA1_CHANNEL7 } , Vector { _handler : ADC1 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : C2SEV_PWR_C2H } , Vector { _handler : COMP } , Vector { _handler : EXTI9_5 } , Vector { _handler : TIM1_BRK } , Vector { _handler : TIM1_UP } , Vector { _handler : TIM1_TRG_COM } , Vector { _handler : TIM1_CC } , Vector { _handler : TIM2 } , Vector { _handler : PKA } , Vector { _handler : I2C1_EV } , Vector { _handler : I2C1_ER } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : SPI1 } , Vector { _reserved : 0 } , Vector { _handler : USART1 } , Vector { _handler : LPUART1 } , Vector { _reserved : 0 } , Vector { _handler : TSC } , Vector { _handler : EXTI15_10 } , Vector { _handler : RTC_ALARM } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : IPCC_C1_RX } , Vector { _handler : IPCC_C1_TX } , Vector { _handler : HSEM } , Vector { _handler : LPTIM1 } , Vector { _handler : LPTIM2 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : AES2 } , Vector { _handler : RNG } , Vector { _handler : FPU } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : DMAMUX1_OVR } ,]
; } pub const ADC1 : * mut () = 0x4001_2400 as u32 as _ ; pub const ADC_COMMON : * mut () = 0x4001_2700 as u32 as _ ; pub const AES2 : * mut () = 0x5800_1800 as u32 as _ ; pub const COMP1 : * mut () = 0x4001_0200 as u32 as _ ; pub const CRC : crc :: Crc = crc :: Crc (0x4002_3000 as u32 as _) ; pub const DBGMCU : dbgmcu :: Dbgmcu = dbgmcu :: Dbgmcu (0xe004_2000 as u32 as _) ; pub const DMA1 : bdma :: Dma = bdma :: Dma (0x4002_0000 as u32 as _) ; pub const DMAMUX1 : dmamux :: Dmamux = dmamux :: Dmamux (0x4002_0800 as u32 as _) ; pub const EXTI : exti :: Exti = exti :: Exti (0x5800_0800 as u32 as _) ; pub const FLASH : flash :: Flash = flash :: Flash (0x5800_4000 as u32 as _) ; pub const GPIOA : gpio :: Gpio = gpio :: Gpio (0x4800_0000 as u32 as _) ; pub const GPIOB : gpio :: Gpio = gpio :: Gpio (0x4800_0400 as u32 as _) ; pub const GPIOC : gpio :: Gpio = gpio :: Gpio (0x4800_0800 as u32 as _) ; pub const GPIOE : gpio :: Gpio = gpio :: Gpio (0x4800_1000 as u32 as _) ; pub const GPIOH : gpio :: Gpio = gpio :: Gpio (0x4800_1c00 as u32 as _) ; pub const HSEM : * mut () = 0x5800_1400 as u32 as _ ; pub const I2C1 : i2c :: I2c = i2c :: I2c (0x4000_5400 as u32 as _) ; pub const IPCC : ipcc :: Ipcc = ipcc :: Ipcc (0x5800_0c00 as u32 as _) ; pub const IWDG : iwdg :: Iwdg = iwdg :: Iwdg (0x4000_3000 as u32 as _) ; pub const LPTIM1 : * mut () = 0x4000_7c00 as u32 as _ ; pub const LPTIM2 : * mut () = 0x4000_9400 as u32 as _ ; pub const LPUART1 : lpuart :: Lpuart = lpuart :: Lpuart (0x4000_8000 as u32 as _) ; pub const PKA : * mut () = 0x5800_2000 as u32 as _ ; pub const PWR : pwr :: Pwr = pwr :: Pwr (0x5800_0400 as u32 as _) ; pub const RCC : rcc :: Rcc = rcc :: Rcc (0x5800_0000 as u32 as _) ; pub const RNG : rng :: Rng = rng :: Rng (0x5800_1000 as u32 as _) ; pub const RTC : rtc :: Rtc = rtc :: Rtc (0x4000_2800 as u32 as _) ; pub const SPI1 : spi :: Spi = spi :: Spi (0x4001_3000 as u32 as _) ; pub const SYSCFG : syscfg :: Syscfg = syscfg :: Syscfg (0x4001_0000 as u32 as _) ; pub const TIM1 : timer :: TimGp16 = timer :: TimGp16 (0x4001_2c00 as u32 as _) ; pub const TIM2 : timer :: TimGp16 = timer :: TimGp16 (0x4000_0000 as u32 as _) ; pub const TSC : * mut () = 0x4002_4000 as u32 as _ ; pub const USART1 : usart :: Usart = usart :: Usart (0x4001_3800 as u32 as _) ; pub const VREFINTCAL : vrefintcal :: Vrefintcal = vrefintcal :: Vrefintcal (0x1fff_75aa as u32 as _) ; pub const WWDG : * mut () = 0x4000_2c00 as u32 as _ ;pub fn GPIO(n: usize) -> gpio::Gpio {
            gpio::Gpio((1207959552 + 1024*n) as _)
        }#[path="../../peripherals/bdma_v1.rs"] pub mod bdma;
#[path="../../peripherals/crc_v2.rs"] pub mod crc;
#[path="../../peripherals/dbgmcu_wb.rs"] pub mod dbgmcu;
#[path="../../peripherals/dmamux_v1.rs"] pub mod dmamux;
#[path="../../peripherals/exti_w.rs"] pub mod exti;
#[path="../../peripherals/flash_wb55.rs"] pub mod flash;
#[path="../../peripherals/gpio_v2.rs"] pub mod gpio;
#[path="../../peripherals/i2c_v2.rs"] pub mod i2c;
#[path="../../peripherals/ipcc_v1.rs"] pub mod ipcc;
#[path="../../peripherals/iwdg_v2.rs"] pub mod iwdg;
#[path="../../peripherals/lpuart_v2.rs"] pub mod lpuart;
#[path="../../peripherals/pwr_wb55.rs"] pub mod pwr;
#[path="../../peripherals/rcc_wb.rs"] pub mod rcc;
#[path="../../peripherals/rng_v1.rs"] pub mod rng;
#[path="../../peripherals/rtc_v2.rs"] pub mod rtc;
#[path="../../peripherals/spi_v2.rs"] pub mod spi;
#[path="../../peripherals/syscfg_wb.rs"] pub mod syscfg;
#[path="../../peripherals/timer_v1.rs"] pub mod timer;
#[path="../../peripherals/usart_v2.rs"] pub mod usart;
#[path="../../peripherals/vrefintcal_v1.rs"] pub mod vrefintcal;
pub const CORE_INDEX: usize = 0;
