

# [derive (Copy , Clone , Debug , PartialEq , Eq)]
pub enum Interrupt { # [doc = "0 - WWDG"]
WWDG = 0 , # [doc = "1 - PVD_PVM"]
PVD_PVM = 1 , # [doc = "2 - TAMP_STAMP"]
TAMP_STAMP = 2 , # [doc = "3 - RTC_WKUP"]
RTC_WKUP = 3 , # [doc = "4 - FLASH"]
FLASH = 4 , # [doc = "5 - RCC"]
RCC = 5 , # [doc = "6 - EXTI0"]
EXTI0 = 6 , # [doc = "7 - EXTI1"]
EXTI1 = 7 , # [doc = "8 - EXTI2"]
EXTI2 = 8 , # [doc = "9 - EXTI3"]
EXTI3 = 9 , # [doc = "10 - EXTI4"]
EXTI4 = 10 , # [doc = "11 - DMA1_CHANNEL1"]
DMA1_CHANNEL1 = 11 , # [doc = "12 - DMA1_CHANNEL2"]
DMA1_CHANNEL2 = 12 , # [doc = "13 - DMA1_CHANNEL3"]
DMA1_CHANNEL3 = 13 , # [doc = "14 - DMA1_CHANNEL4"]
DMA1_CHANNEL4 = 14 , # [doc = "15 - DMA1_CHANNEL5"]
DMA1_CHANNEL5 = 15 , # [doc = "16 - DMA1_CHANNEL6"]
DMA1_CHANNEL6 = 16 , # [doc = "17 - DMA1_CHANNEL7"]
DMA1_CHANNEL7 = 17 , # [doc = "18 - ADC1_2"]
ADC1_2 = 18 , # [doc = "19 - CAN1_TX"]
CAN1_TX = 19 , # [doc = "20 - CAN1_RX0"]
CAN1_RX0 = 20 , # [doc = "21 - CAN1_RX1"]
CAN1_RX1 = 21 , # [doc = "22 - CAN1_SCE"]
CAN1_SCE = 22 , # [doc = "23 - EXTI9_5"]
EXTI9_5 = 23 , # [doc = "24 - TIM1_BRK_TIM15"]
TIM1_BRK_TIM15 = 24 , # [doc = "25 - TIM1_UP_TIM16"]
TIM1_UP_TIM16 = 25 , # [doc = "26 - TIM1_TRG_COM_TIM17"]
TIM1_TRG_COM_TIM17 = 26 , # [doc = "27 - TIM1_CC"]
TIM1_CC = 27 , # [doc = "28 - TIM2"]
TIM2 = 28 , # [doc = "29 - TIM3"]
TIM3 = 29 , # [doc = "30 - TIM4"]
TIM4 = 30 , # [doc = "31 - I2C1_EV"]
I2C1_EV = 31 , # [doc = "32 - I2C1_ER"]
I2C1_ER = 32 , # [doc = "33 - I2C2_EV"]
I2C2_EV = 33 , # [doc = "34 - I2C2_ER"]
I2C2_ER = 34 , # [doc = "35 - SPI1"]
SPI1 = 35 , # [doc = "36 - SPI2"]
SPI2 = 36 , # [doc = "37 - USART1"]
USART1 = 37 , # [doc = "38 - USART2"]
USART2 = 38 , # [doc = "39 - USART3"]
USART3 = 39 , # [doc = "40 - EXTI15_10"]
EXTI15_10 = 40 , # [doc = "41 - RTC_ALARM"]
RTC_ALARM = 41 , # [doc = "42 - DFSDM1_FLT3"]
DFSDM1_FLT3 = 42 , # [doc = "43 - TIM8_BRK"]
TIM8_BRK = 43 , # [doc = "44 - TIM8_UP"]
TIM8_UP = 44 , # [doc = "45 - TIM8_TRG_COM"]
TIM8_TRG_COM = 45 , # [doc = "46 - TIM8_CC"]
TIM8_CC = 46 , # [doc = "47 - ADC3"]
ADC3 = 47 , # [doc = "48 - FMC"]
FMC = 48 , # [doc = "49 - SDMMC1"]
SDMMC1 = 49 , # [doc = "50 - TIM5"]
TIM5 = 50 , # [doc = "51 - SPI3"]
SPI3 = 51 , # [doc = "52 - UART4"]
UART4 = 52 , # [doc = "53 - UART5"]
UART5 = 53 , # [doc = "54 - TIM6_DAC"]
TIM6_DAC = 54 , # [doc = "55 - TIM7"]
TIM7 = 55 , # [doc = "56 - DMA2_CHANNEL1"]
DMA2_CHANNEL1 = 56 , # [doc = "57 - DMA2_CHANNEL2"]
DMA2_CHANNEL2 = 57 , # [doc = "58 - DMA2_CHANNEL3"]
DMA2_CHANNEL3 = 58 , # [doc = "59 - DMA2_CHANNEL4"]
DMA2_CHANNEL4 = 59 , # [doc = "60 - DMA2_CHANNEL5"]
DMA2_CHANNEL5 = 60 , # [doc = "61 - DFSDM1_FLT0"]
DFSDM1_FLT0 = 61 , # [doc = "62 - DFSDM1_FLT1"]
DFSDM1_FLT1 = 62 , # [doc = "63 - DFSDM1_FLT2"]
DFSDM1_FLT2 = 63 , # [doc = "64 - COMP"]
COMP = 64 , # [doc = "65 - LPTIM1"]
LPTIM1 = 65 , # [doc = "66 - LPTIM2"]
LPTIM2 = 66 , # [doc = "67 - OTG_FS"]
OTG_FS = 67 , # [doc = "68 - DMA2_CHANNEL6"]
DMA2_CHANNEL6 = 68 , # [doc = "69 - DMA2_CHANNEL7"]
DMA2_CHANNEL7 = 69 , # [doc = "70 - LPUART1"]
LPUART1 = 70 , # [doc = "71 - QUADSPI"]
QUADSPI = 71 , # [doc = "72 - I2C3_EV"]
I2C3_EV = 72 , # [doc = "73 - I2C3_ER"]
I2C3_ER = 73 , # [doc = "74 - SAI1"]
SAI1 = 74 , # [doc = "75 - SAI2"]
SAI2 = 75 , # [doc = "76 - SWPMI1"]
SWPMI1 = 76 , # [doc = "77 - TSC"]
TSC = 77 , # [doc = "78 - LCD"]
LCD = 78 , # [doc = "79 - AES"]
AES = 79 , # [doc = "80 - RNG"]
RNG = 80 , # [doc = "81 - FPU"]
FPU = 81 , } unsafe impl cortex_m :: interrupt :: InterruptNumber for Interrupt { # [inline (always)]
fn number (self) -> u16 { self as u16 } } # [cfg (feature = "rt")]
mod _vectors { extern "C" { fn WWDG () ; fn PVD_PVM () ; fn TAMP_STAMP () ; fn RTC_WKUP () ; fn FLASH () ; fn RCC () ; fn EXTI0 () ; fn EXTI1 () ; fn EXTI2 () ; fn EXTI3 () ; fn EXTI4 () ; fn DMA1_CHANNEL1 () ; fn DMA1_CHANNEL2 () ; fn DMA1_CHANNEL3 () ; fn DMA1_CHANNEL4 () ; fn DMA1_CHANNEL5 () ; fn DMA1_CHANNEL6 () ; fn DMA1_CHANNEL7 () ; fn ADC1_2 () ; fn CAN1_TX () ; fn CAN1_RX0 () ; fn CAN1_RX1 () ; fn CAN1_SCE () ; fn EXTI9_5 () ; fn TIM1_BRK_TIM15 () ; fn TIM1_UP_TIM16 () ; fn TIM1_TRG_COM_TIM17 () ; fn TIM1_CC () ; fn TIM2 () ; fn TIM3 () ; fn TIM4 () ; fn I2C1_EV () ; fn I2C1_ER () ; fn I2C2_EV () ; fn I2C2_ER () ; fn SPI1 () ; fn SPI2 () ; fn USART1 () ; fn USART2 () ; fn USART3 () ; fn EXTI15_10 () ; fn RTC_ALARM () ; fn DFSDM1_FLT3 () ; fn TIM8_BRK () ; fn TIM8_UP () ; fn TIM8_TRG_COM () ; fn TIM8_CC () ; fn ADC3 () ; fn FMC () ; fn SDMMC1 () ; fn TIM5 () ; fn SPI3 () ; fn UART4 () ; fn UART5 () ; fn TIM6_DAC () ; fn TIM7 () ; fn DMA2_CHANNEL1 () ; fn DMA2_CHANNEL2 () ; fn DMA2_CHANNEL3 () ; fn DMA2_CHANNEL4 () ; fn DMA2_CHANNEL5 () ; fn DFSDM1_FLT0 () ; fn DFSDM1_FLT1 () ; fn DFSDM1_FLT2 () ; fn COMP () ; fn LPTIM1 () ; fn LPTIM2 () ; fn OTG_FS () ; fn DMA2_CHANNEL6 () ; fn DMA2_CHANNEL7 () ; fn LPUART1 () ; fn QUADSPI () ; fn I2C3_EV () ; fn I2C3_ER () ; fn SAI1 () ; fn SAI2 () ; fn SWPMI1 () ; fn TSC () ; fn LCD () ; fn AES () ; fn RNG () ; fn FPU () ; } pub union Vector { _handler : unsafe extern "C" fn () , _reserved : u32 , } # [link_section = ".vector_table.interrupts"]
# [no_mangle]
pub static __INTERRUPTS : [Vector ; 82]
= [Vector { _handler : WWDG } , Vector { _handler : PVD_PVM } , Vector { _handler : TAMP_STAMP } , Vector { _handler : RTC_WKUP } , Vector { _handler : FLASH } , Vector { _handler : RCC } , Vector { _handler : EXTI0 } , Vector { _handler : EXTI1 } , Vector { _handler : EXTI2 } , Vector { _handler : EXTI3 } , Vector { _handler : EXTI4 } , Vector { _handler : DMA1_CHANNEL1 } , Vector { _handler : DMA1_CHANNEL2 } , Vector { _handler : DMA1_CHANNEL3 } , Vector { _handler : DMA1_CHANNEL4 } , Vector { _handler : DMA1_CHANNEL5 } , Vector { _handler : DMA1_CHANNEL6 } , Vector { _handler : DMA1_CHANNEL7 } , Vector { _handler : ADC1_2 } , Vector { _handler : CAN1_TX } , Vector { _handler : CAN1_RX0 } , Vector { _handler : CAN1_RX1 } , Vector { _handler : CAN1_SCE } , Vector { _handler : EXTI9_5 } , Vector { _handler : TIM1_BRK_TIM15 } , Vector { _handler : TIM1_UP_TIM16 } , Vector { _handler : TIM1_TRG_COM_TIM17 } , Vector { _handler : TIM1_CC } , Vector { _handler : TIM2 } , Vector { _handler : TIM3 } , Vector { _handler : TIM4 } , Vector { _handler : I2C1_EV } , Vector { _handler : I2C1_ER } , Vector { _handler : I2C2_EV } , Vector { _handler : I2C2_ER } , Vector { _handler : SPI1 } , Vector { _handler : SPI2 } , Vector { _handler : USART1 } , Vector { _handler : USART2 } , Vector { _handler : USART3 } , Vector { _handler : EXTI15_10 } , Vector { _handler : RTC_ALARM } , Vector { _handler : DFSDM1_FLT3 } , Vector { _handler : TIM8_BRK } , Vector { _handler : TIM8_UP } , Vector { _handler : TIM8_TRG_COM } , Vector { _handler : TIM8_CC } , Vector { _handler : ADC3 } , Vector { _handler : FMC } , Vector { _handler : SDMMC1 } , Vector { _handler : TIM5 } , Vector { _handler : SPI3 } , Vector { _handler : UART4 } , Vector { _handler : UART5 } , Vector { _handler : TIM6_DAC } , Vector { _handler : TIM7 } , Vector { _handler : DMA2_CHANNEL1 } , Vector { _handler : DMA2_CHANNEL2 } , Vector { _handler : DMA2_CHANNEL3 } , Vector { _handler : DMA2_CHANNEL4 } , Vector { _handler : DMA2_CHANNEL5 } , Vector { _handler : DFSDM1_FLT0 } , Vector { _handler : DFSDM1_FLT1 } , Vector { _handler : DFSDM1_FLT2 } , Vector { _handler : COMP } , Vector { _handler : LPTIM1 } , Vector { _handler : LPTIM2 } , Vector { _handler : OTG_FS } , Vector { _handler : DMA2_CHANNEL6 } , Vector { _handler : DMA2_CHANNEL7 } , Vector { _handler : LPUART1 } , Vector { _handler : QUADSPI } , Vector { _handler : I2C3_EV } , Vector { _handler : I2C3_ER } , Vector { _handler : SAI1 } , Vector { _handler : SAI2 } , Vector { _handler : SWPMI1 } , Vector { _handler : TSC } , Vector { _handler : LCD } , Vector { _handler : AES } , Vector { _handler : RNG } , Vector { _handler : FPU } ,]
; } pub const ADC1 : adc :: Adc = adc :: Adc (0x5004_0000 as u32 as _) ; pub const ADC2 : adc :: Adc = adc :: Adc (0x5004_0100 as u32 as _) ; pub const ADC3 : adc :: Adc = adc :: Adc (0x5004_0200 as u32 as _) ; pub const ADC_COMMON : adccommon :: AdcCommon = adccommon :: AdcCommon (0x5004_0300 as u32 as _) ; pub const AES : * mut () = 0x5006_0000 as u32 as _ ; pub const CAN1 : can :: Can = can :: Can (0x4000_6400 as u32 as _) ; pub const COMP1 : * mut () = 0x4001_0200 as u32 as _ ; pub const COMP2 : * mut () = 0x4001_0204 as u32 as _ ; pub const CRC : crc :: Crc = crc :: Crc (0x4002_3000 as u32 as _) ; pub const DAC1 : dac :: Dac = dac :: Dac (0x4000_7400 as u32 as _) ; pub const DBGMCU : dbgmcu :: Dbgmcu = dbgmcu :: Dbgmcu (0xe004_2000 as u32 as _) ; pub const DFSDM1 : * mut () = 0x4001_6000 as u32 as _ ; pub const DMA1 : bdma :: Dma = bdma :: Dma (0x4002_0000 as u32 as _) ; pub const DMA2 : bdma :: Dma = bdma :: Dma (0x4002_0400 as u32 as _) ; pub const EXTI : exti :: Exti = exti :: Exti (0x4001_0400 as u32 as _) ; pub const FLASH : flash :: Flash = flash :: Flash (0x4002_2000 as u32 as _) ; pub const GPIOA : gpio :: Gpio = gpio :: Gpio (0x4800_0000 as u32 as _) ; pub const GPIOB : gpio :: Gpio = gpio :: Gpio (0x4800_0400 as u32 as _) ; pub const GPIOC : gpio :: Gpio = gpio :: Gpio (0x4800_0800 as u32 as _) ; pub const GPIOD : gpio :: Gpio = gpio :: Gpio (0x4800_0c00 as u32 as _) ; pub const GPIOE : gpio :: Gpio = gpio :: Gpio (0x4800_1000 as u32 as _) ; pub const GPIOF : gpio :: Gpio = gpio :: Gpio (0x4800_1400 as u32 as _) ; pub const GPIOG : gpio :: Gpio = gpio :: Gpio (0x4800_1800 as u32 as _) ; pub const GPIOH : gpio :: Gpio = gpio :: Gpio (0x4800_1c00 as u32 as _) ; pub const I2C1 : i2c :: I2c = i2c :: I2c (0x4000_5400 as u32 as _) ; pub const I2C2 : i2c :: I2c = i2c :: I2c (0x4000_5800 as u32 as _) ; pub const I2C3 : i2c :: I2c = i2c :: I2c (0x4000_5c00 as u32 as _) ; pub const IWDG : iwdg :: Iwdg = iwdg :: Iwdg (0x4000_3000 as u32 as _) ; pub const LCD : * mut () = 0x4000_2400 as u32 as _ ; pub const LPTIM1 : * mut () = 0x4000_7c00 as u32 as _ ; pub const LPTIM2 : * mut () = 0x4000_9400 as u32 as _ ; pub const LPUART1 : lpuart :: Lpuart = lpuart :: Lpuart (0x4000_8000 as u32 as _) ; pub const OPAMP1 : * mut () = 0x4000_7800 as u32 as _ ; pub const OPAMP2 : * mut () = 0x4000_7810 as u32 as _ ; pub const PWR : * mut () = 0x4000_7000 as u32 as _ ; pub const QUADSPI : * mut () = 0xa000_1000 as u32 as _ ; pub const RCC : rcc :: Rcc = rcc :: Rcc (0x4002_1000 as u32 as _) ; pub const RNG : rng :: Rng = rng :: Rng (0x5006_0800 as u32 as _) ; pub const RTC : * mut () = 0x4000_2800 as u32 as _ ; pub const SAI1 : sai :: Sai = sai :: Sai (0x4001_5400 as u32 as _) ; pub const SAI2 : sai :: Sai = sai :: Sai (0x4001_5800 as u32 as _) ; pub const SDMMC1 : sdmmc :: Sdmmc = sdmmc :: Sdmmc (0x4001_2800 as u32 as _) ; pub const SPI1 : spi :: Spi = spi :: Spi (0x4001_3000 as u32 as _) ; pub const SPI2 : spi :: Spi = spi :: Spi (0x4000_3800 as u32 as _) ; pub const SPI3 : spi :: Spi = spi :: Spi (0x4000_3c00 as u32 as _) ; pub const SWPMI1 : * mut () = 0x4000_8800 as u32 as _ ; pub const SYSCFG : syscfg :: Syscfg = syscfg :: Syscfg (0x4001_0000 as u32 as _) ; pub const TIM1 : timer :: TimGp16 = timer :: TimGp16 (0x4001_2c00 as u32 as _) ; pub const TIM15 : timer :: TimGp16 = timer :: TimGp16 (0x4001_4000 as u32 as _) ; pub const TIM16 : timer :: TimGp16 = timer :: TimGp16 (0x4001_4400 as u32 as _) ; pub const TIM17 : timer :: TimGp16 = timer :: TimGp16 (0x4001_4800 as u32 as _) ; pub const TIM2 : timer :: TimGp16 = timer :: TimGp16 (0x4000_0000 as u32 as _) ; pub const TIM3 : timer :: TimGp16 = timer :: TimGp16 (0x4000_0400 as u32 as _) ; pub const TIM4 : timer :: TimGp16 = timer :: TimGp16 (0x4000_0800 as u32 as _) ; pub const TIM5 : timer :: TimGp16 = timer :: TimGp16 (0x4000_0c00 as u32 as _) ; pub const TIM6 : timer :: TimGp16 = timer :: TimGp16 (0x4000_1000 as u32 as _) ; pub const TIM7 : timer :: TimGp16 = timer :: TimGp16 (0x4000_1400 as u32 as _) ; pub const TIM8 : timer :: TimGp16 = timer :: TimGp16 (0x4001_3400 as u32 as _) ; pub const TSC : * mut () = 0x4002_4000 as u32 as _ ; pub const UART4 : usart :: Usart = usart :: Usart (0x4000_4c00 as u32 as _) ; pub const UART5 : usart :: Usart = usart :: Usart (0x4000_5000 as u32 as _) ; pub const USART1 : usart :: Usart = usart :: Usart (0x4001_3800 as u32 as _) ; pub const USART2 : usart :: Usart = usart :: Usart (0x4000_4400 as u32 as _) ; pub const USART3 : usart :: Usart = usart :: Usart (0x4000_4800 as u32 as _) ; pub const USB_OTG_FS : * mut () = 0x5000_0000 as u32 as _ ; pub const VREFINTCAL : vrefintcal :: Vrefintcal = vrefintcal :: Vrefintcal (0x1fff_75aa as u32 as _) ; pub const WWDG : wwdg :: Wwdg = wwdg :: Wwdg (0x4000_2c00 as u32 as _) ;pub fn GPIO(n: usize) -> gpio::Gpio {
            gpio::Gpio((1207959552 + 1024*n) as _)
        }#[path="../../peripherals/adc_v3.rs"] pub mod adc;
#[path="../../peripherals/adccommon_v3.rs"] pub mod adccommon;
#[path="../../peripherals/bdma_v2.rs"] pub mod bdma;
#[path="../../peripherals/can_bxcan.rs"] pub mod can;
#[path="../../peripherals/crc_v3.rs"] pub mod crc;
#[path="../../peripherals/dac_v2.rs"] pub mod dac;
#[path="../../peripherals/dbgmcu_l4.rs"] pub mod dbgmcu;
#[path="../../peripherals/exti_v1.rs"] pub mod exti;
#[path="../../peripherals/flash_l4.rs"] pub mod flash;
#[path="../../peripherals/gpio_v2.rs"] pub mod gpio;
#[path="../../peripherals/i2c_v2.rs"] pub mod i2c;
#[path="../../peripherals/iwdg_v2.rs"] pub mod iwdg;
#[path="../../peripherals/lpuart_v1.rs"] pub mod lpuart;
#[path="../../peripherals/rcc_l4.rs"] pub mod rcc;
#[path="../../peripherals/rng_v1.rs"] pub mod rng;
#[path="../../peripherals/sai_v1.rs"] pub mod sai;
#[path="../../peripherals/sdmmc_v1.rs"] pub mod sdmmc;
#[path="../../peripherals/spi_v2.rs"] pub mod spi;
#[path="../../peripherals/syscfg_l4.rs"] pub mod syscfg;
#[path="../../peripherals/timer_v1.rs"] pub mod timer;
#[path="../../peripherals/usart_v2.rs"] pub mod usart;
#[path="../../peripherals/vrefintcal_v1.rs"] pub mod vrefintcal;
#[path="../../peripherals/wwdg_v1.rs"] pub mod wwdg;
pub const CORE_INDEX: usize = 0;
