

# [derive (Copy , Clone , Debug , PartialEq , Eq)]
pub enum Interrupt { # [doc = "0 - WWDG"]
WWDG = 0 , # [doc = "1 - PVD"]
PVD = 1 , # [doc = "2 - RTC"]
RTC = 2 , # [doc = "3 - FLASH"]
FLASH = 3 , # [doc = "4 - RCC"]
RCC = 4 , # [doc = "5 - EXTI0_1"]
EXTI0_1 = 5 , # [doc = "6 - EXTI2_3"]
EXTI2_3 = 6 , # [doc = "7 - EXTI4_15"]
EXTI4_15 = 7 , # [doc = "9 - DMA1_CHANNEL1"]
DMA1_CHANNEL1 = 9 , # [doc = "10 - DMA1_CHANNEL2_3"]
DMA1_CHANNEL2_3 = 10 , # [doc = "11 - DMA1_CHANNEL4_5"]
DMA1_CHANNEL4_5 = 11 , # [doc = "12 - ADC1_COMP"]
ADC1_COMP = 12 , # [doc = "13 - LPTIM1"]
LPTIM1 = 13 , # [doc = "15 - TIM2"]
TIM2 = 15 , # [doc = "20 - TIM21"]
TIM21 = 20 , # [doc = "23 - I2C1"]
I2C1 = 23 , # [doc = "25 - SPI1"]
SPI1 = 25 , # [doc = "28 - USART2"]
USART2 = 28 , # [doc = "29 - LPUART1"]
LPUART1 = 29 , } unsafe impl cortex_m :: interrupt :: InterruptNumber for Interrupt { # [inline (always)]
fn number (self) -> u16 { self as u16 } } # [cfg (feature = "rt")]
mod _vectors { extern "C" { fn WWDG () ; fn PVD () ; fn RTC () ; fn FLASH () ; fn RCC () ; fn EXTI0_1 () ; fn EXTI2_3 () ; fn EXTI4_15 () ; fn DMA1_CHANNEL1 () ; fn DMA1_CHANNEL2_3 () ; fn DMA1_CHANNEL4_5 () ; fn ADC1_COMP () ; fn LPTIM1 () ; fn TIM2 () ; fn TIM21 () ; fn I2C1 () ; fn SPI1 () ; fn USART2 () ; fn LPUART1 () ; } pub union Vector { _handler : unsafe extern "C" fn () , _reserved : u32 , } # [link_section = ".vector_table.interrupts"]
# [no_mangle]
pub static __INTERRUPTS : [Vector ; 30]
= [Vector { _handler : WWDG } , Vector { _handler : PVD } , Vector { _handler : RTC } , Vector { _handler : FLASH } , Vector { _handler : RCC } , Vector { _handler : EXTI0_1 } , Vector { _handler : EXTI2_3 } , Vector { _handler : EXTI4_15 } , Vector { _reserved : 0 } , Vector { _handler : DMA1_CHANNEL1 } , Vector { _handler : DMA1_CHANNEL2_3 } , Vector { _handler : DMA1_CHANNEL4_5 } , Vector { _handler : ADC1_COMP } , Vector { _handler : LPTIM1 } , Vector { _reserved : 0 } , Vector { _handler : TIM2 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : TIM21 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : I2C1 } , Vector { _reserved : 0 } , Vector { _handler : SPI1 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : USART2 } , Vector { _handler : LPUART1 } ,]
; } pub const ADC : * mut () = 0x4001_2708 as u32 as _ ; pub const ADC_COMMON : * mut () = 0x4001_2708 as u32 as _ ; pub const COMP1 : * mut () = 0x4001_0018 as u32 as _ ; pub const COMP2 : * mut () = 0x4001_001c as u32 as _ ; pub const CRC : crc :: Crc = crc :: Crc (0x4002_3000 as u32 as _) ; pub const DBGMCU : dbgmcu :: Dbgmcu = dbgmcu :: Dbgmcu (0x4001_5800 as u32 as _) ; pub const DMA1 : bdma :: Dma = bdma :: Dma (0x4002_0000 as u32 as _) ; pub const EXTI : exti :: Exti = exti :: Exti (0x4001_0400 as u32 as _) ; pub const FLASH : * mut () = 0x4002_2000 as u32 as _ ; pub const GPIOA : gpio :: Gpio = gpio :: Gpio (0x5000_0000 as u32 as _) ; pub const GPIOB : gpio :: Gpio = gpio :: Gpio (0x5000_0400 as u32 as _) ; pub const GPIOC : gpio :: Gpio = gpio :: Gpio (0x5000_0800 as u32 as _) ; pub const I2C1 : i2c :: I2c = i2c :: I2c (0x4000_5400 as u32 as _) ; pub const IWDG : iwdg :: Iwdg = iwdg :: Iwdg (0x4000_3000 as u32 as _) ; pub const LPTIM1 : * mut () = 0x4000_7c00 as u32 as _ ; pub const LPUART1 : lpuart :: Lpuart = lpuart :: Lpuart (0x4000_4800 as u32 as _) ; pub const PWR : * mut () = 0x4000_7000 as u32 as _ ; pub const RCC : rcc :: Rcc = rcc :: Rcc (0x4002_1000 as u32 as _) ; pub const RTC : * mut () = 0x4000_2800 as u32 as _ ; pub const SPI1 : spi :: Spi = spi :: Spi (0x4001_3000 as u32 as _) ; pub const SYSCFG : syscfg :: Syscfg = syscfg :: Syscfg (0x4001_0000 as u32 as _) ; pub const TIM2 : timer :: TimGp16 = timer :: TimGp16 (0x4000_0000 as u32 as _) ; pub const TIM21 : timer :: TimGp16 = timer :: TimGp16 (0x4001_0800 as u32 as _) ; pub const USART2 : usart :: Usart = usart :: Usart (0x4000_4400 as u32 as _) ; pub const WWDG : wwdg :: Wwdg = wwdg :: Wwdg (0x4000_2c00 as u32 as _) ;pub fn GPIO(n: usize) -> gpio::Gpio {
            gpio::Gpio((1342177280 + 1024*n) as _)
        }#[path="../../peripherals/bdma_v2.rs"] pub mod bdma;
#[path="../../peripherals/crc_v3.rs"] pub mod crc;
#[path="../../peripherals/dbgmcu_l0.rs"] pub mod dbgmcu;
#[path="../../peripherals/exti_v1.rs"] pub mod exti;
#[path="../../peripherals/gpio_v2.rs"] pub mod gpio;
#[path="../../peripherals/i2c_v2.rs"] pub mod i2c;
#[path="../../peripherals/iwdg_v2.rs"] pub mod iwdg;
#[path="../../peripherals/lpuart_v1.rs"] pub mod lpuart;
#[path="../../peripherals/rcc_l0.rs"] pub mod rcc;
#[path="../../peripherals/spi_v2.rs"] pub mod spi;
#[path="../../peripherals/syscfg_l0.rs"] pub mod syscfg;
#[path="../../peripherals/timer_v1.rs"] pub mod timer;
#[path="../../peripherals/usart_v2.rs"] pub mod usart;
#[path="../../peripherals/wwdg_v1.rs"] pub mod wwdg;
pub const CORE_INDEX: usize = 0;
