

# [derive (Copy , Clone , Debug , PartialEq , Eq)]
pub enum Interrupt { # [doc = "0 - WWDG"]
WWDG = 0 , # [doc = "2 - RTC_TAMP"]
RTC_TAMP = 2 , # [doc = "3 - FLASH"]
FLASH = 3 , # [doc = "4 - RCC_CRS"]
RCC_CRS = 4 , # [doc = "5 - EXTI0_1"]
EXTI0_1 = 5 , # [doc = "6 - EXTI2_3"]
EXTI2_3 = 6 , # [doc = "7 - EXTI4_15"]
EXTI4_15 = 7 , # [doc = "8 - USB_UCPD1_2"]
USB_UCPD1_2 = 8 , # [doc = "9 - DMA1_CHANNEL1"]
DMA1_CHANNEL1 = 9 , # [doc = "10 - DMA1_CHANNEL2_3"]
DMA1_CHANNEL2_3 = 10 , # [doc = "11 - DMA1_CH4_7_DMA2_CH1_5_DMAMUX1_OVR"]
DMA1_CH4_7_DMA2_CH1_5_DMAMUX1_OVR = 11 , # [doc = "12 - ADC1_COMP"]
ADC1_COMP = 12 , # [doc = "13 - TIM1_BRK_UP_TRG_COM"]
TIM1_BRK_UP_TRG_COM = 13 , # [doc = "14 - TIM1_CC"]
TIM1_CC = 14 , # [doc = "15 - TIM2"]
TIM2 = 15 , # [doc = "16 - TIM3_TIM4"]
TIM3_TIM4 = 16 , # [doc = "17 - TIM6_DAC_LPTIM1"]
TIM6_DAC_LPTIM1 = 17 , # [doc = "18 - TIM7_LPTIM2"]
TIM7_LPTIM2 = 18 , # [doc = "19 - TIM14"]
TIM14 = 19 , # [doc = "20 - TIM15"]
TIM15 = 20 , # [doc = "21 - TIM16_FDCAN_IT0"]
TIM16_FDCAN_IT0 = 21 , # [doc = "22 - TIM17_FDCAN_IT1"]
TIM17_FDCAN_IT1 = 22 , # [doc = "23 - I2C1"]
I2C1 = 23 , # [doc = "24 - I2C2_3"]
I2C2_3 = 24 , # [doc = "25 - SPI1"]
SPI1 = 25 , # [doc = "26 - SPI2_3"]
SPI2_3 = 26 , # [doc = "27 - USART1"]
USART1 = 27 , # [doc = "28 - USART2_LPUART2"]
USART2_LPUART2 = 28 , # [doc = "29 - USART3_4_5_6_LPUART1"]
USART3_4_5_6_LPUART1 = 29 , # [doc = "30 - CEC"]
CEC = 30 , # [doc = "31 - AES_RNG"]
AES_RNG = 31 , } unsafe impl cortex_m :: interrupt :: InterruptNumber for Interrupt { # [inline (always)]
fn number (self) -> u16 { self as u16 } } # [cfg (feature = "rt")]
mod _vectors { extern "C" { fn WWDG () ; fn RTC_TAMP () ; fn FLASH () ; fn RCC_CRS () ; fn EXTI0_1 () ; fn EXTI2_3 () ; fn EXTI4_15 () ; fn USB_UCPD1_2 () ; fn DMA1_CHANNEL1 () ; fn DMA1_CHANNEL2_3 () ; fn DMA1_CH4_7_DMA2_CH1_5_DMAMUX1_OVR () ; fn ADC1_COMP () ; fn TIM1_BRK_UP_TRG_COM () ; fn TIM1_CC () ; fn TIM2 () ; fn TIM3_TIM4 () ; fn TIM6_DAC_LPTIM1 () ; fn TIM7_LPTIM2 () ; fn TIM14 () ; fn TIM15 () ; fn TIM16_FDCAN_IT0 () ; fn TIM17_FDCAN_IT1 () ; fn I2C1 () ; fn I2C2_3 () ; fn SPI1 () ; fn SPI2_3 () ; fn USART1 () ; fn USART2_LPUART2 () ; fn USART3_4_5_6_LPUART1 () ; fn CEC () ; fn AES_RNG () ; } pub union Vector { _handler : unsafe extern "C" fn () , _reserved : u32 , } # [link_section = ".vector_table.interrupts"]
# [no_mangle]
pub static __INTERRUPTS : [Vector ; 32]
= [Vector { _handler : WWDG } , Vector { _reserved : 0 } , Vector { _handler : RTC_TAMP } , Vector { _handler : FLASH } , Vector { _handler : RCC_CRS } , Vector { _handler : EXTI0_1 } , Vector { _handler : EXTI2_3 } , Vector { _handler : EXTI4_15 } , Vector { _handler : USB_UCPD1_2 } , Vector { _handler : DMA1_CHANNEL1 } , Vector { _handler : DMA1_CHANNEL2_3 } , Vector { _handler : DMA1_CH4_7_DMA2_CH1_5_DMAMUX1_OVR } , Vector { _handler : ADC1_COMP } , Vector { _handler : TIM1_BRK_UP_TRG_COM } , Vector { _handler : TIM1_CC } , Vector { _handler : TIM2 } , Vector { _handler : TIM3_TIM4 } , Vector { _handler : TIM6_DAC_LPTIM1 } , Vector { _handler : TIM7_LPTIM2 } , Vector { _handler : TIM14 } , Vector { _handler : TIM15 } , Vector { _handler : TIM16_FDCAN_IT0 } , Vector { _handler : TIM17_FDCAN_IT1 } , Vector { _handler : I2C1 } , Vector { _handler : I2C2_3 } , Vector { _handler : SPI1 } , Vector { _handler : SPI2_3 } , Vector { _handler : USART1 } , Vector { _handler : USART2_LPUART2 } , Vector { _handler : USART3_4_5_6_LPUART1 } , Vector { _handler : CEC } , Vector { _handler : AES_RNG } ,]
; } pub const ADC1 : adc :: Adc = adc :: Adc (0x4001_2400 as u32 as _) ; pub const ADC_COMMON : adccommon :: AdcCommon = adccommon :: AdcCommon (0x4001_2708 as u32 as _) ; pub const AES : * mut () = 0x4002_6000 as u32 as _ ; pub const CEC : * mut () = 0x4000_7800 as u32 as _ ; pub const COMP1 : * mut () = 0x4001_0200 as u32 as _ ; pub const COMP2 : * mut () = 0x4001_0204 as u32 as _ ; pub const COMP3 : * mut () = 0x4001_0208 as u32 as _ ; pub const CRC : crc :: Crc = crc :: Crc (0x4002_3000 as u32 as _) ; pub const CRS : * mut () = 0x4000_6c00 as u32 as _ ; pub const DAC1 : dac :: Dac = dac :: Dac (0x4000_7400 as u32 as _) ; pub const DBGMCU : dbgmcu :: Dbgmcu = dbgmcu :: Dbgmcu (0x4001_5800 as u32 as _) ; pub const DMA1 : bdma :: Dma = bdma :: Dma (0x4002_0000 as u32 as _) ; pub const DMA2 : bdma :: Dma = bdma :: Dma (0x4002_0400 as u32 as _) ; pub const DMAMUX1 : dmamux :: Dmamux = dmamux :: Dmamux (0x4002_0800 as u32 as _) ; pub const EXTI : exti :: Exti = exti :: Exti (0x4002_1800 as u32 as _) ; pub const FDCAN1 : * mut () = 0x4000_6400 as u32 as _ ; pub const FDCAN2 : * mut () = 0x4000_6800 as u32 as _ ; pub const FLASH : * mut () = 0x4002_2000 as u32 as _ ; pub const GPIOA : gpio :: Gpio = gpio :: Gpio (0x5000_0000 as u32 as _) ; pub const GPIOB : gpio :: Gpio = gpio :: Gpio (0x5000_0400 as u32 as _) ; pub const GPIOC : gpio :: Gpio = gpio :: Gpio (0x5000_0800 as u32 as _) ; pub const GPIOD : gpio :: Gpio = gpio :: Gpio (0x5000_0c00 as u32 as _) ; pub const GPIOE : gpio :: Gpio = gpio :: Gpio (0x5000_1000 as u32 as _) ; pub const GPIOF : gpio :: Gpio = gpio :: Gpio (0x5000_1400 as u32 as _) ; pub const I2C1 : i2c :: I2c = i2c :: I2c (0x4000_5400 as u32 as _) ; pub const I2C2 : i2c :: I2c = i2c :: I2c (0x4000_5800 as u32 as _) ; pub const I2C3 : i2c :: I2c = i2c :: I2c (0x4000_8800 as u32 as _) ; pub const IWDG : iwdg :: Iwdg = iwdg :: Iwdg (0x4000_3000 as u32 as _) ; pub const LPTIM1 : lptim :: Lptim = lptim :: Lptim (0x4000_7c00 as u32 as _) ; pub const LPTIM2 : lptim :: Lptim = lptim :: Lptim (0x4000_9400 as u32 as _) ; pub const LPUART1 : lpuart :: Lpuart = lpuart :: Lpuart (0x4000_8000 as u32 as _) ; pub const LPUART2 : lpuart :: Lpuart = lpuart :: Lpuart (0x4000_8400 as u32 as _) ; pub const PWR : pwr :: Pwr = pwr :: Pwr (0x4000_7000 as u32 as _) ; pub const RCC : rcc :: Rcc = rcc :: Rcc (0x4002_1000 as u32 as _) ; pub const RNG : rng :: Rng = rng :: Rng (0x4002_5000 as u32 as _) ; pub const RTC : * mut () = 0x4000_2800 as u32 as _ ; pub const SPI1 : spi :: Spi = spi :: Spi (0x4001_3000 as u32 as _) ; pub const SPI2 : spi :: Spi = spi :: Spi (0x4000_3800 as u32 as _) ; pub const SPI3 : spi :: Spi = spi :: Spi (0x4000_3c00 as u32 as _) ; pub const SYSCFG : syscfg :: Syscfg = syscfg :: Syscfg (0x4001_0000 as u32 as _) ; pub const TIM1 : timer :: TimGp16 = timer :: TimGp16 (0x4001_2c00 as u32 as _) ; pub const TIM14 : timer :: TimGp16 = timer :: TimGp16 (0x4000_2000 as u32 as _) ; pub const TIM15 : timer :: TimGp16 = timer :: TimGp16 (0x4001_4000 as u32 as _) ; pub const TIM16 : timer :: TimGp16 = timer :: TimGp16 (0x4001_4400 as u32 as _) ; pub const TIM17 : timer :: TimGp16 = timer :: TimGp16 (0x4001_4800 as u32 as _) ; pub const TIM2 : timer :: TimGp16 = timer :: TimGp16 (0x4000_0000 as u32 as _) ; pub const TIM3 : timer :: TimGp16 = timer :: TimGp16 (0x4000_0400 as u32 as _) ; pub const TIM4 : timer :: TimGp16 = timer :: TimGp16 (0x4000_0800 as u32 as _) ; pub const TIM6 : timer :: TimGp16 = timer :: TimGp16 (0x4000_1000 as u32 as _) ; pub const TIM7 : timer :: TimGp16 = timer :: TimGp16 (0x4000_1400 as u32 as _) ; pub const UCPD1 : * mut () = 0x4000_a000 as u32 as _ ; pub const UCPD2 : * mut () = 0x4000_a400 as u32 as _ ; pub const USART1 : usart :: Usart = usart :: Usart (0x4001_3800 as u32 as _) ; pub const USART2 : usart :: Usart = usart :: Usart (0x4000_4400 as u32 as _) ; pub const USART3 : usart :: Usart = usart :: Usart (0x4000_4800 as u32 as _) ; pub const USART4 : usart :: Usart = usart :: Usart (0x4000_4c00 as u32 as _) ; pub const USART5 : usart :: Usart = usart :: Usart (0x4000_5000 as u32 as _) ; pub const USART6 : usart :: Usart = usart :: Usart (0x4001_3c00 as u32 as _) ; pub const USB_DRD_FS : * mut () = 0x4000_5c00 as u32 as _ ; pub const WWDG : * mut () = 0x4000_2c00 as u32 as _ ;pub fn GPIO(n: usize) -> gpio::Gpio {
            gpio::Gpio((1342177280 + 1024*n) as _)
        }#[path="../../peripherals/adc_g0.rs"] pub mod adc;
#[path="../../peripherals/adccommon_v3.rs"] pub mod adccommon;
#[path="../../peripherals/bdma_v1.rs"] pub mod bdma;
#[path="../../peripherals/crc_v2.rs"] pub mod crc;
#[path="../../peripherals/dac_v2.rs"] pub mod dac;
#[path="../../peripherals/dbgmcu_g0.rs"] pub mod dbgmcu;
#[path="../../peripherals/dmamux_v1.rs"] pub mod dmamux;
#[path="../../peripherals/exti_g0.rs"] pub mod exti;
#[path="../../peripherals/gpio_v2.rs"] pub mod gpio;
#[path="../../peripherals/i2c_v2.rs"] pub mod i2c;
#[path="../../peripherals/iwdg_v2.rs"] pub mod iwdg;
#[path="../../peripherals/lptim_g0.rs"] pub mod lptim;
#[path="../../peripherals/lpuart_v2.rs"] pub mod lpuart;
#[path="../../peripherals/pwr_g0.rs"] pub mod pwr;
#[path="../../peripherals/rcc_g0.rs"] pub mod rcc;
#[path="../../peripherals/rng_v1.rs"] pub mod rng;
#[path="../../peripherals/spi_v2.rs"] pub mod spi;
#[path="../../peripherals/syscfg_g0.rs"] pub mod syscfg;
#[path="../../peripherals/timer_v1.rs"] pub mod timer;
#[path="../../peripherals/usart_v2.rs"] pub mod usart;
pub const CORE_INDEX: usize = 0;
