

# [derive (Copy , Clone , Debug , PartialEq , Eq)]
pub enum Interrupt { # [doc = "0 - WWDG"]
WWDG = 0 , # [doc = "1 - PVD"]
PVD = 1 , # [doc = "2 - TAMP_STAMP"]
TAMP_STAMP = 2 , # [doc = "3 - RTC_WKUP"]
RTC_WKUP = 3 , # [doc = "4 - FLASH"]
FLASH = 4 , # [doc = "5 - RCC"]
RCC = 5 , # [doc = "6 - EXTI0"]
EXTI0 = 6 , # [doc = "7 - EXTI1"]
EXTI1 = 7 , # [doc = "8 - EXTI2"]
EXTI2 = 8 , # [doc = "9 - EXTI3"]
EXTI3 = 9 , # [doc = "10 - EXTI4"]
EXTI4 = 10 , # [doc = "11 - DMA1_STREAM0"]
DMA1_STREAM0 = 11 , # [doc = "12 - DMA1_STREAM1"]
DMA1_STREAM1 = 12 , # [doc = "13 - DMA1_STREAM2"]
DMA1_STREAM2 = 13 , # [doc = "14 - DMA1_STREAM3"]
DMA1_STREAM3 = 14 , # [doc = "15 - DMA1_STREAM4"]
DMA1_STREAM4 = 15 , # [doc = "16 - DMA1_STREAM5"]
DMA1_STREAM5 = 16 , # [doc = "17 - DMA1_STREAM6"]
DMA1_STREAM6 = 17 , # [doc = "18 - ADC"]
ADC = 18 , # [doc = "23 - EXTI9_5"]
EXTI9_5 = 23 , # [doc = "24 - TIM1_BRK_TIM9"]
TIM1_BRK_TIM9 = 24 , # [doc = "25 - TIM1_UP"]
TIM1_UP = 25 , # [doc = "26 - TIM1_TRG_COM_TIM11"]
TIM1_TRG_COM_TIM11 = 26 , # [doc = "27 - TIM1_CC"]
TIM1_CC = 27 , # [doc = "31 - I2C1_EV"]
I2C1_EV = 31 , # [doc = "32 - I2C1_ER"]
I2C1_ER = 32 , # [doc = "33 - I2C2_EV"]
I2C2_EV = 33 , # [doc = "34 - I2C2_ER"]
I2C2_ER = 34 , # [doc = "35 - SPI1"]
SPI1 = 35 , # [doc = "37 - USART1"]
USART1 = 37 , # [doc = "38 - USART2"]
USART2 = 38 , # [doc = "40 - EXTI15_10"]
EXTI15_10 = 40 , # [doc = "41 - RTC_ALARM"]
RTC_ALARM = 41 , # [doc = "47 - DMA1_STREAM7"]
DMA1_STREAM7 = 47 , # [doc = "50 - TIM5"]
TIM5 = 50 , # [doc = "54 - TIM6_DAC"]
TIM6_DAC = 54 , # [doc = "56 - DMA2_STREAM0"]
DMA2_STREAM0 = 56 , # [doc = "57 - DMA2_STREAM1"]
DMA2_STREAM1 = 57 , # [doc = "58 - DMA2_STREAM2"]
DMA2_STREAM2 = 58 , # [doc = "59 - DMA2_STREAM3"]
DMA2_STREAM3 = 59 , # [doc = "60 - DMA2_STREAM4"]
DMA2_STREAM4 = 60 , # [doc = "68 - DMA2_STREAM5"]
DMA2_STREAM5 = 68 , # [doc = "69 - DMA2_STREAM6"]
DMA2_STREAM6 = 69 , # [doc = "70 - DMA2_STREAM7"]
DMA2_STREAM7 = 70 , # [doc = "80 - RNG"]
RNG = 80 , # [doc = "81 - FPU"]
FPU = 81 , # [doc = "95 - FMPI2C1_EV"]
FMPI2C1_EV = 95 , # [doc = "96 - FMPI2C1_ER"]
FMPI2C1_ER = 96 , # [doc = "97 - LPTIM1"]
LPTIM1 = 97 , } unsafe impl cortex_m :: interrupt :: InterruptNumber for Interrupt { # [inline (always)]
fn number (self) -> u16 { self as u16 } } # [cfg (feature = "rt")]
mod _vectors { extern "C" { fn WWDG () ; fn PVD () ; fn TAMP_STAMP () ; fn RTC_WKUP () ; fn FLASH () ; fn RCC () ; fn EXTI0 () ; fn EXTI1 () ; fn EXTI2 () ; fn EXTI3 () ; fn EXTI4 () ; fn DMA1_STREAM0 () ; fn DMA1_STREAM1 () ; fn DMA1_STREAM2 () ; fn DMA1_STREAM3 () ; fn DMA1_STREAM4 () ; fn DMA1_STREAM5 () ; fn DMA1_STREAM6 () ; fn ADC () ; fn EXTI9_5 () ; fn TIM1_BRK_TIM9 () ; fn TIM1_UP () ; fn TIM1_TRG_COM_TIM11 () ; fn TIM1_CC () ; fn I2C1_EV () ; fn I2C1_ER () ; fn I2C2_EV () ; fn I2C2_ER () ; fn SPI1 () ; fn USART1 () ; fn USART2 () ; fn EXTI15_10 () ; fn RTC_ALARM () ; fn DMA1_STREAM7 () ; fn TIM5 () ; fn TIM6_DAC () ; fn DMA2_STREAM0 () ; fn DMA2_STREAM1 () ; fn DMA2_STREAM2 () ; fn DMA2_STREAM3 () ; fn DMA2_STREAM4 () ; fn DMA2_STREAM5 () ; fn DMA2_STREAM6 () ; fn DMA2_STREAM7 () ; fn RNG () ; fn FPU () ; fn FMPI2C1_EV () ; fn FMPI2C1_ER () ; fn LPTIM1 () ; } pub union Vector { _handler : unsafe extern "C" fn () , _reserved : u32 , } # [link_section = ".vector_table.interrupts"]
# [no_mangle]
pub static __INTERRUPTS : [Vector ; 98]
= [Vector { _handler : WWDG } , Vector { _handler : PVD } , Vector { _handler : TAMP_STAMP } , Vector { _handler : RTC_WKUP } , Vector { _handler : FLASH } , Vector { _handler : RCC } , Vector { _handler : EXTI0 } , Vector { _handler : EXTI1 } , Vector { _handler : EXTI2 } , Vector { _handler : EXTI3 } , Vector { _handler : EXTI4 } , Vector { _handler : DMA1_STREAM0 } , Vector { _handler : DMA1_STREAM1 } , Vector { _handler : DMA1_STREAM2 } , Vector { _handler : DMA1_STREAM3 } , Vector { _handler : DMA1_STREAM4 } , Vector { _handler : DMA1_STREAM5 } , Vector { _handler : DMA1_STREAM6 } , Vector { _handler : ADC } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : EXTI9_5 } , Vector { _handler : TIM1_BRK_TIM9 } , Vector { _handler : TIM1_UP } , Vector { _handler : TIM1_TRG_COM_TIM11 } , Vector { _handler : TIM1_CC } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : I2C1_EV } , Vector { _handler : I2C1_ER } , Vector { _handler : I2C2_EV } , Vector { _handler : I2C2_ER } , Vector { _handler : SPI1 } , Vector { _reserved : 0 } , Vector { _handler : USART1 } , Vector { _handler : USART2 } , Vector { _reserved : 0 } , Vector { _handler : EXTI15_10 } , Vector { _handler : RTC_ALARM } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : DMA1_STREAM7 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : TIM5 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : TIM6_DAC } , Vector { _reserved : 0 } , Vector { _handler : DMA2_STREAM0 } , Vector { _handler : DMA2_STREAM1 } , Vector { _handler : DMA2_STREAM2 } , Vector { _handler : DMA2_STREAM3 } , Vector { _handler : DMA2_STREAM4 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : DMA2_STREAM5 } , Vector { _handler : DMA2_STREAM6 } , Vector { _handler : DMA2_STREAM7 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : RNG } , Vector { _handler : FPU } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : FMPI2C1_EV } , Vector { _handler : FMPI2C1_ER } , Vector { _handler : LPTIM1 } ,]
; } pub const ADC1 : adc :: Adc = adc :: Adc (0x4001_2000 as u32 as _) ; pub const ADC_COMMON : adccommon :: AdcCommon = adccommon :: AdcCommon (0x4001_2300 as u32 as _) ; pub const CRC : crc :: Crc = crc :: Crc (0x4002_3000 as u32 as _) ; pub const DAC : dac :: Dac = dac :: Dac (0x4000_7400 as u32 as _) ; pub const DBGMCU : dbgmcu :: Dbgmcu = dbgmcu :: Dbgmcu (0xe004_2000 as u32 as _) ; pub const DMA1 : dma :: Dma = dma :: Dma (0x4002_6000 as u32 as _) ; pub const DMA2 : dma :: Dma = dma :: Dma (0x4002_6400 as u32 as _) ; pub const EXTI : exti :: Exti = exti :: Exti (0x4001_3c00 as u32 as _) ; pub const FLASH : flash :: Flash = flash :: Flash (0x4002_3c00 as u32 as _) ; pub const FMPI2C1 : * mut () = 0x4000_6000 as u32 as _ ; pub const GPIOA : gpio :: Gpio = gpio :: Gpio (0x4002_0000 as u32 as _) ; pub const GPIOB : gpio :: Gpio = gpio :: Gpio (0x4002_0400 as u32 as _) ; pub const GPIOC : gpio :: Gpio = gpio :: Gpio (0x4002_0800 as u32 as _) ; pub const GPIOH : gpio :: Gpio = gpio :: Gpio (0x4002_1c00 as u32 as _) ; pub const I2C1 : i2c :: I2c = i2c :: I2c (0x4000_5400 as u32 as _) ; pub const I2C2 : i2c :: I2c = i2c :: I2c (0x4000_5800 as u32 as _) ; pub const IWDG : * mut () = 0x4000_3000 as u32 as _ ; pub const LPTIM1 : * mut () = 0x4000_2400 as u32 as _ ; pub const PWR : pwr :: Pwr = pwr :: Pwr (0x4000_7000 as u32 as _) ; pub const RCC : rcc :: Rcc = rcc :: Rcc (0x4002_3800 as u32 as _) ; pub const RNG : rng :: Rng = rng :: Rng (0x4008_0000 as u32 as _) ; pub const RTC : * mut () = 0x4000_2800 as u32 as _ ; pub const SPI1 : * mut () = 0x4001_3000 as u32 as _ ; pub const SYSCFG : syscfg :: Syscfg = syscfg :: Syscfg (0x4001_3800 as u32 as _) ; pub const TIM1 : timer :: TimGp16 = timer :: TimGp16 (0x4001_0000 as u32 as _) ; pub const TIM11 : timer :: TimGp16 = timer :: TimGp16 (0x4001_4800 as u32 as _) ; pub const TIM5 : timer :: TimGp16 = timer :: TimGp16 (0x4000_0c00 as u32 as _) ; pub const TIM6 : timer :: TimGp16 = timer :: TimGp16 (0x4000_1000 as u32 as _) ; pub const TIM9 : timer :: TimGp16 = timer :: TimGp16 (0x4001_4000 as u32 as _) ; pub const USART1 : usart :: Usart = usart :: Usart (0x4001_1000 as u32 as _) ; pub const USART2 : usart :: Usart = usart :: Usart (0x4000_4400 as u32 as _) ; pub const WWDG : wwdg :: Wwdg = wwdg :: Wwdg (0x4000_2c00 as u32 as _) ;pub fn GPIO(n: usize) -> gpio::Gpio {
            gpio::Gpio((1073872896 + 1024*n) as _)
        }#[path="../../peripherals/adc_v2.rs"] pub mod adc;
#[path="../../peripherals/adccommon_v2.rs"] pub mod adccommon;
#[path="../../peripherals/crc_v1.rs"] pub mod crc;
#[path="../../peripherals/dac_v1.rs"] pub mod dac;
#[path="../../peripherals/dbgmcu_f4.rs"] pub mod dbgmcu;
#[path="../../peripherals/dma_v2.rs"] pub mod dma;
#[path="../../peripherals/exti_v1.rs"] pub mod exti;
#[path="../../peripherals/flash_f4.rs"] pub mod flash;
#[path="../../peripherals/gpio_v2.rs"] pub mod gpio;
#[path="../../peripherals/i2c_v1.rs"] pub mod i2c;
#[path="../../peripherals/pwr_f4.rs"] pub mod pwr;
#[path="../../peripherals/rcc_f410.rs"] pub mod rcc;
#[path="../../peripherals/rng_v1.rs"] pub mod rng;
#[path="../../peripherals/syscfg_f4.rs"] pub mod syscfg;
#[path="../../peripherals/timer_v1.rs"] pub mod timer;
#[path="../../peripherals/usart_v1.rs"] pub mod usart;
#[path="../../peripherals/wwdg_v1.rs"] pub mod wwdg;
pub const CORE_INDEX: usize = 0;
